/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.progress;

import ghidra.app.plugin.core.debug.service.progress.DefaultMonitorReceiver;
import ghidra.app.plugin.core.debug.service.progress.ProgressServicePlugin;
import ghidra.debug.api.progress.CloseableTaskMonitor;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelledListener;
import java.lang.ref.Cleaner;
import javax.help.UnsupportedOperationException;

public class DefaultCloseableTaskMonitor
implements CloseableTaskMonitor {
    private static final Cleaner CLEANER = Cleaner.create();
    private final DefaultMonitorReceiver receiver;
    private final State state;
    private final Cleaner.Cleanable cleanable;

    public DefaultCloseableTaskMonitor(ProgressServicePlugin plugin) {
        this.receiver = new DefaultMonitorReceiver(plugin);
        this.state = new State(this.receiver);
        this.cleanable = CLEANER.register(this, this.state);
    }

    DefaultMonitorReceiver getReceiver() {
        return this.receiver;
    }

    public boolean isCancelled() {
        return this.receiver.isCancelled();
    }

    public void setShowProgressValue(boolean showProgressValue) {
        this.receiver.setShowProgressValue(showProgressValue);
    }

    public void setMessage(String message) {
        this.receiver.setMessage(message);
    }

    public String getMessage() {
        return this.receiver.getMessage();
    }

    public void setProgress(long value) {
        this.receiver.setProgress(value);
    }

    public void initialize(long max) {
        this.receiver.setProgress(0L);
        this.receiver.setMaximum(max);
    }

    public void setMaximum(long max) {
        this.receiver.setMaximum(max);
    }

    public long getMaximum() {
        return this.receiver.getMaximum();
    }

    public void setIndeterminate(boolean indeterminate) {
        this.receiver.setIndeterminate(indeterminate);
    }

    public boolean isIndeterminate() {
        return this.receiver.isIndeterminate();
    }

    public void checkCanceled() throws CancelledException {
        if (this.receiver.isCancelled()) {
            throw new CancelledException();
        }
    }

    public void incrementProgress(long incrementAmount) {
        this.receiver.incrementProgress(incrementAmount);
    }

    public long getProgress() {
        return this.receiver.getProgress();
    }

    public void cancel() {
        this.receiver.cancel();
    }

    public void addCancelledListener(CancelledListener listener) {
        this.receiver.addCancelledListener(listener);
    }

    public void removeCancelledListener(CancelledListener listener) {
        this.receiver.removeCancelledListener(listener);
    }

    public void setCancelEnabled(boolean enable) {
        this.receiver.setCancelEnabled(enable);
    }

    public boolean isCancelEnabled() {
        return this.receiver.isCancelEnabled();
    }

    public void clearCanceled() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.receiver.close();
    }

    static class State
    implements Runnable {
        private final DefaultMonitorReceiver receiver;

        State(DefaultMonitorReceiver receiver) {
            this.receiver = receiver;
        }

        @Override
        public void run() {
            this.receiver.clean();
        }
    }
}

