/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.pcode.exec.SleighProgramCompiler;
import ghidra.program.model.pcode.Varnode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SleighPcodeUseropDefinition<T>
implements PcodeUseropLibrary.PcodeUseropDefinition<T> {
    public static final String OUT_SYMBOL_NAME = "__op_output";
    private final SleighLanguage language;
    private final String name;
    private final List<String> params;
    private final String body;
    private final Map<List<Varnode>, PcodeProgram> cacheByArgs = new HashMap<List<Varnode>, PcodeProgram>();

    protected SleighPcodeUseropDefinition(SleighLanguage language, String name, List<String> params, String body) {
        this.language = language;
        this.name = name;
        this.params = params;
        this.body = body;
    }

    public PcodeProgram programFor(Varnode outArg, List<Varnode> inArgs, PcodeUseropLibrary<?> library) {
        ArrayList<Varnode> args = new ArrayList<Varnode>(inArgs.size() + 1);
        args.add(outArg);
        args.addAll(inArgs);
        return this.cacheByArgs.computeIfAbsent(args, a -> SleighProgramCompiler.compileUserop(this.language, this.name, this.params, this.body, library, a));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getInputCount() {
        return this.params.size() - 1;
    }

    @Override
    public void execute(PcodeExecutor<T> executor, PcodeUseropLibrary<T> library, Varnode outArg, List<Varnode> inArgs) {
        PcodeProgram program = this.programFor(outArg, inArgs, library);
        executor.execute(program, library);
    }

    public List<String> getInputs() {
        return this.params;
    }

    public String getBody() {
        return this.body;
    }

    public static class Builder {
        private final Factory factory;
        private final String name;
        private final List<String> params = new ArrayList<String>();
        private final StringBuffer body = new StringBuffer();

        protected Builder(Factory factory, String name) {
            this.factory = factory;
            this.name = name;
            this.params(SleighPcodeUseropDefinition.OUT_SYMBOL_NAME);
        }

        public Builder params(Collection<String> additionalParams) {
            this.params.addAll(additionalParams);
            return this;
        }

        public Builder params(String ... additionalParams) {
            return this.params(Arrays.asList(additionalParams));
        }

        public Builder body(CharSequence additionalBody) {
            this.body.append(additionalBody);
            return this;
        }

        public <T> SleighPcodeUseropDefinition<T> build() {
            return new SleighPcodeUseropDefinition(this.factory.language, this.name, List.copyOf(this.params), this.body.toString());
        }
    }

    public static class Factory {
        private final SleighLanguage language;

        public Factory(SleighLanguage language) {
            this.language = language;
        }

        public Builder define(String name) {
            return new Builder(this, name);
        }
    }
}

