/*
 * Decompiled with CFR 0.152.
 */
package docking.menu;

import docking.ActionContext;
import docking.DockingWindowManager;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingActionIf;
import docking.action.ToolBarData;
import docking.menu.DockingToolBarUtils;
import ghidra.util.Swing;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;

public class ToolBarItemManager
implements PropertyChangeListener,
ActionListener,
MouseListener {
    private DockingActionIf toolBarAction;
    private JButton toolBarButton;
    private final DockingWindowManager windowManager;

    public ToolBarItemManager(DockingActionIf action, DockingWindowManager windowManager) {
        this.toolBarAction = action;
        this.windowManager = windowManager;
        action.addPropertyChangeListener(this);
    }

    String getGroup() {
        return this.toolBarAction.getToolBarData().getToolBarGroup();
    }

    public JButton getButton() {
        if (this.toolBarButton == null) {
            this.toolBarButton = this.createButton(this.toolBarAction);
            this.toolBarButton.setEnabled(this.toolBarAction.isEnabled());
        }
        return this.toolBarButton;
    }

    public JButton createButton(DockingActionIf action) {
        JButton button = action.createButton();
        button.addActionListener(this);
        button.addMouseListener(this);
        button.setName(action.getName());
        DockingToolBarUtils.setToolTipText(button, action);
        return button;
    }

    public DockingActionIf getAction() {
        return this.toolBarAction;
    }

    void dispose() {
        this.toolBarAction.removePropertyChangeListener(this);
        if (this.toolBarButton != null) {
            this.toolBarButton.removeActionListener(this);
            this.toolBarButton = null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (this.toolBarButton == null) {
            return;
        }
        String name = e.getPropertyName();
        if (name.equals("enabled")) {
            this.toolBarButton.setEnabled((Boolean)e.getNewValue());
        } else if (name.equals("description")) {
            DockingToolBarUtils.setToolTipText(this.toolBarButton, this.toolBarAction);
        } else if (name.equals("ToolBar")) {
            ToolBarData toolBarData = (ToolBarData)e.getNewValue();
            this.toolBarButton.setIcon(toolBarData == null ? null : toolBarData.getIcon());
        } else if (name.equals("selectState")) {
            this.toolBarButton.setSelected((Boolean)e.getNewValue());
        } else if (name.equals("KeyBindings")) {
            DockingToolBarUtils.setToolTipText(this.toolBarButton, this.toolBarAction);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        DockingWindowManager.clearMouseOverHelp();
        ActionContext context = this.getWindowManager().createActionContext(this.toolBarAction);
        context.setSourceObject(event.getSource());
        context.setEventClickModifiers(event.getModifiers());
        Swing.runLater(() -> {
            if (this.toolBarAction.isValidContext(context) && this.toolBarAction.isEnabledForContext(context)) {
                if (this.toolBarAction instanceof ToggleDockingActionIf) {
                    ToggleDockingActionIf toggleAction;
                    toggleAction.setSelected(!(toggleAction = (ToggleDockingActionIf)this.toolBarAction).isSelected());
                }
                this.toolBarAction.actionPerformed(context);
            }
        });
    }

    private DockingWindowManager getWindowManager() {
        if (this.windowManager != null) {
            return this.windowManager;
        }
        return DockingWindowManager.getActiveInstance();
    }

    public String toString() {
        return this.toolBarAction.getName();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        DockingWindowManager.setMouseOverAction(this.toolBarAction);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        DockingWindowManager.clearMouseOverHelp();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

