/*
 * Decompiled with CFR 0.152.
 */
package docking.options.editor;

import docking.theme.gui.ProtectedIcon;
import docking.widgets.DefaultDropDownSelectionDataModel;
import docking.widgets.DropDownSelectionChoiceListener;
import docking.widgets.DropDownSelectionTextField;
import docking.widgets.DropDownTextFieldDataModel;
import docking.widgets.OptionDialog;
import docking.widgets.button.BrowseButton;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.label.GDLabel;
import docking.widgets.list.GListCellRenderer;
import ghidra.framework.Application;
import ghidra.framework.preferences.Preferences;
import ghidra.util.Msg;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.apache.commons.io.FileUtils;
import resources.ResourceManager;
import resources.icons.ScaledImageIcon;
import resources.icons.UrlImageIcon;

public class IconPropertyEditor
extends PropertyEditorSupport {
    private IconChooserPanel iconChooserPanel;

    @Override
    public Component getCustomEditor() {
        this.iconChooserPanel = new IconChooserPanel();
        return this.iconChooserPanel;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public void setValue(Object value) {
        if (this.iconChooserPanel != null) {
            this.iconChooserPanel.setSelectedIcon((Icon)value);
        }
        this.doSetValue(value);
    }

    private void doSetValue(Object value) {
        if (!Objects.equals(value, this.getValue())) {
            super.setValue(value);
        }
    }

    private String iconToString(Icon icon) {
        if (icon instanceof UrlImageIcon) {
            UrlImageIcon urlIcon = (UrlImageIcon)icon;
            return urlIcon.getOriginalPath();
        }
        return "<Original>";
    }

    class IconChooserPanel
    extends JPanel {
        private static final String IMAGE_DIR = "images/";
        private static final String LAST_ICON_DIR_PREFERENCE_KEY = "IconEditor.lastDir";
        private GDLabel previewLabel;
        private DropDownSelectionTextField<Icon> dropDown;
        private IconDropDownDataModel dataModel;
        DropDownSelectionChoiceListener<Icon> choiceListener = t -> this.iconChanged((Icon)t);

        public IconChooserPanel() {
            this.build();
        }

        public void setSelectedIcon(Icon icon) {
            if (icon == null) {
                return;
            }
            if (!(icon instanceof UrlImageIcon)) {
                icon = new ProtectedIcon(icon);
            }
            this.updateDropDownDataModel(icon);
            this.updatePreviewLabel(icon);
        }

        private void updateDropDownDataModel(Icon icon) {
            Set<Icon> icons = this.getCoreIcons();
            icons.add(icon);
            this.dataModel.setData(new ArrayList<Icon>(icons));
            this.dropDown.setSelectedValue(icon);
        }

        private Set<Icon> getCoreIcons() {
            Set loadedIcons = ResourceManager.getLoadedIcons();
            HashSet<Icon> filtered = new HashSet<Icon>();
            for (Icon icon : loadedIcons) {
                if (!this.isCoreIcon(icon)) continue;
                filtered.add(icon);
            }
            return filtered;
        }

        private boolean isCoreIcon(Icon icon) {
            if (icon instanceof UrlImageIcon) {
                UrlImageIcon urlIcon = (UrlImageIcon)icon;
                String path = urlIcon.getUrl().getPath();
                if (path.contains("Ghidra/Framework")) {
                    return true;
                }
                if (path.contains("Ghidra/Features")) {
                    return true;
                }
                if (path.contains("Ghidra/Debug")) {
                    return true;
                }
            }
            return false;
        }

        private void build() {
            this.setLayout(new BorderLayout());
            this.add(this.buildTopPanel(), "North");
            this.add(this.buildPreviewLabel(), "Center");
        }

        private Component buildTopPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            this.dataModel = new IconDropDownDataModel();
            this.dropDown = new DropDownSelectionTextField<Icon>((DropDownTextFieldDataModel)this.dataModel){

                @Override
                protected List<Icon> getMatchingData(String searchText) {
                    if (searchText.isBlank()) {
                        return ((IconDropDownDataModel)this.dataModel).getData();
                    }
                    return super.getMatchingData(searchText);
                }
            };
            this.dropDown.addDropDownSelectionChoiceListener(this.choiceListener);
            panel.add(this.dropDown, "Center");
            BrowseButton browseButton = new BrowseButton();
            panel.add((Component)browseButton, "East");
            browseButton.addActionListener(e -> this.browse());
            return panel;
        }

        private void iconChanged(Icon icon) {
            boolean isDropDownWindowShowing = this.dropDown.isMatchingListShowing();
            if (!isDropDownWindowShowing) {
                this.updatePreviewLabel(icon);
                IconPropertyEditor.this.doSetValue(icon);
            }
        }

        private void browse() {
            File file;
            GhidraFileChooser chooser = new GhidraFileChooser(IconPropertyEditor.this.iconChooserPanel);
            chooser.setTitle("Import Icon");
            chooser.setApproveButtonToolTipText("Import Icon");
            chooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
            chooser.setSelectedFileFilter((GhidraFileFilter)ExtensionFileFilter.forExtensions((String)"Icon Files", (String[])new String[]{".png", "gif"}));
            String lastDir = Preferences.getProperty((String)LAST_ICON_DIR_PREFERENCE_KEY);
            if (lastDir != null) {
                chooser.setCurrentDirectory(new File(lastDir));
            }
            if ((file = chooser.getSelectedFile()) != null) {
                File dir = chooser.getCurrentDirectory();
                Preferences.setProperty((String)LAST_ICON_DIR_PREFERENCE_KEY, (String)dir.getAbsolutePath());
                this.importIconFile(file);
            }
            chooser.dispose();
        }

        private void importIconFile(File file) {
            int result;
            String relativePath;
            if (!this.isValidIcon(file)) {
                Msg.error((Object)this, (Object)("File is not a valid icon: " + file.getAbsolutePath()));
                return;
            }
            File dir = Application.getUserSettingsDirectory();
            File destinationFile = new File(dir, relativePath = IMAGE_DIR + file.getName());
            if (destinationFile.exists() && (result = OptionDialog.showYesNoDialog(this.dropDown, "Overwrite?", "An icon with that name already exists.\n Do you want to overwrite it?")) == 2) {
                return;
            }
            try {
                FileUtils.copyFile((File)file, (File)destinationFile);
                String path = "[EXTERNAL]" + relativePath;
                ImageIcon icon = ResourceManager.loadImage((String)path);
                IconPropertyEditor.this.setValue(icon);
            }
            catch (IOException e) {
                Msg.showError((Object)this, this.dropDown, (String)"Error importing file", (Object)e);
            }
        }

        private boolean isValidIcon(File file) {
            if (!file.exists()) {
                return false;
            }
            try {
                UrlImageIcon icon = new UrlImageIcon(file.getAbsolutePath(), file.toURI().toURL());
                icon.getIconWidth();
                return true;
            }
            catch (Exception e) {
                Msg.showError((Object)this, this.dropDown, (String)"Invalid Icon File", (Object)("The file is not a valid icon: " + file.getAbsolutePath()));
                return false;
            }
        }

        private Component buildPreviewLabel() {
            JPanel panel = new JPanel(new BorderLayout());
            this.previewLabel = new GDLabel("");
            this.previewLabel.setIcon(ResourceManager.getDefaultIcon());
            this.previewLabel.setHorizontalAlignment(0);
            this.previewLabel.setVerticalAlignment(0);
            panel.add((Component)this.previewLabel, "Center");
            panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            return panel;
        }

        private void updatePreviewLabel(Icon icon) {
            this.previewLabel.setIcon(icon);
            int height = icon.getIconHeight();
            int width = icon.getIconWidth();
            Dimension d = this.previewLabel.getSize();
            height = Math.max(d.height, height);
            width = Math.max(d.width, width);
            this.previewLabel.setPreferredSize(new Dimension(width, height));
            this.previewLabel.invalidate();
            IconPropertyEditor.this.iconChooserPanel.validate();
        }
    }

    class IconListCellRender
    extends GListCellRenderer<Icon> {
        IconListCellRender() {
        }

        @Override
        protected String getItemText(Icon icon) {
            return IconPropertyEditor.this.iconToString(icon);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Icon> list, Icon icon, int index, boolean isSelected, boolean hasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, icon, index, isSelected, hasFocus);
            if (icon.getIconWidth() != 16 || icon.getIconHeight() != 16) {
                icon = new ScaledImageIcon(icon, 16, 16);
            }
            label.setIcon(icon);
            return label;
        }
    }

    class IconDropDownDataModel
    extends DefaultDropDownSelectionDataModel<Icon> {
        IconListCellRender renderer;

        public IconDropDownDataModel() {
            super(Collections.emptyList(), IconPropertyEditor.this::iconToString);
            this.renderer = new IconListCellRender();
        }

        List<Icon> getData() {
            return this.data;
        }

        void setData(List<Icon> icons) {
            Collections.sort(icons, this.comparator);
            this.data = icons;
        }

        @Override
        public List<Icon> getMatchingData(String searchText) {
            if (searchText.isBlank()) {
                return this.data;
            }
            searchText = searchText.toLowerCase();
            ArrayList<Icon> results = new ArrayList<Icon>();
            for (Icon icon : this.data) {
                String name = IconPropertyEditor.this.iconToString(icon);
                if (!name.toLowerCase().contains(searchText)) continue;
                results.add(icon);
            }
            return results;
        }

        @Override
        public ListCellRenderer<Icon> getListRenderer() {
            return this.renderer;
        }
    }
}

