/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.autocomplete;

import docking.DockingUtils;
import docking.widgets.autocomplete.AutocompletionCellRenderer;
import docking.widgets.autocomplete.AutocompletionEvent;
import docking.widgets.autocomplete.AutocompletionListener;
import docking.widgets.autocomplete.AutocompletionModel;
import docking.widgets.textfield.TextFieldLinker;
import generic.theme.GColor;
import generic.util.WindowUtilities;
import ghidra.util.task.SwingUpdateManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;

public class TextFieldAutocompleter<T> {
    private static final int DEFAULT_UPDATE_DELAY = 10;
    private static final int DEFAULT_MAX_UPDATE_DELAY = 2000;
    private static final int MIN_HEIGHT = 100;
    private static final int MIN_WIDTH = 200;
    private static final int DEFAULT_HEIGHT = 300;
    private static final int DEFAULT_WIDTH = 200;
    private final AutocompletionModel<T> model;
    private final Set<JTextField> attachees = new HashSet<JTextField>();
    private JTextField focus;
    private List<AutocompletionListener<T>> autocompletionListeners = new ArrayList<AutocompletionListener<T>>();
    private JWindow completionWindow;
    private JPanel content = new JPanel(new BorderLayout());
    private JScrollPane scrollPane = new JScrollPane();
    private DefaultListModel<T> listModel = new DefaultListModel();
    private DefaultListModel<T> blankModel = new DefaultListModel();
    private JList<T> list = new JList<T>(this.listModel);
    protected MyListener listener = new MyListener();
    private boolean pendingTextUpdate;
    private SwingUpdateManager updateManager = new SwingUpdateManager(10, 2000, "Auto Completion Update Manager " + this.getClass(), () -> {
        if (!this.pendingTextUpdate) {
            return;
        }
        this.doUpdateDisplayContents();
        this.pendingTextUpdate = false;
    });

    public void dispose() {
        this.updateManager.dispose();
    }

    protected void addContent(JPanel contentPanel) {
    }

    public TextFieldAutocompleter(AutocompletionModel<T> model) {
        this.content.setBorder(BorderFactory.createBevelBorder(0, (Color)new GColor("color.border.bevel.highlight"), (Color)new GColor("color.border.bevel.shadow")));
        this.scrollPane.setBorder(BorderFactory.createBevelBorder(0, (Color)new GColor("color.border.bevel.highlight"), (Color)new GColor("color.border.bevel.shadow")));
        this.scrollPane.getVerticalScrollBar().setFocusable(false);
        this.scrollPane.getViewport().add(this.list);
        ResizeListener resizeListener = new ResizeListener();
        this.scrollPane.addMouseMotionListener(resizeListener);
        this.scrollPane.addMouseListener(resizeListener);
        this.content.addMouseMotionListener(resizeListener);
        this.content.addMouseListener(resizeListener);
        this.addContent(this.content);
        this.list.setCellRenderer(this.buildListCellRenderer());
        this.list.setSelectionMode(0);
        this.list.addMouseListener(this.listener);
        this.content.add(this.scrollPane);
        DockingUtils.forAllDescendants(this.content, c -> {
            c.setFocusable(false);
            return DockingUtils.TreeTraversalResult.CONTINUE;
        });
        this.model = model;
    }

    public void updateDisplayLocation() {
        SwingUtilities.invokeLater(() -> this.doUpdateDisplayLocation());
    }

    protected void updateDisplayContents() {
        this.pendingTextUpdate = true;
        this.updateManager.updateLater();
    }

    private void doUpdateDisplayContents() {
        if (this.focus == null) {
            return;
        }
        if (this.completionWindow == null || !this.completionWindow.isVisible()) {
            return;
        }
        String text = this.getPrefix(this.focus);
        Collection<T> completions = this.model.computeCompletions(text);
        if (completions == null || completions.size() == 0) {
            this.setCompletionListVisible(false);
            return;
        }
        this.doUpdateDisplayLocation();
        this.list.setModel(this.blankModel);
        this.listModel.clear();
        for (T t : completions) {
            this.listModel.addElement(t);
        }
        this.list.setModel(this.listModel);
        this.select(0);
    }

    protected void destroyCompletionWindow() {
        this.completionWindow.remove(this.content);
        this.completionWindow.dispose();
        this.completionWindow = null;
    }

    protected void buildCompletionWindow() {
        if (this.focus == null) {
            return;
        }
        this.completionWindow = new JWindow(WindowUtilities.windowForComponent((Component)this.focus));
        this.completionWindow.add(this.content);
        this.content.setVisible(true);
        this.list.setVisible(true);
        Dimension size = this.getDefaultCompletionWindowDimension();
        if (-1 == size.height) {
            size.height = 300;
        }
        if (-1 == size.width) {
            size.width = 200;
        }
        this.completionWindow.setSize(size);
    }

    public void setCompletionListVisible(boolean visible) {
        if (visible) {
            if (this.completionWindow == null) {
                this.buildCompletionWindow();
            } else if (this.completionWindow.getOwner() != WindowUtilities.windowForComponent((Component)this.focus)) {
                this.destroyCompletionWindow();
                this.buildCompletionWindow();
            }
            this.completionWindow.setVisible(true);
        } else if (this.completionWindow != null) {
            this.completionWindow.setVisible(false);
        }
    }

    public boolean isCompletionListVisible() {
        return this.completionWindow != null && this.completionWindow.isVisible();
    }

    private void doUpdateDisplayLocation() {
        Point p = this.getCompletionWindowPosition();
        if (p != null) {
            this.completionWindow.setLocation(p);
        }
    }

    protected String getPrefix(JTextField field) {
        try {
            return field.getText(0, field.getCaretPosition());
        }
        catch (BadLocationException e) {
            throw new AssertionError("INTERNAL: Should not be here", e);
        }
    }

    protected Point getCompletionWindowPosition() {
        return this.getCaretPositionOnScreen(this.focus);
    }

    protected Dimension getDefaultCompletionWindowDimension() {
        if (this.focus == null) {
            return new Dimension(-1, -1);
        }
        return new Dimension(this.focus.getWidth(), -1);
    }

    protected Point getCaretPositionOnScreen(JTextField field) {
        if (this.focus == null) {
            return null;
        }
        FontMetrics metrics = field.getFontMetrics(field.getFont());
        Caret c = field.getCaret();
        Point p = c.getMagicCaretPosition();
        p = p == null ? new Point(0, field.getBaseline(1, 1)) : new Point(p);
        p.y += metrics.getHeight();
        SwingUtilities.convertPointToScreen(p, field);
        return p;
    }

    protected ListCellRenderer<? super T> buildListCellRenderer() {
        return new AutocompletionCellRenderer(this);
    }

    public boolean attachTo(JTextField field) {
        if (!this.attachees.add(field)) {
            return false;
        }
        boolean keep = false;
        try {
            field.addFocusListener(this.listener);
            field.addCaretListener(this.listener);
            field.addKeyListener(this.listener);
            field.getDocument().addDocumentListener(this.listener);
            keep = true;
        }
        finally {
            if (!keep) {
                this.attachees.remove(field);
            }
        }
        return keep;
    }

    public boolean detachFrom(JTextField field) {
        if (!this.attachees.remove(field)) {
            return false;
        }
        field.removeFocusListener(this.listener);
        field.removeCaretListener(this.listener);
        field.removeKeyListener(this.listener);
        field.getDocument().removeDocumentListener(this.listener);
        return true;
    }

    protected void activateCurrentCompletion() {
        T sel = this.list.getSelectedValue();
        if (sel == null) {
            return;
        }
        this.setCompletionListVisible(false);
        this.completionActivated(sel);
    }

    protected boolean fireAutocompletionListeners(AutocompletionEvent<T> ev) {
        for (AutocompletionListener<T> l : this.autocompletionListeners) {
            if (ev.isConsumed()) break;
            l.completionActivated(ev);
        }
        return !ev.isCancelled();
    }

    private void completionActivated(T sel) {
        if (this.focus == null) {
            return;
        }
        AutocompletionEvent<T> ev = new AutocompletionEvent<T>(sel, this.focus);
        if (!this.fireAutocompletionListeners(ev)) {
            return;
        }
        try {
            this.focus.getDocument().insertString(this.focus.getCaretPosition(), this.getCompletionText(sel), null);
        }
        catch (BadLocationException e) {
            throw new AssertionError("INTERNAL: Should not be here", e);
        }
    }

    public void addAutocompletionListener(AutocompletionListener<T> l) {
        this.autocompletionListeners.add(l);
    }

    public void removeAutocompletionListener(AutocompletionListener<T> l) {
        this.autocompletionListeners.remove(l);
    }

    public AutocompletionListener<T>[] getAutocompletionListeners() {
        return this.autocompletionListeners.toArray(new AutocompletionListener[0]);
    }

    public <T> T[] getListeners(Class<T> listenerType) {
        if (listenerType == AutocompletionListener.class) {
            return this.getAutocompletionListeners();
        }
        return null;
    }

    protected String getCompletionText(T sel) {
        return sel.toString();
    }

    protected String getCompletionDisplay(T sel) {
        return sel.toString();
    }

    protected Color getCompletionForeground(T sel, boolean isSelected, boolean cellHasFocus) {
        return null;
    }

    protected Color getCompletionBackground(T sel, boolean isSelected, boolean cellHasFocus) {
        return null;
    }

    protected Icon getCompletionIcon(T sel, boolean isSelected, boolean cellHasFocus) {
        return null;
    }

    protected Font getCompletionFont(T sel, boolean isSelected, boolean cellHasFocus) {
        if (this.focus == null) {
            return null;
        }
        return this.focus.getFont();
    }

    protected boolean getCompletionCanDefault(T sel) {
        return true;
    }

    public void startCompletion(JTextField field) {
        if (!this.attachees.contains(field)) {
            throw new IllegalArgumentException("Given field is not attached");
        }
        HashSet<String> visited = new HashSet<String>();
        while (true) {
            String before;
            if (!visited.add(before = this.getPrefix(field))) {
                return;
            }
            Collection<T> comp = this.model.computeCompletions(before);
            if (comp == null || comp.size() == 0) {
                return;
            }
            if (comp.size() == 1) {
                T sel = comp.iterator().next();
                if (this.getCompletionCanDefault(sel)) {
                    this.completionActivated(comp.iterator().next());
                    continue;
                }
                this.setCompletionListVisible(true);
                this.updateDisplayContents();
                return;
            }
            if (!this.isCompletionListVisible()) break;
        }
        this.setCompletionListVisible(true);
        this.updateDisplayContents();
    }

    public void flushUpdates() {
        this.updateManager.flush();
    }

    public void updateNow() {
        this.pendingTextUpdate = true;
        this.updateManager.updateNow();
    }

    public void select(int index) {
        this.list.setSelectedIndex(index);
        this.list.ensureIndexIsVisible(index);
    }

    public void selectNext() {
        int index = this.list.getSelectedIndex();
        int size = this.listModel.getSize();
        if (++index >= size) {
            index -= size;
        }
        this.select(index);
    }

    public void selectPrev() {
        int index = this.list.getSelectedIndex();
        int size = this.listModel.getSize();
        if (index >= 0) {
            --index;
        }
        if (index < 0) {
            index += size;
        }
        this.select(index);
    }

    protected void selectNextPage() {
        int index = this.list.getSelectedIndex();
        int size = this.listModel.getSize();
        if ((index += 10) >= size) {
            index = size - 1;
        }
        this.select(index);
    }

    protected void selectPrevPage() {
        int index = this.list.getSelectedIndex();
        int size = this.listModel.getSize();
        if (size <= 10) {
            this.select(0);
            return;
        }
        if (index >= 0) {
            index -= 10;
        }
        if (index < 0) {
            index = 0;
        }
        this.select(index);
    }

    public void selectFirst() {
        this.select(0);
    }

    public void selectLast() {
        this.select(this.listModel.getSize() - 1);
    }

    public List<T> getSuggestions() {
        return IntStream.range(0, this.listModel.getSize()).mapToObj(this.listModel::get).collect(Collectors.toUnmodifiableList());
    }

    protected class MyListener
    implements FocusListener,
    KeyListener,
    DocumentListener,
    MouseListener,
    CaretListener {
        protected MyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (e.getKeyCode() == 10) {
                if (TextFieldAutocompleter.this.isCompletionListVisible()) {
                    TextFieldAutocompleter.this.activateCurrentCompletion();
                    e.consume();
                }
            } else if (e.getKeyCode() == 40) {
                if (TextFieldAutocompleter.this.isCompletionListVisible()) {
                    TextFieldAutocompleter.this.selectNext();
                    e.consume();
                }
            } else if (e.getKeyCode() == 38) {
                if (TextFieldAutocompleter.this.isCompletionListVisible()) {
                    TextFieldAutocompleter.this.selectPrev();
                    e.consume();
                }
            } else if (e.getKeyCode() == 34) {
                if (TextFieldAutocompleter.this.isCompletionListVisible()) {
                    TextFieldAutocompleter.this.selectNextPage();
                    e.consume();
                }
            } else if (e.getKeyCode() == 33) {
                if (TextFieldAutocompleter.this.isCompletionListVisible()) {
                    TextFieldAutocompleter.this.selectPrevPage();
                    e.consume();
                }
            } else if (e.getKeyCode() == 35) {
                if (TextFieldAutocompleter.this.isCompletionListVisible()) {
                    TextFieldAutocompleter.this.selectLast();
                    e.consume();
                }
            } else if (e.getKeyCode() == 36) {
                if (TextFieldAutocompleter.this.isCompletionListVisible()) {
                    TextFieldAutocompleter.this.selectFirst();
                    e.consume();
                }
            } else if (e.getKeyCode() == 32 && (e.getModifiersEx() & 0x80) != 0) {
                TextFieldAutocompleter.this.startCompletion((JTextField)e.getComponent());
                e.consume();
            } else if (e.getKeyCode() == 27 && TextFieldAutocompleter.this.isCompletionListVisible()) {
                TextFieldAutocompleter.this.setCompletionListVisible(false);
                e.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void focusGained(FocusEvent e) {
            TextFieldAutocompleter.this.focus = (JTextField)e.getComponent();
            TextFieldAutocompleter.this.updateDisplayContents();
        }

        public void fakeFocusGained(JTextField field) {
            TextFieldAutocompleter.this.focus = field;
        }

        @Override
        public void focusLost(FocusEvent e) {
            Component opp = e.getOppositeComponent();
            if (TextFieldAutocompleter.this.attachees.contains(opp)) {
                TextFieldAutocompleter.this.focus = (JTextField)opp;
            } else if (opp != TextFieldAutocompleter.this.list) {
                TextFieldAutocompleter.this.setCompletionListVisible(false);
                TextFieldAutocompleter.this.focus = null;
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            TextFieldAutocompleter.this.updateDisplayContents();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            TextFieldAutocompleter.this.updateDisplayContents();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            TextFieldAutocompleter.this.updateDisplayContents();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                TextFieldAutocompleter.this.activateCurrentCompletion();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    class ResizeListener
    extends MouseAdapter {
        protected static final int REGION_NONE = 0;
        protected static final int REGION_E = 1;
        protected static final int REGION_S = 2;
        protected static final int REGION_SE = 3;
        protected int grabbedRegion = 0;
        protected int xoff = 0;
        protected int yoff = 0;

        ResizeListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.grabbedRegion = this.getRegion(e);
            this.xoff = TextFieldAutocompleter.this.completionWindow.getWidth() - e.getX();
            this.yoff = TextFieldAutocompleter.this.completionWindow.getHeight() - e.getY();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.grabbedRegion = 0;
        }

        protected int getRegion(MouseEvent e) {
            boolean closeBottom;
            Insets insets = TextFieldAutocompleter.this.content.getInsets();
            JScrollBar hbar = TextFieldAutocompleter.this.scrollPane.getHorizontalScrollBar();
            JScrollBar vbar = TextFieldAutocompleter.this.scrollPane.getVerticalScrollBar();
            int vdim = 0;
            if (hbar != null && hbar.isVisible()) {
                vdim = hbar.getHeight();
            }
            int hdim = 0;
            if (vbar != null && vbar.isVisible()) {
                hdim = vbar.getWidth();
            }
            boolean nearRight = e.getX() >= TextFieldAutocompleter.this.content.getWidth() - insets.right - hdim;
            boolean nearBottom = e.getY() >= TextFieldAutocompleter.this.content.getHeight() - insets.bottom - vdim;
            boolean closeRight = e.getX() >= TextFieldAutocompleter.this.content.getWidth() - 20;
            boolean bl = closeBottom = e.getY() >= TextFieldAutocompleter.this.content.getHeight() - 20;
            if (nearRight && nearBottom || nearRight && closeBottom || closeRight && nearBottom) {
                return 3;
            }
            if (nearRight) {
                return 1;
            }
            if (nearBottom) {
                return 2;
            }
            return 0;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            switch (this.getRegion(e)) {
                case 1: {
                    TextFieldAutocompleter.this.content.setCursor(Cursor.getPredefinedCursor(11));
                    break;
                }
                case 2: {
                    TextFieldAutocompleter.this.content.setCursor(Cursor.getPredefinedCursor(9));
                    break;
                }
                case 3: {
                    TextFieldAutocompleter.this.content.setCursor(Cursor.getPredefinedCursor(5));
                    break;
                }
                default: {
                    TextFieldAutocompleter.this.content.setCursor(null);
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            TextFieldAutocompleter.this.content.setCursor(null);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.grabbedRegion == 0) {
                return;
            }
            Dimension size = TextFieldAutocompleter.this.completionWindow.getSize();
            if ((this.grabbedRegion & 1) != 0) {
                size.width = Math.max(200, e.getXOnScreen() - TextFieldAutocompleter.this.completionWindow.getX() + this.xoff);
            }
            if ((this.grabbedRegion & 2) != 0) {
                size.height = Math.max(100, e.getYOnScreen() - TextFieldAutocompleter.this.completionWindow.getY() + this.yoff);
            }
            TextFieldAutocompleter.this.completionWindow.setSize(size);
        }
    }

    public static class DualTextAutocompleterDemo {
        public static void main(String[] args) {
            JDialog dialog = new JDialog((Window)null, "MultiTextField with Autocompleter Demo");
            Box hbox = Box.createHorizontalBox();
            dialog.add(hbox);
            final TextFieldLinker dual = TextFieldLinker.twoSpacedFields();
            hbox.add(dual.getField(0));
            hbox.add(Box.createHorizontalStrut(10));
            hbox.add(dual.getField(1));
            dual.setVisible(true);
            AutocompletionModel<String> model = new AutocompletionModel<String>(){
                Set<String> strings = new HashSet<String>(Arrays.asList("Test", "Testing", "Another", "Yet another", "Yet still more", "Yet still even more", "Yetis, yo"));

                @Override
                public Collection<String> computeCompletions(String text) {
                    TreeSet<String> matching = new TreeSet<String>();
                    for (String s : this.strings) {
                        if (!s.startsWith(text)) continue;
                        matching.add(s.substring(text.length()));
                    }
                    return matching;
                }
            };
            TextFieldAutocompleter<String> auto = new TextFieldAutocompleter<String>((AutocompletionModel)model){

                @Override
                protected String getPrefix(JTextField field) {
                    return dual.getTextBeforeCursor(field);
                }
            };
            auto.attachTo(dual.getField(0));
            auto.attachTo(dual.getField(1));
            dialog.setBounds(2560, 500, 400, 200);
            dialog.setModal(true);
            dialog.setVisible(true);
        }
    }

    public static class TextFieldAutocompleterDemo {
        public static void main(String[] args) {
            JDialog dialog = new JDialog((Window)null, "Autocompleter Demo");
            JTextField field = new JTextField();
            dialog.add(field);
            TextFieldAutocompleter<String> auto = new TextFieldAutocompleter<String>(new AutocompletionModel<String>(){
                Set<String> strings = new HashSet<String>(Arrays.asList("Test", "Testing", "Another", "Yet another", "Yet still more"));
                {
                    for (int i = 0; i < 20; ++i) {
                        this.strings.add("Item " + i);
                    }
                }

                @Override
                public Collection<String> computeCompletions(String text) {
                    TreeSet<String> matching = new TreeSet<String>();
                    for (String s : this.strings) {
                        if (!s.startsWith(text)) continue;
                        matching.add(s.substring(text.length()));
                    }
                    return matching;
                }
            });
            auto.attachTo(field);
            dialog.setBounds(2560, 500, 400, 200);
            dialog.setModal(true);
            dialog.setVisible(true);
        }
    }
}

