/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.dialogs;

import docking.DialogComponentProvider;
import docking.DockingUtils;
import docking.DockingWindowManager;
import docking.widgets.OptionDialog;
import docking.widgets.label.GIconLabel;
import docking.widgets.label.GLabel;
import ghidra.util.HTMLUtilities;
import ghidra.util.Swing;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.text.DefaultCaret;
import org.apache.commons.lang3.StringUtils;

public class MultiLineMessageDialog
extends DialogComponentProvider {
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int PLAIN_MESSAGE = -1;

    public static void showModalMessageDialog(Component parent, String title, String shortMessage, String detailedMessage, int messageType) {
        Swing.runNow(() -> {
            MultiLineMessageDialog dialog = new MultiLineMessageDialog(title, shortMessage, detailedMessage, messageType, true);
            DockingWindowManager.showDialog(parent, dialog);
        });
    }

    public static void showMessageDialog(Component parent, String title, String shortMessage, String detailedMessage, int messageType) {
        Swing.runNow(() -> {
            MultiLineMessageDialog dialog = new MultiLineMessageDialog(title, shortMessage, detailedMessage, messageType, false);
            DockingWindowManager.showDialog(parent, dialog);
        });
    }

    public MultiLineMessageDialog(String title, String shortMessage, String detailedMessage, int messageType, boolean modal) {
        super(title, modal, false, true, false);
        Icon icon;
        JPanel workPanel = new JPanel(new BorderLayout());
        workPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (!StringUtils.isBlank((CharSequence)shortMessage)) {
            GLabel shortMessageLabel = new GLabel(shortMessage);
            shortMessageLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 10));
            workPanel.add((Component)shortMessageLabel, "North");
        }
        if (!StringUtils.isBlank((CharSequence)detailedMessage)) {
            if (HTMLUtilities.isHTML((String)detailedMessage)) {
                JTextPane textPane = new JTextPane();
                String fontfamily = textPane.getFont().getFamily();
                detailedMessage = "<html><body style=\"font-family: " + fontfamily + "\">" + ((String)detailedMessage).substring(6);
                DefaultCaret caret = (DefaultCaret)textPane.getCaret();
                caret.setUpdatePolicy(1);
                textPane.setContentType("text/html");
                textPane.setText((String)detailedMessage);
                textPane.setEditable(false);
                DockingUtils.setTransparent(textPane);
                JScrollPane scrollPane = new JScrollPane(textPane);
                DockingUtils.setTransparent(scrollPane);
                scrollPane.setBorder(BorderFactory.createEmptyBorder());
                workPanel.add((Component)scrollPane, "Center");
                textPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            } else {
                JTextArea textArea = new JTextArea((String)detailedMessage);
                textArea.setEditable(false);
                DockingUtils.setTransparent(textArea);
                JScrollPane scrollPane = new JScrollPane(textArea);
                DockingUtils.setTransparent(scrollPane);
                workPanel.add((Component)scrollPane, "Center");
                textArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            }
        }
        if ((icon = OptionDialog.getIconForMessageType(messageType)) != null) {
            GIconLabel iconLabel = new GIconLabel(icon);
            iconLabel.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 10));
            workPanel.add((Component)iconLabel, "West");
        }
        this.setTransient(true);
        this.addWorkPanel(workPanel);
        this.addOKButton();
        this.setFocusComponent(this.okButton);
        this.setDefaultButton(this.okButton);
        this.setRememberSize(false);
        this.setPreferredSize(600, 300);
    }

    @Override
    protected void okCallback() {
        this.close();
    }
}

