/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constrainteditor;

import docking.widgets.label.GDHtmlLabel;
import docking.widgets.spinner.IntegerSpinner;
import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.RangeColumnConstraint;
import docking.widgets.table.constrainteditor.AbstractColumnConstraintEditor;
import docking.widgets.table.constrainteditor.BoundedSpinnerNumberModel;
import docking.widgets.table.constrainteditor.LongConverter;
import generic.theme.GThemeDefaults;
import ghidra.util.layout.VerticalLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.math.BigInteger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class IntegerRangeConstraintEditor<T extends Number>
extends AbstractColumnConstraintEditor<T> {
    private IntegerSpinner lowerSpinner;
    private BoundedSpinnerNumberModel lowerSpinnerModel;
    private IntegerSpinner upperSpinner;
    private BoundedSpinnerNumberModel upperSpinnerModel;
    private JLabel infoLabel;
    private LongConverter<T> converter;
    private String errorMessage;

    public IntegerRangeConstraintEditor(ColumnConstraint<T> constraint, LongConverter<T> converter) {
        super(constraint);
        this.converter = converter;
    }

    private void initLowerSpinner(Long value, Long minValue, Long maxValue, Long stepSize) {
        this.lowerSpinnerModel = new BoundedSpinnerNumberModel((Number)value, minValue, maxValue, (Number)stepSize);
        this.lowerSpinner = new IntegerSpinner(this.lowerSpinnerModel);
        this.lowerSpinner.getTextField().setShowNumberMode(true);
        this.lowerSpinner.getTextField().addChangeListener(e -> this.valueChanged());
        this.lowerSpinner.getSpinner().setName("lowerSpinner");
        this.lowerSpinner.addChangeListener(e -> this.valueChanged());
    }

    private void initUpperSpinner(Long value, Long minValue, Long maxValue, Long stepSize) {
        this.upperSpinnerModel = new BoundedSpinnerNumberModel((Number)value, minValue, maxValue, (Number)stepSize);
        this.upperSpinner = new IntegerSpinner(this.upperSpinnerModel);
        this.upperSpinner.getTextField().setShowNumberMode(true);
        this.upperSpinner.getTextField().addChangeListener(e -> this.valueChanged());
        this.upperSpinner.getSpinner().setName("upperSpinner");
        this.upperSpinner.addChangeListener(e -> this.valueChanged());
    }

    @Override
    protected Component buildInlineEditorComponent() {
        long minValue = ((Number)this.getConstraint().getMinValue()).longValue();
        long maxValue = ((Number)this.getConstraint().getMaxValue()).longValue();
        Long stepSize = 1L;
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(2));
        this.initLowerSpinner(minValue, this.getMinAllowedValue(), this.getMaxAllowedValue(), stepSize);
        this.initUpperSpinner(maxValue, this.getMinAllowedValue(), this.getMaxAllowedValue(), stepSize);
        JPanel rangeControlPanel = new JPanel(new GridLayout(1, 2));
        rangeControlPanel.add(this.lowerSpinner.getSpinner());
        rangeControlPanel.add(this.upperSpinner.getSpinner());
        panel.add(rangeControlPanel);
        this.infoLabel = new GDHtmlLabel();
        this.infoLabel.setForeground((Color)GThemeDefaults.Colors.Messages.HINT);
        this.infoLabel.setHorizontalAlignment(0);
        panel.add(this.infoLabel);
        return panel;
    }

    @Override
    protected void updateInfoMessage(boolean isValid) {
        if (isValid) {
            Number start = (Number)this.lowerSpinnerModel.getValue();
            Number end = (Number)this.upperSpinnerModel.getValue();
            BigInteger bigStart = BigInteger.valueOf(start.longValue());
            BigInteger bigEnd = BigInteger.valueOf(end.longValue());
            BigInteger delta = bigEnd.subtract(bigStart).add(BigInteger.ONE);
            boolean hexMode = this.lowerSpinner.getTextField().isHexMode() || this.upperSpinner.getTextField().isHexMode();
            String statusMsg = IntegerRangeConstraintEditor.formatStatus(String.format("Range Size: " + (hexMode ? "0x%x" : "%,d"), delta), false);
            this.infoLabel.setText(statusMsg);
        } else {
            this.infoLabel.setText(IntegerRangeConstraintEditor.formatStatus(this.getErrorMessage(), true));
        }
    }

    @Override
    public void reset() {
        Number newMinValue = (Number)this.converter.fromLong(0L);
        Number newMaxValue = (Number)this.converter.fromLong(0L);
        this.setValue(this.getConstraint().copy(newMinValue, newMaxValue));
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    protected ColumnConstraint<T> getValueFromComponent() {
        long lowerValue = this.lowerSpinner.getTextField().getLongValue();
        long upperValue = this.upperSpinner.getTextField().getLongValue();
        return this.getConstraint().copy((Number)this.converter.fromLong(lowerValue), (Number)this.converter.fromLong(upperValue));
    }

    @Override
    protected boolean checkEditorValueValidity() {
        long uVal;
        boolean isValidLower = IntegerRangeConstraintEditor.hasValidValue(this.lowerSpinner);
        boolean isValidUpper = IntegerRangeConstraintEditor.hasValidValue(this.upperSpinner);
        IntegerRangeConstraintEditor.markSpinnerAsValid(this.lowerSpinner, isValidLower);
        IntegerRangeConstraintEditor.markSpinnerAsValid(this.upperSpinner, isValidUpper);
        this.errorMessage = "";
        if (!isValidLower && !isValidUpper) {
            this.errorMessage = "Invalid lower and upper bounds!";
            return false;
        }
        if (!isValidLower) {
            this.errorMessage = "Invalid lower bounds!";
            return false;
        }
        if (!isValidUpper) {
            this.errorMessage = "Invalid upper bounds!";
            return false;
        }
        long lVal = (Long)this.lowerSpinnerModel.getValue();
        if (lVal > (uVal = ((Long)this.upperSpinnerModel.getValue()).longValue())) {
            this.errorMessage = "Upper bounds value must be greater than lower bounds!";
            return false;
        }
        return true;
    }

    private static boolean hasValidValue(IntegerSpinner spinner) {
        Long value;
        long textFieldValue = spinner.getTextField().getLongValue();
        return textFieldValue == (value = (Long)spinner.getSpinner().getValue());
    }

    private static void markSpinnerAsValid(IntegerSpinner spinner, boolean valid) {
        JTextField textField = (JTextField)spinner.getTextField().getComponent();
        textField.setBackground(valid ? VALID_INPUT_COLOR : INVALID_INPUT_COLOR);
    }

    private long getMinAllowedValue() {
        Number value = (Number)this.getConstraint().getMinValue();
        Class<?> class1 = value.getClass();
        if (class1 == Byte.class) {
            return -128L;
        }
        if (class1 == Short.class) {
            return -32768L;
        }
        if (class1 == Integer.class) {
            return Integer.MIN_VALUE;
        }
        if (class1 == Long.class) {
            return Long.MIN_VALUE;
        }
        throw new IllegalArgumentException("IntegerValueConstraintEditor does not suppport values of type " + class1);
    }

    private long getMaxAllowedValue() {
        Number value = (Number)this.getConstraint().getMinValue();
        Class<?> class1 = value.getClass();
        if (class1 == Byte.class) {
            return 127L;
        }
        if (class1 == Short.class) {
            return 32767L;
        }
        if (class1 == Integer.class) {
            return Integer.MAX_VALUE;
        }
        if (class1 == Long.class) {
            return Long.MAX_VALUE;
        }
        throw new IllegalArgumentException("IntegerValueConstraintEditor does not suppport values of type " + class1);
    }

    @Override
    protected void updateEditorComponent() {
        if (this.hasEditorComponents()) {
            Number minValue = (Number)this.getConstraint().getMinValue();
            Number maxValue = (Number)this.getConstraint().getMaxValue();
            this.lowerSpinnerModel.setValue(minValue.longValue());
            this.upperSpinnerModel.setValue(maxValue.longValue());
        }
        this.valueChanged();
    }

    private RangeColumnConstraint<T> getConstraint() {
        return (RangeColumnConstraint)this.currentConstraint;
    }

    IntegerSpinner getLowerSpinner() {
        return this.lowerSpinner;
    }

    IntegerSpinner getUpperSpinner() {
        return this.upperSpinner;
    }
}

