/*
 * Decompiled with CFR 0.152.
 */
package help.validator;

import help.validator.model.AnchorDefinition;
import help.validator.model.HREF;
import help.validator.model.IMG;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AnchorManager {
    private Map<String, AnchorDefinition> anchorsByHelpPath = new HashMap<String, AnchorDefinition>();
    private Map<String, AnchorDefinition> anchorsById = new HashMap<String, AnchorDefinition>();
    private Map<String, AnchorDefinition> anchorsByName = new HashMap<String, AnchorDefinition>();
    private Map<String, List<AnchorDefinition>> duplicateAnchorsById = new HashMap<String, List<AnchorDefinition>>();
    private List<HREF> anchorRefs = new ArrayList<HREF>();
    private List<IMG> imgRefs = new ArrayList<IMG>();

    public void addAnchor(Path file, String anchorName, int srcLineNo) {
        AnchorDefinition anchor = new AnchorDefinition(file, anchorName, srcLineNo);
        String id = anchor.getId();
        if (this.anchorsById.containsKey(id)) {
            this.addDuplicateAnchor(anchorName, anchor, id);
            return;
        }
        this.anchorsById.put(id, anchor);
        this.anchorsByHelpPath.put(anchor.getHelpPath(), anchor);
        if (anchorName != null) {
            this.anchorsByName.put(anchorName, anchor);
        }
    }

    private void addDuplicateAnchor(String anchorName, AnchorDefinition anchor, String id) {
        List<AnchorDefinition> list = this.duplicateAnchorsById.get(id);
        if (list == null) {
            list = new ArrayList<AnchorDefinition>();
            list.add(this.anchorsById.get(id));
            this.duplicateAnchorsById.put(id, list);
        }
        list.add(anchor);
        if (anchorName == null) {
            return;
        }
        if (!this.anchorsByName.containsKey(anchorName)) {
            this.anchorsByName.put(anchorName, anchor);
            this.anchorsByHelpPath.put(anchor.getHelpPath(), anchor);
        }
    }

    public Map<String, AnchorDefinition> getAnchorsByHelpPath() {
        return this.anchorsByHelpPath;
    }

    public AnchorDefinition getAnchorForHelpPath(String path) {
        if (path == null) {
            return null;
        }
        return this.anchorsByHelpPath.get(path);
    }

    public void addAnchorRef(HREF href) {
        this.anchorRefs.add(href);
    }

    public void addImageRef(IMG ref) {
        this.imgRefs.add(ref);
    }

    public List<HREF> getAnchorRefs() {
        return this.anchorRefs;
    }

    public List<IMG> getImageRefs() {
        return this.imgRefs;
    }

    public AnchorDefinition getAnchorForName(String anchorName) {
        return this.anchorsByName.get(anchorName);
    }

    public Map<String, List<AnchorDefinition>> getDuplicateAnchorsByID() {
        this.cleanupDuplicateAnchors();
        return this.duplicateAnchorsById;
    }

    private void cleanupDuplicateAnchors() {
        HashSet<String> keySet = new HashSet<String>(this.duplicateAnchorsById.keySet());
        for (String id : keySet) {
            List<AnchorDefinition> list = this.duplicateAnchorsById.get(id);
            Iterator<AnchorDefinition> iterator = list.iterator();
            while (iterator.hasNext()) {
                AnchorDefinition anchorDefinition = iterator.next();
                if (anchorDefinition.getLineNumber() >= 0) continue;
                iterator.remove();
            }
            if (list.size() != 1) continue;
            list.clear();
            this.duplicateAnchorsById.remove(id);
        }
    }
}

