/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.gadp.client;

import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.dbg.DebuggerModelFactory;
import ghidra.dbg.gadp.client.GadpClient;
import ghidra.dbg.util.ConfigurableFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;

@ConfigurableFactory.FactoryDescription(brief="Ghidra debug agent (GADP)", htmlDetails="Connect to a Ghidra debug agent using GADP.\nThis is Ghidra's debugging protocol.\nUse this if launching a (usually remote) agent manually.")
public class GadpTcpDebuggerModelFactory
implements DebuggerModelFactory {
    private String host = "localhost";
    @ConfigurableFactory.FactoryOption(value="Agent network address")
    public final ConfigurableFactory.Property<String> agentAddressOption = ConfigurableFactory.Property.fromAccessors(String.class, this::getAgentAddress, this::setAgentAddress);
    private int port = 15432;
    @ConfigurableFactory.FactoryOption(value="Agent TCP port")
    public final ConfigurableFactory.Property<Integer> agentPortOption = ConfigurableFactory.Property.fromAccessors(Integer.class, this::getAgentPort, this::setAgentPort);

    public CompletableFuture<GadpClient> build() {
        try {
            AsynchronousChannelGroup group = AsynchronousChannelGroup.withThreadPool(Executors.newSingleThreadExecutor());
            AsynchronousSocketChannel channel = AsynchronousSocketChannel.open(group);
            CompletableFuture connect = AsyncUtils.completable((TypeSpec)TypeSpec.VOID, channel::connect, (Object)new InetSocketAddress(this.host, this.port));
            return connect.thenCompose(__ -> {
                GadpClient client = this.createClient(this.host + ":" + this.port, channel);
                return client.connect().thenApply(___ -> client);
            });
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    protected GadpClient createClient(String description, AsynchronousByteChannel channel) {
        return new GadpClient(description, channel);
    }

    public String getAgentAddress() {
        return this.host;
    }

    public void setAgentAddress(String host) {
        this.host = host;
    }

    public int getAgentPort() {
        return this.port;
    }

    public void setAgentPort(int port) {
        this.port = port;
    }
}

