/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import com.google.gson.JsonObject;
import docking.widgets.tree.GTree;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ISF.IsfDataTypeWriter;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class DataTypeWriterTask
extends Task {
    private final DataTypeManager programDataTypeMgr;
    private final List<DataType> dataTypeList;
    private final File file;
    private final GTree gTree;

    public DataTypeWriterTask(GTree gTree, DataTypeManager programDataTypeMgr, List<DataType> dataTypeList, File file) {
        super("Export Data Types", true, false, true);
        this.gTree = gTree;
        this.programDataTypeMgr = programDataTypeMgr;
        this.dataTypeList = dataTypeList;
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor) {
        try {
            FileWriter baseWriter = this.file == null ? null : new FileWriter(this.file);
            try (IsfDataTypeWriter dataTypeWriter = new IsfDataTypeWriter(this.programDataTypeMgr, this.dataTypeList, baseWriter);){
                JsonObject object = dataTypeWriter.getRootObject(monitor);
                if (this.file != null) {
                    dataTypeWriter.write(object);
                }
            }
        }
        catch (CancelledException baseWriter) {
        }
        catch (IOException e) {
            Msg.showError(((Object)((Object)this)).getClass(), (Component)this.gTree, (String)"Export Data Types Failed", (Object)("Error exporting Data Types: " + e));
            return;
        }
    }
}

