/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.MIPS_Elf64Relocation;
import ghidra.app.util.bin.format.elf.relocation.MIPS_ElfRelocationContext;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.util.exception.AssertException;
import java.util.Iterator;
import java.util.Map;

public class MIPS_ElfRelocationHandler
extends ElfRelocationHandler {
    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 8;
    }

    public MIPS_ElfRelocationContext createRelocationContext(ElfLoadHelper loadHelper, Map<ElfSymbol, Address> symbolMap) {
        return new MIPS_ElfRelocationContext(this, loadHelper, symbolMap);
    }

    public RelocationResult relocate(ElfRelocationContext elfRelocationContext, ElfRelocation relocation, Address relocationAddress) throws MemoryAccessException {
        ElfHeader elf = elfRelocationContext.getElfHeader();
        if (elf.e_machine() != 8) {
            return RelocationResult.FAILURE;
        }
        MIPS_ElfRelocationContext mipsRelocationContext = (MIPS_ElfRelocationContext)elfRelocationContext;
        mipsRelocationContext.lastSymbolAddr = null;
        mipsRelocationContext.lastElfSymbol = null;
        int type = relocation.getType();
        int symbolIndex = relocation.getSymbolIndex();
        boolean saveValueForNextReloc = mipsRelocationContext.nextRelocationHasSameOffset(relocation);
        RelocationResult lastResult = RelocationResult.FAILURE;
        if (elf.is64Bit()) {
            MIPS_Elf64Relocation mips64Relocation = (MIPS_Elf64Relocation)relocation;
            for (int n = 0; n < 3; ++n) {
                int nextRelocType;
                int relocType = type & 0xFF;
                symbolIndex = n == 0 ? mips64Relocation.getSymbolIndex() : (n == 1 ? mips64Relocation.getSpecialSymbolIndex() : 0);
                RelocationResult result = this.doRelocate(mipsRelocationContext, relocType, symbolIndex, mips64Relocation, relocationAddress, (nextRelocType = n < 2 ? (type >>= 8) & 0xFF : 0) != 0 || saveValueForNextReloc);
                if (result.status() == Relocation.Status.FAILURE || result.status() == Relocation.Status.UNSUPPORTED) {
                    return result;
                }
                lastResult = result;
                symbolIndex = 0;
                if (nextRelocType == 0) break;
            }
            return lastResult;
        }
        return this.doRelocate(mipsRelocationContext, type, symbolIndex, relocation, relocationAddress, saveValueForNextReloc);
    }

    private RelocationResult doRelocate(MIPS_ElfRelocationContext mipsRelocationContext, int relocType, int symbolIndex, ElfRelocation relocation, Address relocationAddress, boolean saveValue) throws MemoryAccessException, AddressOutOfBoundsException {
        if (relocType == 0) {
            return RelocationResult.SKIPPED;
        }
        Program program = mipsRelocationContext.getProgram();
        Memory memory = program.getMemory();
        MessageLog log = mipsRelocationContext.getLog();
        ElfHeader elf = mipsRelocationContext.getElfHeader();
        long offset = (int)relocationAddress.getOffset();
        ElfSymbol elfSymbol = mipsRelocationContext.getSymbol(symbolIndex);
        Address symbolAddr = mipsRelocationContext.getSymbolAddress(elfSymbol);
        long symbolValue = mipsRelocationContext.getSymbolValue(elfSymbol);
        String symbolName = mipsRelocationContext.getSymbolName(symbolIndex);
        if (symbolIndex != 0) {
            mipsRelocationContext.lastSymbolAddr = symbolAddr;
            mipsRelocationContext.lastElfSymbol = elfSymbol;
        }
        long addend = 0L;
        if (mipsRelocationContext.useSavedAddend) {
            if (mipsRelocationContext.savedAddendHasError) {
                MIPS_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (String)Integer.toString(relocType), (String)symbolName, (String)"Stacked relocation failure", (MessageLog)log);
                mipsRelocationContext.useSavedAddend = saveValue;
                mipsRelocationContext.savedAddend = 0L;
                return RelocationResult.FAILURE;
            }
            addend = mipsRelocationContext.savedAddend;
        } else if (relocation.hasAddend()) {
            addend = relocation.getAddend();
        }
        if (!elfSymbol.isLocal()) {
            if (relocType == 20) {
                relocType = 19;
                addend = 0L;
            } else if (relocType == 146) {
                relocType = 145;
                addend = 0L;
            }
        }
        mipsRelocationContext.savedAddendHasError = false;
        mipsRelocationContext.savedAddend = 0L;
        boolean isGpDisp = false;
        if ("_gp_disp".equals(symbolName)) {
            isGpDisp = true;
        } else if ("__gnu_local_gp".equals(symbolName)) {
            MIPS_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (String)Integer.toString(relocType), (String)symbolName, (String)"__gnu_local_gp relocation not yet supported", (MessageLog)log);
            if (saveValue) {
                mipsRelocationContext.savedAddendHasError = true;
            }
            return RelocationResult.FAILURE;
        }
        long oldValue = Integer.toUnsignedLong(this.unshuffle(memory.getInt(relocationAddress), relocType, mipsRelocationContext));
        long value = 0L;
        long newValue = 0L;
        boolean writeNewValue = false;
        Relocation.Status status = Relocation.Status.PARTIAL;
        int byteLength = 4;
        switch (relocType) {
            case 21: 
            case 147: {
                if (mipsRelocationContext.extractAddend()) {
                    addend = oldValue & 0xFFFFL;
                }
                long pageOffset = symbolValue + addend + 32768L & 0xFFFFFFFFFFFF0000L;
                value = symbolValue + addend - pageOffset;
                newValue = oldValue & 0xFFFFFFFFFFFF0000L | value & 0xFFFFL;
                writeNewValue = true;
                break;
            }
            case 20: 
            case 146: {
                long pageOffset;
                Address gotAddr;
                if (mipsRelocationContext.extractAddend()) {
                    addend = oldValue & 0xFFFFL;
                }
                if ((gotAddr = mipsRelocationContext.getSectionGotAddress(pageOffset = symbolValue + addend + 32768L & 0xFFFFFFFFFFFF0000L)) == null) {
                    MIPS_ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)relocationAddress, (String)Integer.toString(relocType), (String)symbolName, (String)("Relocation Failed, unable to allocate GOT entry for relocation symbol: " + symbolName), (MessageLog)mipsRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                value = this.getGpOffset(mipsRelocationContext, gotAddr.getOffset());
                if (value == -1L) {
                    MIPS_ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)relocationAddress, (String)Integer.toString(relocType), (String)symbolName, (String)"Failed to perform GP-based relocation", (MessageLog)mipsRelocationContext.getLog());
                    if (saveValue) {
                        mipsRelocationContext.savedAddendHasError = true;
                    }
                    return RelocationResult.FAILURE;
                }
                newValue = oldValue & 0xFFFFFFFFFFFF0000L | value & 0xFFFFL;
                writeNewValue = true;
                break;
            }
            case 19: 
            case 22: 
            case 145: 
            case 148: {
                Address gotAddr = mipsRelocationContext.getSectionGotAddress(symbolValue);
                if (gotAddr == null) {
                    MIPS_ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)relocationAddress, (String)Integer.toString(relocType), (String)symbolName, (String)("Relocation Failed, unable to allocate GOT entry for relocation symbol: " + symbolName), (MessageLog)mipsRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                value = this.getGpOffset(mipsRelocationContext, gotAddr.getOffset());
                if (value == -1L) {
                    MIPS_ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)relocationAddress, (String)Integer.toString(relocType), (String)symbolName, (String)"Failed to perform GP-based relocation", (MessageLog)mipsRelocationContext.getLog());
                    if (saveValue) {
                        mipsRelocationContext.savedAddendHasError = true;
                    }
                    return RelocationResult.FAILURE;
                }
                long appliedValue = relocType == 19 ? value & 0xFFFFL : value + 32768L >> 16 & 0xFFFFL;
                newValue = oldValue & 0xFFFFFFFFFFFF0000L | appliedValue;
                writeNewValue = true;
                break;
            }
            case 9: 
            case 102: 
            case 138: {
                if (elfSymbol.isLocal()) {
                    MIPS_DeferredRelocation got16reloc = new MIPS_DeferredRelocation(relocType, elfSymbol, relocationAddress, oldValue, addend, isGpDisp);
                    mipsRelocationContext.addGOT16Relocation(got16reloc);
                    break;
                }
            }
            case 11: 
            case 103: 
            case 142: {
                Address gotAddr = mipsRelocationContext.getSectionGotAddress(symbolValue + addend);
                if (gotAddr == null) {
                    MIPS_ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)relocationAddress, (String)Integer.toString(relocType), (String)symbolName, (String)("Relocation Failed, unable to allocate GOT entry for relocation symbol: " + symbolName), (MessageLog)mipsRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                value = this.getGpOffset(mipsRelocationContext, gotAddr.getOffset());
                if (value == -1L) {
                    MIPS_ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)relocationAddress, (String)Integer.toString(relocType), (String)symbolName, (String)"Failed to perform GP-based relocation", (MessageLog)mipsRelocationContext.getLog());
                    if (saveValue) {
                        mipsRelocationContext.savedAddendHasError = true;
                    }
                    return RelocationResult.FAILURE;
                }
                newValue = oldValue & 0xFFFFFFFFFFFF0000L | value & 0xFFFFL;
                writeNewValue = true;
                break;
            }
            case 30: 
            case 153: {
                Address gotAddr = mipsRelocationContext.getSectionGotAddress(symbolValue + addend);
                if (gotAddr == null) {
                    MIPS_ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)relocationAddress, (String)Integer.toString(relocType), (String)symbolName, (String)("Relocation Failed, unable to allocate GOT entry for relocation symbol: " + symbolName), (MessageLog)mipsRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                value = this.getGpOffset(mipsRelocationContext, gotAddr.getOffset());
                if (value == -1L) {
                    MIPS_ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)relocationAddress, (String)Integer.toString(relocType), (String)symbolName, (String)"Failed to perform GP-based relocation", (MessageLog)mipsRelocationContext.getLog());
                    if (saveValue) {
                        mipsRelocationContext.savedAddendHasError = true;
                    }
                    return RelocationResult.FAILURE;
                }
                newValue = oldValue & 0xFFFFFFFFFFFF0000L | value + 32768L >> 16 & 0xFFFFL;
                writeNewValue = true;
                break;
            }
            case 5: 
            case 104: 
            case 134: {
                if (mipsRelocationContext.getGPValue() == -1L) {
                    MIPS_ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)relocationAddress, (String)Integer.toString(relocType), (String)elfSymbol.getNameAsString(), (String)"Failed to perform GP-based relocation", (MessageLog)mipsRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                MIPS_DeferredRelocation hi16reloc = new MIPS_DeferredRelocation(relocType, elfSymbol, relocationAddress, oldValue, (int)addend, isGpDisp);
                mipsRelocationContext.addHI16Relocation(hi16reloc);
                break;
            }
            case 6: 
            case 105: 
            case 135: 
            case 157: {
                if (mipsRelocationContext.extractAddend()) {
                    addend = (short)(oldValue & 0xFFFFL);
                }
                this.processHI16Relocations(mipsRelocationContext, relocType, elfSymbol, (int)addend);
                this.processGOT16Relocations(mipsRelocationContext, relocType, elfSymbol, (int)addend);
                if (isGpDisp) {
                    value = mipsRelocationContext.getGPValue();
                    if (value == -1L) {
                        MIPS_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (String)Integer.toString(relocType), (String)symbolName, (String)"Failed to perform GP-based relocation", (MessageLog)mipsRelocationContext.getLog());
                        if (saveValue) {
                            mipsRelocationContext.savedAddendHasError = true;
                        }
                        return RelocationResult.FAILURE;
                    }
                    value = relocType == 105 ? (value -= offset & 0xFFFFFFFFFFFFFFFCL) : (value -= offset - 4L);
                } else {
                    value = (int)symbolValue;
                }
                newValue = oldValue & 0xFFFFFFFFFFFF0000L | (value += addend) & 0xFFFFL;
                writeNewValue = true;
                break;
            }
            case 3: {
                if (symbolIndex == 0) {
                    symbolValue = mipsRelocationContext.getImageBaseWordAdjustmentOffset();
                }
                value = symbolValue;
                if (mipsRelocationContext.extractAddend()) {
                    addend = elf.is64Bit() ? (long)((int)memory.getLong(relocationAddress)) : (long)memory.getInt(relocationAddress);
                }
                newValue = value + addend;
                if (saveValue) {
                    mipsRelocationContext.savedAddend = newValue;
                    break;
                }
                memory.setInt(relocationAddress, (int)newValue);
                status = Relocation.Status.APPLIED;
                if (symbolIndex == 0 || addend == 0L || elfSymbol.isSection()) break;
                MIPS_ElfRelocationHandler.warnExternalOffsetRelocation((Program)program, (Address)relocationAddress, (Address)symbolAddr, (String)symbolName, (long)addend, (MessageLog)mipsRelocationContext.getLog());
                MIPS_ElfRelocationHandler.applyComponentOffsetPointer((Program)program, (Address)relocationAddress, (long)addend);
                break;
            }
            case 2: {
                value = symbolValue;
                if (mipsRelocationContext.extractAddend()) {
                    addend = memory.getInt(relocationAddress);
                }
                newValue = value + addend;
                if (saveValue) {
                    mipsRelocationContext.savedAddend = newValue;
                    break;
                }
                memory.setInt(relocationAddress, (int)newValue);
                status = Relocation.Status.APPLIED;
                break;
            }
            case 4: 
            case 100: 
            case 133: {
                int shift;
                int n = shift = relocType == 133 ? 1 : 2;
                if (mipsRelocationContext.extractAddend()) {
                    addend = (oldValue & 0x3FFFFFFL) << shift;
                }
                if (!elfSymbol.isLocal() && !elfSymbol.isSection()) {
                    addend = this.signExtend((int)addend, 26 + shift);
                }
                value = addend + symbolValue >> shift;
                newValue = oldValue & 0xFFFFFFFFFC000000L | value & 0x3FFFFFFL;
                writeNewValue = true;
                break;
            }
            case 60: {
                if (mipsRelocationContext.extractAddend()) {
                    addend = (oldValue & 0x1FFFFFL) << 2;
                }
                if (!elfSymbol.isLocal() && !elfSymbol.isSection()) {
                    addend = this.signExtend((int)addend, 23);
                }
                value = addend + symbolValue - offset >> 2;
                newValue = oldValue & 0xFFFFFFFFFFE00000L | value & 0x1FFFFFL;
                writeNewValue = true;
                break;
            }
            case 61: {
                if (mipsRelocationContext.extractAddend()) {
                    addend = (oldValue & 0x3FFFFFFL) << 2;
                }
                if (!elfSymbol.isLocal() && !elfSymbol.isSection()) {
                    addend = this.signExtend((int)addend, 28);
                }
                value = addend + symbolValue - offset >> 2;
                newValue = oldValue & 0xFFFFFFFFFC000000L | value & 0x3FFFFFFL;
                writeNewValue = true;
                break;
            }
            case 10: {
                if (mipsRelocationContext.extractAddend()) {
                    addend = (oldValue & 0xFFFFL) << 2;
                }
                value = symbolValue - offset + (long)this.signExtend((int)addend, 18);
                newValue = oldValue & 0xFFFFFFFFFFFF0000L | value >> 2 & 0xFFFFL;
                writeNewValue = true;
                break;
            }
            case 18: {
                if (mipsRelocationContext.extractAddend()) {
                    addend = memory.getLong(relocationAddress);
                }
                newValue = symbolValue + addend;
                if (saveValue) {
                    mipsRelocationContext.savedAddend = newValue;
                    break;
                }
                memory.setLong(relocationAddress, newValue);
                byteLength = 8;
                status = Relocation.Status.APPLIED;
                boolean isSectionBased = elfSymbol.isSection();
                Address addr = symbolAddr;
                if (symbolIndex == 0 && mipsRelocationContext.lastSymbolAddr != null) {
                    addr = mipsRelocationContext.lastSymbolAddr;
                    symbolName = mipsRelocationContext.lastElfSymbol.getNameAsString();
                    isSectionBased = mipsRelocationContext.lastElfSymbol.isSection();
                }
                if (addr == null || isSectionBased) break;
                if (symbolIndex == 0) {
                    addend -= addr.getOffset();
                }
                if (addend == 0L) break;
                MIPS_ElfRelocationHandler.warnExternalOffsetRelocation((Program)program, (Address)relocationAddress, (Address)addr, (String)symbolName, (long)addend, (MessageLog)mipsRelocationContext.getLog());
                if (!elf.is64Bit()) break;
                MIPS_ElfRelocationHandler.applyComponentOffsetPointer((Program)program, (Address)relocationAddress, (long)addend);
                break;
            }
            case 28: 
            case 151: {
                if (mipsRelocationContext.extractAddend()) {
                    addend = oldValue;
                }
                value = symbolValue + 0x80008000L + (addend &= 0xFFFFL);
                value = value >> 32 & 0xFFFFL;
                newValue = oldValue & 0xFFFFFFFFFFFF0000L | value;
                writeNewValue = true;
                break;
            }
            case 29: 
            case 152: {
                if (mipsRelocationContext.extractAddend()) {
                    addend = oldValue;
                }
                value = symbolValue + 0x80008000L + (addend &= 0xFFFFL);
                value = value >> 48 & 0xFFFFL;
                newValue = oldValue & 0xFFFFFFFFFFFF0000L | value;
                writeNewValue = true;
                break;
            }
            case 139: {
                if (mipsRelocationContext.extractAddend()) {
                    addend = (oldValue & 0x7F0000L) >> 15;
                }
                value = symbolValue + addend - offset >> 1 & 0x7FL;
                newValue = oldValue & 0xFFFFFFFFFF80FFFFL | value << 16;
                writeNewValue = true;
                break;
            }
            case 140: {
                if (mipsRelocationContext.extractAddend()) {
                    addend = (oldValue & 0x3FF0000L) >> 15;
                }
                value = symbolValue + addend - offset >> 1 & 0x3FFL;
                newValue = oldValue & 0xFFFFFFFFFC00FFFFL | value << 16;
                writeNewValue = true;
                break;
            }
            case 141: {
                if (mipsRelocationContext.extractAddend()) {
                    addend = (oldValue & 0xFFFFL) << 1;
                }
                value = symbolValue + addend - offset >> 1 & 0xFFFFL;
                newValue = oldValue & 0xFFFFFFFFFFFF0000L | value;
                writeNewValue = true;
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 101: 
            case 136: 
            case 137: 
            case 172: {
                long gp;
                if (mipsRelocationContext.extractAddend()) {
                    if (relocType == 12) {
                        addend = oldValue;
                    } else {
                        addend = oldValue & 0xFFFFL;
                        if (relocType == 172) {
                            addend <<= 2;
                        }
                        addend = this.signExtend((int)addend, 16);
                    }
                }
                long gp0 = 0L;
                if (elfSymbol.isLocal() && (relocType == 7 || relocType == 12)) {
                    gp0 = mipsRelocationContext.getGP0Value();
                    if (gp0 == -1L) {
                        MIPS_ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)relocationAddress, (String)Integer.toString(relocType), (String)symbolName, (String)"Failed to perform local GP0-based relocation (requires .reginfo data)", (MessageLog)mipsRelocationContext.getLog());
                        if (saveValue) {
                            mipsRelocationContext.savedAddendHasError = true;
                        }
                        return RelocationResult.FAILURE;
                    }
                    if (gp0 == 0L) {
                        gp0 = mipsRelocationContext.getImageBaseWordAdjustmentOffset();
                    }
                }
                if ((gp = mipsRelocationContext.getGPValue()) == -1L) {
                    MIPS_ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)relocationAddress, (String)Integer.toString(relocType), (String)symbolName, (String)"Failed to perform GP-based relocation", (MessageLog)mipsRelocationContext.getLog());
                    if (saveValue) {
                        mipsRelocationContext.savedAddendHasError = true;
                    }
                    return RelocationResult.FAILURE;
                }
                value = symbolValue + addend - gp + gp0;
                long mask = relocType == 12 ? 0xFFFFFFFFL : 65535L;
                newValue = oldValue & (mask ^ 0xFFFFFFFFFFFFFFFFL) | value & mask;
                writeNewValue = true;
                break;
            }
            case 24: 
            case 150: {
                if (mipsRelocationContext.extractAddend()) {
                    addend = oldValue;
                }
                newValue = symbolValue - addend;
                if (saveValue) {
                    mipsRelocationContext.savedAddend = newValue;
                    break;
                }
                memory.setLong(relocationAddress, newValue);
                byteLength = 8;
                status = Relocation.Status.APPLIED;
                break;
            }
            case 126: {
                MIPS_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_MIPS_COPY", (String)symbolName, (long)symbolIndex, (String)"Runtime copy not supported", (MessageLog)log);
                if (saveValue) {
                    mipsRelocationContext.savedAddendHasError = true;
                }
                return RelocationResult.UNSUPPORTED;
            }
            case 127: {
                if (saveValue) {
                    mipsRelocationContext.savedAddend = symbolValue;
                } else if (mipsRelocationContext.getElfHeader().is64Bit()) {
                    memory.setLong(relocationAddress, symbolValue);
                    byteLength = 8;
                } else {
                    memory.setInt(relocationAddress, (int)symbolValue);
                }
                status = Relocation.Status.APPLIED;
                break;
            }
            case 37: 
            case 156: {
                MemoryBlock block;
                boolean success = false;
                Address symAddr = mipsRelocationContext.getSymbolAddress(elfSymbol);
                if (symAddr != null && (block = memory.getBlock(symAddr)) != null) {
                    if ("EXTERNAL".equals(block.getName())) {
                        boolean bl = success = mipsRelocationContext.getLoadHelper().createExternalFunctionLinkage(symbolName, symAddr, null) != null;
                        if (success) {
                            if (relocType == 156) {
                                int offsetBits = (int)(symAddr.getOffset() >> 1) & 0x3FFFFFF;
                                int microJalrBits = 0xF4000000 | offsetBits;
                                memory.setShort(relocationAddress, (short)(microJalrBits >>> 16));
                                memory.setShort(relocationAddress.add(2L), (short)microJalrBits);
                            } else {
                                int offsetBits = (int)(symAddr.getOffset() >> 2) & 0x3FFFFFF;
                                int jalrBits = 0xC000000 | offsetBits;
                                memory.setInt(relocationAddress, jalrBits);
                            }
                            status = Relocation.Status.APPLIED;
                        }
                    } else {
                        return RelocationResult.SKIPPED;
                    }
                }
                if (success) break;
                MIPS_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (String)(relocType == 37 ? "R_MIPS_JALR" : "R_MICROMIPS_JALR"), (String)symbolName, (String)"Failed to establish external linkage", (MessageLog)log);
                return RelocationResult.FAILURE;
            }
            default: {
                MIPS_ElfRelocationHandler.markAsUnhandled((Program)program, (Address)relocationAddress, (long)relocType, (long)symbolIndex, (String)symbolName, (MessageLog)log);
                if (saveValue) {
                    mipsRelocationContext.savedAddendHasError = true;
                }
                return RelocationResult.UNSUPPORTED;
            }
        }
        if (writeNewValue) {
            if (saveValue) {
                mipsRelocationContext.savedAddend = value;
            } else {
                memory.setInt(relocationAddress, this.shuffle((int)newValue, relocType, mipsRelocationContext));
                status = Relocation.Status.APPLIED;
            }
        }
        mipsRelocationContext.useSavedAddend = saveValue;
        return new RelocationResult(status, byteLength);
    }

    private boolean isMIPS16Reloc(int type) {
        return type >= 100 && type <= 112;
    }

    private boolean isMicroMIPSReloc(int type) {
        return type >= 133 && type <= 173;
    }

    private boolean shuffleRequired(int type) {
        return this.isMIPS16Reloc(type) || this.isMicroMIPSReloc(type) && type != 139 && type != 140;
    }

    private boolean isMIPS16_26_JAL_Reloc(int type, ElfRelocationContext elfRelocationContext) {
        return type == 100 && elfRelocationContext.getElfHeader().isRelocatable();
    }

    private int unshuffle(int value, int type, ElfRelocationContext elfRelocationContext) {
        int second;
        int first;
        if (!this.shuffleRequired(type)) {
            return value;
        }
        if (elfRelocationContext.isBigEndian()) {
            first = value >>> 16;
            second = value & 0xFFFF;
        } else {
            first = value & 0xFFFF;
            second = value >>> 16;
        }
        value = this.isMIPS16_26_JAL_Reloc(type, elfRelocationContext) ? (first & 0xF800) << 16 | (second & 0xFFE0) << 11 | (first & 0x1F) << 11 | first & 0x7E0 | second & 0x1F : (this.isMicroMIPSReloc(type) || type == 100 ? first << 16 | second : (first & 0xFC00) << 16 | (first & 0x3E0) << 11 | (first & 0x1F) << 21 | second);
        return value;
    }

    private int shuffle(int value, int type, ElfRelocationContext elfRelocationContext) {
        short second;
        short first;
        if (!this.shuffleRequired(type)) {
            return value;
        }
        if (this.isMIPS16_26_JAL_Reloc(type, elfRelocationContext)) {
            first = (short)(value >> 16 & 0xF800 | value >> 11 & 0x1F | value & 0x7E0);
            second = (short)(value >> 11 & 0xFFE0 | value & 0x1F);
        } else if (this.isMicroMIPSReloc(type) || type == 100) {
            first = (short)(value >> 16);
            second = (short)value;
        } else {
            first = (short)(value >> 16 & 0xFC00 | value >> 11 & 0x3E0 | value >> 21 & 0x1F);
            second = (short)value;
        }
        value = elfRelocationContext.isBigEndian() ? first << 16 | second & 0xFFFF : second << 16 | first & 0xFFFF;
        return value;
    }

    private boolean matchingHiLo16Types(int hi16Type, int lo16Type) {
        switch (hi16Type) {
            case 5: 
            case 9: {
                return lo16Type == 6;
            }
            case 102: 
            case 104: {
                return lo16Type == 105;
            }
            case 134: 
            case 138: {
                return lo16Type == 135;
            }
        }
        return false;
    }

    private int signExtend(int val, int bits) {
        int shift = 32 - bits;
        return val << shift >> shift;
    }

    private void processHI16Relocations(MIPS_ElfRelocationContext mipsRelocationContext, int lo16RelocType, ElfSymbol lo16ElfSymbol, int lo16Addend) {
        Iterator<MIPS_DeferredRelocation> iterateHi16 = mipsRelocationContext.iterateHi16();
        while (iterateHi16.hasNext()) {
            MIPS_DeferredRelocation hi16reloc = iterateHi16.next();
            if (!this.matchingHiLo16Types(hi16reloc.relocType, lo16RelocType) || hi16reloc.elfSymbol != lo16ElfSymbol) continue;
            this.processHI16Relocation(mipsRelocationContext, hi16reloc, lo16Addend);
            iterateHi16.remove();
        }
    }

    private void processHI16Relocation(MIPS_ElfRelocationContext mipsRelocationContext, MIPS_DeferredRelocation hi16reloc, long lo16Addend) {
        long newValue;
        if (hi16reloc.isGpDisp) {
            newValue = (int)mipsRelocationContext.getGPValue();
            if (newValue == -1L) {
                MIPS_ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)hi16reloc.relocAddr, (String)Integer.toString(hi16reloc.relocType), (String)hi16reloc.elfSymbol.getNameAsString(), (String)"Failed to perform GP-based relocation", (MessageLog)mipsRelocationContext.getLog());
                return;
            }
            newValue = hi16reloc.relocType == 104 ? (newValue -= hi16reloc.relocAddr.getOffset() + 4L & 0xFFFFFFFFFFFFFFFCL) : (newValue -= hi16reloc.relocAddr.getOffset());
        } else {
            newValue = (int)mipsRelocationContext.getSymbolValue(hi16reloc.elfSymbol);
        }
        long addend = mipsRelocationContext.extractAddend() ? ((hi16reloc.oldValueL & 0xFFFFL) << 16) + lo16Addend : hi16reloc.addendL;
        newValue = newValue + addend + 32768L >> 16;
        newValue = hi16reloc.oldValueL & 0xFFFFFFFFFFFF0000L | newValue & 0xFFFFL;
        Memory memory = mipsRelocationContext.getProgram().getMemory();
        try {
            memory.setInt(hi16reloc.relocAddr, this.shuffle((int)newValue, hi16reloc.relocType, mipsRelocationContext));
        }
        catch (MemoryAccessException e) {
            throw new AssertException((Throwable)e);
        }
    }

    private void processGOT16Relocations(MIPS_ElfRelocationContext mipsRelocationContext, int lo16RelocType, ElfSymbol lo16ElfSymbol, int lo16Addend) {
        Iterator<MIPS_DeferredRelocation> iterateGot16 = mipsRelocationContext.iterateGot16();
        while (iterateGot16.hasNext()) {
            MIPS_DeferredRelocation hi16reloc = iterateGot16.next();
            if (!this.matchingHiLo16Types(hi16reloc.relocType, lo16RelocType) || hi16reloc.elfSymbol != lo16ElfSymbol) continue;
            this.processGOT16Relocation(mipsRelocationContext, hi16reloc, lo16Addend);
            iterateGot16.remove();
        }
    }

    private void processGOT16Relocation(MIPS_ElfRelocationContext mipsRelocationContext, MIPS_DeferredRelocation got16reloc, long lo16Addend) {
        long addend = mipsRelocationContext.extractAddend() ? ((got16reloc.oldValueL & 0xFFFFL) << 16) + lo16Addend : got16reloc.addendL;
        long symbolValue = (int)mipsRelocationContext.getSymbolValue(got16reloc.elfSymbol);
        String symbolName = got16reloc.elfSymbol.getNameAsString();
        long value = symbolValue + addend + 32768L & 0xFFFFFFFFFFFF0000L;
        Address gotAddr = mipsRelocationContext.getSectionGotAddress(value);
        if (gotAddr == null) {
            MIPS_ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)got16reloc.relocAddr, (String)Integer.toString(got16reloc.relocType), (String)symbolName, (String)"Relocation Failed, unable to allocate GOT entry for relocation symbol", (MessageLog)mipsRelocationContext.getLog());
            return;
        }
        value = this.getGpOffset(mipsRelocationContext, gotAddr.getOffset());
        if (value == -1L) {
            MIPS_ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)got16reloc.relocAddr, (String)Integer.toString(got16reloc.relocType), (String)symbolName, (String)"Failed to perform GP-based relocation", (MessageLog)mipsRelocationContext.getLog());
            return;
        }
        long newValue = got16reloc.oldValueL & 0xFFFFFFFFFFFF0000L | (long)((int)value & 0xFFFF);
        Memory memory = mipsRelocationContext.getProgram().getMemory();
        try {
            memory.setInt(got16reloc.relocAddr, this.shuffle((int)newValue, got16reloc.relocType, mipsRelocationContext));
        }
        catch (MemoryAccessException e) {
            throw new AssertException((Throwable)e);
        }
    }

    private long getGpOffset(MIPS_ElfRelocationContext mipsRelocationContext, long value) {
        long gp = mipsRelocationContext.getGPValue();
        if (gp == -1L) {
            return -1L;
        }
        return value - gp;
    }

    static class MIPS_DeferredRelocation {
        final int relocType;
        final ElfSymbol elfSymbol;
        final Address relocAddr;
        final long oldValueL;
        final long addendL;
        final boolean isGpDisp;

        MIPS_DeferredRelocation(int relocType, ElfSymbol elfSymbol, Address relocAddr, long oldValue, long addend, boolean isGpDisp) {
            this.relocType = relocType;
            this.elfSymbol = elfSymbol;
            this.relocAddr = relocAddr;
            this.oldValueL = oldValue;
            this.addendL = addend;
            this.isGpDisp = isGpDisp;
        }

        void markUnprocessed(MIPS_ElfRelocationContext mipsRelocationContext, String missingDependencyName) {
            ElfRelocationHandler.markAsError((Program)mipsRelocationContext.getProgram(), (Address)this.relocAddr, (String)Integer.toString(this.relocType), (String)this.elfSymbol.getNameAsString(), (String)("Relocation missing required " + missingDependencyName), (MessageLog)mipsRelocationContext.getLog());
        }
    }
}

