#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 brick
version:              1.9
visibility:           public
id:                   brick-1.9-G4jy96pMPkmBqx1AAVnQxh
key:                  brick-1.9-G4jy96pMPkmBqx1AAVnQxh
license:              BSD-3-Clause
copyright:            (c) Jonathan Daugherty 2015-2022
maintainer:           Jonathan Daugherty <cygnus@foobox.com>
author:               Jonathan Daugherty <cygnus@foobox.com>
homepage:             https://github.com/jtdaugherty/brick/
synopsis:             A declarative terminal user interface library
description:
    Write terminal user interfaces (TUIs) painlessly with '\''brick'\''! You
    write an event handler and a drawing function and the library does the
    rest.


    > module Main where
    >
    > import Brick
    >
    > ui :: Widget ()
    > ui = str "Hello, world!"
    >
    > main :: IO ()
    > main = simpleMain ui


    To get started, see:

    * <https://github.com/jtdaugherty/brick/blob/master/README.md The README>

    * The <https://github.com/jtdaugherty/brick/blob/master/docs/guide.rst Brick user guide>

    * The demonstration programs in the '\''programs'\'' directory


    This package deprecates <http://hackage.haskell.org/package/vty-ui vty-ui>.

category:             Graphics
abi:                  c24e91c95f6661923c31dc20a25f8bac
exposed:              True
exposed-modules:
    Brick Brick.AttrMap Brick.BChan Brick.BorderMap Brick.Focus
    Brick.Forms Brick.Keybindings Brick.Keybindings.KeyConfig
    Brick.Keybindings.KeyDispatcher Brick.Keybindings.KeyEvents
    Brick.Keybindings.Parse Brick.Keybindings.Pretty Brick.Main
    Brick.Themes Brick.Types Brick.Util Brick.Widgets.Border
    Brick.Widgets.Border.Style Brick.Widgets.Center Brick.Widgets.Core
    Brick.Widgets.Dialog Brick.Widgets.Edit Brick.Widgets.FileBrowser
    Brick.Widgets.List Brick.Widgets.ProgressBar Brick.Widgets.Table
    Data.IMap

hidden-modules:
    Brick.Types.Common Brick.Types.TH Brick.Types.EventM
    Brick.Types.Internal Brick.Widgets.Internal

import-dirs:          /usr/lib/ghc-9.4.8/site-local/brick-1.9
library-dirs:         /usr/lib/ghc-9.4.8/site-local/brick-1.9
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/brick-1.9
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-brick
hs-libraries:         HSbrick-1.9-G4jy96pMPkmBqx1AAVnQxh
depends:
    base-4.17.2.1 bimap-0.5.0-BAfkrKaJUGO8Gar440TGhI
    bytestring-0.11.5.3 config-ini-0.2.6.0-CFFVZaiQzdK6KOo0tZpEHB
    containers-0.6.7 data-clist-0.2-SoGGqmgYsUKHBsTKja9JF
    deepseq-1.4.8.0 directory-1.3.7.1 exceptions-0.10.5
    filepath-1.4.2.2 microlens-0.4.13.1-BCmTOusOWAwKF1xfvNhRYd
    microlens-mtl-0.2.0.3-vQELA1onhlLfPXHvjZtx7
    microlens-th-0.4.3.17-Vfga0HXPTS6SXD3NuXqZ3 mtl-2.2.2 stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2
    text-zipper-0.13-CpOb0fOGPdPA8Kg9lYIH9e unix-2.7.3
    vector-0.13.1.0-Dc65CzydytHE52tdajtbOv
    vty-5.39-KkmaeTwc8ZA2a1HDk0Ulcz
    word-wrap-0.5-B8C3Xb3lHAZHacNLsUigRA

haddock-interfaces:   /usr/share/doc/haskell-brick/html/brick.haddock
haddock-html:         /usr/share/doc/haskell-brick/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

