#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.0
visibility:           public
id:                   hOpenPGP-2.10.0-4hDGdYYRpyS2WhOQLrTtk5
key:                  hOpenPGP-2.10.0-4hDGdYYRpyS2WhOQLrTtk5
license:              MIT
copyright:            2012-2024  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  2627e1409abb863bbf20d0c49086b6c4
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Data.Conduit.OpenPGP.Compression Data.Conduit.OpenPGP.Decrypt
    Data.Conduit.OpenPGP.Filter Data.Conduit.OpenPGP.Keyring
    Data.Conduit.OpenPGP.Keyring.Instances Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.0-4hDGdYYRpyS2WhOQLrTtk5
depends:
    aeson-2.1.2.1-GOr0sGsn8HVJzt9KhewtB0
    asn1-encoding-0.9.6-LGhJbxhD6Cf3nqUWbw5SbR
    attoparsec-0.14.4-CiUWnNTnUzcEcRmqqSBimu base-4.17.2.1
    base16-bytestring-1.0.2.0-48ZRmm275Sv4uBxPoXHzXc
    bifunctors-5.6-HaIWxrePO92KlaNmJJfxgZ binary-0.8.9.1
    binary-conduit-1.3.1-B3UoP1jPIsrK0nI4FElq5H bytestring-0.11.5.3
    bz2-1.0.1.1-Iw93mJpbFW2AxGKlAaYKfl
    conduit-1.3.6.1-GhV2KMoemFPB5FDryFR5X5
    conduit-extra-1.3.6-4VZQrDv9KU68F339d2BW5y containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-1.0.0-IIrgJZNDZ7S1y2tDaxcuSw
    errors-2.3.0-JLgn8LP2yuX8UsXlcJZ1HO
    hashable-1.4.4.0-HA5jWeGkLE053htWZjUgjX
    incremental-parser-0.5.1-JS0OBDldFAzKdtWAz48HKX
    ixset-typed-0.5.1.0-Ai8j7oJKOot3q83lDrU7qX
    lens-5.2.3-J1GK3I4tdtMEzlekK9vBY2
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-2Sr7Eg9Bhz3KcJ8Mdx9CYP
    openpgp-asciiarmor-0.1.2-8wypmO25MrDJPz0tJPjuuG
    prettyprinter-1.7.1-2SyS45w2YIjHD6NDr8Zx1B
    resourcet-1.2.6-1qaZdHoBp5u2zlBnaE55JI
    split-0.2.5-m008juveJFC906Vg2goUt text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-Jl6TkouWI2i1D1jczNV0uv
    zlib-0.6.3.0-LpsU7RxXEmX5AsdSWV7cLM

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

