#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-5pstoB97H4PKga43D3C6d4
key:                  trifecta-2.1.4-5pstoB97H4PKga43D3C6d4
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  f4e1799237128f8d4e9aa2344b408d5b
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-5pstoB97H4PKga43D3C6d4
depends:
    ansi-terminal-1.0.2-6TxOAUbfOQrDbPnWIRhRhS array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.2.3-1WUo1omsOYUH2PSkelI6MS
    blaze-html-0.9.2.0-FKwarBKbyvpIFQ2PEdKkVd
    blaze-markup-0.8.3.0-58qVR6Ti62D37e0qM46OpS bytestring-0.11.5.3
    charset-0.3.12-8OkXZHQ1GRn1hWi9ySzkR3
    comonad-5.0.9-LkJkT74yhsMAX9tSgmZsNW containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.5.0-JJ7YgqPdvGQ1ClzIYoBO7J
    ghc-prim-0.9.1 hashable-1.4.4.0-5O85VrI4oZ4EDBPYdTgwgk
    indexed-traversable-0.1.4-5uvxwew3Uwx9YqKKWPbxP3
    lens-5.2.3-CV81uxSR0PiAcO8XtynZEb mtl-2.2.2
    parsers-0.12.12-75fcA51k0S9J1QdyfPEl96
    prettyprinter-1.7.1-BaAmjemZ9A8Bwhfteg2YYF
    prettyprinter-ansi-terminal-1.1.3-3UaEd28yvERuzLBWT3ZVt
    profunctors-5.6.2-HcmQMl1CmCsL3Ph63hJBuk
    reducers-3.12.5-BpCvDZxa0lJErkgYh0x0DJ transformers-0.5.6.2
    unordered-containers-0.2.20-2kG5VEC3Gy42AwINT9WJ9w
    utf8-string-1.0.2-FnO1h94XkEn7naEuvLflUO

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

