#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-iadd
version:              1.3.20
visibility:           public
id:                   hledger-iadd-1.3.20-GwEaxXziL71PeGxoBxcIw
key:                  hledger-iadd-1.3.20-GwEaxXziL71PeGxoBxcIw
license:              BSD-3-Clause
copyright:            2018 Hans-Peter Deifel
maintainer:           Hans-Peter Deifel <hpd@hpdeifel.de>
author:               Hans-Peter Deifel <hpd@hpdeifel.de>
homepage:             https://github.com/hpdeifel/hledger-iadd#readme
synopsis:             A terminal UI as drop-in replacement for hledger add
description:
    This is a terminal UI as drop-in replacement for hledger add.

    It improves in the following ways on hledger'\''s add command:

    * Interactive as-you-type completion for
    account names and descriptions with optional
    fuzzy matching.

    * Integrated calculator: Amounts can be written
    as simple sums with real-time feedback on the
    result.

    * All actions while entering a transaction can
    be undone

    * Configurable format for date input. Instead
    of @y\/m\/d@ it is also possible to use other
    formats like the german @d.m.y@.

category:             Finance, Console
abi:                  d5a689a6c809409b32e9783d7c995665
exposed:              True
exposed-modules:
    AmountParser Brick.Widgets.BetterDialog Brick.Widgets.Border.Utils
    Brick.Widgets.CommentDialog Brick.Widgets.Edit.EmacsBindings
    Brick.Widgets.HelpMessage Brick.Widgets.List.Utils
    Brick.Widgets.WrappedText ConfigParser Data.Time.Ext DateParser
    Model View

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-iadd-1.3.20
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-iadd-1.3.20
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-iadd-1.3.20
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-iadd
hs-libraries:         HShledger-iadd-1.3.20-GwEaxXziL71PeGxoBxcIw
depends:
    base-4.17.2.1 brick-1.9-G4jy96pMPkmBqx1AAVnQxh containers-0.6.7
    directory-1.3.7.1 free-5.2-26VRGaLhVPn4OR8KTitk7E
    hledger-lib-1.32.1-9H5GgUh7cKdAxiqdfjK6ei
    megaparsec-9.6.1-AHfz4qPwoQs815dRss8YYZ
    microlens-0.4.13.1-BCmTOusOWAwKF1xfvNhRYd
    microlens-mtl-0.2.0.3-vQELA1onhlLfPXHvjZtx7
    microlens-th-0.4.3.17-Vfga0HXPTS6SXD3NuXqZ3
    optparse-applicative-0.17.1.0-4tPjpOfYmOi9nj8To0UB1j text-2.0.2
    text-zipper-0.13-CpOb0fOGPdPA8Kg9lYIH9e time-1.12.2
    transformers-0.5.6.2
    unordered-containers-0.2.20-2kG5VEC3Gy42AwINT9WJ9w
    vector-0.13.1.0-Dc65CzydytHE52tdajtbOv
    vty-5.39-KkmaeTwc8ZA2a1HDk0Ulcz
    xdg-basedir-0.2.2-GUgbFy73ZJ02w1NqlBIm8a

haddock-interfaces:   /usr/share/doc/hledger-iadd/html/hledger-iadd.haddock
haddock-html:         /usr/share/doc/hledger-iadd/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

