#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.32.1
visibility:           public
id:                   hledger-web-1.32.1-HIWG6WH36DjFF3hZyLXmOG
key:                  hledger-web-1.32.1-HIWG6WH36DjFF3hZyLXmOG
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  8507f927c0ee8cd2bb40ce427034ddb6
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.Foundation Hledger.Web.Handler.AddR
    Hledger.Web.Handler.EditR Hledger.Web.Handler.JournalR
    Hledger.Web.Handler.MiscR Hledger.Web.Handler.RegisterR
    Hledger.Web.Handler.UploadR Hledger.Web.Settings
    Hledger.Web.Settings.StaticFiles Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.32.1-HIWG6WH36DjFF3hZyLXmOG
depends:
    Decimal-0.5.2-79E3HPvJE9wIJQu9E1TEVT
    aeson-2.1.2.1-GOr0sGsn8HVJzt9KhewtB0 base-4.17.2.1
    base64-0.4.2.4-1c0wYYG314IBiTDRSOESqf
    blaze-html-0.9.2.0-7rraM1lSLOl2LrVAS4qxq6
    blaze-markup-0.8.3.0-EXIdF6gaJs7HROOmQDdLmZ bytestring-0.11.5.3
    case-insensitive-1.2.1.0-9695IAuXzI9BpRD3yNxY1D
    clientsession-0.9.2.0-4ayf6xxAJkZE5Gx1zQLfcv
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-GhV2KMoemFPB5FDryFR5X5
    conduit-extra-1.3.6-4VZQrDv9KU68F339d2BW5y containers-0.6.7
    data-default-0.7.1.1-HuI8bY4bNR4F11jcRg6vOi directory-1.3.7.1
    extra-1.7.16-JJdQ9eFtkoVDmjYz0qVuVR filepath-1.4.2.2
    hjsmin-0.2.1-2GZGBK18dcxGhffMF3p4Xf
    hledger-1.32.1-Dl8FNoPDpHW1hMw8fejegt
    hledger-lib-1.32.1-8gyDtvGXhKT8ZrGneTIzYS
    hspec-2.10.9-KjMOU4OB4qFAiRTApzpdJt
    http-client-0.7.18-16GRXSx1Un6FZdK2reCcpV
    http-conduit-2.3.9.1-Fr7XCF5XmoT9187GL9zJM8
    http-types-0.12.4-8b2vqk4ytrNGMVbZZ8fq7J
    megaparsec-9.6.1-747qApo3GKN165PbKLSk2e mtl-2.2.2
    network-3.1.4.0-29qUxJkoDip75hxElAm7gZ
    safe-0.3.21-4RbCGR2deY91o6dlI4zODz
    shakespeare-2.1.0.1-5RILvIEoiKPDNjuLhOJq66
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 unix-compat-0.7.3-GKrDUqCOM7qIZhM6rNxdwj
    unordered-containers-0.2.20-Jl6TkouWI2i1D1jczNV0uv
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-KfCBQ4hW2dQ3UrOuZjE7QX
    wai-cors-0.2.7-An0MSFb9xyDIdFWK2a9oxX
    wai-extra-3.1.17-EQaSVqAPuPrWMOXJ9Zed7
    wai-handler-launch-3.0.3.1-8AL2JR73bup6NkoIcPqlzs
    warp-3.3.30-ERGSsAnOLVE9tSaRUWrkfD
    yaml-0.11.11.2-HEyJLnR3A9NJG6tnIWlo7S
    yesod-1.6.2.1-DGvvXpFjSxG4Q5CzABSqRZ
    yesod-core-1.6.27.0-DC4LrztOnXoJ2DhH5C89by
    yesod-form-1.7.9-KNeDQWvhzv6K6JMkKDpZEA
    yesod-static-1.6.1.0-Co60vxjP0GMHQtGJvpOFkC
    yesod-test-1.6.19-5iBjsHo6gv09PWeMtdAYOr

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

