/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Computes the sine of each pixel.


This filter is templated over the pixel type of the input image and
the pixel type of the output image.

The filter walks over all the pixels in the input image, and for each
pixel does the following:


cast the pixel value to double ,

apply the std::asin() function to the double value,

cast the double value resulting from std::asin() to the pixel type of
the output image,

store the casted value into the output image.
 The filter expects both images to have the same dimension (e.g. both
2D, or both 3D, or both ND)
See:
 itk::simple::Asin for the procedural interface

 itk::AsinImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkAsinImageFilter.h
*/
public class AsinImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected AsinImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.AsinImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(AsinImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(AsinImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::AsinImageFilter::~AsinImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_AsinImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::AsinImageFilter::AsinImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  AsinImageFilter() {
    this(SimpleITKJNI.new_AsinImageFilter(), true);
  }

  /**
std::string itk::simple::AsinImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.AsinImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::AsinImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.AsinImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::AsinImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.AsinImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
