/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Increase the image size by padding with a constant value.


ConstantPadImageFilter changes the output image region. If the output image region is larger
than the input image region, the extra pixels are filled in by a
constant value. The output image region must be specified.

Visual explanation of padding regions.

This filter is implemented as a multithreaded filter. It provides a
DynamicThreadedGenerateData() method for its implementation.


See:
 WrapPadImageFilter , MirrorPadImageFilter

 itk::simple::ConstantPad for the procedural interface

 itk::ConstantPadImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkConstantPadImageFilter.h
*/
public class ConstantPadImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ConstantPadImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ConstantPadImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ConstantPadImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ConstantPadImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ConstantPadImageFilter::~ConstantPadImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ConstantPadImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ConstantPadImageFilter::ConstantPadImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ConstantPadImageFilter() {
    this(SimpleITKJNI.new_ConstantPadImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ConstantPadImageFilter::SetPadLowerBound(std::vector&lt; unsigned int &gt; PadLowerBound)
*/
public  void setPadLowerBound(VectorUInt32 PadLowerBound) {
    SimpleITKJNI.ConstantPadImageFilter_setPadLowerBound(swigCPtr, this, VectorUInt32.getCPtr(PadLowerBound), PadLowerBound);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::ConstantPadImageFilter::GetPadLowerBound() const
*/
public  VectorUInt32 getPadLowerBound() {
    return new VectorUInt32(SimpleITKJNI.ConstantPadImageFilter_getPadLowerBound(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::ConstantPadImageFilter::SetPadUpperBound(std::vector&lt; unsigned int &gt; PadUpperBound)
*/
public  void setPadUpperBound(VectorUInt32 PadUpperBound) {
    SimpleITKJNI.ConstantPadImageFilter_setPadUpperBound(swigCPtr, this, VectorUInt32.getCPtr(PadUpperBound), PadUpperBound);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::ConstantPadImageFilter::GetPadUpperBound() const
*/
public  VectorUInt32 getPadUpperBound() {
    return new VectorUInt32(SimpleITKJNI.ConstantPadImageFilter_getPadUpperBound(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::ConstantPadImageFilter::SetConstant(double Constant)

Set/Get the pad value. Default is Zero.

*/
public  void setConstant(double Constant) {
    SimpleITKJNI.ConstantPadImageFilter_setConstant(swigCPtr, this, Constant);
  }

  /**
double itk::simple::ConstantPadImageFilter::GetConstant() const

Set/Get the pad value. Default is Zero.

*/
public  double getConstant() {
    return SimpleITKJNI.ConstantPadImageFilter_getConstant(swigCPtr, this);
  }

  /**
std::string itk::simple::ConstantPadImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ConstantPadImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ConstantPadImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ConstantPadImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ConstantPadImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.ConstantPadImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
