/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

dilation of an object in an image


Dilate an image using binary morphology. Pixel values matching the
object value are considered the "foreground" and all other pixels
are "background". This is useful in processing mask images
containing only one object.

If a pixel's value is equal to the object value and the pixel is
adjacent to a non-object valued pixel, then the kernel is centered on
the object-value pixel and neighboring pixels covered by the kernel
are assigned the object value. The structuring element is assumed to
be composed of binary values (zero or one).


See:
 ObjectMorphologyImageFilter , ErodeObjectMorphologyImageFilter

 BinaryDilateImageFilter

 itk::simple::DilateObjectMorphology for the procedural interface

 itk::DilateObjectMorphologyImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkDilateObjectMorphologyImageFilter.h
*/
public class DilateObjectMorphologyImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected DilateObjectMorphologyImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.DilateObjectMorphologyImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(DilateObjectMorphologyImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(DilateObjectMorphologyImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::DilateObjectMorphologyImageFilter::~DilateObjectMorphologyImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_DilateObjectMorphologyImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::DilateObjectMorphologyImageFilter::DilateObjectMorphologyImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  DilateObjectMorphologyImageFilter() {
    this(SimpleITKJNI.new_DilateObjectMorphologyImageFilter(), true);
  }

  /**
Self&amp; itk::simple::DilateObjectMorphologyImageFilter::SetKernelRadius(unsigned int value)

Set the values of the KernelRadius vector all to value

*/
public  void setKernelRadius(VectorUInt32 KernelRadius) {
    SimpleITKJNI.DilateObjectMorphologyImageFilter_setKernelRadius__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(KernelRadius), KernelRadius);
  }

  /**
Self&amp; itk::simple::DilateObjectMorphologyImageFilter::SetKernelRadius(unsigned int value)

Set the values of the KernelRadius vector all to value

*/
public  void setKernelRadius(long value) {
    SimpleITKJNI.DilateObjectMorphologyImageFilter_setKernelRadius__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::DilateObjectMorphologyImageFilter::GetKernelRadius() const

Get the radius of the kernel structuring element.

*/
public  VectorUInt32 getKernelRadius() {
    return new VectorUInt32(SimpleITKJNI.DilateObjectMorphologyImageFilter_getKernelRadius(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::DilateObjectMorphologyImageFilter::SetKernelType(KernelEnum KernelType)

Set the kernel or structuring element used for the morphology.

*/
public  void setKernelType(KernelEnum KernelType) {
    SimpleITKJNI.DilateObjectMorphologyImageFilter_setKernelType(swigCPtr, this, KernelType.swigValue());
  }

  /**
KernelEnum itk::simple::DilateObjectMorphologyImageFilter::GetKernelType() const

Get the kernel or structuring element used for the morphology.

*/
public  KernelEnum getKernelType() {
    return KernelEnum.swigToEnum(SimpleITKJNI.DilateObjectMorphologyImageFilter_getKernelType(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::DilateObjectMorphologyImageFilter::SetObjectValue(double ObjectValue)
*/
public  void setObjectValue(double ObjectValue) {
    SimpleITKJNI.DilateObjectMorphologyImageFilter_setObjectValue(swigCPtr, this, ObjectValue);
  }

  /**
double itk::simple::DilateObjectMorphologyImageFilter::GetObjectValue() const
*/
public  double getObjectValue() {
    return SimpleITKJNI.DilateObjectMorphologyImageFilter_getObjectValue(swigCPtr, this);
  }

  /**
std::string itk::simple::DilateObjectMorphologyImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.DilateObjectMorphologyImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::DilateObjectMorphologyImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.DilateObjectMorphologyImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::DilateObjectMorphologyImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.DilateObjectMorphologyImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
