/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Grayscale dilation of an image.


Dilate an image using grayscale morphology. Dilation takes the maximum
of all the pixels identified by the structuring element.

The structuring element is assumed to be composed of binary values
(zero or one). Only elements of the structuring element having values
&gt; 0 are candidates for affecting the center pixel.


See:
 MorphologyImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter

 itk::simple::GrayscaleDilate for the procedural interface

 itk::GrayscaleDilateImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkGrayscaleDilateImageFilter.h
*/
public class GrayscaleDilateImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected GrayscaleDilateImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.GrayscaleDilateImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(GrayscaleDilateImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(GrayscaleDilateImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::GrayscaleDilateImageFilter::~GrayscaleDilateImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_GrayscaleDilateImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::GrayscaleDilateImageFilter::GrayscaleDilateImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  GrayscaleDilateImageFilter() {
    this(SimpleITKJNI.new_GrayscaleDilateImageFilter(), true);
  }

  /**
Self&amp; itk::simple::GrayscaleDilateImageFilter::SetKernelRadius(unsigned int value)

Set the values of the KernelRadius vector all to value

*/
public  void setKernelRadius(VectorUInt32 KernelRadius) {
    SimpleITKJNI.GrayscaleDilateImageFilter_setKernelRadius__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(KernelRadius), KernelRadius);
  }

  /**
Self&amp; itk::simple::GrayscaleDilateImageFilter::SetKernelRadius(unsigned int value)

Set the values of the KernelRadius vector all to value

*/
public  void setKernelRadius(long value) {
    SimpleITKJNI.GrayscaleDilateImageFilter_setKernelRadius__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::GrayscaleDilateImageFilter::GetKernelRadius() const

Get the radius of the kernel structuring element.

*/
public  VectorUInt32 getKernelRadius() {
    return new VectorUInt32(SimpleITKJNI.GrayscaleDilateImageFilter_getKernelRadius(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::GrayscaleDilateImageFilter::SetKernelType(KernelEnum KernelType)

Set the kernel or structuring element used for the morphology.

*/
public  void setKernelType(KernelEnum KernelType) {
    SimpleITKJNI.GrayscaleDilateImageFilter_setKernelType(swigCPtr, this, KernelType.swigValue());
  }

  /**
KernelEnum itk::simple::GrayscaleDilateImageFilter::GetKernelType() const

Get the kernel or structuring element used for the morphology.

*/
public  KernelEnum getKernelType() {
    return KernelEnum.swigToEnum(SimpleITKJNI.GrayscaleDilateImageFilter_getKernelType(swigCPtr, this));
  }

  /**
std::string itk::simple::GrayscaleDilateImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.GrayscaleDilateImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::GrayscaleDilateImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.GrayscaleDilateImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::GrayscaleDilateImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.GrayscaleDilateImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
