/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.scriptext;

import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javajs.util.AU;
import javajs.util.BArray;
import javajs.util.BS;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.Rdr;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.JmolNMRInterface;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.bspt.PointIterator;
import org.jmol.c.VDW;
import org.jmol.i18n.GT;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondSet;
import org.jmol.modelset.Measurement;
import org.jmol.modelset.ModelSet;
import org.jmol.script.SV;
import org.jmol.script.ScriptEval;
import org.jmol.script.ScriptException;
import org.jmol.script.ScriptMathProcessor;
import org.jmol.script.T;
import org.jmol.util.BSUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Edge;
import org.jmol.util.Escape;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.PatternMatcher;
import org.jmol.util.Point3fi;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Tensor;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public class MathExt {
    private static final Float nan = Float.valueOf(Float.NaN);
    private Viewer vwr;
    private ScriptEval e;
    private static long t0 = System.currentTimeMillis();
    private Random rand;
    private PatternMatcher pm;

    public MathExt init(Object se) {
        this.e = (ScriptEval)se;
        this.vwr = this.e.vwr;
        return this;
    }

    public boolean evaluate(ScriptMathProcessor mp, T op, SV[] args, int tok) throws ScriptException {
        switch (tok) {
            case 0x8000408: {
                return args.length >= 1 && args[0].tok == 4 ? mp.addXStr((args.length == 1 ? new Date().toString() : this.vwr.apiPlatform.getDateFormat(SV.sValue(args[1]))) + "\t" + SV.sValue(args[0]).trim()) : mp.addXInt((int)(System.currentTimeMillis() - t0) - (args.length == 0 ? 0 : args[0].asInt()));
            }
            case 134218250: {
                return args.length == 1 && args[0].tok == 2 ? mp.addXInt(Math.abs(args[0].intValue)) : mp.addXFloat(Math.abs(args[0].asFloat()));
            }
            case 134218241: 
            case 134218244: 
            case 134218245: 
            case 134218246: {
                return args.length == 1 && this.evaluateMath(mp, args, tok);
            }
            case 1275068928: 
            case 1275068929: 
            case 1275068930: 
            case 1275068931: 
            case 1275069441: 
            case 1275334681: 
            case 1275335685: {
                return this.evaluateList(mp, op.intValue, args);
            }
            case 0x10000800: {
                if (args.length == 0) {
                    mp.wasX = false;
                }
            }
            case 1275068418: {
                return this.evaluateArray(mp, args, tok == 1275068418 && op.tok == 0x10001A01);
            }
            case 134217766: {
                return this.evaluateMatrix(mp, args);
            }
            case 134217765: {
                return this.evaluateCallbackParam(mp, args);
            }
            case 0x8000003: 
            case 134221850: {
                return this.evaluateQuaternion(mp, args, tok);
            }
            case 0x4C000004: {
                return this.evaluateBin(mp, args);
            }
            case 134221829: {
                return this.evaluateCache(mp, args);
            }
            case 1275068934: 
            case 1275068935: {
                return this.evaluateRowCol(mp, args, tok);
            }
            case 1765808134: {
                return this.evaluateColor(mp, args);
            }
            case 134221831: {
                return this.evaluateCompare(mp, args);
            }
            case 0x8000008: 
            case 1228931586: 
            case 1275203608: {
                return this.evaluateConnected(mp, args, tok, op.intValue);
            }
            case 1812599299: 
            case 1814695966: {
                return this.evaluateUnitCell(mp, args, op.tok == 0x10001A01, op.tok == 0x10001A01 ? op.intValue : op.tok);
            }
            case 134353926: {
                return this.evaluateContact(mp, args);
            }
            case 134221834: {
                return this.evaluateData(mp, args);
            }
            case 1275069442: 
            case 0x4C000404: {
                return this.evaluateDotDist(mp, args, tok, op.intValue);
            }
            case 1275069443: {
                if (op.tok == 0x10001A01) {
                    return this.evaluateDotDist(mp, args, tok, op.intValue);
                }
            }
            case 0x8000001: 
            case 1745489939: {
                return this.evaluateMeasure(mp, args, op.tok);
            }
            case 134223363: 
            case 1228935687: {
                return this.evaluateLoad(mp, args, tok == 1228935687);
            }
            case 1275068427: {
                return this.evaluateFind(mp, args);
            }
            case 1275068433: {
                return this.evaluateInChI(mp, args);
            }
            case 1287653388: 
            case 1825200146: {
                return this.evaluateFormat(mp, op.intValue, args, tok == 1825200146);
            }
            case 134320141: {
                return this.evaluateUserFunction(mp, (String)op.value, args, op.intValue, op.tok == 0x10001A01);
            }
            case 1275068437: {
                tok = 1275068725;
            }
            case 1275068446: 
            case 1275068725: 
            case 1275072526: 
            case 1275082241: {
                return this.evaluateGetProperty(mp, args, tok, op.tok == 0x10001A01);
            }
            case 136314895: {
                return this.evaluateHelix(mp, args);
            }
            case 134217750: 
            case 134217763: 
            case 0x8000801: {
                return this.evaluatePlane(mp, args, tok, op.tok == 0x10001A01);
            }
            case 134218759: 
            case 134222350: 
            case 134222850: 
            case 134238732: {
                return this.evaluateScript(mp, args, tok);
            }
            case 1275068932: 
            case 1275069446: 
            case 1275069447: {
                return this.evaluateString(mp, op.intValue, args);
            }
            case 134217751: {
                return this.evaluatePoint(mp, args);
            }
            case 1275068447: {
                return this.evaluatePointGroup(mp, args, op.tok == 0x10001A01);
            }
            case 134256129: {
                return this.evaluatePrompt(mp, args);
            }
            case 134219266: {
                return this.evaluateRandom(mp, args);
            }
            case 1275068432: {
                return this.evaluateIn(mp, args);
            }
            case 1275072532: {
                return this.evaluateModulation(mp, args);
            }
            case 1275068443: {
                return this.evaluateReplace(mp, args);
            }
            case 134218753: 
            case 0x8000404: 
            case 134218757: 
            case 1237320707: {
                return this.evaluateSubstructure(mp, args, tok, op.tok == 0x10001A01);
            }
            case 1275068425: 
            case 1275068444: {
                return this.evaluateSort(mp, args, tok);
            }
            case 134217764: {
                return this.evaluateSpacegroup(mp, args);
            }
            case 1296041985: {
                return this.evaluateSymop(mp, args, op.tok == 0x10001A01);
            }
            case 1275068445: {
                return this.evaluateTensor(mp, args);
            }
            case 134217759: {
                return this.evaluateWithin(mp, args, op.tok == 0x10001A01);
            }
            case 134221856: {
                return this.evaluateWrite(mp, args);
            }
        }
        return false;
    }

    private boolean evaluateMatrix(ScriptMathProcessor mp, SV[] args) {
        float[] a;
        boolean asRXYZ;
        boolean asXYZ;
        boolean asABC;
        M4 m4;
        block40: {
            int n = args.length;
            m4 = null;
            String sarg0 = n > 0 && args[0].tok == 4 ? (String)args[0].value : null;
            Map<String, SV> map = n < 2 || sarg0 == null ? null : args[1].getMap();
            Lst<SV> lst = n < 2 || sarg0 == null ? null : args[1].getList();
            String retType = n > 1 && args[n - 1].tok == 4 ? (String)args[n - 1].value : null;
            boolean asUVW = "uvw".equalsIgnoreCase(retType);
            asABC = "abc".equalsIgnoreCase(retType);
            asXYZ = asUVW || !asABC && "xyz".equalsIgnoreCase(retType);
            asRXYZ = !asUVW && !asABC && !asXYZ && "rxyz".equalsIgnoreCase(retType);
            a = null;
            if (retType != null || lst != null || map != null) {
                --n;
            }
            block0 : switch (n) {
                case 0: {
                    m4 = new M4();
                    m4.setIdentity();
                    break;
                }
                case 1: {
                    block5 : switch (args[0].tok) {
                        case 12: {
                            m4 = (M4)args[0].value;
                            break;
                        }
                        case 4: {
                            Lst retLst;
                            String s = (String)args[0].value;
                            if (s.equals("h") || s.equals("r") || s.indexOf(",") >= 0 && s.indexOf(":") < 0) {
                                SymmetryInterface sym;
                                if (s.indexOf(42) >= 0) {
                                    sym = this.vwr.getCurrentUnitCell();
                                    if (sym == null) {
                                        return false;
                                    }
                                } else {
                                    sym = this.vwr.getSymTemp();
                                }
                                m4 = (M4)sym.convertTransform(s, null);
                            }
                            if (m4 != null) break;
                            String select = null;
                            if (!(retType == null || asABC || asXYZ || asUVW)) {
                                if ("map".equals(retType)) {
                                    map = new Hashtable<String, SV>();
                                    retType = null;
                                } else if ("list".equals(retType)) {
                                    lst = new Lst();
                                    retType = null;
                                } else {
                                    select = "[SELECT (" + retType + ")]";
                                    lst = new Lst();
                                    retType = null;
                                }
                            }
                            boolean returnM4 = lst == null && map == null;
                            Hashtable<String, Boolean> retMap = map == null ? null : new Hashtable<String, Boolean>();
                            Lst lst2 = retLst = lst == null ? null : new Lst();
                            if (returnM4) {
                                retMap = new Hashtable();
                                retMap.put("ASM4", Boolean.TRUE);
                            }
                            m4 = this.vwr.getSymStatic().staticGetMatrixTransform(s, retMap == null ? retLst : retMap);
                            if (returnM4) break;
                            if (map != null) {
                                map.clear();
                                for (Map.Entry e : retMap.entrySet()) {
                                    map.put((String)e.getKey(), SV.getVariable(e.getValue()));
                                }
                                return mp.addXMap(map);
                            }
                            if (lst != null) {
                                if (select != null) {
                                    return mp.addXObj(this.vwr.extractProperty(retLst, select, -1));
                                }
                                lst.clear();
                                int nl = retLst.size();
                                for (int i = 0; i < nl; ++i) {
                                    lst.addLast(SV.getVariable(retLst.get(i)));
                                }
                                return mp.addXList(lst);
                            }
                            break block40;
                        }
                        case 7: {
                            lst = args[0].getList();
                            int len = lst.size();
                            switch (len) {
                                case 3: 
                                case 4: {
                                    a = new float[len * len];
                                    int pt = 0;
                                    for (int i = 0; i < len; ++i) {
                                        Lst<SV> a2 = ((SV)lst.get(i)).getList();
                                        if (a2 == null || a2.size() != len) {
                                            return false;
                                        }
                                        for (int j = 0; j < len; ++j) {
                                            a[pt++] = SV.fValue((T)a2.get(j));
                                        }
                                    }
                                    break block0;
                                }
                                case 9: 
                                case 16: {
                                    a = SV.flistValue(args[0], 0);
                                    break block5;
                                }
                                default: {
                                    return false;
                                }
                            }
                        }
                    }
                    break;
                }
                case 3: 
                case 4: {
                    if (args[0].tok != 7) break;
                    a = new float[n == 3 ? 9 : 16];
                    int p = 0;
                    for (int i = 0; i < n; ++i) {
                        float[] row = SV.flistValue(args[i], 0);
                        for (int j = 0; j < n; ++j) {
                            a[p++] = row[j];
                        }
                    }
                    break;
                }
            }
        }
        if (a != null) {
            switch (a.length) {
                case 9: {
                    return mp.addXObj(M3.newA9(a));
                }
                case 16: {
                    m4 = M4.newA16(a);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return m4 == null ? mp.addXStr("") : (asRXYZ || asABC || asXYZ ? mp.addXStr(this.matToString(m4, asRXYZ ? 1 : (asABC ? 2748 : 0))) : mp.addXM4(m4));
    }

    private String matToString(M4 m4, int mode) {
        SymmetryInterface sym = this.vwr.getSymStatic();
        switch (mode) {
            case 1: {
                return (String)sym.staticConvertOperation(null, m4, "rxyz");
            }
            case 32: 
            case 2748: {
                return sym.staticGetTransformABC(m4, false);
            }
        }
        return (String)this.vwr.getSymStatic().staticConvertOperation("", m4, mode == 36 ? "uvw" : "xyz");
    }

    private boolean evaluateCallbackParam(ScriptMathProcessor mp, SV[] args) {
        return mp.addX(this.e.getCallbackParameter(args.length == 0 ? Integer.MIN_VALUE : args[0].asInt()));
    }

    private boolean evaluateSpacegroup(ScriptMathProcessor mp, SV[] args) {
        float[] ucParams = null;
        int nargs = args.length;
        if (nargs == 0) {
            return mp.addXObj(this.vwr.getSymTemp().getSpaceGroupInfo(this.vwr.ms, null, this.vwr.am.cmi, true, null));
        }
        String mode = args[args.length - 1].tok == 4 ? (String)args[args.length - 1].value : null;
        boolean isSettings = "settings".equalsIgnoreCase(mode);
        boolean isSetting = "setting".equalsIgnoreCase(mode);
        boolean isSubgroups = nargs > 1 && (nargs != 2 || !isSettings && !isSetting && !"list".equalsIgnoreCase(mode) && !"jmol".equalsIgnoreCase(mode));
        String xyzList = args[0].asString();
        if (isSubgroups || "subgroups".equals(mode)) {
            Object ret = this.getSubgroupInfo(args, "subgroups".equals(mode) ? nargs : nargs + 1);
            return ret == null ? false : mp.addXObj(ret);
        }
        Object params = null;
        Object ret = null;
        switch (nargs) {
            default: {
                return false;
            }
            case 2: {
                if ("list".equals(mode)) {
                    params = Integer.valueOf((String)this.vwr.getSymTemp().getSpaceGroupInfoObj("itaNumber", xyzList, false, false));
                    xyzList = "list";
                    break;
                }
                if (args[1].tok != 4) {
                    ucParams = SV.flistValue(args[1], 0);
                    if (ucParams == null || ucParams.length != 6) {
                        return false;
                    }
                    ucParams = SimpleUnitCell.newParams(ucParams, Float.NaN);
                    params = ucParams;
                }
            }
            case 1: {
                int itaNo;
                if (args[0].tok == 10) {
                    BS atoms = SV.getBitSet(args[0], true);
                    return mp.addXObj(this.vwr.findSpaceGroup(null, atoms, null, ucParams, null, null, 1));
                }
                int n = args[0].tok == 2 ? args[0].intValue : (itaNo = nargs == 1 ? Integer.MIN_VALUE : 0);
                if (isSettings || isSetting) {
                    if (isSettings && itaNo == 0) {
                        return false;
                    }
                    String data = isSetting && nargs > 1 ? xyzList : null;
                    return mp.addXObj((itaNo == Integer.MIN_VALUE ? this.vwr.getCurrentUnitCell() : this.vwr.getSymTemp()).getSpaceGroupJSON(mode.toLowerCase(), data, itaNo));
                }
                if ("setting".equalsIgnoreCase(xyzList) || "settings".equalsIgnoreCase(xyzList)) {
                    SymmetryInterface sym = this.vwr.getOperativeSymmetry();
                    return mp.addXObj(sym == null ? null : sym.getSpaceGroupJSON(xyzList.toLowerCase(), null, Integer.MIN_VALUE));
                }
                if (xyzList.toUpperCase().startsWith("AFLOWLIB/")) {
                    return mp.addXObj(this.vwr.getSymTemp().getSpaceGroupJSON("AFLOWLIB", xyzList.substring(9), 0));
                }
                if (xyzList.startsWith("Hall:") || xyzList.indexOf("x") >= 0 || ucParams != null) {
                    ret = this.vwr.findSpaceGroup(null, null, xyzList, ucParams, null, null, 1);
                    break;
                }
                if (itaNo <= 0 && args[0].tok != 3 && args[0].tok != 4) break;
                if (itaNo > 0 || xyzList.length() > 1 && xyzList.charAt(1) == '/' || !xyzList.endsWith(":") && !Double.isNaN(PT.parseFloat(xyzList))) {
                    xyzList = "ITA/" + xyzList;
                }
                if (!xyzList.toUpperCase().startsWith("ITA/")) break;
                return mp.addXObj(this.vwr.getSymTemp().getSpaceGroupJSON("ITA", xyzList.substring(4), 0));
            }
        }
        if (ret == null) {
            ret = this.vwr.getSymStatic().getSpaceGroupInfoObj(xyzList, params, true, false);
        }
        if (ret != null && !"jmol".equals(mode) && !"list".equals(mode)) {
            System.out.println("MathExt " + ret);
            String s = "" + ((Map)ret).get("itaIndex");
            ret = this.vwr.getSymTemp().getSpaceGroupJSON("ITA", s, 0);
        }
        return mp.addXObj(ret);
    }

    private Object getSubgroupInfo(SV[] args, int nargs) {
        SymmetryInterface sym;
        int index1 = Integer.MIN_VALUE;
        int index2 = Integer.MIN_VALUE;
        String nameFrom = null;
        String nameTo = null;
        switch (nargs) {
            case 5: {
                index2 = args[3].intValue;
                if (index2 < 0) {
                    return null;
                }
            }
            case 4: {
                index1 = args[2].intValue;
                if (index1 < 0 || index1 == Integer.MAX_VALUE) {
                    return null;
                }
            }
            case 3: {
                nameTo = args[1].intValue == 0 ? "" : args[1].asString();
            }
            case 2: {
                nameFrom = args[0].asString();
            }
        }
        if (nameFrom == null) {
            sym = this.vwr.getOperativeSymmetry();
            if (sym == null) {
                return null;
            }
            nameFrom = sym.getSpaceGroupClegId();
        } else {
            sym = this.vwr.getSymStatic();
        }
        return sym.getSubgroupJSON(nameFrom, nameTo, index1, index2, 0, null, null);
    }

    private boolean evaluatePointGroup(ScriptMathProcessor mp, SV[] args, boolean isAtomProperty) throws ScriptException {
        T3[] pts = null;
        P3 center = null;
        float distanceTolerance = -1.0f;
        float linearTolerance = -1.0f;
        BS bsAtoms = null;
        boolean isSpaceGroup = false;
        block0 : switch (args.length) {
            case 4: {
                linearTolerance = args[3].asFloat();
            }
            case 3: {
                distanceTolerance = args[2].asFloat();
            }
            case 2: {
                switch (args[1].tok) {
                    case 8: {
                        center = SV.ptValue(args[1]);
                        break;
                    }
                    case 10: {
                        bsAtoms = SV.getBitSet(args[1], false);
                        if (!args[0].asString().equalsIgnoreCase("spaceGroup")) break;
                        isSpaceGroup = true;
                        if (args.length != 2) break;
                        distanceTolerance = 0.0f;
                    }
                }
                if (isSpaceGroup) break;
            }
            case 1: {
                switch (args[0].tok) {
                    case 7: {
                        Lst<SV> points = args[0].getList();
                        pts = new T3[points.size()];
                        int i = pts.length;
                        while (--i >= 0) {
                            pts[i] = SV.ptValue((SV)points.get(i));
                        }
                        break block0;
                    }
                    case 10: {
                        bsAtoms = SV.getBitSet(args[0], false);
                        pts = this.vwr.ms.at;
                        break block0;
                    }
                    case 4: {
                        if (isAtomProperty) {
                            bsAtoms = SV.getBitSet(mp.getX(), true);
                            if (bsAtoms == null || bsAtoms.isEmpty()) {
                                return false;
                            }
                            String s = args[0].asString();
                            if ("spacegroup".equals(s)) {
                                isSpaceGroup = true;
                                break block0;
                            }
                        }
                    }
                    default: {
                        return false;
                    }
                }
            }
            case 0: {
                if (!isAtomProperty) {
                    return mp.addXObj(this.vwr.ms.getPointGroupInfo(null));
                }
                bsAtoms = SV.getBitSet(mp.getX(), false);
                break;
            }
            default: {
                return false;
            }
        }
        if (bsAtoms != null) {
            int iatom = bsAtoms.nextSetBit(0);
            if (iatom < 0 || iatom >= this.vwr.ms.ac || isSpaceGroup && bsAtoms.cardinality() != 1) {
                return false;
            }
            if (isSpaceGroup) {
                Lst<P3> lst = this.vwr.ms.generateCrystalClass(iatom, P3.new3(Float.NaN, Float.NaN, Float.NaN));
                pts = new T3[lst.size()];
                int i = pts.length;
                while (--i >= 0) {
                    pts[i] = (T3)lst.get(i);
                }
                center = new P3();
            }
        }
        SymmetryInterface pointGroup = this.vwr.getSymTemp().setPointGroup(this.vwr, null, center, pts == null ? this.vwr.ms.at : pts, bsAtoms, false, distanceTolerance < 0.0f ? this.vwr.getFloat(0x22000026) : distanceTolerance, linearTolerance < 0.0f ? this.vwr.getFloat(0x22000028) : linearTolerance, bsAtoms == null ? pts.length : bsAtoms.cardinality(), true);
        return mp.addXMap((Map)pointGroup.getPointGroupInfo(-1, null, true, null, 0, 1.0f));
    }

    private boolean evaluateUnitCell(ScriptMathProcessor mp, SV[] args, boolean isSelector, int tok) throws ScriptException {
        String op;
        boolean toPrimitive;
        int ptParam;
        SymmetryInterface u;
        T3[] ucnew;
        float scale;
        int lastParam;
        int iatom;
        block47: {
            int i;
            block48: {
                boolean haveUC;
                BS x1 = isSelector ? SV.getBitSet(mp.getX(), true) : (tok == 1812599299 ? this.vwr.getAllAtoms() : null);
                iatom = (x1 == null ? this.vwr.getAllAtoms() : x1).nextSetBit(0);
                lastParam = args.length - 1;
                scale = 1.0f;
                switch (lastParam < 0 ? 0 : args[lastParam].tok) {
                    case 2: 
                    case 3: {
                        scale = args[lastParam].asFloat();
                        --lastParam;
                    }
                }
                boolean normalize = false;
                int tok0 = lastParam < 0 ? 0 : args[0].tok;
                ucnew = null;
                Lst<SV> uc = null;
                String arg0 = null;
                switch (tok0) {
                    case 7: {
                        uc = args[0].getList();
                        break;
                    }
                    case 12: {
                        switch (lastParam > 1 ? 0x40000070 : (lastParam < 1 ? 0 : args[1].tok)) {
                            default: {
                                return false;
                            }
                            case 0: 
                            case 1073742334: {
                                break;
                            }
                            case 1073742335: {
                                normalize = true;
                            }
                        }
                        return mp.addXStr(this.vwr.getSymStatic().staticGetTransformABC(args[0].value, normalize));
                    }
                    case 4: {
                        arg0 = args[0].asString();
                        if (tok != 1814695966) break;
                        if (arg0.indexOf("a=") == 0) {
                            ucnew = new P3[4];
                            for (int i2 = 0; i2 < 4; ++i2) {
                                ucnew[i2] = new P3();
                            }
                            SimpleUnitCell.setAbc(arg0, null, ucnew);
                            break;
                        }
                        if (arg0.indexOf(",") < 0 && !arg0.equals("r")) break;
                        boolean asMatrix = args.length == 2 && SV.bValue(args[1]);
                        Object ret = asMatrix ? this.vwr.getSymTemp().convertTransform(arg0, null) : this.vwr.getV0abc(-1, arg0);
                        return mp.addXObj(ret);
                    }
                }
                if (tok == 1812599299) {
                    BoxInfo b = this.vwr.ms.getBoxInfo(x1, 1.0f);
                    return mp.addXObj(b.getInfo(arg0));
                }
                u = null;
                boolean bl = haveUC = uc != null;
                if (ucnew == null && haveUC && uc.size() < 4) {
                    return false;
                }
                int n = ptParam = haveUC ? 1 : 0;
                if (ucnew == null && !haveUC && tok0 != 8) {
                    T3[] t3Array;
                    SymmetryInterface symmetryInterface = u = iatom < 0 ? this.vwr.getCurrentUnitCell() : this.vwr.ms.getUnitCell(this.vwr.ms.at[iatom].mi);
                    if (u == null) {
                        P3[] p3Array = new P3[4];
                        p3Array[0] = P3.new3(0.0f, 0.0f, 0.0f);
                        p3Array[1] = P3.new3(1.0f, 0.0f, 0.0f);
                        p3Array[2] = P3.new3(0.0f, 1.0f, 0.0f);
                        t3Array = p3Array;
                        p3Array[3] = P3.new3(0.0f, 0.0f, 1.0f);
                    } else {
                        t3Array = ucnew = u.getUnitCellVectors();
                    }
                }
                if (ucnew != null) break block47;
                ucnew = new P3[4];
                if (!haveUC) break block48;
                switch (uc.size()) {
                    case 3: {
                        ucnew[0] = new P3();
                        for (int i3 = 0; i3 < 3; ++i3) {
                            ucnew[i3 + 1] = P3.newP(SV.ptValue((SV)uc.get(i3)));
                        }
                        break block47;
                    }
                    case 4: {
                        for (int i4 = 0; i4 < 4; ++i4) {
                            ucnew[i4] = P3.newP(SV.ptValue((SV)uc.get(i4)));
                        }
                        break block47;
                    }
                    case 6: {
                        float[] params = new float[6];
                        for (i = 0; i < 6; ++i) {
                            params[i] = ((SV)uc.get(i)).asFloat();
                        }
                        SimpleUnitCell.setAbc(null, params, ucnew);
                        break block47;
                    }
                    default: {
                        return false;
                    }
                }
            }
            ucnew[0] = P3.newP(SV.ptValue(args[0]));
            switch (lastParam) {
                case 3: {
                    for (int i5 = 1; i5 < 4; ++i5) {
                        ucnew[i5] = P3.newP(SV.ptValue(args[i5]));
                        ucnew[i5].sub(ucnew[0]);
                    }
                    break;
                }
                case 1: {
                    Lst<SV> l = args[1].getList();
                    if (l != null && l.size() == 3) {
                        for (i = 0; i < 3; ++i) {
                            ucnew[i + 1] = P3.newP(SV.ptValue((SV)l.get(i)));
                        }
                        break;
                    }
                }
                default: {
                    return false;
                }
            }
        }
        if ((toPrimitive = "primitive".equalsIgnoreCase(op = ptParam <= lastParam ? args[ptParam].asString() : null)) || "conventional".equalsIgnoreCase(op)) {
            String stype;
            String string = stype = ++ptParam > lastParam ? "" : args[ptParam].asString().toUpperCase();
            if (stype.equals("BCC")) {
                stype = "I";
            } else if (stype.length() == 0) {
                stype = (String)this.vwr.getSymmetryInfo(iatom, null, 0, null, null, null, 0x400000AA, null, 0.0f, -1, 0, null);
            }
            if (stype == null || stype.length() == 0) {
                return false;
            }
            if (u == null) {
                u = this.vwr.getSymTemp();
            }
            M3 m3 = (M3)this.vwr.getModelForAtomIndex((int)iatom).auxiliaryInfo.get("primitiveToCrystal");
            if (!u.toFromPrimitive(toPrimitive, stype.charAt(0), ucnew, m3)) {
                return false;
            }
        } else if ("reciprocal".equalsIgnoreCase(op)) {
            ucnew = SimpleUnitCell.getReciprocal(ucnew, null, scale);
            scale = 1.0f;
        } else if ("vertices".equalsIgnoreCase(op)) {
            return mp.addXObj(BoxInfo.getVerticesFromOABC(ucnew));
        }
        if (scale != 1.0f) {
            for (int i = 1; i < 4; ++i) {
                ucnew[i].scale(scale);
            }
        }
        return mp.addXObj(ucnew);
    }

    /*
     * WARNING - void declaration
     */
    private boolean evaluateArray(ScriptMathProcessor mp, SV[] args, boolean isSelector) throws ScriptException {
        if (isSelector) {
            SV x1 = mp.getX();
            switch (x1.tok) {
                case 11: 
                case 12: {
                    return mp.addX(x1.toArray());
                }
            }
            if (args.length == 0 || args.length > 2) {
                return false;
            }
            boolean doCopy = args.length == 1 || args[1].tok == 1073742334;
            switch (x1.tok) {
                case 11: 
                case 12: {
                    return mp.addX(x1.toArray());
                }
                case 6: {
                    int i;
                    if (args.length != 1) {
                        return false;
                    }
                    Lst<SV> lst = new Lst<SV>();
                    Map<String, SV> map = x1.getMap();
                    String[] keys = x1.getKeys(false);
                    int n = keys.length;
                    for (i = 0; i < n; ++i) {
                        if (map.get(keys[i]).getMap() != null) continue;
                        return false;
                    }
                    String id = args[0].asString();
                    n = keys.length;
                    for (i = 0; i < n; ++i) {
                        Map m1 = map.get(keys[i]).getMap();
                        if (doCopy) {
                            m1 = (Map)SV.deepCopy(m1, true, false);
                        }
                        m1.put(id, SV.newS(keys[i]));
                        lst.addLast(SV.newV(6, m1));
                    }
                    return mp.addXList(lst);
                }
                case 7: {
                    int pt;
                    Map<String, SV> m1;
                    boolean toArray = true;
                    BS bsIndex = new BS();
                    Hashtable<String, SV> map1 = new Hashtable<String, SV>();
                    Lst<SV> lst1 = x1.getList();
                    String id = args[0].asString();
                    int i = lst1.size();
                    while (--i > 0) {
                        m1 = ((SV)lst1.get(i)).getMap();
                        if (m1 != null && m1.get(id) != null) continue;
                        return false;
                    }
                    int n = lst1.size();
                    for (i = 0; i < n; ++i) {
                        Object key;
                        m1 = ((SV)lst1.get(i)).getMap();
                        if (m1 == null) {
                            return false;
                        }
                        if (doCopy) {
                            m1 = (Map<String, SV>)SV.deepCopy(m1, true, false);
                        }
                        SV mid = m1.remove(id);
                        if (toArray) {
                            if (mid.tok == 2 && mid.intValue >= 0 && mid.intValue <= 10000) {
                                bsIndex.set(mid.intValue);
                            } else {
                                toArray = false;
                            }
                        }
                        if (map1.containsKey(key = mid.asString())) {
                            return false;
                        }
                        map1.put((String)key, SV.newV(6, m1));
                    }
                    if (toArray && (pt = bsIndex.nextSetBit(0)) == 0 | pt == 1) {
                        int len = bsIndex.cardinality();
                        if (bsIndex.nextClearBit(pt) == len + pt) {
                            void var19_27;
                            SV[] a = new SV[len];
                            for (Map.Entry entry : map1.entrySet()) {
                                a[Integer.parseInt((String)((String)entry.getKey())) - pt] = (SV)entry.getValue();
                            }
                            Lst<SV> list = new Lst<SV>();
                            boolean bl = false;
                            while (var19_27 < len) {
                                list.addLast(a[var19_27]);
                                ++var19_27;
                            }
                            return mp.addXList(list);
                        }
                    }
                    return mp.addXObj(map1);
                }
            }
            return false;
        }
        SV[] a = new SV[args.length];
        int i = a.length;
        while (--i >= 0) {
            a[i] = SV.newT(args[i]);
        }
        return mp.addXAV(a);
    }

    private boolean evaluateBin(ScriptMathProcessor mp, SV[] args) throws ScriptException {
        float[] data;
        boolean isListf;
        int n = args.length;
        if (n < 3 || n > 5) {
            return false;
        }
        SV x1 = mp.getX();
        boolean bl = isListf = x1.tok == 13;
        if (!isListf && x1.tok != 7) {
            return mp.addX(x1);
        }
        float f0 = SV.fValue(args[0]);
        float f1 = SV.fValue(args[1]);
        float df = SV.fValue(args[2]);
        boolean addBins = n >= 4 && args[n - 1].tok == 1073742335;
        String key = (n == 5 || n == 4 && !addBins) && args[3].tok != 1073742334 ? SV.sValue(args[3]) : null;
        Map<K, V>[] maps = null;
        if (isListf) {
            data = (float[])x1.value;
        } else {
            Lst<SV> list = x1.getList();
            data = new float[list.size()];
            if (key != null) {
                maps = AU.createArrayOfHashtable(list.size());
            }
            try {
                int i = list.size();
                while (--i >= 0) {
                    T t;
                    if (key == null) {
                        t = (T)list.get(i);
                    } else {
                        maps[i] = ((SV)list.get(i)).getMap();
                        t = maps[i].get(key);
                    }
                    data[i] = SV.fValue(t);
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        int nbins = Math.max((int)Math.floor((f1 - f0) / df + 0.01f), 1);
        int[] array = new int[nbins];
        int nPoints = data.length;
        for (int i = 0; i < nPoints; ++i) {
            Map<String, SV> map;
            float v = data[i];
            int bin = (int)Math.floor((v - f0) / df);
            if (bin < 0 || bin >= nbins) continue;
            int n2 = bin;
            array[n2] = array[n2] + 1;
            if (key == null || (map = maps[i]) == null) continue;
            map.put("_bin", SV.newI(bin));
            float v1 = f0 + df * (float)bin;
            float v2 = v1 + df;
            map.put("_binMin", SV.newF(bin == 0 ? -3.4028235E38f : v1));
            map.put("_binMax", SV.newF(bin == nbins - 1 ? Float.MAX_VALUE : v2));
        }
        if (addBins) {
            Lst<float[]> lst = new Lst<float[]>();
            for (int i = 0; i < nbins; ++i) {
                lst.addLast(new float[]{f0 + df * (float)i, array[i]});
            }
            return mp.addXList(lst);
        }
        return mp.addXAI(array);
    }

    private boolean evaluateCache(ScriptMathProcessor mp, SV[] args) {
        if (args.length > 0) {
            return false;
        }
        return mp.addXMap(this.vwr.fm.cacheList());
    }

    private boolean evaluateColor(ScriptMathProcessor mp, SV[] args) {
        boolean haveRange;
        ColorEncoder ce;
        String colorScheme = args.length > 0 ? SV.sValue(args[0]) : "";
        boolean isIsosurface = colorScheme.startsWith("$");
        if (args.length == 2 && colorScheme.equalsIgnoreCase("TOHSL")) {
            return mp.addXPt(CU.rgbToHSL(P3.newP(args[1].tok == 8 ? SV.ptValue(args[1]) : CU.colorPtFromString(args[1].asString())), true));
        }
        if (args.length == 2 && colorScheme.equalsIgnoreCase("TORGB")) {
            P3 pt = P3.newP(args[1].tok == 8 ? SV.ptValue(args[1]) : CU.colorPtFromString(args[1].asString()));
            return mp.addXPt(args[1].tok == 8 ? CU.hslToRGB(pt) : pt);
        }
        if (args.length == 4 && (args[3].tok == 1073742335 || args[3].tok == 1073742334)) {
            boolean usingHSL;
            P3 pt1 = P3.newP(args[0].tok == 8 ? SV.ptValue(args[0]) : CU.colorPtFromString(args[0].asString()));
            P3 pt2 = P3.newP(args[1].tok == 8 ? SV.ptValue(args[1]) : CU.colorPtFromString(args[1].asString()));
            boolean bl = usingHSL = args[3].tok == 1073742335;
            if (usingHSL) {
                pt1 = CU.rgbToHSL(pt1, false);
                pt2 = CU.rgbToHSL(pt2, false);
            }
            SB sb = new SB();
            V3 vd = V3.newVsub(pt2, pt1);
            int n = args[2].asInt();
            if (n < 2) {
                n = 20;
            }
            vd.scale(1.0f / (float)(n - 1));
            for (int i = 0; i < n; ++i) {
                sb.append(Escape.escapeColor(CU.colorPtToFFRGB(usingHSL ? CU.hslToRGB(pt1) : pt1)));
                pt1.add(vd);
            }
            return mp.addXStr(sb.toString());
        }
        ColorEncoder colorEncoder = ce = isIsosurface ? null : this.vwr.cm.getColorEncoder(colorScheme);
        if (!isIsosurface && ce == null) {
            return mp.addXStr("");
        }
        float lo = args.length > 1 ? SV.fValue(args[1]) : Float.MAX_VALUE;
        float hi = args.length > 2 ? SV.fValue(args[2]) : Float.MAX_VALUE;
        float value = args.length > 3 ? SV.fValue(args[3]) : Float.MAX_VALUE;
        boolean getValue = value != Float.MAX_VALUE || lo != Float.MAX_VALUE && hi == Float.MAX_VALUE;
        boolean bl = haveRange = hi != Float.MAX_VALUE;
        if (!haveRange && colorScheme.length() == 0) {
            value = lo;
            float[] range = this.vwr.getCurrentColorRange();
            lo = range[0];
            hi = range[1];
        }
        if (isIsosurface) {
            String id = colorScheme.substring(1);
            Object[] data = new Object[]{id, null};
            if (!this.vwr.shm.getShapePropertyData(24, "colorEncoder", data)) {
                return mp.addXStr("");
            }
            ce = (ColorEncoder)data[1];
        } else {
            ce.setRange(lo, hi, lo > hi);
        }
        Map<String, Object> key = ce.getColorKey();
        if (getValue) {
            return mp.addXPt(CU.colorPtFromInt(ce.getArgb(hi == Float.MAX_VALUE ? lo : value), null));
        }
        return mp.addX(SV.getVariableMap(key));
    }

    private boolean evaluateCompare(ScriptMathProcessor mp, SV[] args) throws ScriptException {
        Lst<SV> abmap;
        boolean isTrue;
        int narg = args.length;
        if (narg < 2 || narg > 5) {
            return false;
        }
        boolean bl = isTrue = args[narg - 1].tok == 1073742335;
        if (isTrue || args[narg - 1].tok == 1073742334) {
            --narg;
        }
        String sOpt = SV.sValue(args[narg - 1]);
        boolean isStdDev = sOpt.equalsIgnoreCase("stddev");
        boolean isIsomer = sOpt.equalsIgnoreCase("ISOMER");
        boolean isTautomer = isIsomer && isTrue;
        boolean isBonds = sOpt.equalsIgnoreCase("BONDS");
        boolean isPoints = args[0].tok == 7 && args[1].tok == 7;
        Lst<SV> lst = abmap = narg >= 3 ? args[2].getList() : null;
        boolean isSmiles = abmap == null && !isPoints && !isIsomer && narg > (isStdDev ? 3 : 2);
        BS bs1 = args[0].tok == 10 ? (BS)args[0].value : null;
        BS bs2 = args[1].tok == 10 ? (BS)args[1].value : null;
        String smiles1 = bs1 == null ? SV.sValue(args[0]) : "";
        String smiles2 = bs2 == null ? SV.sValue(args[1]) : "";
        float stddev = Float.NaN;
        try {
            if (isBonds) {
                if (narg != 4) {
                    return false;
                }
                smiles1 = SV.sValue(args[2]);
                isSmiles = smiles1.equalsIgnoreCase("SMILES");
                try {
                    if (isSmiles) {
                        smiles1 = this.vwr.getSmiles(bs1);
                    }
                }
                catch (Exception ex) {
                    this.e.evalError(ex.getMessage(), null);
                }
                float[] data = this.e.getSmilesExt().getFlexFitList(bs1, bs2, smiles1, !isSmiles);
                return data == null ? mp.addXStr("") : mp.addXAF(data);
            }
            if (isIsomer) {
                boolean check;
                String mf2;
                if (narg != 3) {
                    return false;
                }
                if (bs1 == null && bs2 == null) {
                    String ret = this.vwr.getSmilesMatcher().getRelationship(smiles1, smiles2).toUpperCase();
                    return mp.addXStr(ret);
                }
                String mf1 = bs1 == null ? this.vwr.getSmilesMatcher().getMolecularFormula(smiles1, false, false) : JmolMolecule.getMolecularFormulaAtoms(this.vwr.ms.at, bs1, null, false);
                String string = mf2 = bs2 == null ? this.vwr.getSmilesMatcher().getMolecularFormula(smiles2, false, false) : JmolMolecule.getMolecularFormulaAtoms(this.vwr.ms.at, bs2, null, false);
                if (!mf1.equals(mf2)) {
                    return mp.addXStr("NONE");
                }
                if (bs1 != null) {
                    smiles1 = (String)this.e.getSmilesExt().getSmilesMatches("/strict///", null, bs1, null, 1, true, false);
                }
                if (bs2 == null) {
                    check = this.vwr.getSmilesMatcher().areEqual(smiles2, smiles1) > 0;
                } else {
                    smiles2 = (String)this.e.getSmilesExt().getSmilesMatches("/strict///", null, bs2, null, 1, true, false);
                    boolean bl2 = check = ((BS)this.e.getSmilesExt().getSmilesMatches("/strict///" + smiles1, null, bs2, null, 1, true, false)).nextSetBit(0) >= 0;
                }
                if (!check) {
                    String inchi;
                    String s = smiles1 + smiles2;
                    if (s.indexOf("/") >= 0 || s.indexOf("\\") >= 0 || s.indexOf("@") >= 0) {
                        if (smiles1.indexOf("@") >= 0 && (bs2 != null || smiles2.indexOf("@") >= 0) && smiles1.indexOf("@SP") < 0) {
                            int pt = smiles1.toLowerCase().indexOf("invertstereo");
                            String string2 = smiles1 = pt >= 0 ? "/strict/" + smiles1.substring(0, pt) + smiles1.substring(pt + 12) : "/invertstereo strict/" + smiles1;
                            if (bs2 == null) {
                                check = this.vwr.getSmilesMatcher().areEqual(smiles1, smiles2) > 0;
                            } else {
                                boolean bl3 = check = ((BS)this.e.getSmilesExt().getSmilesMatches(smiles1, null, bs2, null, 1, true, false)).nextSetBit(0) >= 0;
                            }
                            if (check) {
                                return mp.addXStr("ENANTIOMERS");
                            }
                        }
                        if (bs2 == null) {
                            check = this.vwr.getSmilesMatcher().areEqual("/nostereo/" + smiles2, smiles1) > 0;
                        } else {
                            Object ret = this.e.getSmilesExt().getSmilesMatches("/nostereo/" + smiles1, null, bs2, null, 1, true, false);
                            boolean bl4 = check = ((BS)ret).nextSetBit(0) >= 0;
                        }
                        if (check) {
                            return mp.addXStr("DIASTEREOMERS");
                        }
                    }
                    String ret = "CONSTITUTIONAL ISOMERS";
                    if (isTautomer && (inchi = this.vwr.getInchi(bs1, null, null)) != null && inchi.equals(this.vwr.getInchi(bs2, null, null))) {
                        ret = "TAUTOMERS";
                    }
                    return mp.addXStr(ret);
                }
                if (bs1 == null || bs2 == null) {
                    return mp.addXStr("IDENTICAL");
                }
                stddev = this.e.getSmilesExt().getSmilesCorrelation(bs1, bs2, smiles1, null, null, null, null, false, null, null, false, 1);
                return mp.addXStr(stddev < 0.2f ? "IDENTICAL" : "IDENTICAL or CONFORMATIONAL ISOMERS (RMSD=" + stddev + ")");
            }
            M4 m = new M4();
            Lst<P3> ptsA = null;
            Lst<P3> ptsB = null;
            if (isSmiles) {
                boolean isPolyhedron;
                boolean isSearch;
                if (bs1 == null || bs2 == null) {
                    return false;
                }
                sOpt = SV.sValue(args[2]);
                boolean isMap = sOpt.equalsIgnoreCase("MAP");
                isSmiles = sOpt.equalsIgnoreCase("SMILES");
                boolean bl5 = isSearch = isMap || sOpt.equalsIgnoreCase("SMARTS");
                if (isSmiles || isSearch) {
                    sOpt = narg > (isStdDev ? 4 : 3) ? SV.sValue(args[3]) : null;
                }
                boolean hMaps = "H".equalsIgnoreCase(sOpt) || "allH".equalsIgnoreCase(sOpt) || "bestH".equalsIgnoreCase(sOpt);
                boolean bl6 = isPolyhedron = !hMaps && ("polyhedra".equalsIgnoreCase(sOpt) || "polyhedron".equalsIgnoreCase(sOpt));
                if (isPolyhedron) {
                    stddev = this.e.getSmilesExt().mapPolyhedra(bs1.nextSetBit(0), bs2.nextSetBit(0), isSmiles, m);
                } else {
                    boolean bestMap;
                    ptsA = new Lst();
                    ptsB = new Lst();
                    boolean allMaps = "all".equalsIgnoreCase(sOpt) || "allH".equalsIgnoreCase(sOpt);
                    boolean bl7 = bestMap = "best".equalsIgnoreCase(sOpt) || "bestH".equalsIgnoreCase(sOpt);
                    if ("stddev".equals(sOpt)) {
                        sOpt = null;
                    }
                    String pattern = sOpt;
                    if (sOpt == null || hMaps || allMaps || bestMap) {
                        if (!isMap && !isSmiles || hMaps && isPolyhedron) {
                            return false;
                        }
                        pattern = "/noaromatic" + (allMaps || bestMap ? "/" : " nostereo/") + this.e.getSmilesExt().getSmilesMatches(hMaps ? "H" : "", null, bs1, null, 32769, true, false);
                    } else {
                        allMaps = true;
                    }
                    stddev = this.e.getSmilesExt().getSmilesCorrelation(bs1, bs2, pattern, ptsA, ptsB, m, null, isMap, null, null, bestMap, (isSmiles ? 1 : 2) | (!allMaps && !bestMap ? 8 : 0));
                    if (isMap) {
                        int nAtoms = ptsA.size();
                        if (nAtoms == 0) {
                            return mp.addXStr("");
                        }
                        int nMatch = ptsB.size() / nAtoms;
                        Lst<int[][]> ret = new Lst<int[][]>();
                        int pt = 0;
                        for (int i = 0; i < nMatch; ++i) {
                            int[][] a = AU.newInt2(nAtoms);
                            ret.addLast(a);
                            int j = 0;
                            while (j < nAtoms) {
                                a[j] = new int[]{((Atom)ptsA.get((int)j)).i, ((Atom)ptsB.get((int)pt)).i};
                                ++j;
                                ++pt;
                            }
                        }
                        return allMaps ? mp.addXList(ret) : (ret.size() > 0 ? mp.addXAII((int[][])ret.get(0)) : mp.addXStr(""));
                    }
                }
            } else {
                ptsA = this.e.getPointVector(args[0], 0);
                ptsB = this.e.getPointVector(args[1], 0);
                if (ptsA == null || ptsB == null) {
                    return false;
                }
                if (abmap != null) {
                    --narg;
                    int n = abmap.size();
                    if (n > ptsA.size() || n != ptsB.size()) {
                        return false;
                    }
                    Lst list = new Lst();
                    for (int i = 0; i < n; ++i) {
                        list.addLast(ptsA.get(((SV)abmap.get((int)i)).intValue - 1));
                    }
                    ptsA = list;
                }
                switch (narg) {
                    case 2: {
                        break;
                    }
                    case 3: {
                        if (isStdDev) break;
                    }
                    default: {
                        return false;
                    }
                }
                if (ptsA.size() == ptsB.size()) {
                    Interface.getInterface("javajs.util.Eigen", this.vwr, "script");
                    stddev = Measure.getTransformMatrix4(ptsA, ptsB, m, null);
                }
            }
            return isStdDev || Float.isNaN(stddev) ? mp.addXFloat(stddev) : mp.addXM4(m.round(1.0E-7f));
        }
        catch (Exception ex) {
            this.e.evalError(ex.getMessage() == null ? ex.toString() : ex.getMessage(), null);
            return false;
        }
    }

    private boolean evaluateConnected(ScriptMathProcessor mp, SV[] args, int tok, int intValue) throws ScriptException {
        if (args.length > 5) {
            return false;
        }
        float min = -2.1474836E9f;
        float max = 2.1474836E9f;
        float fmin = 0.0f;
        float fmax = Float.MAX_VALUE;
        int order = 65535;
        BS atoms1 = null;
        BS atoms2 = null;
        boolean haveDecimal = false;
        boolean isBonds = false;
        switch (tok) {
            case 1275203608: {
                Object[] data;
                int nv = Integer.MIN_VALUE;
                String smiles = null;
                if (args.length > 0) {
                    switch (args[0].tok) {
                        case 2: {
                            nv = args[0].intValue;
                            break;
                        }
                        case 4: {
                            smiles = SV.sValue(args[0]);
                        }
                    }
                }
                if (intValue == 1275203608) {
                    atoms1 = SV.getBitSet(mp.getX(), true);
                }
                if (!this.vwr.shm.getShapePropertyData(21, "getCenters", data = new Object[]{nv, smiles, atoms1})) {
                    data[1] = null;
                }
                return mp.addXBs(data[1] == null ? new BS() : (BS)data[1]);
            }
            case 1228931586: {
                SV x1 = mp.getX();
                if (x1.tok != 10 || args.length != 1 || args[0].tok != 10) {
                    return false;
                }
                atoms1 = (BS)x1.value;
                atoms2 = (BS)args[0].value;
                Lst<Integer> list = new Lst<Integer>();
                Atom[] atoms = this.vwr.ms.at;
                int i = atoms1.nextSetBit(0);
                while (i >= 0) {
                    int n = 0;
                    Bond[] b = atoms[i].bonds;
                    int j = b.length;
                    while (--j >= 0) {
                        if (!atoms2.get(b[j].getOtherAtom((Atom)atoms[i]).i)) continue;
                        ++n;
                    }
                    list.addLast(n);
                    i = atoms1.nextSetBit(i + 1);
                }
                return mp.addXList(list);
            }
        }
        block15: for (int i = 0; i < args.length; ++i) {
            SV var = args[i];
            switch (var.tok) {
                case 10: {
                    isBonds = var.value instanceof BondSet;
                    if (isBonds && atoms1 != null) {
                        return false;
                    }
                    if (atoms1 == null) {
                        atoms1 = (BS)var.value;
                        continue block15;
                    }
                    if (atoms2 == null) {
                        atoms2 = (BS)var.value;
                        continue block15;
                    }
                    return false;
                }
                case 4: {
                    String type = SV.sValue(var);
                    order = type.equalsIgnoreCase("hbond") ? 30720 : Edge.getBondOrderFromString(type);
                    if (order != 131071) continue block15;
                    return false;
                }
                case 3: {
                    haveDecimal = true;
                }
                default: {
                    int n = var.asInt();
                    float f = var.asFloat();
                    if (max != 2.1474836E9f) {
                        return false;
                    }
                    if (min == -2.1474836E9f) {
                        min = Math.max(n, 0);
                        fmin = f;
                        continue block15;
                    }
                    max = n;
                    fmax = f;
                }
            }
        }
        if (min == -2.1474836E9f) {
            min = 1.0f;
            max = 100.0f;
            fmin = 0.1f;
            fmax = 1.0E8f;
        } else if (max == 2.1474836E9f) {
            max = min;
            fmax = fmin;
            fmin = 0.1f;
        }
        if (atoms1 == null) {
            atoms1 = this.vwr.getAllAtoms();
        }
        if (haveDecimal && atoms2 == null) {
            atoms2 = atoms1;
        }
        if (atoms2 != null) {
            BS bsBonds = new BS();
            this.vwr.makeConnections(fmin, fmax, order, 1086324745, atoms1, atoms2, bsBonds, isBonds, false, 0.0f);
            return mp.addX(SV.newV(10, BondSet.newBS(bsBonds)));
        }
        return mp.addXBs(this.vwr.ms.getAtomsConnected(min, max, order, atoms1));
    }

    private boolean evaluateContact(ScriptMathProcessor mp, SV[] args) {
        if (args.length < 1 || args.length > 3) {
            return false;
        }
        int i = 0;
        float distance = 100.0f;
        int tok = args[0].tok;
        switch (tok) {
            case 2: 
            case 3: {
                distance = SV.fValue(args[i++]);
                break;
            }
            case 10: {
                break;
            }
            default: {
                return false;
            }
        }
        if (i == args.length || !(args[i].value instanceof BS)) {
            return false;
        }
        BS bsA = BSUtil.copy((BS)args[i++].value);
        BS bsB = i < args.length ? BSUtil.copy((BS)args[i].value) : null;
        RadiusData rd = new RadiusData(null, distance > 10.0f ? distance / 100.0f : distance, distance > 10.0f ? RadiusData.EnumType.FACTOR : RadiusData.EnumType.OFFSET, VDW.AUTO);
        bsB = this.setContactBitSets(bsA, bsB, true, Float.NaN, rd, false);
        bsB.or(bsA);
        return mp.addXBs(bsB);
    }

    private boolean evaluateData(ScriptMathProcessor mp, SV[] args) {
        String selected = args.length == 0 ? "" : SV.sValue(args[0]);
        switch (args.length) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                if (args[0].tok != 10) break;
                return mp.addXStr(this.vwr.getModelFileData(selected, SV.sValue(args[1]), args.length == 3 && SV.bValue(args[2])));
            }
            case 4: {
                int iField = args[1].asInt();
                int nBytes = args[2].asInt();
                int firstLine = args[3].asInt();
                float[] f = Parser.parseFloatArrayFromMatchAndField(SV.sValue(args[0]), null, 0, 0, null, iField, nBytes, null, firstLine);
                return mp.addXStr(Escape.escapeFloatA(f, false));
            }
            default: {
                return false;
            }
        }
        if (selected.indexOf("data2d_") == 0) {
            float[][] f1 = (float[][])this.vwr.getDataObj(selected, null, 2);
            if (f1 == null) {
                return mp.addXStr("");
            }
            if (args.length == 2 && args[1].tok == 2) {
                int pt = args[1].intValue;
                if (pt < 0) {
                    pt += f1.length;
                }
                if (pt >= 0 && pt < f1.length) {
                    return mp.addXStr(Escape.escapeFloatA(f1[pt], false));
                }
                return mp.addXStr("");
            }
            return mp.addXStr(Escape.escapeFloatAA(f1, false));
        }
        if (selected.endsWith("*")) {
            return mp.addXList((Lst)this.vwr.getDataObj(selected, null, 0));
        }
        if (selected.indexOf("property_") == 0) {
            float[] f1 = (float[])this.vwr.getDataObj(selected, null, 1);
            return f1 == null ? mp.addXStr("") : mp.addXStr(Escape.escapeFloatA(f1, false));
        }
        Object[] data = (Object[])this.vwr.getDataObj(selected, null, -1);
        return mp.addXStr(data == null || data.length < 2 ? "" : "" + data[1]);
    }

    private boolean evaluateDotDist(ScriptMathProcessor mp, SV[] args, int tok, int op) throws ScriptException {
        float f;
        block38: {
            SV x2;
            SV x1;
            boolean isDist = tok == 1275069443;
            SV x3 = null;
            switch (args.length) {
                case 2: {
                    if (op == Integer.MAX_VALUE) {
                        x1 = args[0];
                        x2 = args[1];
                        break;
                    }
                    x3 = args[1];
                }
                case 1: {
                    x1 = mp.getX();
                    x2 = args[0];
                    break;
                }
                case 0: {
                    if (isDist) {
                        x1 = mp.getX();
                        x2 = SV.getVariable(new P3());
                        break;
                    }
                }
                default: {
                    return false;
                }
            }
            f = Float.NaN;
            try {
                if (tok == 1275069442) {
                    P3 a = P3.newP(mp.ptValue(x1, null));
                    a.cross(a, mp.ptValue(x2, null));
                    return mp.addXPt(a);
                }
                P3 pt2 = x2.tok == 7 ? null : mp.ptValue(x2, null);
                P4 plane2 = this.e.planeValue(x2);
                if (isDist) {
                    int minMax = op == Integer.MIN_VALUE ? 0 : op & 0x1E0;
                    boolean isMinMax = minMax == 32 || minMax == 64;
                    boolean isAll = minMax == 480;
                    switch (x1.tok) {
                        case 7: 
                        case 10: {
                            boolean isAtomSet1 = x1.tok == 10;
                            boolean isAtomSet2 = x2.tok == 10;
                            boolean isPoint2 = x2.tok == 8;
                            BS bs1 = isAtomSet1 ? (BS)x1.value : null;
                            BS bs2 = isAtomSet2 ? (BS)x2.value : null;
                            Lst<SV> list1 = isAtomSet1 ? null : x1.getList();
                            Lst<SV> list2 = isAtomSet2 ? null : x2.getList();
                            boolean returnAtom = isMinMax && x3 != null && x3.asBoolean();
                            switch (x2.tok) {
                                case 7: 
                                case 8: 
                                case 10: {
                                    Atom[] atoms = this.vwr.ms.at;
                                    if (returnAtom) {
                                        float dMinMax = Float.NaN;
                                        int iMinMax = Integer.MAX_VALUE;
                                        if (isAtomSet1) {
                                            int i = bs1.nextSetBit(0);
                                            while (i >= 0) {
                                                float d;
                                                float f2 = d = isPoint2 ? atoms[i].distanceSquared(pt2) : ((Float)this.e.getBitsetProperty(bs2, (Lst)list2, op, (P3)atoms[i], plane2, x1.value, (Object)null, false, x1.index, false)).floatValue();
                                                if (!(minMax == 32 ? d >= dMinMax : d <= dMinMax)) {
                                                    dMinMax = d;
                                                    iMinMax = i;
                                                }
                                                i = bs1.nextSetBit(i + 1);
                                            }
                                            return mp.addXBs(iMinMax == Integer.MAX_VALUE ? new BS() : BSUtil.newAndSetBit(iMinMax));
                                        }
                                        int i = list1.size();
                                        while (--i >= 0) {
                                            float d;
                                            P3 pt = SV.ptValue((SV)list1.get(i));
                                            float f3 = d = isPoint2 ? pt.distanceSquared(pt2) : ((Float)this.e.getBitsetProperty(bs2, (Lst)list2, op, pt, plane2, x1.value, (Object)null, false, Integer.MAX_VALUE, false)).floatValue();
                                            if (minMax == 32 ? d >= dMinMax : d <= dMinMax) continue;
                                            dMinMax = d;
                                            iMinMax = i;
                                        }
                                        return mp.addXInt(iMinMax);
                                    }
                                    if (isAll) {
                                        if (bs2 == null) {
                                            float[] data = new float[bs1.cardinality()];
                                            int p = 0;
                                            int i = bs1.nextSetBit(0);
                                            while (i >= 0) {
                                                data[p] = atoms[i].distance(pt2);
                                                i = bs1.nextSetBit(i + 1);
                                                ++p;
                                            }
                                            return mp.addXAF(data);
                                        }
                                        float[][] data2 = new float[bs1.cardinality()][bs2.cardinality()];
                                        int p = 0;
                                        int i = bs1.nextSetBit(0);
                                        while (i >= 0) {
                                            int q = 0;
                                            int j = bs2.nextSetBit(0);
                                            while (j >= 0) {
                                                data2[p][q] = atoms[i].distance(atoms[j]);
                                                j = bs2.nextSetBit(j + 1);
                                                ++q;
                                            }
                                            i = bs1.nextSetBit(i + 1);
                                            ++p;
                                        }
                                        return mp.addXAFF(data2);
                                    }
                                    if (isMinMax) {
                                        float[] data = new float[isAtomSet1 ? bs1.cardinality() : list1.size()];
                                        if (isAtomSet1) {
                                            int i = bs1.nextSetBit(0);
                                            int p = 0;
                                            while (i >= 0) {
                                                data[p++] = ((Float)this.e.getBitsetProperty(bs2, (Lst)list2, op, (P3)atoms[i], plane2, x1.value, (Object)null, false, x1.index, false)).floatValue();
                                                i = bs1.nextSetBit(i + 1);
                                            }
                                            return mp.addXAF(data);
                                        }
                                        int i = data.length;
                                        while (--i >= 0) {
                                            data[i] = ((Float)this.e.getBitsetProperty(bs2, (Lst)list2, op, SV.ptValue((SV)list1.get(i)), plane2, (Object)null, (Object)null, false, Integer.MAX_VALUE, false)).floatValue();
                                        }
                                        return mp.addXAF(data);
                                    }
                                    return mp.addXObj(this.e.getBitsetProperty(bs1, (Lst)list1, op, pt2, plane2, x1.value, (Object)null, false, x1.index, false));
                                }
                            }
                        }
                    }
                }
                P3 pt1 = mp.ptValue(x1, null);
                P4 plane1 = this.e.planeValue(x1);
                if (isDist) {
                    if (plane2 != null && x3 != null) {
                        f = Measure.directedDistanceToPlane(pt1, plane2, SV.ptValue(x3));
                        break block38;
                    }
                    f = plane1 == null ? (plane2 == null ? pt2.distance(pt1) : Measure.distanceToPlane(plane2, pt1)) : Measure.distanceToPlane(plane1, pt2);
                    break block38;
                }
                if (plane1 != null && plane2 != null) {
                    f = plane1.x * plane2.x + plane1.y * plane2.y + plane1.z * plane2.z + plane1.w * plane2.w;
                } else {
                    if (plane1 != null) {
                        pt1 = P3.new3(plane1.x, plane1.y, plane1.z);
                    } else if (plane2 != null) {
                        pt2 = P3.new3(plane2.x, plane2.y, plane2.z);
                    }
                    f = pt1.dot(pt2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return mp.addXFloat(f);
    }

    private boolean evaluateHelix(ScriptMathProcessor mp, SV[] args) throws ScriptException {
        if (args.length < 1 || args.length > 5) {
            return false;
        }
        int pt = args.length > 2 ? 3 : 1;
        String type = pt >= args.length ? "array" : SV.sValue(args[pt]);
        int tok = T.getTokFromName(type);
        if (args.length > 2) {
            P3 pta = mp.ptValue(args[0], null);
            P3 ptb = mp.ptValue(args[1], null);
            if (tok == 0 || args[2].tok != 9 || pta == null || ptb == null) {
                return false;
            }
            Quat dq = Quat.newP4((P4)args[2].value);
            T3[] data = Measure.computeHelicalAxis(pta, ptb, dq);
            return data == null ? false : mp.addXObj(Escape.escapeHelical(type, tok, pta, ptb, data));
        }
        BS bs = args[0].value instanceof BS ? (BS)args[0].value : this.vwr.ms.getAtoms(1094715412, args[0].asInt());
        switch (tok) {
            case 134217751: 
            case 1073741854: 
            case 1665140738: {
                return mp.addXObj(this.getHelixData(bs, tok));
            }
            case 0x8000001: {
                return mp.addXFloat(((Float)this.getHelixData(bs, 0x8000001)).floatValue());
            }
            case 135176: 
            case 1745489939: {
                return mp.addXObj(this.getHelixData(bs, tok));
            }
            case 1275068418: {
                String[] data = (String[])this.getHelixData(bs, 1073742001);
                if (data == null) {
                    return false;
                }
                return mp.addXAS(data);
            }
        }
        return false;
    }

    private Object getHelixData(BS bs, int tokType) {
        int iAtom = bs.nextSetBit(0);
        return iAtom < 0 ? "null" : this.vwr.ms.at[iAtom].group.getHelixData(tokType, this.vwr.getQuaternionFrame(), this.vwr.getInt(553648142));
    }

    private boolean evaluateInChI(ScriptMathProcessor mp, SV[] args) throws ScriptException {
        BS atoms;
        String flags;
        SV x1 = mp.getX();
        String string = flags = args.length > 0 ? SV.sValue(args[0]) : "fixedh?";
        if (flags.toLowerCase().equals("standard")) {
            flags = "";
        }
        String molData = (atoms = SV.getBitSet(x1, true)) == null ? SV.sValue(x1) : null;
        String ret = this.vwr.getInchi(atoms, molData, flags);
        return flags.indexOf("model") >= 0 ? mp.addXMap(this.vwr.parseJSONMap(ret)) : mp.addXStr(ret);
    }

    private boolean evaluateFind(ScriptMathProcessor mp, SV[] args) throws ScriptException {
        boolean isPattern;
        boolean checkEmpty;
        Lst<SV> svlist;
        boolean isEquivalent;
        boolean isSequence;
        String flags;
        boolean asIndex;
        boolean isOff;
        String sFind;
        int tok0;
        boolean isEmpty;
        boolean isList;
        SV x1;
        block118: {
            boolean isPatternObj;
            boolean isSeq;
            x1 = mp.getX();
            isList = x1.tok == 7;
            boolean isAtoms = x1.tok == 10;
            isEmpty = args.length == 0;
            tok0 = args.length == 0 ? 0 : args[0].tok;
            sFind = isEmpty || tok0 != 4 ? "" : SV.sValue(args[0]);
            isOff = args.length > 1 && args[1].tok == 1073742334;
            int tokLast = tok0 == 0 ? 0 : args[args.length - 1].tok;
            SV argLast = tokLast == 0 ? SV.vF : args[args.length - 1];
            boolean isON = !isList && tokLast == 1073742335;
            asIndex = isList && argLast.tok == 4 && "index".equalsIgnoreCase(SV.sValue(argLast));
            flags = args.length > 1 && args[1].tok != 1073742335 && args[1].tok != 1073742334 && args[1].tok != 10 ? SV.sValue(args[1]) : "";
            isSequence = !isList && !isOff && sFind.equalsIgnoreCase("SEQUENCE");
            boolean bl = isSeq = !isList && !isOff && sFind.equalsIgnoreCase("SEQ");
            if (sFind.toUpperCase().startsWith("SMILES/")) {
                String s;
                if (!sFind.endsWith("/")) {
                    sFind = sFind + "/";
                }
                if (JC.isSmilesCanonical(s = sFind.substring(6) + "//")) {
                    flags = "SMILES";
                    sFind = "CHEMICAL";
                } else {
                    sFind = "SMILES";
                    flags = s + flags;
                }
            } else if (sFind.toUpperCase().startsWith("SMARTS/")) {
                if (!sFind.endsWith("/")) {
                    sFind = sFind + "/";
                }
                flags = sFind.substring(6) + (flags.length() == 0 ? "//" : flags);
                sFind = "SMARTS";
            }
            Object smiles = null;
            boolean isStr = false;
            boolean bl2 = isPatternObj = args.length > 0 && args[0].tok == 134218753;
            if (!isPatternObj && x1.tok == 4) {
                switch (args.length) {
                    case 1: {
                        if (((String)x1.value).startsWith("InChI=") && sFind.equalsIgnoreCase("SMILES")) {
                            return mp.addXStr(this.vwr.getInchi(null, x1.value, "SMILES" + flags));
                        }
                        isStr = !sFind.equals("SMILES");
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (isOff || isON) {
                            isStr = true;
                            break;
                        }
                        if (((String)x1.value).startsWith("InChI=")) {
                            if (sFind.equals("SMARTS")) {
                                smiles = this.vwr.getInchi(null, x1.value, "SMILES");
                                break;
                            }
                            isStr = true;
                            break;
                        }
                        if (flags.length() > 3 || flags.replace('m', ' ').replace('i', ' ').replace('v', ' ').trim().length() != 0) break;
                        isStr = true;
                    }
                }
            }
            boolean isSmiles = !isStr && sFind.equalsIgnoreCase("SMILES");
            boolean isSMARTS = isPatternObj || !isStr && sFind.equalsIgnoreCase("SMARTS");
            boolean isChemical = !isList && !isStr && sFind.equalsIgnoreCase("CHEMICAL");
            boolean isMF = !isList && !isStr && sFind.equalsIgnoreCase("MF");
            boolean isCF = !isList && !isStr && sFind.equalsIgnoreCase("CELLFORMULA");
            boolean isInchi = isAtoms && !isList && sFind.equalsIgnoreCase("INCHI");
            boolean isInchiKey = isAtoms && !isList && sFind.equalsIgnoreCase("INCHIKEY");
            boolean isStructureMap = !isSmiles && !isSMARTS && tok0 == 10 && flags.toLowerCase().indexOf("map") >= 0;
            isEquivalent = !isSmiles && !isSMARTS && (x1.tok == 10 || x1.tok == 8 || x1.tok == 7) && sFind.toLowerCase().startsWith("equivalent");
            try {
                if (isEquivalent) {
                    switch (x1.tok) {
                        case 10: {
                            return mp.addXBs(this.vwr.ms.getSymmetryEquivAtoms((BS)x1.value, null, null));
                        }
                        case 8: {
                            return mp.addXList(this.vwr.getSymmetryEquivPoints((P3)x1.value, sFind + flags));
                        }
                        case 7: {
                            Lst<P3> lst = new Lst<P3>();
                            Lst<SV> l0 = x1.getList();
                            int n = l0.size();
                            for (int i = 0; i < n; ++i) {
                                P3 p = SV.ptValue((SV)l0.get(i));
                                if (p == null) {
                                    return false;
                                }
                                lst.addLast(p);
                            }
                            return mp.addXList(this.vwr.getSymmetryEquivPointList(lst, sFind + flags));
                        }
                    }
                } else if (isInchi || isInchiKey) {
                    if (isInchiKey) {
                        flags = flags + " key";
                    }
                    return mp.addXStr(this.vwr.getInchi(SV.getBitSet(x1, true), null, flags));
                }
                if (isChemical) {
                    BS bsAtoms = isAtoms ? (BS)x1.value : null;
                    String data = bsAtoms == null ? SV.sValue(x1) : this.vwr.getOpenSmiles(bsAtoms);
                    if ((data = (data.length() == 0 ? "" : this.vwr.getChemicalInfo(data, flags.toLowerCase(), bsAtoms)).trim()).startsWith("InChI")) {
                        data = PT.rep(PT.rep(data, "InChI=", ""), "InChIKey=", "");
                    }
                    return mp.addXStr(data);
                }
                if (!isSmiles && !isSMARTS && !isAtoms) break block118;
                int iPt = isStructureMap ? 0 : (isSmiles || isSMARTS ? 2 : 1);
                BS bs2 = iPt < args.length && args[iPt].tok == 10 ? (BS)args[iPt++].value : null;
                boolean asBonds = argLast.tok == 4 && "bonds".equalsIgnoreCase(SV.sValue(argLast));
                boolean isAll = asBonds || isON;
                boolean isSmilesObj = false;
                Object ret = null;
                switch (x1.tok) {
                    case 134218753: {
                        isSmilesObj = true;
                    }
                    case 4: 
                    case 7: {
                        int len;
                        if (smiles == null && !isList) {
                            smiles = x1.value;
                        }
                        if ((isSmiles || isSMARTS) && args.length == 1 && flags == null) {
                            return false;
                        }
                        if (bs2 != null) {
                            return false;
                        }
                        if (flags.equalsIgnoreCase("mf")) {
                            ret = this.vwr.getSmilesMatcher().getMolecularFormula(smiles.toString(), isSMARTS, isON);
                            break;
                        }
                        String pattern = isPatternObj ? args[0].value : flags;
                        boolean allMappings = true;
                        boolean asMap = false;
                        if (isPatternObj) {
                            switch (args.length) {
                                case 3: {
                                    allMappings = SV.bValue(args[2]);
                                }
                                case 2: {
                                    asMap = SV.bValue(args[1]);
                                }
                            }
                        } else {
                            switch (args.length) {
                                case 4: {
                                    allMappings = SV.bValue(args[3]);
                                }
                                case 3: {
                                    asMap = SV.bValue(args[2]);
                                }
                            }
                        }
                        boolean isChirality = !isPatternObj && pattern.equals("chirality");
                        boolean justOne = !asMap && (!allMappings || !isSMARTS && !isChirality);
                        try {
                            if (isList) {
                                Lst<SV> list = x1.getList();
                                Object[] o = new Object[list.size()];
                                int i = o.length;
                                while (--i >= 0) {
                                    o[i] = ((SV)list.get((int)i)).value;
                                }
                                smiles = o;
                            }
                            ret = this.e.getSmilesExt().getSmilesMatches(pattern, smiles, null, null, isSMARTS ? 2 : 1, !asMap, !allMappings);
                            if (isList) {
                                return mp.addXObj(ret);
                            }
                        }
                        catch (Exception ex) {
                            System.out.println(ex.getMessage());
                            return mp.addXInt(-1);
                        }
                        int n = isChirality ? 1 : (len = AU.isAI(ret) ? ((int[])ret).length : ((int[][])ret).length);
                        if (len == 0 && this.vwr.getSmilesMatcher().getLastException() != "MF_FAILED" && (isSmilesObj || ((String)smiles).toLowerCase().indexOf("noaromatic") < 0 && ((String)smiles).toLowerCase().indexOf("strict") < 0)) {
                            ret = this.e.getSmilesExt().getSmilesMatches(pattern, smiles, null, null, 0x10 | (isSMARTS ? 2 : 1), !asMap, !allMappings);
                        }
                        if (!justOne) break;
                        return mp.addXInt(!allMappings && len > 0 ? 1 : len);
                    }
                    case 10: {
                        BS bs = (BS)x1.value;
                        if (sFind.equalsIgnoreCase("spacegroup")) {
                            Object o = this.vwr.findSpaceGroup(null, bs, null, null, null, null, "parent".equals(flags.toLowerCase()) ? 8 : 0);
                            if (o != null) {
                                String s = o.toString();
                                o = PT.rep(s.substring(s.indexOf(" ") + 1), " #", "\t");
                            }
                            return mp.addXStr(o.toString());
                        }
                        if (sFind.equalsIgnoreCase("crystalClass")) {
                            int n = bs.nextSetBit(0);
                            BS bsNew = null;
                            if (args.length != 2) {
                                bsNew = new BS();
                                bsNew.set(n);
                            }
                            return mp.addXList(this.vwr.ms.generateCrystalClass(n, bsNew != null ? this.vwr.ms.getAtomSetCenter(bsNew) : (argLast.tok == 10 ? this.vwr.ms.getAtomSetCenter((BS)argLast.value) : SV.ptValue(argLast))));
                        }
                        if (isMF && flags.length() != 0) {
                            return mp.addXBs(JmolMolecule.getBitSetForMF(this.vwr.ms.at, bs, flags));
                        }
                        if (isMF || isCF) {
                            boolean isEmpirical = isON;
                            return mp.addXStr(this.vwr.getFormulaForAtoms(bs, isMF ? "MF" : "CELLFORMULA", isEmpirical));
                        }
                        if (isSequence || isSeq) {
                            boolean isHH = argLast.asString().equalsIgnoreCase("H");
                            return mp.addXStr(this.vwr.getSmilesOpt(bs, -1, -1, ((isAll |= isHH) ? 0x700000 | (isHH ? 0x900000 : 0) : 0) | (isSeq ? 0x2100000 : 0x100000), null));
                        }
                        if (isStructureMap) {
                            int itype;
                            String key;
                            int[] map = null;
                            int[] map1 = null;
                            int[] map2 = null;
                            Object[][] mapNames = null;
                            String string = key = args.length == 3 ? SV.sValue(argLast) : null;
                            int n = key == null || key.equals("%i") || key.equals("number") ? 105 : (key.equals("%a") || key.equals("name") ? 97 : (itype = key.equals("%D") || key.equals("index") ? 68 : 63));
                            if (key == null) {
                                key = "number";
                            }
                            String err = null;
                            flags = flags.replace("map", "").trim();
                            sFind = this.vwr.getSmilesOpt(bs, 0, 0, 0, flags);
                            if (bs.cardinality() != bs2.cardinality()) {
                                err = "atom sets are not the same size";
                            } else {
                                try {
                                    int iflags = 137;
                                    if (flags.length() > 0) {
                                        sFind = "/" + flags + "/" + sFind;
                                    }
                                    map1 = this.vwr.getSmilesMatcher().getCorrelationMaps(sFind, this.vwr.ms.at, this.vwr.ms.ac, bs, iflags)[0];
                                    int[][] m2 = this.vwr.getSmilesMatcher().getCorrelationMaps(sFind, this.vwr.ms.at, this.vwr.ms.ac, bs2, iflags);
                                    if (m2.length > 0) {
                                        String[] names;
                                        map = new int[bs.length()];
                                        int i = map.length;
                                        while (--i >= 0) {
                                            map[i] = -1;
                                        }
                                        map2 = m2[0];
                                        i = map1.length;
                                        while (--i >= 0) {
                                            map[map1[i]] = map2[i];
                                        }
                                        mapNames = new Object[map1.length][2];
                                        BS bsAll = BS.copy(bs);
                                        bsAll.or(bs2);
                                        String[] stringArray = names = itype == 63 ? new String[bsAll.length()] : null;
                                        if (names != null) {
                                            names = (String[])this.e.getCmdExt().getBitsetIdentFull(bsAll, key, false, Integer.MAX_VALUE, false, names);
                                        }
                                        Atom[] at = this.vwr.ms.at;
                                        int pt = 0;
                                        int i2 = bs.nextSetBit(0);
                                        while (i2 >= 0) {
                                            int j = map[i2];
                                            if (j != -1) {
                                                Object[] a;
                                                switch (itype) {
                                                    case 97: {
                                                        a = new String[]{at[i2].getAtomName(), at[j].getAtomName()};
                                                        break;
                                                    }
                                                    case 105: {
                                                        a = new Integer[]{at[i2].getAtomNumber(), at[j].getAtomNumber()};
                                                        break;
                                                    }
                                                    case 68: {
                                                        a = new Integer[]{i2, j};
                                                        break;
                                                    }
                                                    default: {
                                                        a = new String[]{names[i2], names[j]};
                                                    }
                                                }
                                                mapNames[pt++] = a;
                                            }
                                            i2 = bs.nextSetBit(i2 + 1);
                                        }
                                    }
                                }
                                catch (Exception ee) {
                                    err = ee.getMessage();
                                }
                            }
                            Hashtable<String, Object> m = new Hashtable<String, Object>();
                            m.put("BS1", bs);
                            m.put("BS2", bs2);
                            m.put("SMILES", sFind);
                            if (err == null) {
                                m.put("SMILEStoBS1", map1);
                                m.put("SMILEStoBS2", map2);
                                m.put("BS1toBS2", map);
                                m.put("MAP1to2", mapNames);
                                m.put("key", key);
                            } else {
                                m.put("error", err);
                            }
                            return mp.addXMap(m);
                        }
                        if (isSmiles || isSMARTS) {
                            sFind = args.length > 1 && args[1].tok == 10 ? this.vwr.getSmilesOpt((BS)args[1].value, 0, 0, 0, flags) : flags;
                        }
                        flags = flags.toUpperCase();
                        BS bsMatch3D = bs2;
                        if (flags.indexOf("INCHI") >= 0) {
                            return mp.addXStr(this.vwr.getInchi(bs, null, "SMILES/" + flags));
                        }
                        if (flags.equals("MF")) {
                            smiles = this.e.getSmilesExt().getSmilesMatches("", null, bs, bsMatch3D, 1, true, false);
                            ret = this.vwr.getSmilesMatcher().getMolecularFormula(smiles.toString(), false, isON);
                            break;
                        }
                        if (asBonds) {
                            int[][] map = this.vwr.getSmilesMatcher().getCorrelationMaps(sFind, this.vwr.ms.at, this.vwr.ms.ac, bs, (isSmiles ? 1 : 2) | 8);
                            ret = map.length > 0 ? (Object)this.vwr.ms.getDihedralMap(map[0]) : new int[]{};
                            break;
                        }
                        if (flags.equals("MAP")) {
                            int[][] map = this.vwr.getSmilesMatcher().getCorrelationMaps(sFind, this.vwr.ms.at, this.vwr.ms.ac, bs, (isSmiles ? 1 : 2) | 0x80 | 0x10);
                            ret = map;
                            break;
                        }
                        int smilesFlags = (isSmiles ? (flags.indexOf("OPEN") >= 0 ? 5 : 1) : 2) | (isON && sFind.length() == 0 ? 0x1500000 : 0);
                        if (isSmiles && flags.indexOf("/ALL/") >= 0) {
                            smilesFlags |= 0x8000;
                        }
                        if (flags.indexOf("/MOLECULE/") >= 0) {
                            JmolMolecule[] mols = this.vwr.ms.getMolecules();
                            Lst<BS> molList = new Lst<BS>();
                            for (int i = 0; i < mols.length; ++i) {
                                BS bsRet;
                                if (!mols[i].atomList.intersects(bs) || (bsRet = (BS)this.e.getSmilesExt().getSmilesMatches(sFind, null, mols[i].atomList, bsMatch3D, smilesFlags, !isON, false)).isEmpty()) continue;
                                molList.addLast(bsRet);
                            }
                            ret = molList;
                            break;
                        }
                        ret = this.e.getSmilesExt().getSmilesMatches(sFind, null, bs, bsMatch3D, smilesFlags, !isON, false);
                    }
                }
                if (ret == null) {
                    this.e.invArg();
                }
                return mp.addXObj(ret);
            }
            catch (Exception ex) {
                this.e.evalError(ex.getMessage(), null);
            }
        }
        BS bs = new BS();
        Lst<SV> lst = svlist = isList ? x1.getList() : null;
        if (isList && tok0 != 4 && tok0 != 0) {
            SV v = args[0];
            int n = svlist.size();
            for (int i = 0; i < n; ++i) {
                if (!SV.areEqual((SV)svlist.get(i), v)) continue;
                bs.set(i);
            }
            int[] ret = new int[bs.cardinality()];
            int pt = 0;
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                ret[pt++] = i + 1;
                i = bs.nextSetBit(i + 1);
            }
            return mp.addXAI(ret);
        }
        boolean isReverse = flags.indexOf("v") >= 0;
        boolean isCaseInsensitive = flags.indexOf("i") >= 0 || isOff;
        boolean asMatch = flags.indexOf("m") >= 0;
        boolean bl = checkEmpty = sFind.length() == 0;
        boolean bl3 = !checkEmpty && !isEquivalent && args.length == (asIndex ? 3 : 2) ? true : (isPattern = false);
        if (isList || isPattern) {
            int i;
            int nlist;
            PatternMatcher pm = isPattern ? this.getPatternMatcher() : null;
            Pattern pattern = null;
            if (isPattern) {
                try {
                    pattern = pm.compile(sFind, isCaseInsensitive);
                }
                catch (Exception ex) {
                    this.e.evalError(ex.toString(), null);
                }
            }
            String[] list = checkEmpty ? null : SV.strListValue(x1);
            int n = nlist = checkEmpty ? svlist.size() : list.length;
            if (Logger.debugging) {
                Logger.debug("finding " + sFind);
            }
            int n2 = 0;
            Matcher matcher = null;
            Lst<String> v = asMatch ? new Lst<String>() : null;
            String what = "";
            for (int i3 = 0; i3 < nlist; ++i3) {
                boolean isMatch;
                if (checkEmpty) {
                    SV o = (SV)svlist.get(i3);
                    switch (o.tok) {
                        case 6: {
                            isMatch = o.getMap().isEmpty() != isEmpty;
                            break;
                        }
                        case 7: {
                            isMatch = o.getList().size() == 0 != isEmpty;
                            break;
                        }
                        case 4: {
                            isMatch = o.asString().length() == 0 != isEmpty;
                            break;
                        }
                        default: {
                            isMatch = true;
                            break;
                        }
                    }
                } else if (isPattern) {
                    what = list[i3];
                    matcher = pattern.matcher(what);
                    isMatch = matcher.find();
                } else {
                    boolean bl4 = isMatch = SV.sValue((T)svlist.get(i3)).indexOf(sFind) >= 0;
                }
                if ((!asMatch || !isMatch) && (asMatch || isMatch != !isReverse)) continue;
                ++n2;
                bs.set(i3);
                if (!asMatch) continue;
                v.addLast(isReverse ? what.substring(0, matcher.start()) + what.substring(matcher.end()) : matcher.group());
            }
            if (!isList) {
                return asMatch ? mp.addXStr(v.size() == 1 ? (String)v.get(0) : "") : (isReverse ? mp.addXBool(n2 == 1) : (asMatch ? mp.addXStr(n2 == 0 ? "" : matcher.group()) : mp.addXInt(n2 == 0 ? 0 : matcher.start() + 1)));
            }
            if (asIndex) {
                Lst<SV> lst2 = new Lst<SV>();
                i = bs.nextSetBit(0);
                while (i >= 0) {
                    lst2.addLast(SV.newI(i + 1));
                    i = bs.nextSetBit(i + 1);
                }
                return mp.addXList(lst2);
            }
            if (asMatch) {
                String[] listNew = new String[n2];
                if (n2 > 0) {
                    i = list.length;
                    while (--i >= 0) {
                        if (!bs.get(i)) continue;
                        String string = asMatch ? (String)v.get(--n2) : list[i];
                        listNew[n2] = string;
                    }
                }
                return mp.addXAS(listNew);
            }
            Lst l = new Lst();
            i = bs.nextSetBit(0);
            while (i >= 0) {
                l.addLast(svlist.get(i));
                i = bs.nextSetBit(i + 1);
            }
            return mp.addXList(l);
        }
        if (isSequence) {
            return mp.addXStr(this.vwr.getJBR().toStdAmino3(SV.sValue(x1)));
        }
        return mp.addXInt(SV.sValue(x1).indexOf(sFind) + 1);
    }

    private boolean evaluateGetProperty(ScriptMathProcessor mp, SV[] args, int tok0, boolean isAtomProperty) throws ScriptException {
        String pname;
        int tok;
        int nargs = args.length;
        boolean isSelect = isAtomProperty && tok0 == 1275082241;
        boolean isPivot = isAtomProperty && tok0 == 1275068725;
        boolean isAuxiliary = tok0 == 1275068446;
        int pt = 0;
        int n = tok = nargs == 0 ? 0 : args[0].tok;
        if (nargs == 2 && (tok == 7 || tok == 6 || tok == 14)) {
            return mp.addXObj(this.vwr.extractProperty(args[0].value, args[1].value.toString(), -1));
        }
        BS bsSelect = isAtomProperty && nargs == 1 && args[0].tok == 10 ? (BS)args[0].value : null;
        String propertyName = pname = bsSelect == null && nargs > 0 ? SV.sValue(args[pt++]) : "";
        String lc = propertyName.toLowerCase();
        if (!isSelect && lc.indexOf("[select ") < 0) {
            propertyName = lc;
        }
        boolean isJSON = false;
        if (propertyName.equals("json") && nargs > pt) {
            isJSON = true;
            propertyName = SV.sValue(args[pt++]);
        }
        SV x = null;
        if (isAtomProperty) {
            x = mp.getX();
            switch (x.tok) {
                case 10: {
                    break;
                }
                case 4: {
                    String name = (String)x.value;
                    Object[] data = new Object[3];
                    if (name.startsWith("$")) {
                        int shapeID = this.vwr.shm.getShapeIdFromObjectName(name = name.substring(1));
                        if (shapeID >= 0) {
                            data[0] = name;
                            this.vwr.shm.getShapePropertyData(shapeID, "index", data);
                            if (data[1] != null && !pname.equals("index")) {
                                int index = (Integer)data[1];
                                data[1] = this.vwr.shm.getShapePropertyIndex(shapeID, pname.intern(), index);
                            }
                        }
                    } else {
                        int shapeID = JC.shapeTokenIndex(T.getTokFromName(name));
                        if (shapeID >= 0) {
                            data[0] = pname;
                            data[1] = -1;
                            this.vwr.shm.getShapePropertyData(shapeID, pname.intern(), data);
                        }
                    }
                    return data[1] == null ? mp.addXStr("") : mp.addXObj(data[1]);
                }
                case 7: {
                    if (isPivot) {
                        int i;
                        String sep;
                        Lst<SV> lstx = x.getList();
                        if (nargs == 0) {
                            return mp.addXObj(this.getMinMax(lstx, 1275068725, true));
                        }
                        Hashtable<String, SV> map = new Hashtable<String, SV>();
                        String string = sep = nargs > 1 ? SV.sValue(args[nargs - 1]) : null;
                        if (sep != null) {
                            --nargs;
                        }
                        String[] stringArray = new String[nargs];
                        for (i = 0; i < nargs; ++i) {
                            stringArray[i] = SV.sValue(args[i]);
                        }
                        int n2 = lstx.size();
                        for (i = 0; i < n2; ++i) {
                            SV sv = (SV)lstx.get(i);
                            if (sv.tok != 6) continue;
                            Map<String, SV> mapi = sv.getMap();
                            String key = "";
                            for (int j = 0; j < nargs; ++j) {
                                SV obj = mapi.get(stringArray[j]);
                                key = key + (j == 0 ? "" : sep) + SV.sValue(obj);
                            }
                            SV vlist = (SV)map.get(key);
                            if (vlist == null) {
                                vlist = SV.newV(7, new Lst());
                                map.put(key, vlist);
                            }
                            vlist.getList().addLast(sv);
                        }
                        return mp.addXMap(map);
                    }
                    if (bsSelect != null) {
                        Lst<SV> l0 = x.getList();
                        Lst lst = new Lst();
                        int i = bsSelect.nextSetBit(0);
                        while (i >= 0) {
                            lst.addLast(l0.get(i));
                            i = bsSelect.nextSetBit(i + 1);
                        }
                        return mp.addXList(lst);
                    }
                }
                default: {
                    if (tok0 == 1275068725 && x.tok == 6) {
                        Hashtable<String, Lst<String>> map = new Hashtable<String, Lst<String>>();
                        Map<String, SV> map0 = x.getMap();
                        for (Map.Entry<String, SV> entry : map0.entrySet()) {
                            String key = entry.getKey();
                            String s = entry.getValue().asString();
                            Lst<String> l = (Lst<String>)map.get(s);
                            if (l == null) {
                                l = new Lst<String>();
                                map.put(s, l);
                            }
                            l.addLast(key);
                        }
                        if ("count".equals(lc)) {
                            for (Map.Entry<String, SV> entry : map.entrySet()) {
                                entry.setValue((SV)((Object)Integer.valueOf(((Lst)((Object)entry.getValue())).size())));
                            }
                        }
                        return mp.addXMap(map);
                    }
                    if (isSelect) {
                        propertyName = "[SELECT " + propertyName + "]";
                    }
                    return mp.addXObj(this.vwr.extractProperty(x, propertyName, -1));
                }
            }
            if (!(lc.startsWith("bondinfo") || lc.startsWith("atominfo") || lc.startsWith("modelkitinfo"))) {
                propertyName = "atomInfo." + propertyName;
            }
        }
        BS[] propertyValue = "";
        if (propertyName.equalsIgnoreCase("fileContents") && nargs >= 2) {
            String s = SV.sValue(args[1]);
            for (int i = 2; i < nargs; ++i) {
                s = s + "|" + SV.sValue(args[i]);
            }
            propertyValue = s;
            pt = nargs;
        } else if (nargs > pt) {
            switch (args[pt].tok) {
                case 10: {
                    propertyValue = args[pt++].value;
                    if (!propertyName.equalsIgnoreCase("bondInfo") || nargs <= pt || args[pt].tok != 10) break;
                    propertyValue = new BS[]{(BS)propertyValue, (BS)args[pt].value};
                    break;
                }
                case 4: 
                case 6: {
                    if (!this.vwr.checkPropertyParameter(propertyName)) break;
                    propertyValue = args[pt++].value;
                }
            }
        }
        if (isAtomProperty) {
            BS bs = (BS)x.value;
            int iAtom = bs.nextSetBit(0);
            if (iAtom < 0) {
                return mp.addXStr("");
            }
            propertyValue = bs;
        }
        if (isAuxiliary && !isAtomProperty) {
            propertyName = "auxiliaryInfo.models." + propertyName;
        }
        propertyName = PT.rep(propertyName, ".[", "[");
        Object property = this.vwr.getProperty(null, propertyName, propertyValue);
        if (pt < nargs) {
            property = this.vwr.extractProperty(property, args, pt);
        }
        return mp.addXObj(isJSON ? SV.safeJSON("value", property) : (SV.isVariableType(property) ? property : Escape.toReadable(propertyName, property)));
    }

    private boolean evaluateFormat(ScriptMathProcessor mp, int intValue, SV[] args, boolean isLabel) throws ScriptException {
        Lst<SV> formatList;
        Lst<SV> listIn;
        BS bs;
        String format;
        if (isLabel && args.length > 1) {
            return false;
        }
        SV x1 = args.length < 2 || intValue == 1287653388 ? mp.getX() : null;
        int pt = -1;
        SV x = null;
        block0 : switch (args.length) {
            case 0: {
                format = "%U";
                break;
            }
            case 1: {
                if (x1 == null) {
                    return false;
                }
                switch (args[0].tok) {
                    case 7: {
                        format = null;
                        break block0;
                    }
                    case 4: {
                        format = (String)args[0].value;
                        pt = SV.getFormatType(format);
                        if (pt < 0) break block0;
                        x = x1;
                        break block0;
                    }
                    default: {
                        return false;
                    }
                }
            }
            case 2: {
                if (args[0].tok == 4) {
                    format = SV.sValue(args[0]);
                    x = args[1];
                } else {
                    x = args[0];
                    format = SV.sValue(args[1]);
                }
                pt = SV.getFormatType(format);
                break;
            }
            default: {
                format = (String)args[0].value;
                pt = SV.getFormatType(format);
                if (pt < 0) break;
                return false;
            }
        }
        switch (pt) {
            case -1: {
                break;
            }
            case 28: 
            case 32: 
            case 36: {
                return x.tok == 12 && mp.addXStr(this.matToString((M4)x.value, pt));
            }
            default: {
                return mp.addXObj(SV.getFormat(x, pt));
            }
        }
        BS bS = bs = x1 != null && x1.tok == 10 ? (BS)x1.value : null;
        if (!isLabel && args.length > 0 && bs == null && format != null) {
            if (args.length == 2) {
                listIn = x1.getList();
                formatList = x.getList();
                if (listIn == null || formatList == null) {
                    return false;
                }
                x1 = SV.getVariableList(this.getSublist(listIn, formatList));
            }
            args = new SV[]{args[0], x1};
            x1 = null;
        }
        if (x1 == null) {
            if (format == null || pt >= 0 && args.length != 2) {
                return false;
            }
            if (pt >= 0 || args.length < 2 || args[1].tok != 7) {
                Object o = SV.format(args, pt);
                return o instanceof String ? mp.addXStr((String)o) : mp.addXObj(o);
            }
            Lst<SV> a = args[1].getList();
            SV[] args2 = new SV[]{args[0], null};
            String[] sa = new String[a.size()];
            int i = sa.length;
            while (--i >= 0) {
                args2[1] = (SV)a.get(i);
                sa[i] = SV.format(args2, pt).toString();
            }
            return mp.addXAS(sa);
        }
        if (x1.tok == 7 && format == null) {
            listIn = x1.getList();
            formatList = args[0].getList();
            Lst<SV> listOut = this.getSublist(listIn, formatList);
            return mp.addXList(listOut);
        }
        Object ret = null;
        ret = format == null ? "" : (bs == null ? SV.sprintf(PT.formatCheck(format), x1) : this.e.getCmdExt().getBitsetIdent(bs, format, x1.value, true, x1.index, false));
        return mp.addXObj(ret);
    }

    private Lst<SV> getSublist(Lst<SV> listIn, Lst<SV> formatList) {
        Lst<SV> listOut = new Lst<SV>();
        int n = listIn.size();
        block4: for (int i = 0; i < n; ++i) {
            SV element = (SV)listIn.get(i);
            switch (element.tok) {
                case 6: {
                    int j;
                    Map<String, SV> map = element.getMap();
                    Lst<Object> list = new Lst();
                    int n1 = formatList.size();
                    for (j = 0; j < n1; ++j) {
                        SV v = map.get(SV.sValue((T)formatList.get(j)));
                        list.addLast(v == null ? SV.newS("") : v);
                    }
                    listOut.addLast(SV.getVariableList(list));
                    continue block4;
                }
                case 7: {
                    int j;
                    Map<String, SV> map = new Hashtable<String, SV>();
                    Lst<Object> list = element.getList();
                    int n1 = Math.min(list.size(), formatList.size());
                    for (j = 0; j < n1; ++j) {
                        map.put(SV.sValue((T)formatList.get(j)), (SV)list.get(j));
                    }
                    listOut.addLast(SV.getVariable(map));
                }
            }
        }
        return listOut;
    }

    private boolean evaluateList(ScriptMathProcessor mp, int tok, SV[] args) throws ScriptException {
        boolean justVal;
        boolean isAll;
        boolean isArray1;
        int len = args.length;
        SV x1 = mp.getX();
        switch (tok) {
            case 1275335685: {
                return len == 2 && mp.addX(x1.pushPop(args[0], args[1])) || len == 1 && mp.addX(x1.pushPop(null, args[0]));
            }
            case 1275334681: {
                return len == 1 && mp.addX(x1.pushPop(args[0], null)) || len == 0 && mp.addX(x1.pushPop(null, null));
            }
            case 1275069441: {
                if (len == 1 || len == 2) break;
                return false;
            }
            case 1275069446: 
            case 1275069447: {
                break;
            }
            default: {
                if (len == 1) break;
                return false;
            }
        }
        boolean bl = isArray1 = x1.tok == 7;
        if (len == 2) {
            Object ret = this.listSpecial(tok, x1, SV.sValue(args[0]), args[1], isArray1);
            return ret != null && mp.addXObj(ret);
        }
        SV x2 = len == 0 ? SV.newV(1073742327, "all") : args[0];
        boolean bl2 = isAll = x2.tok == 1073742327;
        if (!isArray1 && x1.tok != 4) {
            return mp.binaryOp(this.opTokenFor(tok), x1, x2);
        }
        boolean isScalar1 = SV.isScalar(x1);
        boolean isScalar2 = SV.isScalar(x2);
        float[] list1 = null;
        float[] list2 = null;
        Lst<SV> alist1 = x1.getList();
        Lst<SV> alist2 = x2.getList();
        String[] sList1 = null;
        String[] sList2 = null;
        if (isArray1) {
            len = alist1.size();
        } else if (isScalar1) {
            len = Integer.MAX_VALUE;
        } else {
            sList1 = PT.split(SV.sValue(x1), "\n");
            len = sList1.length;
            list1 = new float[len];
            PT.parseFloatArrayData(sList1, list1);
        }
        if (isAll && tok != 1275069446) {
            float sum = 0.0f;
            if (isArray1) {
                int i = len;
                while (--i >= 0) {
                    sum += SV.fValue((T)alist1.get(i));
                }
            } else if (!isScalar1) {
                int i = len;
                while (--i >= 0) {
                    sum += list1[i];
                }
            }
            return mp.addXFloat(sum);
        }
        if (tok == 1275069446 && x2.tok == 4) {
            SB sb = new SB();
            if (isScalar1) {
                sb.append(SV.sValue(x1));
            } else {
                String s = isAll ? "" : x2.value.toString();
                for (int i = 0; i < len; ++i) {
                    sb.append(i > 0 ? s : "").append(SV.sValue((T)alist1.get(i)));
                }
            }
            return mp.addXStr(sb.toString());
        }
        SV scalar = null;
        if (isScalar2) {
            scalar = x2;
        } else if (x2.tok == 7) {
            len = Math.min(len, alist2.size());
        } else {
            sList2 = PT.split(SV.sValue(x2), "\n");
            list2 = new float[sList2.length];
            PT.parseFloatArrayData(sList2, list2);
            len = Math.min(len, list2.length);
        }
        T token = this.opTokenFor(tok);
        if (isArray1 && isAll) {
            Lst<SV> llist = new Lst<SV>();
            return mp.addXList(this.addAllLists(x1.getList(), llist));
        }
        SV a = isScalar1 ? x1 : null;
        boolean bl3 = justVal = len == Integer.MAX_VALUE;
        if (justVal) {
            len = 1;
        }
        SV[] olist = new SV[len];
        for (int i = 0; i < len; ++i) {
            SV b = isScalar2 ? scalar : (x2.tok == 7 ? (SV)alist2.get(i) : (Float.isNaN(list2[i]) ? SV.getVariable(SV.unescapePointOrBitsetAsVariable(sList2[i])) : SV.newF(list2[i])));
            if (!isScalar1) {
                a = isArray1 ? (SV)alist1.get(i) : (Float.isNaN(list1[i]) ? SV.getVariable(SV.unescapePointOrBitsetAsVariable(sList1[i])) : SV.newF(list1[i]));
            }
            if (tok == 1275069446 && a.tok != 7) {
                Lst<SV> l = new Lst<SV>();
                l.addLast(a);
                a = SV.getVariableList(l);
            }
            if (!mp.binaryOp(token, a, b)) {
                return false;
            }
            olist[i] = mp.getX();
        }
        return justVal ? mp.addXObj(olist[0]) : mp.addXAV(olist);
    }

    private Object listSpecial(int tok, SV x1, String tab, SV x2, boolean isArray1) {
        boolean isCSV;
        String[] sList1 = null;
        String[] sList2 = null;
        String[] sList3 = null;
        if (tok == 1275069441) {
            sList1 = isArray1 ? SV.strListValue(x1) : PT.split(SV.sValue(x1), "\n");
            sList2 = x2.tok == 7 ? SV.strListValue(x2) : PT.split(SV.sValue(x2), "\n");
            int len = Math.max(sList1.length, sList2.length);
            sList3 = new String[len];
            for (int i = 0; i < len; ++i) {
                sList3[i] = (i >= sList1.length ? "" : sList1[i]) + tab + (i >= sList2.length ? "" : sList2[i]);
            }
            return sList3;
        }
        if (x2.tok != 1073742335) {
            return null;
        }
        Lst<SV> l = x1.getList();
        boolean bl = isCSV = tab.length() == 0;
        if (isCSV) {
            tab = ",";
        }
        if (tok == 1275069446) {
            SV[] s2 = new SV[l.size()];
            int i = l.size();
            while (--i >= 0) {
                Lst<SV> a = ((SV)l.get(i)).getList();
                if (a == null) {
                    s2[i] = (SV)l.get(i);
                    continue;
                }
                SB sb = new SB();
                int n = a.size();
                for (int j = 0; j < n; ++j) {
                    if (j > 0) {
                        sb.append(tab);
                    }
                    SV sv = (SV)a.get(j);
                    String s = null;
                    if (sv.tok == 4) {
                        String st = (String)sv.value;
                        if (isCSV) {
                            s = "\"" + PT.rep(st, "\"", "\"\"") + "\"";
                        }
                    }
                    sb.append(s == null ? "" + sv.asString() : s);
                }
                s2[i] = SV.newS(sb.toString());
            }
            return s2;
        }
        Lst<SV> sa = new Lst<SV>();
        if (isCSV) {
            tab = "\u0000";
        }
        int[] next = new int[2];
        int nl = l.size();
        for (int i = 0; i < nl; ++i) {
            String line = ((SV)l.get(i)).asString();
            if (isCSV) {
                next[1] = 0;
                next[0] = 0;
                int last = 0;
                while (true) {
                    String s;
                    if ((s = PT.getCSVString(line, next)) == null) {
                        if (next[1] == -1) {
                            line = line + (++i < nl ? "\n" + ((SV)l.get(i)).asString() : "\"");
                            next[1] = last;
                            continue;
                        }
                        line = line.substring(0, last) + line.substring(last).replace(',', '\u0000');
                        break;
                    }
                    line = line.substring(0, last) + line.substring(last, next[0]).replace(',', '\u0000') + s + line.substring(next[1]);
                    next[1] = last = next[0] + s.length();
                }
            }
            String[] linaa = line.split(tab);
            Lst<SV> la = new Lst<SV>();
            for (String s : linaa) {
                if (s.indexOf(".") < 0) {
                    try {
                        la.addLast(SV.newI(Integer.parseInt(s)));
                        continue;
                    }
                    catch (Exception exception) {
                    }
                } else {
                    try {
                        la.addLast(SV.getVariable(Float.valueOf(Float.parseFloat(s))));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                la.addLast(SV.newS(s));
            }
            sa.addLast(SV.getVariableList(la));
        }
        return SV.getVariableList(sa);
    }

    private Lst<SV> addAllLists(Lst<SV> list, Lst<SV> l) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            SV v = (SV)list.get(i);
            if (v.tok == 7) {
                this.addAllLists(v.getList(), l);
                continue;
            }
            l.addLast(v);
        }
        return l;
    }

    private boolean evaluateLoad(ScriptMathProcessor mp, SV[] args, boolean isFile) throws ScriptException {
        boolean asJSON;
        if (!this.checkAccess()) {
            return false;
        }
        if (args.length < 1 || args.length > 3) {
            return false;
        }
        String file = FileManager.fixDOSName(SV.sValue(args[0]));
        boolean asMap = args.length > 1 && args[1].tok == 1073742335;
        boolean async = this.vwr.async || args.length > 2 && args[args.length - 1].tok == 1073742335;
        int nBytesMax = args.length > 1 && args[1].tok == 2 ? args[1].asInt() : -1;
        boolean bl = asJSON = args.length > 1 && args[1].asString().equalsIgnoreCase("JSON");
        if (asMap) {
            return mp.addXMap((Map)this.vwr.fm.getFileAsMap(file, null, false));
        }
        boolean isQues = file.startsWith("?");
        if (Viewer.isJS && (isQues || async)) {
            if (isFile && isQues) {
                return mp.addXStr("");
            }
            file = this.e.loadFileAsync("load()_", file, mp.oPt, true);
        }
        String str = isFile ? this.vwr.fm.getFilePath(file, false, false) : this.vwr.getFileAsString4(file, nBytesMax, false, false, true, "script");
        try {
            return asJSON ? mp.addXObj(this.vwr.parseJSON(str)) : mp.addXStr(str);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean evaluateMath(ScriptMathProcessor mp, SV[] args, int tok) {
        double x = SV.fValue(args[0]);
        switch (tok) {
            case 134218246: {
                x = Math.sqrt(x);
                break;
            }
            case 134218244: {
                x = Math.sin(x * Math.PI / 180.0);
                break;
            }
            case 134218245: {
                x = Math.cos(x * Math.PI / 180.0);
                break;
            }
            case 134218241: {
                x = Math.acos(x) * 180.0 / Math.PI;
            }
        }
        return mp.addXFloat((float)x);
    }

    private boolean evaluateMeasure(ScriptMathProcessor mp, SV[] args, int tok) throws ScriptException {
        int nPoints = 0;
        switch (tok) {
            case 1745489939: {
                String property = null;
                Lst<Object> points = new Lst<Object>();
                float[] rangeMinMax = new float[]{Float.MAX_VALUE, Float.MAX_VALUE};
                String strFormat = null;
                String units = null;
                boolean isAllConnected = false;
                boolean isNotConnected = false;
                int rPt = 0;
                boolean isNull = false;
                RadiusData rd = null;
                int nBitSets = 0;
                float vdw = Float.MAX_VALUE;
                boolean asMinArray = false;
                boolean asFloatArray = false;
                block15: for (int i = 0; i < args.length; ++i) {
                    switch (args[i].tok) {
                        case 10: {
                            BS bs = (BS)args[i].value;
                            if (bs.length() == 0) {
                                isNull = true;
                            }
                            points.addLast(bs);
                            ++nPoints;
                            ++nBitSets;
                            continue block15;
                        }
                        case 8: {
                            Point3fi v = new Point3fi();
                            v.setT((P3)args[i].value);
                            points.addLast(v);
                            ++nPoints;
                            continue block15;
                        }
                        case 2: 
                        case 3: {
                            rangeMinMax[rPt++ % 2] = SV.fValue(args[i]);
                            continue block15;
                        }
                        case 4: {
                            String s = SV.sValue(args[i]);
                            if (s.startsWith("property_")) {
                                property = s;
                                continue block15;
                            }
                            if (s.equalsIgnoreCase("vdw") || s.equalsIgnoreCase("vanderwaals")) {
                                vdw = (float)(i + 1 < args.length && args[i + 1].tok == 2 ? args[++i].asInt() : 100) / 100.0f;
                                continue block15;
                            }
                            if (s.equalsIgnoreCase("notConnected")) {
                                isNotConnected = true;
                                continue block15;
                            }
                            if (s.equalsIgnoreCase("connected")) {
                                isAllConnected = true;
                                continue block15;
                            }
                            if (s.equalsIgnoreCase("minArray")) {
                                asMinArray = nBitSets >= 1;
                                continue block15;
                            }
                            if (s.equalsIgnoreCase("asArray") || s.length() == 0) {
                                asFloatArray = nBitSets >= 1;
                                continue block15;
                            }
                            if (Measurement.isUnits(s)) {
                                units = s.toLowerCase();
                                continue block15;
                            }
                            strFormat = nPoints + ":" + s;
                            continue block15;
                        }
                        default: {
                            return false;
                        }
                    }
                }
                if (nPoints < 2 || nPoints > 4 || rPt > 2 || isNotConnected && isAllConnected) {
                    return false;
                }
                if (isNull) {
                    return mp.addXStr("");
                }
                if (vdw != Float.MAX_VALUE && (nBitSets != 2 || nPoints != 2)) {
                    return mp.addXStr("");
                }
                rd = vdw == Float.MAX_VALUE ? new RadiusData(rangeMinMax, 0.0f, null, null) : new RadiusData(null, vdw, RadiusData.EnumType.FACTOR, VDW.AUTO);
                Object obj = this.vwr.newMeasurementData(null, points).set(0, null, rd, property, strFormat, units, null, isAllConnected, isNotConnected, null, true, 0, (short)0, null, Float.NaN, null).getMeasurements(asFloatArray, asMinArray);
                return mp.addXObj(obj);
            }
            case 0x8000001: {
                nPoints = args.length;
                if (nPoints == 3 || nPoints == 4) break;
                return false;
            }
            default: {
                nPoints = args.length;
                if (nPoints == 2) break;
                return false;
            }
        }
        P3[] pts = new P3[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            pts[i] = mp.ptValue(args[i], null);
            if (pts[i] != null) continue;
            return false;
        }
        switch (nPoints) {
            case 2: {
                return mp.addXFloat(pts[0].distance(pts[1]));
            }
            case 3: {
                return mp.addXFloat(Measure.computeAngleABC(pts[0], pts[1], pts[2], true));
            }
            case 4: {
                return mp.addXFloat(Measure.computeTorsion(pts[0], pts[1], pts[2], pts[3], true));
            }
        }
        return false;
    }

    private boolean evaluateModulation(ScriptMathProcessor mp, SV[] args) throws ScriptException {
        String type = "";
        float t = Float.NaN;
        P3 t456 = null;
        block0 : switch (args.length) {
            case 0: {
                break;
            }
            case 1: {
                switch (args[0].tok) {
                    case 8: {
                        t456 = (P3)args[0].value;
                        break block0;
                    }
                    case 4: {
                        type = args[0].asString();
                        break block0;
                    }
                }
                t = SV.fValue(args[0]);
                break;
            }
            case 2: {
                type = SV.sValue(args[0]);
                t = SV.fValue(args[1]);
                break;
            }
            default: {
                return false;
            }
        }
        if (t456 == null && (double)t < 1000000.0) {
            t456 = P3.new3(t, t, t);
        }
        SV x = mp.getX();
        BS bs = x.tok == 10 ? (BS)x.value : new BS();
        return mp.addXList(this.vwr.ms.getModulationList(bs, (type + "D").toUpperCase().charAt(0), t456));
    }

    private boolean evaluatePlane(ScriptMathProcessor mp, SV[] args, int tok, boolean isSelector) throws ScriptException {
        P4 plane;
        block45: {
            if (tok == 0x8000801 && args.length != 3 && args.length != 4 || tok == 134217763 && args.length != 2 && args.length != 3 && args.length != 4 || args.length == 0 || args.length > 4) {
                return false;
            }
            plane = this.e.planeValue(args[0]);
            switch (args.length) {
                case 1: {
                    if (tok == 134217750) {
                        if (args[0].tok != 7) {
                            return false;
                        }
                        float[] uvw = SV.flistValue(args[0], 3);
                        if (uvw.length != 3) {
                            return false;
                        }
                        SymmetryInterface sym = this.vwr.getOperativeSymmetry();
                        if (sym == null) {
                            return false;
                        }
                        P3 ptuvw = P3.new3(uvw[0], uvw[1], uvw[2]);
                        sym.toCartesian(ptuvw, false);
                        plane = P4.new4(ptuvw.x, ptuvw.y, ptuvw.z, 0.0f);
                        if (isSelector) break;
                    }
                    return plane != null && mp.addXPt4(plane);
                }
                case 2: {
                    if (tok == 134217763) {
                        P4 plane1 = this.e.planeValue(args[1]);
                        if (plane1 == null) {
                            return false;
                        }
                        P3 pt3 = new P3();
                        V3 norm = new V3();
                        V3 vTemp = new V3();
                        if (plane != null) {
                            Lst<Object> list = Measure.getIntersectionPP(plane, plane1);
                            if (list == null) {
                                return mp.addXStr("");
                            }
                            return mp.addXList(list);
                        }
                        P3 pt2 = mp.ptValue(args[0], null);
                        if (pt2 == null) {
                            return mp.addXStr("");
                        }
                        return mp.addXPt(Measure.getIntersection(pt2, null, plane1, pt3, norm, vTemp));
                    }
                }
                case 3: 
                case 4: {
                    switch (tok) {
                        case 0x8000801: {
                            float offset = args.length == 4 ? SV.fValue(args[3]) : Float.NaN;
                            plane = this.e.getHklPlane(P3.new3(SV.fValue(args[0]), SV.fValue(args[1]), SV.fValue(args[2])), offset, null);
                            if (isSelector) break;
                            return plane != null && mp.addXPt4(plane);
                        }
                        case 134217763: {
                            P3 pt1 = mp.ptValue(args[0], null);
                            P3 pt2 = mp.ptValue(args[1], null);
                            if (pt1 == null || pt2 == null) {
                                return mp.addXStr("");
                            }
                            V3 vLine = V3.newV(pt2);
                            vLine.normalize();
                            P4 plane2 = this.e.planeValue(args[2]);
                            if (plane2 != null) {
                                P3 pt3 = new P3();
                                V3 norm = new V3();
                                V3 vTemp = new V3();
                                if ((pt1 = Measure.getIntersection(pt1, vLine, plane2, pt3, norm, vTemp)) == null) {
                                    return mp.addXStr("");
                                }
                                return mp.addXPt(pt1);
                            }
                            P3 pt3 = mp.ptValue(args[2], null);
                            if (pt3 == null) {
                                return mp.addXStr("");
                            }
                            V3 v = new V3();
                            pt3 = P3.newP(pt3);
                            if (args.length == 3) {
                                Measure.projectOntoAxis(pt3, pt1, vLine, v);
                                return mp.addXPt(pt3);
                            }
                            float r = SV.fValue(args[3]);
                            P3 ptCenter = P3.newP(pt3);
                            Measure.projectOntoAxis(pt3, pt1, vLine, v);
                            float d = ptCenter.distance(pt3);
                            Lst<P3> l = new Lst<P3>();
                            if (d == r) {
                                l.addLast(pt3);
                            } else if (d < r) {
                                d = (float)Math.sqrt(r * r - d * d);
                                v.scaleAdd2(d, vLine, pt3);
                                l.addLast(P3.newP(v));
                                v.scaleAdd2(-d, vLine, pt3);
                                l.addLast(P3.newP(v));
                            }
                            return mp.addXList(l);
                        }
                    }
                    switch (args[0].tok) {
                        case 2: 
                        case 3: {
                            if (args.length == 3) {
                                float r = SV.fValue(args[0]);
                                float theta = SV.fValue(args[1]);
                                float phi = SV.fValue(args[2]);
                                V3 norm = V3.new3(0.0f, 0.0f, 1.0f);
                                P3 pt2 = P3.new3(0.0f, 1.0f, 0.0f);
                                Quat q = Quat.newVA(pt2, phi);
                                q.getMatrix().rotate(norm);
                                pt2.set(0.0f, 0.0f, 1.0f);
                                q = Quat.newVA(pt2, theta);
                                q.getMatrix().rotate(norm);
                                pt2.setT(norm);
                                pt2.scale(r);
                                plane = new P4();
                                Measure.getPlaneThroughPoint(pt2, norm, plane);
                                return mp.addXPt4(plane);
                            }
                            break block45;
                        }
                        case 8: 
                        case 10: {
                            P3 pt1 = mp.ptValue(args[0], null);
                            P3 pt2 = mp.ptValue(args[1], null);
                            if (pt2 == null) {
                                return false;
                            }
                            P3 pt3 = args.length > 2 && (args[2].tok == 10 || args[2].tok == 8) ? mp.ptValue(args[2], null) : null;
                            V3 norm = V3.newV(pt2);
                            if (pt3 == null) {
                                plane = new P4();
                                if (args.length == 2 || args[2].tok != 2 && args[2].tok != 3 && !args[2].asBoolean()) {
                                    pt3 = P3.newP(pt1);
                                    pt3.add(pt2);
                                    pt3.scale(0.5f);
                                    norm.sub(pt1);
                                    norm.normalize();
                                } else if (args[2].tok == 1073742335) {
                                    pt3 = pt1;
                                } else {
                                    norm.sub(pt1);
                                    pt3 = new P3();
                                    pt3.scaleAdd2(args[2].asFloat(), norm, pt1);
                                }
                                Measure.getPlaneThroughPoint(pt3, norm, plane);
                                return mp.addXPt4(plane);
                            }
                            V3 vAB = new V3();
                            P3 ptref = args.length == 4 ? mp.ptValue(args[3], null) : null;
                            float nd = Measure.getDirectedNormalThroughPoints(pt1, pt2, pt3, ptref, norm, vAB);
                            return mp.addXPt4(P4.new4(norm.x, norm.y, norm.z, nd));
                        }
                    }
                }
            }
        }
        if (isSelector) {
            SV x1 = mp.getX();
            switch (x1.tok) {
                case 10: {
                    Lst<SV> list = new Lst<SV>();
                    BS bsAtoms = SV.getBitSet(x1, false);
                    int i = bsAtoms.nextSetBit(0);
                    while (i >= 0) {
                        P3 p = new P3();
                        Measure.getPlaneProjection(this.vwr.ms.at[i], plane, p, new V3());
                        list.addLast(SV.getVariable(p));
                        i = bsAtoms.nextSetBit(i + 1);
                    }
                    return mp.addXList(list);
                }
                case 8: {
                    P3 pt = SV.ptValue(x1);
                    P3 p = new P3();
                    Measure.getPlaneProjection(pt, plane, p, new V3());
                    return mp.addXPt(p);
                }
            }
        }
        if (args.length != 4) {
            return false;
        }
        float x = SV.fValue(args[0]);
        float y = SV.fValue(args[1]);
        float z = SV.fValue(args[2]);
        float w = SV.fValue(args[3]);
        return mp.addXPt4(P4.new4(x, y, z, w));
    }

    private boolean evaluatePoint(ScriptMathProcessor mp, SV[] args) {
        String s = null;
        switch (args.length) {
            default: {
                return false;
            }
            case 1: {
                Object pt;
                switch (args[0].tok) {
                    case 2: 
                    case 3: {
                        return mp.addXInt(args[0].asInt());
                    }
                    case 4: {
                        s = (String)args[0].value;
                        if (!s.startsWith("(") || s.charAt(s.length() - 1) != ')') break;
                        return mp.addXPt(this.getRealPointFromFraction(s));
                    }
                    case 7: {
                        Lst<SV> list = args[0].getList();
                        int len = list.size();
                        if (len == 0) {
                            return false;
                        }
                        switch (((SV)list.get((int)0)).tok) {
                            case 2: 
                            case 3: {
                                break;
                            }
                            case 7: {
                                Lst<SV> ar = new Lst<SV>();
                                for (int i = 0; i < len; ++i) {
                                    ar.addLast(SV.getVariable(Escape.uP("{" + ((SV)list.get(i)).asString() + "}")));
                                }
                                return mp.addXList(ar);
                            }
                            case 4: {
                                s = (String)((SV)list.get((int)0)).value;
                                if (!s.startsWith("{") || Escape.uP(s) instanceof String) {
                                    s = null;
                                    break;
                                }
                                Lst<SV> a = new Lst<SV>();
                                for (int i = 0; i < len; ++i) {
                                    a.addLast(SV.getVariable(Escape.uP(SV.sValue((T)list.get(i)))));
                                }
                                return mp.addXList(a);
                            }
                            default: {
                                return false;
                            }
                        }
                        s = "{" + s + "}";
                    }
                }
                if (s == null) {
                    s = SV.sValue(args[0]);
                }
                return (pt = Escape.uP(s)) instanceof P3 ? mp.addXPt((P3)pt) : mp.addXStr("" + pt);
            }
            case 2: {
                P3 pt3;
                switch (args[1].tok) {
                    case 1073742334: 
                    case 1073742335: {
                        switch (args[0].tok) {
                            case 8: {
                                pt3 = P3.newP((T3)args[0].value);
                                break;
                            }
                            case 10: {
                                pt3 = this.vwr.ms.getAtomSetCenter((BS)args[0].value);
                                break;
                            }
                            default: {
                                return false;
                            }
                        }
                        if (args[1].tok == 1073742335) {
                            this.vwr.tm.transformPt3f(pt3, pt3);
                            pt3.y = (float)this.vwr.tm.height - pt3.y;
                            if (!this.vwr.antialiased) break;
                            pt3.scale(0.5f);
                            break;
                        }
                        if (this.vwr.antialiased) {
                            pt3.scale(2.0f);
                        }
                        pt3.y = (float)this.vwr.tm.height - pt3.y;
                        this.vwr.tm.unTransformPoint(pt3, pt3);
                        break;
                    }
                    case 8: {
                        Lst<SV> sv = args[0].getList();
                        if (sv == null || sv.size() != 4) {
                            return false;
                        }
                        P3 pt1 = SV.ptValue(args[1]);
                        pt3 = P3.newP(SV.ptValue((SV)sv.get(0)));
                        pt3.scaleAdd2(pt1.x, SV.ptValue((SV)sv.get(1)), pt3);
                        pt3.scaleAdd2(pt1.y, SV.ptValue((SV)sv.get(2)), pt3);
                        pt3.scaleAdd2(pt1.z, SV.ptValue((SV)sv.get(3)), pt3);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return mp.addXPt(pt3);
            }
            case 3: {
                return mp.addXPt(P3.new3(args[0].asFloat(), args[1].asFloat(), args[2].asFloat()));
            }
            case 4: 
        }
        return mp.addXPt4(P4.new4(args[0].asFloat(), args[1].asFloat(), args[2].asFloat(), args[3].asFloat()));
    }

    private P3 getRealPointFromFraction(String s) {
        String[] xyz = PT.split((s = PT.rep(s.substring(1, s.length() - 1).replace(',', ' '), "  ", " ")).trim(), " ");
        if (xyz.length != 3) {
            return null;
        }
        P3 pt = P3.new3(SimpleUnitCell.parseCalc(this.vwr, null, xyz[0]), SimpleUnitCell.parseCalc(this.vwr, null, xyz[1]), SimpleUnitCell.parseCalc(this.vwr, null, xyz[2]));
        return pt;
    }

    private boolean evaluatePrompt(ScriptMathProcessor mp, SV[] args) {
        boolean asButtons;
        if (args.length != 1 && args.length != 2 && args.length != 3) {
            return false;
        }
        String label = SV.sValue(args[0]);
        String[] buttonArray = args.length > 1 && args[1].tok == 7 ? SV.strListValue(args[1]) : null;
        boolean bl = asButtons = buttonArray != null || args.length == 1 || args.length == 3 && args[2].asBoolean();
        String input = buttonArray != null ? null : (args.length >= 2 ? SV.sValue(args[1]) : "OK");
        String s = "" + this.vwr.prompt(label, input, buttonArray, asButtons);
        return asButtons && buttonArray != null ? mp.addXInt(Integer.parseInt(s) + 1) : mp.addXStr(s);
    }

    private boolean evaluateQuaternion(ScriptMathProcessor mp, SV[] args, int tok) throws ScriptException {
        P3 pt0 = null;
        int nArgs = args.length;
        int nMax = Integer.MAX_VALUE;
        boolean isRelative = false;
        if (tok == 134221850) {
            if (nArgs > 1 && args[nArgs - 1].tok == 4 && ((String)args[nArgs - 1].value).equalsIgnoreCase("relative")) {
                --nArgs;
                isRelative = true;
            }
            if (nArgs > 1 && args[nArgs - 1].tok == 2 && args[0].tok == 10) {
                nMax = args[nArgs - 1].asInt();
                if (nMax <= 0) {
                    nMax = 0x7FFFFFFE;
                }
                --nArgs;
            }
        }
        switch (nArgs) {
            case 0: 
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                if (tok == 134221850 && (args[0].tok == 7 && (args[1].tok == 7 || args[1].tok == 1073742335) || args[0].tok == 10 && (args[1].tok == 2 || args[1].tok == 10)) || (pt0 = mp.ptValue(args[0], null)) != null && (tok == 134221850 || args[1].tok != 8)) break;
                return false;
            }
            case 3: {
                if (tok != 134221850) {
                    return false;
                }
                if (args[0].tok == 9) {
                    if (args[2].tok == 8 || args[2].tok == 10) break;
                    return false;
                }
                for (int i = 0; i < 3; ++i) {
                    if (args[i].tok == 8 || args[i].tok == 10) continue;
                    return false;
                }
                break;
            }
            default: {
                return false;
            }
        }
        Quat q = null;
        Quat[] qs = null;
        P4 p4 = null;
        switch (nArgs) {
            case 0: {
                return mp.addXPt4(this.vwr.tm.getRotationQ().toPoint4f());
            }
            default: {
                Quat[] data1;
                if (tok == 134221850 && args[0].tok == 7) {
                    data1 = this.e.getQuaternionArray(args[0].getList(), 1073742001);
                    Quat mean = Quat.sphereMean(data1, null, 1.0E-4f);
                    q = mean instanceof Quat ? mean : null;
                    break;
                }
                if (tok == 134221850 && args[0].tok == 10) {
                    qs = this.vwr.getAtomGroupQuaternions((BS)args[0].value, nMax);
                } else if (args[0].tok == 11) {
                    q = Quat.newM((M3)args[0].value);
                } else if (args[0].tok == 9) {
                    p4 = (P4)args[0].value;
                } else {
                    String s = SV.sValue(args[0]);
                    Object v = Escape.uP(s.equalsIgnoreCase("best") ? this.vwr.getOrientation(1073741864, "best", null, null).toString() : s);
                    if (!(v instanceof P4)) {
                        return false;
                    }
                    p4 = (P4)v;
                }
                if (tok != 0x8000003) break;
                q = Quat.newVA(P3.new3(p4.x, p4.y, p4.z), p4.w);
                break;
            }
            case 2: {
                Quat[] data1;
                if (tok == 134221850) {
                    Quat[] data2;
                    if (args[0].tok == 7 && args[1].tok == 7) {
                        data1 = this.e.getQuaternionArray(args[0].getList(), 1073742001);
                        data2 = this.e.getQuaternionArray(args[1].getList(), 1073742001);
                        qs = Quat.arrayDiv(data2, data1, nMax, isRelative);
                        break;
                    }
                    if (args[0].tok == 7 && args[1].tok == 1073742335) {
                        Quat[] data12 = this.e.getQuaternionArray(args[0].getList(), 1073742001);
                        float[] stddev = new float[1];
                        Quat.sphereMean(data12, stddev, 1.0E-4f);
                        return mp.addXFloat(stddev[0]);
                    }
                    if (args[0].tok == 10 && args[1].tok == 10) {
                        data1 = this.vwr.getAtomGroupQuaternions((BS)args[0].value, Integer.MAX_VALUE);
                        data2 = this.vwr.getAtomGroupQuaternions((BS)args[1].value, Integer.MAX_VALUE);
                        qs = Quat.arrayDiv(data2, data1, nMax, isRelative);
                        break;
                    }
                }
                P3 pt1 = mp.ptValue(args[1], null);
                p4 = this.e.planeValue(args[0]);
                if (pt1 != null) {
                    q = Quat.getQuaternionFrame(P3.new3(0.0f, 0.0f, 0.0f), pt0, pt1);
                    break;
                }
                q = Quat.newVA(pt0, SV.fValue(args[1]));
                break;
            }
            case 3: {
                if (args[0].tok == 9) {
                    P3 pt = args[2].tok == 8 ? (P3)args[2].value : this.vwr.ms.getAtomSetCenter((BS)args[2].value);
                    return mp.addXStr(Escape.drawQuat(Quat.newP4((P4)args[0].value), "q", SV.sValue(args[1]), pt, 1.0f));
                }
                P3[] pts = new P3[3];
                for (int i = 0; i < 3; ++i) {
                    pts[i] = args[i].tok == 8 ? (P3)args[i].value : this.vwr.ms.getAtomSetCenter((BS)args[i].value);
                }
                q = Quat.getQuaternionFrame(pts[0], pts[1], pts[2]);
                break;
            }
            case 4: {
                if (tok == 134221850) {
                    p4 = P4.new4(SV.fValue(args[1]), SV.fValue(args[2]), SV.fValue(args[3]), SV.fValue(args[0]));
                    break;
                }
                q = Quat.newVA(P3.new3(SV.fValue(args[0]), SV.fValue(args[1]), SV.fValue(args[2])), SV.fValue(args[3]));
            }
        }
        if (qs != null) {
            if (nMax != Integer.MAX_VALUE) {
                Lst<P4> list = new Lst<P4>();
                for (int i = 0; i < qs.length; ++i) {
                    list.addLast(qs[i].toPoint4f());
                }
                return mp.addXList(list);
            }
            q = qs.length > 0 ? qs[0] : null;
        }
        return mp.addXPt4((q == null ? Quat.newP4(p4) : q).toPoint4f());
    }

    private boolean evaluateRandom(ScriptMathProcessor mp, SV[] args) {
        if (args.length > 3) {
            return false;
        }
        if (this.rand == null) {
            this.rand = new Random();
        }
        float lower = 0.0f;
        float upper = 1.0f;
        switch (args.length) {
            case 3: {
                this.rand.setSeed((int)SV.fValue(args[2]));
            }
            case 2: {
                upper = SV.fValue(args[1]);
            }
            case 1: {
                lower = SV.fValue(args[0]);
            }
            case 0: {
                break;
            }
            default: {
                return false;
            }
        }
        return mp.addXFloat(this.rand.nextFloat() * (upper - lower) + lower);
    }

    private boolean evaluateRowCol(ScriptMathProcessor mp, SV[] args, int tok) throws ScriptException {
        if (args.length != 1) {
            return false;
        }
        int n = args[0].asInt() - 1;
        SV x1 = mp.getX();
        switch (x1.tok) {
            case 11: {
                if (n < 0 || n > 2) {
                    return false;
                }
                M3 m = (M3)x1.value;
                switch (tok) {
                    case 1275068935: {
                        float[] f = new float[3];
                        m.getRow(n, f);
                        return mp.addXAF(f);
                    }
                }
                float[] f = new float[3];
                m.getColumn(n, f);
                return mp.addXAF(f);
            }
            case 12: {
                if (n < 0 || n > 2) {
                    return false;
                }
                M4 m4 = (M4)x1.value;
                switch (tok) {
                    case 1275068935: {
                        float[] f = new float[4];
                        m4.getRow(n, f);
                        return mp.addXAF(f);
                    }
                }
                float[] f = new float[4];
                m4.getColumn(n, f);
                return mp.addXAF(f);
            }
            case 7: {
                Lst<SV> l1 = x1.getList();
                Lst<SV> l2 = new Lst<SV>();
                int len = l1.size();
                for (int i = 0; i < len; ++i) {
                    Lst<SV> l3 = ((SV)l1.get(i)).getList();
                    if (l3 == null) {
                        return mp.addXStr("");
                    }
                    l2.addLast(n < l3.size() ? (SV)l3.get(n) : SV.newS(""));
                }
                return mp.addXList(l2);
            }
        }
        return false;
    }

    private boolean evaluateIn(ScriptMathProcessor mp, SV[] args) throws ScriptException {
        SV x1 = mp.getX();
        switch (args.length) {
            case 1: {
                Lst<SV> lst = args[0].getList();
                if (lst == null) break;
                int n = lst.size();
                for (int i = 0; i < n; ++i) {
                    if (!SV.areEqual(x1, (SV)lst.get(i))) continue;
                    return mp.addXInt(i + 1);
                }
                break;
            }
            default: {
                for (int i = 0; i < args.length; ++i) {
                    if (!SV.areEqual(x1, args[i])) continue;
                    return mp.addXInt(i + 1);
                }
            }
        }
        return mp.addXInt(0);
    }

    private boolean evaluateReplace(ScriptMathProcessor mp, SV[] args) throws ScriptException {
        String sFind;
        String sReplace;
        boolean isAll = false;
        switch (args.length) {
            case 0: {
                isAll = true;
                sReplace = null;
                sFind = null;
                break;
            }
            case 3: {
                isAll = SV.bValue(args[2]);
            }
            case 2: {
                sFind = SV.sValue(args[0]);
                sReplace = SV.sValue(args[1]);
                break;
            }
            default: {
                return false;
            }
        }
        SV x = mp.getX();
        if (x.tok == 7) {
            String[] list = SV.strListValue(x);
            String[] l = new String[list.length];
            int i = list.length;
            while (--i >= 0) {
                l[i] = sFind == null ? PT.clean(list[i]) : (isAll ? PT.replaceAllCharacters(list[i], sFind, sReplace) : PT.rep(list[i], sFind, sReplace));
            }
            return mp.addXAS(l);
        }
        String s = SV.sValue(x);
        return mp.addXStr(sFind == null ? PT.clean(s) : (isAll ? PT.replaceAllCharacters(s, sFind, sReplace) : PT.rep(s, sFind, sReplace)));
    }

    private boolean evaluateScript(ScriptMathProcessor mp, SV[] args, int tok) throws ScriptException {
        if (tok != 134222350 && !this.checkAccess()) {
            return false;
        }
        if (args.length == 0 || args.length != 1 && (tok == 134222350 || tok == 134238732)) {
            return false;
        }
        if ((tok == 134222350 || tok == 134238732) && args.length != 1 || args.length == 0) {
            return false;
        }
        String s = SV.sValue(args[0]);
        SB sb = new SB();
        switch (tok) {
            case 134218759: {
                return args.length == 2 ? s.equalsIgnoreCase("JSON") && mp.addXObj(this.vwr.parseJSON(SV.sValue(args[1]))) : mp.addXObj(this.vwr.evaluateExpressionAsVariable(s));
            }
            case 134222850: {
                String appID;
                String string = appID = args.length == 2 ? SV.sValue(args[1]) : ".";
                if (!appID.equals(".")) {
                    sb.append(this.vwr.jsEval(appID + "\u0001" + s));
                }
                if (!appID.equals(".") && !appID.equals("*")) break;
                this.e.runScriptBuffer(s, sb, true);
                break;
            }
            case 134222350: {
                this.e.runScriptBuffer("show " + s, sb, true);
                break;
            }
            case 134238732: {
                return mp.addX(this.vwr.jsEvalSV(s));
            }
        }
        s = sb.toString();
        float f = PT.parseFloatStrict(s);
        return Float.isNaN(f) ? mp.addXStr(s) : (s.indexOf(".") >= 0 ? mp.addXFloat(f) : mp.addXInt(PT.parseInt(s)));
    }

    private boolean checkAccess() {
        return !this.vwr.haveAccessInternal(null);
    }

    private boolean evaluateSort(ScriptMathProcessor mp, SV[] args, int tok) throws ScriptException {
        SV match;
        if (args.length > 1) {
            return false;
        }
        if (tok == 1275068444) {
            if (args.length == 1 && args[0].tok == 4) {
                return mp.addX(mp.getX().sortMapArray(args[0].asString()));
            }
            int n = args.length == 0 ? 0 : args[0].asInt();
            return mp.addX(mp.getX().sortOrReverse(n));
        }
        SV x = mp.getX();
        SV sV = match = args.length == 0 ? null : args[0];
        if (x.tok == 4) {
            int pt;
            int n = 0;
            String s = SV.sValue(x);
            if (match == null) {
                return mp.addXInt(0);
            }
            String m = SV.sValue(match);
            for (int i = 0; i < s.length() && (pt = s.indexOf(m, i)) >= 0; ++i) {
                ++n;
                i = pt;
            }
            return mp.addXInt(n);
        }
        Lst<SV> counts = new Lst<SV>();
        SV last = null;
        SV count = null;
        Lst<SV> xList = SV.getVariable(x.value).sortOrReverse(0).getList();
        if (xList == null) {
            return match == null ? mp.addXStr("") : mp.addXInt(0);
        }
        int nLast = xList.size();
        for (int i = 0; i <= nLast; ++i) {
            SV a;
            SV sV2 = a = i == nLast ? null : (SV)xList.get(i);
            if (match != null && a != null && !SV.areEqual(a, match)) continue;
            if (SV.areEqual(a, last)) {
                ++count.intValue;
                continue;
            }
            if (last != null) {
                Lst<SV> y = new Lst<SV>();
                y.addLast(last);
                y.addLast(count);
                counts.addLast(SV.getVariableList(y));
            }
            count = SV.newI(1);
            last = a;
        }
        if (match == null) {
            return mp.addX(SV.getVariableList(counts));
        }
        if (counts.isEmpty()) {
            return mp.addXInt(0);
        }
        return mp.addX((SV)((SV)counts.get(0)).getList().get(1));
    }

    private boolean evaluateString(ScriptMathProcessor mp, int tok, SV[] args) throws ScriptException {
        SV x = mp.getX();
        String sArg = args.length > 0 ? SV.sValue(args[0]) : (tok == 1275068932 ? "" : "\n");
        switch (args.length) {
            case 0: {
                break;
            }
            case 1: {
                if (args[0].tok != 1073742335) break;
                return mp.addX(SV.getVariable(PT.getTokens(x.asString())));
            }
            case 2: {
                if (x.tok == 7) break;
                if (tok == 1275069447) {
                    x = SV.getVariable(PT.split(PT.rep((String)x.value, "\n\r", "\n").replace('\r', '\n'), "\n"));
                    break;
                }
            }
            default: {
                return false;
            }
        }
        if (x.tok == 7 && tok != 1275068932 && (tok != 1275069447 || args.length == 2)) {
            mp.addX(x);
            return this.evaluateList(mp, tok, args);
        }
        String s = tok == 1275069447 && x.tok == 10 || tok == 1275068932 && x.tok == 7 ? null : SV.sValue(x);
        switch (tok) {
            case 1275069447: {
                if (x.tok == 10) {
                    BS bsSelected = (BS)x.value;
                    int modelCount = this.vwr.ms.mc;
                    Lst<SV> lst = new Lst<SV>();
                    for (int i = 0; i < modelCount; ++i) {
                        BS bs = this.vwr.getModelUndeletedAtomsBitSet(i);
                        bs.and(bsSelected);
                        lst.addLast(SV.getVariable(bs));
                    }
                    return mp.addXList(lst);
                }
                return mp.addXAS(PT.split(s, sArg));
            }
            case 1275069446: {
                if (s.length() > 0 && s.charAt(s.length() - 1) == '\n') {
                    s = s.substring(0, s.length() - 1);
                }
                return mp.addXStr(PT.rep(s, "\n", sArg));
            }
            case 1275068932: {
                if (s != null) {
                    return mp.addXStr(PT.trim(s, sArg));
                }
                String[] list = SV.strListValue(x);
                int i = list.length;
                while (--i >= 0) {
                    list[i] = PT.trim(list[i], sArg);
                }
                return mp.addXAS(list);
            }
        }
        return mp.addXStr("");
    }

    private boolean evaluateSubstructure(ScriptMathProcessor mp, SV[] args, int tok, boolean isSelector) throws ScriptException {
        Object objPattern;
        boolean compileSearch;
        Object objTarget;
        boolean isSelectedSmiles;
        SV x = isSelector ? mp.getX() : null;
        String sx = null;
        BS bsSelected = null;
        if (x != null) {
            switch (x.tok) {
                case 10: {
                    bsSelected = (BS)x.value;
                    break;
                }
                case 4: {
                    sx = (String)x.value;
                    if (!sx.startsWith("InChI")) break;
                    mp.addX(x);
                    return this.evaluateInChI(mp, new SV[]{SV.newS("SMILES " + (args.length > 0 ? args[0].asString() : (sx.indexOf("/f") >= 0 ? "fixedh" : "amide")))});
                }
            }
        }
        boolean bl = isSelectedSmiles = isSelector && tok == 134218757;
        if (isSelectedSmiles) {
            return mp.addXObj(this.e.getSmilesExt().getSmilesMatches("", null, bsSelected, null, 1, true, false));
        }
        if (args.length == 0 || isSelector && (tok == 134218753 || args.length > 1)) {
            return false;
        }
        Object object = objTarget = tok == 0x8000404 && !isSelector && args[0].tok == 0x8000404 ? args[0].value : null;
        if (objTarget != null && args.length < 2) {
            return false;
        }
        boolean bl2 = compileSearch = tok == 0x8000404 && !isSelector && args[0].tok == 10;
        Object object2 = args[0].tok == 134218753 ? args[0].value : (objPattern = objTarget != null && args[1].tok == 134218753 ? args[1].value : null);
        if (objTarget != null && objPattern == null) {
            return false;
        }
        String pattern = compileSearch ? null : (objPattern == null ? SV.sValue(args[0]) : null);
        BS bs = new BS();
        if (pattern == null || pattern.length() > 0) {
            try {
                if (compileSearch) {
                    return mp.addX(SV.newV(0x8000404, this.vwr.getSmilesMatcher().compileSearchTarget(this.vwr.ms.at, this.vwr.ms.ac, SV.getBitSet(args[0], false))));
                }
                if (objTarget != null) {
                    return mp.addXBs(this.vwr.getSmilesMatcher().getSubstructureSet(objPattern, objTarget, 0, null, 2));
                }
                if (tok == 134218753) {
                    return mp.addX(SV.newV(134218753, this.vwr.getSmilesMatcher().compileSmartsPattern(pattern)));
                }
                if (bsSelected == null) {
                    bsSelected = args.length == 2 && args[1].tok == 10 ? (BS)args[1].value : this.vwr.getModelUndeletedAtomsBitSet(-1);
                }
                bs = this.vwr.getSmilesMatcher().getSubstructureSet(objPattern == null ? pattern : objPattern, this.vwr.ms.at, this.vwr.ms.ac, bsSelected, tok == 134218757 ? 1 : 2);
            }
            catch (Exception ex) {
                this.e.evalError(ex.getMessage(), null);
            }
        }
        return tok != 134218753 && mp.addXBs(bs);
    }

    private boolean evaluateSymop(ScriptMathProcessor mp, SV[] args, boolean isProperty) throws ScriptException {
        if (!isProperty && args.length == 2 && args[0].tok == 7 && args[1].tok == 4) {
            Lst<Object> ret = new Lst<Object>();
            Lst list = (Lst)args[0].value;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Object o = this.getSymopInfo(mp, null, new SV[]{(SV)list.get(i), args[1]}, i + 1, false);
                if (o == null) {
                    return false;
                }
                ret.addLast(o);
            }
            return mp.addXList(ret);
        }
        SV x1 = isProperty ? mp.getX() : null;
        Object o = this.getSymopInfo(mp, x1, args, 0, isProperty);
        return mp.addXObj(o);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getSymopInfo(ScriptMathProcessor mp, SV x1, SV[] args, int index, boolean isProperty) throws ScriptException {
        int iatom;
        String desc;
        int nth;
        P3 pt1;
        Object o = null;
        int narg = args.length;
        String str1 = narg == 2 && args[1].tok == 4 ? ((String)args[1].value).toLowerCase() : null;
        boolean isrxyz = "rxyz".equals(str1);
        if (str1 != null) {
            M4 m = null;
            String xyz = null;
            switch (args[0].tok) {
                case 4: {
                    switch (str1) {
                        case "rxyz": 
                        case "matrix": {
                            xyz = (String)args[0].value;
                        }
                    }
                    break;
                }
                case 12: {
                    switch (str1) {
                        case "rxyz": 
                        case "xyz": {
                            m = (M4)args[0].value;
                        }
                    }
                }
            }
            if (m != null || xyz != null) {
                return this.vwr.getSymStatic().staticConvertOperation(xyz, m, isrxyz ? "rxyz" : null);
            }
        }
        boolean isPoint = false;
        if (x1 != null && x1.tok != 10) {
            if (x1.tok != 8) return null;
            boolean bl = true;
            isPoint = bl;
            if (!bl) {
                return null;
            }
        }
        BS bsAtoms = x1 == null || isPoint ? null : (BS)x1.value;
        P3 p3 = pt1 = isPoint ? SV.ptValue(x1) : null;
        if (!isPoint && bsAtoms == null) {
            bsAtoms = this.vwr.getThisModelAtoms();
        }
        if (narg == 0) {
            String[] ops = PT.split(PT.trim((String)this.vwr.getSymTemp().getSpaceGroupInfo(this.vwr.ms, null, bsAtoms == null || bsAtoms.isEmpty() ? Math.max(0, this.vwr.am.cmi) : (int)this.vwr.ms.at[bsAtoms.nextSetBit((int)0)].mi, false, null).get("symmetryInfo"), "\n"), "\n");
            Lst<String[]> lst = new Lst<String[]>();
            int i = 0;
            int n = ops.length;
            while (i < n) {
                lst.addLast(PT.split(ops[i], "\t"));
                ++i;
            }
            return lst;
        }
        String xyz = null;
        int tok = 0;
        int iOp = Integer.MIN_VALUE;
        int apt = 0;
        P3 pt2 = null;
        BS bs1 = null;
        boolean isWyckoff = false;
        switch (args[0].tok) {
            case 4: {
                xyz = SV.sValue(args[0]);
                switch (xyz == null ? "" : xyz.toLowerCase()) {
                    case "count": {
                        SymmetryInterface sym = this.vwr.getOperativeSymmetry();
                        if (narg != 1) {
                            return null;
                        }
                        Integer n = sym == null ? 0 : sym.getSpaceGroupOperationCount();
                        return n;
                    }
                    case "": {
                        tok = 0;
                        break;
                    }
                    case "invariant": {
                        tok = 36868;
                        break;
                    }
                    case "wyckoff": {
                        tok = 1086324754;
                        isWyckoff = true;
                        break;
                    }
                    case "wyckoffm": {
                        tok = 1086324755;
                        isWyckoff = true;
                    }
                }
                ++apt;
                break;
            }
            case 12: {
                xyz = args[0].escape();
                ++apt;
                break;
            }
            case 2: {
                iOp = args[0].asInt();
                ++apt;
                break;
            }
            case 10: {
                if (isPoint) break;
                bs1 = args.length == 1 || args[1].tok != 10 ? bsAtoms : null;
                bsAtoms = this.vwr.getModelUndeletedAtomsBitSet(this.vwr.getModelIndexForAtom(bsAtoms.nextSetBit(0)));
            }
        }
        if (bsAtoms == null) {
            if (apt < narg && args[apt].tok == 10) {
                bsAtoms = new BS();
                bsAtoms.or((BS)args[apt].value);
            }
            if (apt + 1 < narg && args[apt + 1].tok == 10) {
                (bsAtoms == null ? (bsAtoms = new BS()) : bsAtoms).or((BS)args[apt + 1].value);
            }
        }
        P3 trans = null;
        if (narg > apt && args[apt].tok == 7) {
            Lst<SV> a;
            if ((a = args[apt++].getList()).size() != 3) {
                return null;
            }
            trans = P3.new3(SV.fValue((T)a.get(0)), SV.fValue((T)a.get(1)), SV.fValue((T)a.get(2)));
        } else if (narg > apt && args[apt].tok == 2) {
            int n = apt++;
            trans = new P3();
            SimpleUnitCell.ijkToPoint3f(SV.iValue(args[n]), trans, 0, 0);
        }
        if (pt1 == null && (pt1 = narg > apt ? mp.ptValue(args[apt], bsAtoms) : null) != null) {
            ++apt;
        }
        if ((pt2 = narg > apt ? mp.ptValue(args[apt], bsAtoms) : null) != null) {
            ++apt;
        }
        if (pt1 != null && pt2 == null && bs1 != null && !bs1.isEmpty()) {
            pt2 = pt1;
            pt1 = P3.newP(this.vwr.ms.at[bs1.nextSetBit(0)]);
        }
        int n = nth = pt2 != null && args.length > apt && iOp == Integer.MIN_VALUE && args[apt].tok == 2 ? args[apt].intValue : -1;
        if (nth >= 0) {
            ++apt;
        }
        if (iOp == Integer.MIN_VALUE && tok != 36868) {
            iOp = 0;
        }
        Map<String, Object> map = null;
        if (tok == 0 && xyz != null && xyz.indexOf(",") < 0) {
            if (apt == narg) {
                map = this.vwr.ms.getPointGroupInfo(null);
            } else if (args[apt].tok == 6) {
                map = args[apt].getMap();
            }
        }
        if (map != null) {
            int pt = xyz.indexOf(46);
            int p1 = xyz.indexOf(94);
            if (p1 > 0) {
                nth = PT.parseInt(xyz.substring(p1 + 1));
            } else {
                p1 = xyz.length();
                nth = 1;
            }
            if (pt > 0 && p1 > pt + 1) {
                iOp = PT.parseInt(xyz.substring(pt + 1, p1));
                if (iOp < 1) {
                    iOp = 1;
                }
                p1 = pt;
            } else {
                iOp = 1;
            }
            xyz = xyz.substring(0, p1);
            o = map.get(xyz + "_m");
            if (o == null) {
                o = map.get(xyz);
                if (o == null) {
                    return "";
                }
                Object object = o;
                return object;
            }
            try {
                M3 m;
                P3 centerPt;
                if (o instanceof SV) {
                    centerPt = (P3)((SV)map.get((Object)"center")).value;
                    SV obj = (SV)o;
                    if (obj.tok == 11) {
                        m = (M3)obj.value;
                    } else {
                        if (obj.tok != 7) return null;
                        m = (M3)((SV)obj.getList().get((int)(iOp - 1))).value;
                    }
                } else {
                    centerPt = (P3)map.get("center");
                    m = o instanceof M3 ? (M3)o : (M3)((Lst)o).get(iOp - 1);
                }
                M3 m0 = m;
                m = M3.newM3(m);
                if (nth > 1) {
                    for (int i = 1; i < nth; ++i) {
                        m.mul(m0);
                    }
                }
                if (pt1 == null) {
                    return m;
                }
                pt1 = P3.newP(pt1);
                pt1.sub(centerPt);
                m.rotate(pt1);
                pt1.add(centerPt);
                return pt1;
            }
            catch (Exception m0) {
                return null;
            }
        }
        String string = narg == apt ? (isWyckoff ? "" : (tok == 36868 ? "id" : (pt2 != null || pt1 == null ? "matrix" : "point"))) : (desc = SV.sValue(args[apt++]));
        if (narg > 2) {
            isrxyz = "rxyz".equals(desc);
        }
        boolean haveAtom = (!isWyckoff || isProperty) && bsAtoms != null && !bsAtoms.isEmpty();
        int n2 = iatom = haveAtom ? bsAtoms.nextSetBit(0) : -1;
        if (isWyckoff) {
            P3 pt;
            P3 p32 = pt = haveAtom ? this.vwr.ms.getAtom(iatom) : pt1;
            while (desc.length() > 0 && PT.isDigit(desc.charAt(0))) {
                desc = desc.substring(1);
            }
            if (pt == null) {
                switch (desc) {
                    case "": 
                    case "*": {
                        desc = "*";
                        break;
                    }
                    default: {
                        if (desc.length() != 1) return null;
                        desc = desc + "*";
                        break;
                    }
                }
            }
            if (desc.length() == 0 || desc.equalsIgnoreCase("label")) {
                desc = null;
            }
            String letter = desc == null ? (tok == 1086324755 ? "" : null) : (desc.endsWith("*") || desc.equalsIgnoreCase("coord") || desc.equalsIgnoreCase("coords") ? desc : desc.substring(0, 1));
            SymmetryInterface sym = this.vwr.getOperativeSymmetry();
            if (sym == null) {
                return null;
            }
            Object object = sym.getWyckoffPosition(this.vwr, pt, letter == null ? (tok == 1086324755 ? "M" : null) : (tok == 1086324755 ? "M" : "") + letter);
            return object;
        }
        desc = desc.toLowerCase();
        if (tok == 36868 || desc.equals("invariant") && isProperty) {
            if (haveAtom && pt1 == null) {
                pt1 = this.vwr.ms.at[iatom];
            }
            boolean bl = haveAtom = pt1 != null;
            if (iatom < 0) {
                iatom = this.vwr.getThisModelAtoms().nextSetBit(0);
            }
        }
        if (tok == 36868 && iOp == Integer.MIN_VALUE) {
            int[] ret = null;
            SymmetryInterface sym = this.vwr.getCurrentUnitCell();
            if (pt1 != null) {
                ret = sym == null ? new int[]{} : sym.getInvariantSymops(pt1, null);
            } else if (bsAtoms != null && !bsAtoms.isEmpty()) {
                int ia = bsAtoms.nextSetBit(0);
                pt1 = this.vwr.ms.at[ia];
                ret = this.vwr.ms.getSymmetryInvariant(ia);
            }
            if (ret == null) return ret;
            if (ret.length <= 0) return ret;
            Object[] m = new Object[ret.length];
            int i = 0;
            while (i < m.length) {
                iOp = ret[i];
                m[i] = this.vwr.getSymmetryInfo(iatom, null, iOp, null, pt1, pt1, 1275068418, desc, 0.0f, -1, 0, null);
                ++i;
            }
            return m;
        }
        if (apt != args.length) return null;
        Object object = this.vwr.getSymmetryInfo(iatom, xyz, index > 0 ? index : iOp, trans, pt1, pt2, 1275068418, desc, 0.0f, nth, 0, null);
        return object;
    }

    private boolean evaluateTensor(ScriptMathProcessor mp, SV[] args) throws ScriptException {
        String infoType;
        SV x;
        boolean isTensor = args.length == 2 && args[1].tok == 1275068445;
        SV sV = x = isTensor ? null : mp.getX();
        if (args.length > 2 || !isTensor && x.tok != 10) {
            return false;
        }
        BS bs = (BS)x.value;
        String tensorType = isTensor || args.length == 0 ? null : SV.sValue(args[0]).toLowerCase();
        JmolNMRInterface calc = this.vwr.getNMRCalculation();
        if ("unique".equals(tensorType)) {
            return mp.addXBs(calc.getUniqueTensorSet(bs));
        }
        String string = infoType = args.length < 2 ? null : SV.sValue(args[1]).toLowerCase();
        if (isTensor) {
            return mp.addXObj(((Tensor)args[0].value).getInfo(infoType));
        }
        return mp.addXList(calc.getTensorInfo(tensorType, infoType, bs));
    }

    private boolean evaluateUserFunction(ScriptMathProcessor mp, String name, SV[] args, int tok, boolean isSelector) throws ScriptException {
        SV x1 = null;
        if (isSelector) {
            x1 = mp.getX();
            switch (x1.tok) {
                case 10: {
                    break;
                }
                case 6: {
                    if (args.length > 0) {
                        return false;
                    }
                    return (x1 = x1.getMap().get(name)) == null ? mp.addXStr("") : mp.addX(x1);
                }
                default: {
                    return false;
                }
            }
        }
        name = name.toLowerCase();
        mp.wasX = false;
        Lst<SV> params = new Lst<SV>();
        for (int i = 0; i < args.length; ++i) {
            params.addLast(args[i]);
        }
        if (isSelector) {
            return mp.addXObj(this.e.getBitsetProperty((BS)x1.value, (Lst)null, tok, (P3)null, (P4)null, x1.value, (Object)new Object[]{name, params}, false, x1.index, false));
        }
        SV var = this.e.getUserFunctionResult(name, params, null);
        return var == null ? false : mp.addX(var);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean evaluateWithin(ScriptMathProcessor mp, SV[] args, boolean isAtomProperty) throws ScriptException {
        BS bsSelected;
        BS bs;
        block86: {
            int len = args.length;
            if (len < 1) return false;
            if (len > 5) {
                return false;
            }
            if (len == 1 && args[0].tok == 10) {
                return mp.addX(args[0]);
            }
            bs = isAtomProperty ? SV.getBitSet(mp.getX(), false) : null;
            float distance = 0.0f;
            Object withinSpec = args[0].value;
            String withinStr = "" + withinSpec;
            ModelSet ms = this.vwr.ms;
            boolean isVdw = false;
            boolean isWithinModelSet = false;
            boolean isWithinGroup = false;
            boolean isDistance = false;
            bsSelected = null;
            RadiusData rd = null;
            int tok = args[0].tok;
            block1 : switch (tok == 4 ? (tok = T.getTokFromName(withinStr)) : tok) {
                case 1648363544: {
                    isVdw = true;
                    withinSpec = null;
                }
                case 2: 
                case 3: {
                    isDistance = true;
                    if (len < 2) return false;
                    if (len == 3 && args[1].tok == 7 && args[2].tok != 7) {
                        return false;
                    }
                    distance = isVdw ? 100.0f : SV.fValue(args[0]);
                    tok = args[1].tok;
                    switch (tok) {
                        case 1073742334: 
                        case 1073742335: {
                            isWithinModelSet = args[1].asBoolean();
                            if (len > 2 && SV.sValue(args[2]).equalsIgnoreCase("unitcell")) {
                                tok = 1814695966;
                            } else if (len > 2 && args[2].tok != 10) {
                                return false;
                            }
                            len = 0;
                            break;
                        }
                        case 4: {
                            String s = SV.sValue(args[1]);
                            if (s.startsWith("$")) {
                                bsSelected = this.getAtomsNearSurface(distance, s.substring(1));
                                break block86;
                            } else {
                                if (s.equalsIgnoreCase("group")) {
                                    isWithinGroup = true;
                                    tok = 1086324742;
                                    break;
                                }
                                if (s.equalsIgnoreCase("vanderwaals") || s.equalsIgnoreCase("vdw")) {
                                    withinSpec = null;
                                    isVdw = true;
                                    tok = 1648363544;
                                    break;
                                }
                                tok = T.getTokFromName(s);
                                if (tok == 0) {
                                    return false;
                                }
                                break block1;
                            }
                        }
                    }
                    break;
                }
                case 7: {
                    if (len != 1) break;
                    withinSpec = args[0].asString();
                    tok = 0;
                    break;
                }
                case 1073742328: {
                    bsSelected = len == 3 && args[1].value instanceof BS && args[2].value instanceof BS ? this.vwr.getBranchBitSet(((BS)args[2].value).nextSetBit(0), ((BS)args[1].value).nextSetBit(0), true) : null;
                    break block86;
                }
                case 0x8000404: 
                case 134218757: 
                case 1237320707: {
                    boolean isOK = true;
                    switch (len) {
                        case 2: {
                            bsSelected = bs;
                            break;
                        }
                        case 3: {
                            if (args[2].tok != 10) return false;
                            boolean bl = true;
                            isOK = bl;
                            if (!isOK) break;
                            bsSelected = (BS)args[2].value;
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                    if (!isOK) return false;
                    if (!mp.addXObj(this.e.getSmilesExt().getSmilesMatches(SV.sValue(args[1]), null, bsSelected, null, tok == 0x8000404 ? 2 : 1, mp.asBitSet, false))) return false;
                    return true;
                }
            }
            if (withinSpec instanceof String) {
                if (tok == 0) {
                    tok = 1073742362;
                    if (len > 2) {
                        return false;
                    }
                    len = 2;
                }
            } else if (!isDistance) {
                return false;
            }
            block16 : switch (len) {
                case 1: {
                    switch (tok) {
                        case 0x200020: 
                        case 136314895: 
                        case 1812599299: 
                        case 1814695966: {
                            bsSelected = ms.getAtoms(tok, null);
                            break block86;
                        }
                        case 1073741863: {
                            bsSelected = ms.getAtoms(tok, "");
                            break block86;
                        }
                        case 1073742362: {
                            bsSelected = ms.getAtoms(1086324744, withinStr);
                            break block86;
                        }
                        default: {
                            return false;
                        }
                    }
                }
                case 2: {
                    switch (tok) {
                        case 7: {
                            break;
                        }
                        case 1073742362: {
                            tok = 1086324744;
                            break;
                        }
                        case 0x40000000: 
                        case 1073741863: 
                        case 1073741925: 
                        case 1073742128: 
                        case 1073742189: 
                        case 1086324744: 
                        case 1086326785: 
                        case 1086326786: 
                        case 1111490587: {
                            bsSelected = this.vwr.ms.getAtoms(tok, SV.sValue(args[1]));
                            break block86;
                        }
                        case 1094713349: 
                        case 1094713350: {
                            bsSelected = this.vwr.ms.getAtoms(tok, SV.ptValue(args[1]));
                            break block86;
                        }
                        case 1814695966: {
                            Lst<SV> l = args[1].getList();
                            if (l == null) {
                                return false;
                            }
                            T3[] oabc = null;
                            SymmetryInterface uc = null;
                            if (l.size() != 4) {
                                return false;
                            }
                            oabc = new P3[4];
                            for (int i = 0; i < 4; ++i) {
                                oabc[i] = SV.ptValue((SV)l.get(i));
                                if (oabc[i] != null) continue;
                                return false;
                            }
                            uc = this.vwr.getSymTemp().getUnitCell(oabc, false, null);
                            bsSelected = this.vwr.ms.getAtoms(tok, uc);
                            break block86;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (tok) {
                        case 7: 
                        case 8: 
                        case 134217750: 
                        case 0x8000801: 
                        case 1073742329: 
                        case 1073742334: 
                        case 1073742335: 
                        case 1086324742: 
                        case 1648363544: 
                        case 1814695966: {
                            break block16;
                        }
                        case 1086324744: {
                            withinStr = SV.sValue(args[1]);
                            break block16;
                        }
                    }
                    return false;
                }
            }
            P4 plane = null;
            P3 pt = null;
            Lst<SV> pts1 = null;
            int last = args.length - 1;
            switch (args[last].tok) {
                case 9: {
                    plane = (P4)args[last].value;
                    break;
                }
                case 8: {
                    pt = (P3)args[last].value;
                    if (!SV.sValue(args[1]).equalsIgnoreCase("hkl")) break;
                    plane = this.e.getHklPlane(pt, Float.NaN, null);
                    break;
                }
                case 7: {
                    Lst<SV> lst = pts1 = last == 2 && args[1].tok == 7 ? args[1].getList() : null;
                    pt = last == 2 ? SV.ptValue(args[1]) : (last == 1 ? P3.new3(Float.NaN, 0.0f, 0.0f) : null);
                    break;
                }
            }
            if (plane != null) {
                bsSelected = ms.getAtomsNearPlane(distance, plane);
            } else {
                BS bsLast;
                BS bS = bsLast = args[last].tok == 10 ? (BS)args[last].value : null;
                if (bs == null) {
                    bs = bsLast;
                }
                if (last > 0 && pt == null && pts1 == null && bs == null) {
                    return false;
                }
                if (tok == 1814695966) {
                    boolean asMap = isWithinModelSet;
                    if (bs == null) {
                        if (pt == null) return false;
                    }
                    if (!mp.addXObj(this.vwr.ms.getUnitCellPointsWithin(distance, bs, pt, asMap))) return false;
                    return true;
                }
                if (pt != null || pts1 != null) {
                    if (args[last].tok != 7) return mp.addXBs(this.vwr.getAtomsNearPt(distance, pt, null));
                    Lst<SV> sv = args[last].getList();
                    P3[] ap3 = new P3[sv.size()];
                    int i = ap3.length;
                    while (--i >= 0) {
                        ap3[i] = SV.ptValue((SV)sv.get(i));
                    }
                    P3[] ap31 = null;
                    if (pts1 != null) {
                        ap31 = new P3[pts1.size()];
                        int i2 = ap31.length;
                        while (--i2 >= 0) {
                            ap31[i2] = SV.ptValue((SV)pts1.get(i2));
                        }
                    }
                    Object[] ret = new Object[1];
                    if (bs != null) {
                        bs.and(this.vwr.getAllAtoms());
                        ap31 = this.vwr.ms.at;
                    }
                    switch (PointIterator.withinDistPoints(distance, pt, ap3, ap31, bs, ret)) {
                        case 10: {
                            return mp.addXBs((BS)ret[0]);
                        }
                        case 134217751: {
                            return mp.addXPt((P3)ret[0]);
                        }
                        case 1073742001: {
                            return mp.addXList((Lst)ret[0]);
                        }
                        case 1275068418: {
                            return mp.addXAI((int[])ret[0]);
                        }
                        case 4: {
                            return mp.addXStr((String)ret[0]);
                        }
                    }
                    return false;
                }
                if (tok == 1086324744) {
                    return mp.addXBs(this.vwr.ms.getSequenceBits(withinStr, bs, new BS()));
                }
                if (bs == null) {
                    bs = new BS();
                }
                if (!isDistance) {
                    try {
                        return mp.addXBs(this.vwr.ms.getAtoms(tok, bs));
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                if (isWithinGroup) {
                    return mp.addXBs(this.vwr.getGroupsWithin((int)distance, bs));
                }
                if (isVdw) {
                    rd = new RadiusData(null, distance > 10.0f ? distance / 100.0f : distance, distance > 10.0f ? RadiusData.EnumType.FACTOR : RadiusData.EnumType.OFFSET, VDW.AUTO);
                    if (distance < 0.0f) {
                        distance = 0.0f;
                    }
                }
                BS bsret = this.vwr.ms.getAtomsWithinRadius(distance, isAtomProperty ? bsLast : bs, isWithinModelSet, rd, isAtomProperty ? bs : null);
                if (!isAtomProperty) return mp.addXBs(bsret);
                bsret.andNot(bsLast);
                return mp.addXBs(bsret);
            }
        }
        if (bsSelected == null) return false;
        if (bs == null) return mp.addXBs(bsSelected);
        bsSelected.and(bs);
        return mp.addXBs(bsSelected);
    }

    private boolean evaluateWrite(ScriptMathProcessor mp, SV[] args) throws ScriptException {
        if (!this.checkAccess()) {
            return false;
        }
        int n = args.length;
        boolean asBytes = false;
        if (n == 2 && args[1].tok == 1073742335) {
            n = 1;
            asBytes = true;
        }
        switch (n) {
            case 0: {
                return false;
            }
            case 1: {
                String type = args[0].asString().toUpperCase();
                if (type.equals("PNGJ")) {
                    Object o = this.vwr.fm.getFileAsMap(null, "PNGJ", asBytes);
                    return asBytes ? mp.addX(SV.newV(15, new BArray((byte[])o))) : mp.addXMap((Map)o);
                }
                if (!PT.isOneOf(type, ";ZIP;ZIPALL;JMOL;")) break;
                Hashtable<String, Object> params = new Hashtable<String, Object>();
                OC oc = new OC();
                params.put("outputChannel", oc);
                this.vwr.createZip(null, type, params);
                byte[] bytes = oc.toByteArray();
                if (asBytes) {
                    return mp.addX(SV.newV(15, new BArray(bytes)));
                }
                params = new Hashtable();
                this.vwr.readFileAsMap(Rdr.getBIS(bytes), params, null);
                return mp.addXMap(params);
            }
        }
        return mp.addXStr(this.e.getCmdExt().dispatch(134221856, true, args));
    }

    private BS getAtomsNearSurface(float distance, String surfaceId) {
        Object[] data = new Object[]{surfaceId, null, null};
        if (this.e.getShapePropertyData(24, "getVertices", data)) {
            return this.getAtomsNearPts(distance, (T3[])data[1], (BS)data[2]);
        }
        data[1] = 0;
        data[2] = -1;
        if (this.e.getShapePropertyData(22, "getCenter", data)) {
            return this.vwr.getAtomsNearPt(distance, (P3)data[2], null);
        }
        data[1] = Float.valueOf(distance);
        if (this.e.getShapePropertyData(21, "getAtomsWithin", data)) {
            return (BS)data[2];
        }
        return new BS();
    }

    private BS getAtomsNearPts(float distance, T3[] points, BS bsInclude) {
        BS bsResult = new BS();
        if (points.length == 0 || bsInclude != null && bsInclude.isEmpty()) {
            return bsResult;
        }
        if (bsInclude == null) {
            bsInclude = BSUtil.setAll(points.length);
        }
        Atom[] at = this.vwr.ms.at;
        int i = this.vwr.ms.ac;
        block0: while (--i >= 0) {
            Atom atom = at[i];
            if (atom == null) continue;
            int j = bsInclude.nextSetBit(0);
            while (j >= 0) {
                if (atom.distance(points[j]) < distance) {
                    bsResult.set(i);
                    continue block0;
                }
                j = bsInclude.nextSetBit(j + 1);
            }
        }
        return bsResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getMinMax(Object floatOrSVArray, int tok, boolean isSV) {
        double sum;
        int minMax;
        float[] data = null;
        Lst sv = null;
        int ndata = 0;
        Hashtable<String, Integer> htPivot = null;
        if (AU.isAF(floatOrSVArray)) {
            if (tok == 1275068725) {
                return Float.valueOf(Float.NaN);
            }
            data = (float[])floatOrSVArray;
            ndata = data.length;
            if (ndata == 0) {
                return nan;
            }
        } else {
            if (!(floatOrSVArray instanceof Lst)) return nan;
            sv = (Lst)floatOrSVArray;
            ndata = sv.size();
            if (ndata == 0) {
                if (tok != 1275068725) {
                    return nan;
                }
            } else if (tok != 1275068725) {
                SV sv0 = (SV)sv.get(0);
                if (sv0.tok == 8) {
                    return this.getMinMaxPoint(sv, tok);
                }
                if (sv0.tok == 4 && ((String)sv0.value).startsWith("{")) {
                    P3 pt = SV.ptValue(sv0);
                    if (pt instanceof P3) {
                        return this.getMinMaxPoint(sv, tok);
                    }
                    if (!(pt instanceof P4)) return nan;
                    return this.getMinMaxQuaternion(sv, tok);
                }
            }
        }
        boolean isMin = false;
        switch (tok) {
            case 1275068725: {
                htPivot = new Hashtable<String, Integer>();
                minMax = 0;
                sum = 0;
                break;
            }
            case 32: {
                isMin = true;
                sum = 3.4028234663852886E38;
                minMax = Integer.MAX_VALUE;
                break;
            }
            case 64: {
                sum = -3.4028234663852886E38;
                minMax = -2147483647;
                break;
            }
            default: {
                minMax = 0;
                sum = 0;
            }
        }
        double sum2 = 0.0;
        int n = 0;
        boolean isInt = true;
        boolean isPivot = tok == 1275068725;
        int i = ndata;
        while (--i >= 0) {
            float v;
            SV svi;
            Object o;
            Object object = o = sv == null ? null : (Object)sv.get(i);
            SV sV = !isSV ? null : (svi = o == null ? SV.vF : (SV)o);
            float f = isPivot ? 1.0f : (v = data == null ? SV.fValue(svi) : data[i]);
            if (Float.isNaN(v)) continue;
            ++n;
            switch (tok) {
                case 160: 
                case 192: {
                    sum2 += (double)v * (double)v;
                }
                case 96: 
                case 128: {
                    sum += (double)v;
                    break;
                }
                case 1275068725: {
                    String key = svi == null ? o.toString() : svi.asString();
                    Integer ii = (Integer)htPivot.get(key);
                    htPivot.put(key, ii == null ? Integer.valueOf(1) : Integer.valueOf(ii + 1));
                    break;
                }
                case 32: 
                case 64: {
                    isInt &= svi.tok == 2;
                    if (isMin != (double)v < sum) break;
                    sum = v;
                    if (!isInt) break;
                    minMax = svi.intValue;
                }
            }
        }
        if (tok == 1275068725) {
            return htPivot;
        }
        if (n == 0) return nan;
        switch (tok) {
            case 96: {
                sum /= (double)n;
                return Float.valueOf((float)sum);
            }
            case 192: {
                if (n == 1) return Float.valueOf((float)sum);
                sum = Math.sqrt((sum2 - sum * sum / (double)n) / (double)(n - 1));
                return Float.valueOf((float)sum);
            }
            case 32: 
            case 64: {
                if (!isInt) return Float.valueOf((float)sum);
                return minMax;
            }
            case 128: {
                return Float.valueOf((float)sum);
            }
            case 160: {
                sum = sum2;
            }
        }
        return Float.valueOf((float)sum);
    }

    private Object getMinMaxPoint(Object pointOrSVArray, int tok) {
        P3[] data = null;
        Lst sv = null;
        int ndata = 0;
        if (pointOrSVArray instanceof Quat[]) {
            data = (P3[])pointOrSVArray;
            ndata = data.length;
        } else if (pointOrSVArray instanceof Lst) {
            sv = (Lst)pointOrSVArray;
            ndata = sv.size();
        }
        if (sv == null && data == null) {
            return nan;
        }
        P3 result = new P3();
        float[] fdata = new float[ndata];
        block10: for (int xyz = 0; xyz < 3; ++xyz) {
            block11: for (int i = 0; i < ndata; ++i) {
                P3 pt;
                P3 p3 = pt = data == null ? SV.ptValue((SV)sv.get(i)) : data[i];
                if (pt == null) {
                    return nan;
                }
                switch (xyz) {
                    case 0: {
                        fdata[i] = pt.x;
                        continue block11;
                    }
                    case 1: {
                        fdata[i] = pt.y;
                        continue block11;
                    }
                    case 2: {
                        fdata[i] = pt.z;
                    }
                }
            }
            Object f = this.getMinMax(fdata, tok, true);
            if (!(f instanceof Number)) {
                return nan;
            }
            float value = ((Number)f).floatValue();
            switch (xyz) {
                case 0: {
                    result.x = value;
                    continue block10;
                }
                case 1: {
                    result.y = value;
                    continue block10;
                }
                case 2: {
                    result.z = value;
                }
            }
        }
        return result;
    }

    private Object getMinMaxQuaternion(Lst<SV> svData, int tok) {
        block7: {
            switch (tok) {
                case 32: 
                case 64: 
                case 128: 
                case 160: {
                    return nan;
                }
            }
            Quat[] data = this.e.getQuaternionArray(svData, 1073742001);
            if (data == null) break block7;
            float[] retStddev = new float[1];
            Quat result = Quat.sphereMean(data, retStddev, 1.0E-4f);
            switch (tok) {
                case 96: {
                    return result;
                }
                case 192: {
                    return Float.valueOf(retStddev[0]);
                }
            }
        }
        return nan;
    }

    private PatternMatcher getPatternMatcher() {
        return this.pm == null ? (this.pm = (PatternMatcher)Interface.getUtil("PatternMatcher", this.e.vwr, "script")) : this.pm;
    }

    private T opTokenFor(int tok) {
        switch (tok) {
            case 1275069441: 
            case 1275069446: {
                return T.tokenPlus;
            }
            case 1275068931: {
                return T.tokenMinus;
            }
            case 1275068929: {
                return T.tokenTimes;
            }
            case 1275068930: {
                return T.tokenMul3;
            }
            case 1275068928: {
                return T.tokenDivide;
            }
        }
        return null;
    }

    public BS setContactBitSets(BS bsA, BS bsB, boolean localOnly, float distance, RadiusData rd, boolean warnMultiModel) {
        BS bs;
        boolean withinAllModels;
        if (bsB == null) {
            bsB = BSUtil.setAll(this.vwr.ms.ac);
            BSUtil.andNot(bsB, this.vwr.slm.bsDeleted);
            bsB.andNot(bsA);
            withinAllModels = false;
        } else {
            bs = BSUtil.copy(bsA);
            bs.or(bsB);
            int nModels = this.vwr.ms.getModelBS(bs, false).cardinality();
            boolean bl = withinAllModels = nModels > 1;
            if (warnMultiModel && nModels > 1 && !this.e.tQuiet) {
                this.e.showString(GT.$("Note: More than one model is involved in this contact!"));
            }
        }
        if (!bsA.equals(bsB)) {
            boolean setBfirst;
            boolean bl = setBfirst = !localOnly || bsA.cardinality() < bsB.cardinality();
            if (setBfirst) {
                bs = this.vwr.ms.getAtomsWithinRadius(distance, bsA, withinAllModels, Float.isNaN(distance) ? rd : null, null);
                bsB.and(bs);
            }
            if (localOnly) {
                bs = this.vwr.ms.getAtomsWithinRadius(distance, bsB, withinAllModels, Float.isNaN(distance) ? rd : null, null);
                bsA.and(bs);
                if (!setBfirst) {
                    bs = this.vwr.ms.getAtomsWithinRadius(distance, bsA, withinAllModels, Float.isNaN(distance) ? rd : null, null);
                    bsB.and(bs);
                }
                bs = BSUtil.copy(bsB);
                bs.and(bsA);
                if (bs.equals(bsA)) {
                    bsB.andNot(bsA);
                } else if (bs.equals(bsB)) {
                    bsA.andNot(bsB);
                }
            }
        }
        return bsB;
    }
}

