/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.ext;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.ext.JavaExtensions;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Inspector;
import org.jruby.util.RubyStringBuilder;

public abstract class JavaUtilRegex {
    public static void define(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        JavaExtensions.put(runtime2, java.util.regex.Pattern.class, proxy2 -> proxy2.defineMethods(context, Pattern.class));
        JavaExtensions.put(runtime2, java.util.regex.Matcher.class, proxy2 -> proxy2.defineMethods(context, Matcher.class));
    }

    @JRubyClass(name={"Java::JavaUtilRegex::Matcher"})
    public static class Matcher {
        @JRubyMethod
        public static IRubyObject regexp(ThreadContext context, IRubyObject self2) {
            java.util.regex.Matcher matcher = (java.util.regex.Matcher)JavaUtil.unwrapJavaObject(self2);
            return JavaUtil.convertJavaToUsableRubyObject(context.runtime, matcher.pattern());
        }

        @JRubyMethod
        public static IRubyObject begin(ThreadContext context, IRubyObject self2, IRubyObject idx) {
            java.util.regex.Matcher matcher = (java.util.regex.Matcher)JavaUtil.unwrapJavaObject(self2);
            if (idx instanceof RubySymbol) {
                return Convert.asFixnum(context, matcher.start(idx.toString()));
            }
            int group2 = Convert.toInt(context, idx);
            return Convert.asFixnum(context, matcher.start(group2));
        }

        @JRubyMethod
        public static IRubyObject end(ThreadContext context, IRubyObject self2, IRubyObject idx) {
            java.util.regex.Matcher matcher = (java.util.regex.Matcher)JavaUtil.unwrapJavaObject(self2);
            if (idx instanceof RubySymbol) {
                return Convert.asFixnum(context, matcher.end(idx.toString()));
            }
            int group2 = Convert.toInt(context, idx);
            return Convert.asFixnum(context, matcher.end(group2));
        }

        @JRubyMethod
        public static IRubyObject offset(ThreadContext context, IRubyObject self2, IRubyObject idx) {
            RubyFixnum end2;
            RubyFixnum beg;
            java.util.regex.Matcher matcher = (java.util.regex.Matcher)JavaUtil.unwrapJavaObject(self2);
            if (idx instanceof RubySymbol) {
                beg = Convert.asFixnum(context, matcher.start(idx.toString()));
                end2 = Convert.asFixnum(context, matcher.end(idx.toString()));
            } else {
                int group2 = Convert.toInt(context, idx);
                beg = Convert.asFixnum(context, matcher.start(group2));
                end2 = Convert.asFixnum(context, matcher.end(group2));
            }
            return Create.newArray(context, (IRubyObject)beg, (IRubyObject)end2);
        }

        @JRubyMethod(name={"length", "size"})
        public static RubyFixnum size(ThreadContext context, IRubyObject self2) {
            java.util.regex.Matcher matcher = (java.util.regex.Matcher)JavaUtil.unwrapJavaObject(self2);
            return Convert.asFixnum(context, matcher.groupCount() + 1);
        }

        @JRubyMethod
        public static RubyString string(ThreadContext context, IRubyObject self2) {
            return Matcher.str(context, self2);
        }

        private static RubyString str(ThreadContext context, IRubyObject self2) {
            IRubyObject str = (IRubyObject)self2.getInternalVariables().getInternalVariable("str");
            return str.convertToString();
        }

        @JRubyMethod
        public static IRubyObject pre_match(ThreadContext context, IRubyObject self2) {
            java.util.regex.Matcher matcher = (java.util.regex.Matcher)JavaUtil.unwrapJavaObject(self2);
            return Matcher.str(context, self2).substr(context, 0, matcher.start(0));
        }

        @JRubyMethod
        public static IRubyObject post_match(ThreadContext context, IRubyObject self2) {
            java.util.regex.Matcher matcher = (java.util.regex.Matcher)JavaUtil.unwrapJavaObject(self2);
            RubyString str = Matcher.str(context, self2);
            int offset2 = matcher.end(0);
            return str.substr(context, offset2, str.size() - offset2);
        }

        @JRubyMethod
        public static RubyArray to_a(ThreadContext context, IRubyObject self2) {
            return RubyArray.newArrayMayCopy(context.runtime, Matcher.groups(context, self2, 0));
        }

        @JRubyMethod
        public static RubyArray captures(ThreadContext context, IRubyObject self2) {
            return RubyArray.newArrayMayCopy(context.runtime, Matcher.groups(context, self2, 1));
        }

        private static IRubyObject[] groups(ThreadContext context, IRubyObject self2, int off) {
            java.util.regex.Matcher matcher = (java.util.regex.Matcher)JavaUtil.unwrapJavaObject(self2);
            IRubyObject[] arr = new IRubyObject[matcher.groupCount() - off + 1];
            for (int i2 = 0; i2 < arr.length; ++i2) {
                arr[i2] = matcher.start(i2 + off) == -1 ? context.nil : Create.newString(context, matcher.group(i2 + off));
            }
            return arr;
        }

        @JRubyMethod(name={"[]"})
        public static IRubyObject aref(ThreadContext context, IRubyObject self2, IRubyObject idx) {
            IRubyObject iRubyObject;
            java.util.regex.Matcher matcher = (java.util.regex.Matcher)JavaUtil.unwrapJavaObject(self2);
            if (idx instanceof RubySymbol || idx instanceof RubyString) {
                return Create.newString(context, matcher.group(idx.toString()));
            }
            if (idx instanceof RubyInteger) {
                RubyInteger group2 = (RubyInteger)idx;
                iRubyObject = Create.newString(context, matcher.group(group2.asInt(context)));
            } else {
                iRubyObject = Matcher.to_a(context, self2).aref(context, idx);
            }
            return iRubyObject;
        }

        @JRubyMethod(name={"[]"})
        public static IRubyObject aref(ThreadContext context, IRubyObject self2, IRubyObject arg0, IRubyObject arg1) {
            return Matcher.to_a(context, self2).aref(context, arg0, arg1);
        }

        @JRubyMethod(rest=true)
        public static IRubyObject values_at(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
            return Matcher.to_a(context, self2).values_at(context, args2);
        }
    }

    @JRubyClass(name={"Java::JavaUtilRegex::Pattern"})
    public static class Pattern {
        @JRubyMethod(name={"=~"})
        public static IRubyObject op_match(ThreadContext context, IRubyObject self2, IRubyObject str) {
            java.util.regex.Matcher matcher = Pattern.matcher(self2, str);
            return matcher.find() ? Convert.asFixnum(context, matcher.start()) : context.nil;
        }

        @JRubyMethod(name={"match"})
        public static IRubyObject match(ThreadContext context, IRubyObject self2, IRubyObject str) {
            java.util.regex.Matcher matcher = Pattern.matcher(self2, str);
            if (!matcher.find()) {
                return context.nil;
            }
            RubyObject matcherProxy = (RubyObject)JavaUtil.convertJavaToUsableRubyObject(context.runtime, matcher);
            matcherProxy.setInternalVariable("str", str);
            return matcherProxy;
        }

        @JRubyMethod(name={"==="})
        public static IRubyObject eqq(ThreadContext context, IRubyObject self2, IRubyObject str) {
            return Convert.asBoolean(context, Pattern.matcher(self2, str).find());
        }

        @JRubyMethod(name={"casefold?"})
        public static IRubyObject casefold_p(ThreadContext context, IRubyObject self2) {
            java.util.regex.Pattern regex = (java.util.regex.Pattern)JavaUtil.unwrapJavaObject(self2);
            return Convert.asBoolean(context, (regex.flags() & 2) != 0);
        }

        @JRubyMethod(name={"inspect"})
        public static IRubyObject inspect(ThreadContext context, IRubyObject self2) {
            java.util.regex.Pattern regex = (java.util.regex.Pattern)JavaUtil.unwrapJavaObject(self2);
            RubyString buf = Inspector.inspectPrefix(context, self2.getMetaClass());
            RubyStringBuilder.cat(context.runtime, buf, Inspector.SPACE);
            RubyStringBuilder.cat(context.runtime, buf, Inspector.SLASH);
            RubyStringBuilder.cat(context.runtime, buf, regex.toString());
            RubyStringBuilder.cat(context.runtime, buf, Inspector.SLASH);
            RubyStringBuilder.cat(context.runtime, buf, Inspector.GT);
            return buf;
        }

        private static java.util.regex.Matcher matcher(IRubyObject self2, IRubyObject str) {
            java.util.regex.Pattern regex = (java.util.regex.Pattern)JavaUtil.unwrapJavaObject(self2);
            return regex.matcher(str.toJava(CharSequence.class));
        }
    }
}

