/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime.devmode;

import io.quarkus.arc.runtime.devmode.EventInfo;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.operators.multi.processors.BroadcastProcessor;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.context.Destroyed;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.EventMetadata;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Singleton
public class EventsMonitor {
    private static final int DEFAULT_LIMIT = 500;
    private volatile boolean skipContextEvents = true;
    private final List<EventInfo> events = Collections.synchronizedList(new ArrayList(500));
    private final BroadcastProcessor<EventInfo> eventsStream = BroadcastProcessor.create();
    private final BroadcastProcessor<Boolean> skipContextEventsStream = BroadcastProcessor.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notify(@Observes Object payload, EventMetadata eventMetadata) {
        if (this.skipContextEvents && this.isContextEvent(eventMetadata)) {
            return;
        }
        if (this.events.size() > 500) {
            List<EventInfo> list = this.events;
            synchronized (list) {
                if (this.events.size() > 500) {
                    this.events.subList(0, 250).clear();
                }
            }
        }
        EventInfo eventInfo = this.toEventInfo(payload, eventMetadata);
        this.eventsStream.onNext((Object)eventInfo);
        this.events.add(eventInfo);
    }

    public void clear() {
        this.events.clear();
    }

    public Multi<EventInfo> streamEvents() {
        return this.eventsStream;
    }

    public Multi<Boolean> streamSkipContextEvents() {
        return this.skipContextEventsStream;
    }

    public List<EventInfo> getLastEvents() {
        ArrayList<EventInfo> result = new ArrayList<EventInfo>(this.events);
        Collections.reverse(result);
        return result;
    }

    public boolean isSkipContextEvents() {
        return this.skipContextEvents;
    }

    public void toggleSkipContextEvents() {
        this.skipContextEvents = !this.skipContextEvents;
        this.skipContextEventsStream.onNext((Object)this.skipContextEvents);
    }

    boolean isContextEvent(EventMetadata eventMetadata) {
        if (!eventMetadata.getType().equals(Object.class) || eventMetadata.getQualifiers().size() != 2) {
            return false;
        }
        for (Annotation qualifier : eventMetadata.getQualifiers()) {
            Class<? extends Annotation> qualifierType = qualifier.annotationType();
            if (qualifierType.equals(Any.class) || qualifierType.equals(Initialized.class) || qualifierType.equals(BeforeDestroyed.class) || qualifierType.equals(Destroyed.class)) continue;
            return false;
        }
        return true;
    }

    private EventInfo toEventInfo(Object payload, EventMetadata eventMetadata) {
        EventInfo eventInfo = new EventInfo();
        eventInfo.setTimestamp(this.now());
        eventInfo.setType(eventMetadata.getType().getTypeName());
        ArrayList<String> q = new ArrayList<String>();
        if (eventMetadata.getQualifiers().size() > 1) {
            for (Annotation qualifier : eventMetadata.getQualifiers()) {
                if (qualifier.annotationType().equals(Any.class) || qualifier.annotationType().equals(Default.class)) continue;
                q.add(qualifier.toString());
            }
        }
        eventInfo.setQualifiers(q);
        eventInfo.setIsContextEvent(this.isContextEvent(eventMetadata));
        return eventInfo;
    }

    private String now() {
        LocalDateTime time = LocalDateTime.now();
        String timestamp = time.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME).replace("T", " ");
        return timestamp.substring(0, timestamp.lastIndexOf("."));
    }
}

