/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry;

import io.quarkus.registry.catalog.Category;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.ExtensionOrigin;
import io.quarkus.registry.catalog.Platform;
import io.quarkus.registry.catalog.PlatformCatalog;
import io.quarkus.registry.catalog.PlatformRelease;
import io.quarkus.registry.catalog.PlatformStream;
import io.quarkus.registry.json.JsonBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CatalogMergeUtility {
    public static ExtensionCatalog merge(List<? extends ExtensionCatalog> catalogs) {
        if (catalogs.isEmpty()) {
            throw new IllegalArgumentException("No catalogs provided");
        }
        if (catalogs.size() == 1) {
            return JsonBuilder.buildIfBuilder(catalogs.get(0));
        }
        List<ExtensionCatalog> roots = CatalogMergeUtility.detectRoots(catalogs);
        if (roots.size() == 1) {
            return JsonBuilder.buildIfBuilder(roots.get(0));
        }
        ExtensionCatalog.Mutable combined = ExtensionCatalog.builder();
        LinkedHashMap categories = new LinkedHashMap();
        LinkedHashMap<String, ExtensionCatalog> derivedFrom = new LinkedHashMap<String, ExtensionCatalog>();
        LinkedHashMap extensions = new LinkedHashMap();
        HashMap metadata = new HashMap();
        HashMap originCatalogs = new HashMap();
        catalogs.forEach(c -> {
            ExtensionCatalog catalog = JsonBuilder.buildIfBuilder(c);
            originCatalogs.put(catalog.getId(), catalog);
        });
        for (ExtensionCatalog catalog : roots) {
            if (combined.getBom() == null) {
                combined.setBom(catalog.getBom());
            }
            if (catalog.getId() != null) {
                derivedFrom.putIfAbsent(catalog.getId(), catalog);
            }
            catalog.getDerivedFrom().forEach(o -> derivedFrom.putIfAbsent(o.getId(), (ExtensionCatalog)o));
            catalog.getCategories().forEach(c -> categories.putIfAbsent(c.getId(), c));
            catalog.getExtensions().forEach(e -> {
                Extension.Mutable copy = extensions.computeIfAbsent(e.getArtifact().getKey(), k -> e.mutable().setOrigins(new ArrayList<ExtensionOrigin>()));
                for (ExtensionOrigin origin : e.getOrigins()) {
                    ExtensionCatalog c = (ExtensionCatalog)originCatalogs.get(origin.getId());
                    copy.getOrigins().add(c == null ? origin : c);
                }
            });
            for (Map.Entry<String, Object> e2 : catalog.getMetadata().entrySet()) {
                CatalogMergeUtility.putIfAbscentRecursively(e2.getKey(), e2.getValue(), metadata);
            }
            if (combined.getQuarkusCoreVersion() == null && catalog.getQuarkusCoreVersion() != null) {
                combined.setQuarkusCoreVersion(catalog.getQuarkusCoreVersion());
            }
            if (combined.getUpstreamQuarkusCoreVersion() != null || catalog.getUpstreamQuarkusCoreVersion() == null || combined.getQuarkusCoreVersion().equals(catalog.getUpstreamQuarkusCoreVersion())) continue;
            combined.setUpstreamQuarkusCoreVersion(catalog.getUpstreamQuarkusCoreVersion());
        }
        combined.setCategories(new ArrayList<Category>(categories.values())).setDerivedFrom(new ArrayList<ExtensionOrigin>(derivedFrom.values())).setExtensions(new ArrayList<Extension>(extensions.values())).setMetadata((Map)metadata);
        return combined.build();
    }

    private static void putIfAbscentRecursively(Object key, Object value, Map target) {
        target.compute(key, (k, currentValue) -> {
            if (currentValue == null) {
                return value;
            }
            if (Objects.equals(currentValue, value) || !(value instanceof Map) || !(currentValue instanceof Map)) {
                return currentValue;
            }
            HashMap currentMap = (HashMap)currentValue;
            for (Map.Entry e : ((Map)value).entrySet()) {
                if (!(e.getKey() instanceof String)) continue;
                try {
                    CatalogMergeUtility.putIfAbscentRecursively(e.getKey().toString(), e.getValue(), currentMap);
                }
                catch (UnsupportedOperationException ex) {
                    currentMap = new HashMap(currentMap);
                    CatalogMergeUtility.putIfAbscentRecursively(e.getKey().toString(), e.getValue(), currentMap);
                }
            }
            return currentMap;
        });
    }

    static PlatformCatalog mergePlatformCatalogs(List<PlatformCatalog> catalogs) {
        if (catalogs.isEmpty()) {
            throw new IllegalArgumentException("No catalogs provided");
        }
        if (catalogs.size() == 1) {
            return catalogs.get(0);
        }
        PlatformCatalog.Mutable merged = PlatformCatalog.builder();
        HashMap<String, Platform.Mutable> platformMap = new HashMap<String, Platform.Mutable>();
        for (PlatformCatalog c : catalogs) {
            for (Platform p : c.getPlatforms()) {
                Platform.Mutable mergedPlatform = platformMap.computeIfAbsent(p.getPlatformKey(), k -> {
                    Platform.Mutable pl = Platform.builder().setPlatformKey((String)k);
                    merged.addPlatform(pl);
                    return pl;
                });
                for (PlatformStream s : p.getStreams()) {
                    PlatformStream.Mutable mergedStream = (PlatformStream.Mutable)mergedPlatform.getStream(s.getId());
                    if (mergedStream == null) {
                        mergedStream = PlatformStream.builder().setId(s.getId());
                        mergedPlatform.addStream(mergedStream);
                    }
                    for (PlatformRelease r : s.getReleases()) {
                        PlatformRelease release = mergedStream.getRelease(r.getVersion());
                        if (release != null) continue;
                        mergedStream.addRelease(r);
                    }
                    Map<String, Object> metadata = mergedStream.getMetadata();
                    s.getMetadata().forEach(metadata::putIfAbsent);
                }
                p.getMetadata().forEach(mergedPlatform.getMetadata()::putIfAbsent);
            }
            c.getMetadata().forEach(merged.getMetadata()::putIfAbsent);
        }
        return merged.build();
    }

    private static List<ExtensionCatalog> detectRoots(List<? extends ExtensionCatalog> catalogs) {
        HashSet<String> allDerivedFrom = new HashSet<String>(catalogs.size());
        for (ExtensionCatalog extensionCatalog : catalogs) {
            for (ExtensionOrigin o : extensionCatalog.getDerivedFrom()) {
                allDerivedFrom.add(o.getId());
            }
        }
        ArrayList<ExtensionCatalog> roots = new ArrayList<ExtensionCatalog>(catalogs.size());
        for (ExtensionCatalog extensionCatalog : catalogs) {
            if (extensionCatalog.getId() != null && allDerivedFrom.contains(extensionCatalog.getId())) continue;
            roots.add(extensionCatalog);
        }
        return roots;
    }
}

