/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.keycloak.http.FormPartValue;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.StringUtil;

@Extension(name="x-smallrye-profile-admin", value="")
public class RealmLocalizationResource {
    private final RealmModel realm;
    private final AdminPermissionEvaluator auth;
    protected final KeycloakSession session;

    public RealmLocalizationResource(KeycloakSession session, AdminPermissionEvaluator auth) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.auth = auth;
    }

    @Path(value="{locale}/{key}")
    @PUT
    @Consumes(value={"text/plain"})
    @Tag(name="Realms Admin")
    @Operation
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="400", description="Bad Request"), @APIResponse(responseCode="403", description="Forbidden")})
    public void saveRealmLocalizationText(@PathParam(value="locale") String locale, @PathParam(value="key") String key, String text) {
        this.auth.realm().requireManageRealm();
        try {
            this.session.realms().saveLocalizationText(this.realm, locale, key, text);
        }
        catch (ModelDuplicateException e) {
            throw new BadRequestException(String.format("Localization text %s for the locale %s and realm %s already exists.", key, locale, this.realm.getId()));
        }
    }

    @POST
    @Path(value="{locale}")
    @Consumes(value={"multipart/form-data"})
    @Tag(name="Realms Admin")
    @Operation(summary="Import localization from uploaded JSON file")
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="400", description="Bad Request"), @APIResponse(responseCode="403", description="Forbidden")})
    public void createOrUpdateRealmLocalizationTextsFromFile(@PathParam(value="locale") String locale) {
        this.auth.realm().requireManageRealm();
        MultivaluedMap formDataMap = this.session.getContext().getHttpRequest().getMultiPartFormParameters();
        if (!formDataMap.containsKey((Object)"file")) {
            throw new BadRequestException();
        }
        try (InputStream inputStream = ((FormPartValue)formDataMap.getFirst((Object)"file")).asInputStream();){
            TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(){};
            Map rep = (Map)JsonSerialization.readValue((InputStream)inputStream, (TypeReference)typeRef);
            this.realm.createOrUpdateRealmLocalizationTexts(locale, rep);
        }
        catch (IOException e) {
            throw new BadRequestException("Could not read file.");
        }
    }

    @POST
    @Path(value="{locale}")
    @Consumes(value={"application/json"})
    @Tag(name="Realms Admin")
    @Operation
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="403", description="Forbidden")})
    public void createOrUpdateRealmLocalizationTexts(@PathParam(value="locale") String locale, Map<String, String> localizationTexts) {
        this.auth.realm().requireManageRealm();
        this.realm.createOrUpdateRealmLocalizationTexts(locale, localizationTexts);
    }

    @Path(value="{locale}")
    @DELETE
    @Tag(name="Realms Admin")
    @Operation
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="403", description="Forbidden"), @APIResponse(responseCode="404", description="Not Found")})
    public void deleteRealmLocalizationTexts(@PathParam(value="locale") String locale) {
        this.auth.realm().requireManageRealm();
        if (!this.realm.removeRealmLocalizationTexts(locale)) {
            throw new NotFoundException("No localization texts for locale " + locale + " found.");
        }
    }

    @Path(value="{locale}/{key}")
    @DELETE
    @Tag(name="Realms Admin")
    @Operation
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="403", description="Forbidden"), @APIResponse(responseCode="404", description="Not Found")})
    public void deleteRealmLocalizationText(@PathParam(value="locale") String locale, @PathParam(value="key") String key) {
        this.auth.realm().requireManageRealm();
        if (!this.session.realms().deleteLocalizationText(this.realm, locale, key)) {
            throw new NotFoundException("Localization text not found");
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Tag(name="Realms Admin")
    @Operation
    @APIResponses(value={@APIResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=String.class, type=SchemaType.ARRAY))}), @APIResponse(responseCode="403", description="Forbidden")})
    public Stream<String> getRealmLocalizationLocales() {
        this.auth.requireAnyAdminRole();
        return this.realm.getRealmLocalizationTexts().keySet().stream().sorted();
    }

    @Path(value="{locale}")
    @GET
    @Produces(value={"application/json"})
    @Tag(name="Realms Admin")
    @Operation
    @APIResponses(value={@APIResponse(responseCode="200", description="OK"), @APIResponse(responseCode="403", description="Forbidden")})
    public Map<String, String> getRealmLocalizationTexts(@PathParam(value="locale") String locale, @Deprecated @QueryParam(value="useRealmDefaultLocaleFallback") Boolean useFallback) {
        if (!AdminPermissions.realms(this.session, this.auth.adminAuth()).isAdmin()) {
            throw new ForbiddenException();
        }
        if (useFallback != null && useFallback.booleanValue()) {
            HashMap<String, String> realmLocalizationTexts = new HashMap<String, String>();
            if (StringUtil.isNotBlank((String)this.realm.getDefaultLocale())) {
                realmLocalizationTexts.putAll(this.realm.getRealmLocalizationTextsByLocale(this.realm.getDefaultLocale()));
            }
            realmLocalizationTexts.putAll(this.realm.getRealmLocalizationTextsByLocale(locale));
            return realmLocalizationTexts;
        }
        return this.realm.getRealmLocalizationTextsByLocale(locale);
    }

    @Path(value="{locale}/{key}")
    @GET
    @Produces(value={"text/plain"})
    @Tag(name="Realms Admin")
    @Operation
    @APIResponses(value={@APIResponse(responseCode="200", description="OK"), @APIResponse(responseCode="403", description="Forbidden"), @APIResponse(responseCode="404", description="Not Found")})
    public String getRealmLocalizationText(@PathParam(value="locale") String locale, @PathParam(value="key") String key) {
        this.auth.requireAnyAdminRole();
        String text = this.session.realms().getLocalizationTextsById(this.realm, locale, key);
        if (text != null) {
            return text;
        }
        throw new NotFoundException("Localization text not found");
    }
}

