/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.ModelIllegalStateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleMapperModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.ClientMappingsRepresentation;
import org.keycloak.representations.idm.MappingsRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.ClientRoleMappingsResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.storage.ReadOnlyException;

@Extension(name="x-smallrye-profile-admin", value="")
public class RoleMapperResource {
    protected static final Logger logger = Logger.getLogger(RoleMapperResource.class);
    protected final RealmModel realm;
    private final RoleMapperModel roleMapper;
    private final AdminEventBuilder adminEvent;
    protected final AdminPermissionEvaluator.RequirePermissionCheck managePermission;
    protected final AdminPermissionEvaluator.RequirePermissionCheck viewPermission;
    private final AdminPermissionEvaluator auth;
    protected final ClientConnection clientConnection;
    protected final KeycloakSession session;
    protected final HttpHeaders headers;

    public RoleMapperResource(KeycloakSession session, AdminPermissionEvaluator auth, RoleMapperModel roleMapper, AdminEventBuilder adminEvent, AdminPermissionEvaluator.RequirePermissionCheck manageCheck, AdminPermissionEvaluator.RequirePermissionCheck viewCheck) {
        this.session = session;
        this.auth = auth;
        this.realm = session.getContext().getRealm();
        this.clientConnection = session.getContext().getConnection();
        this.adminEvent = adminEvent.resource(ResourceType.REALM_ROLE_MAPPING);
        this.roleMapper = roleMapper;
        this.managePermission = manageCheck;
        this.viewPermission = viewCheck;
        this.headers = session.getContext().getRequestHeaders();
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Role Mapper")
    @Operation(summary="Get role mappings")
    @APIResponses(value={@APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=MappingsRepresentation.class))}), @APIResponse(responseCode="403", description="Forbidden")})
    public MappingsRepresentation getRoleMappings() {
        this.viewPermission.require();
        ArrayList realmRolesRepresentation = new ArrayList();
        HashMap appMappings = new HashMap();
        AtomicReference mappings = new AtomicReference();
        this.roleMapper.getRoleMappingsStream().forEach(roleMapping -> {
            RoleContainerModel container = roleMapping.getContainer();
            if (container instanceof RealmModel) {
                realmRolesRepresentation.add(ModelToRepresentation.toBriefRepresentation((RoleModel)roleMapping));
            } else if (container instanceof ClientModel) {
                ClientModel clientModel = (ClientModel)container;
                mappings.set((ClientMappingsRepresentation)appMappings.get(clientModel.getClientId()));
                if (mappings.get() == null) {
                    mappings.set(new ClientMappingsRepresentation());
                    ((ClientMappingsRepresentation)mappings.get()).setId(clientModel.getId());
                    ((ClientMappingsRepresentation)mappings.get()).setClient(clientModel.getClientId());
                    ((ClientMappingsRepresentation)mappings.get()).setMappings(new ArrayList());
                    appMappings.put(clientModel.getClientId(), (ClientMappingsRepresentation)mappings.get());
                }
                ((ClientMappingsRepresentation)mappings.get()).getMappings().add(ModelToRepresentation.toBriefRepresentation((RoleModel)roleMapping));
            }
        });
        MappingsRepresentation all = new MappingsRepresentation();
        if (!realmRolesRepresentation.isEmpty()) {
            all.setRealmMappings(realmRolesRepresentation);
        }
        if (!appMappings.isEmpty()) {
            all.setClientMappings(appMappings);
        }
        return all;
    }

    @Path(value="realm")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Role Mapper")
    @Operation(summary="Get realm-level role mappings")
    @APIResponses(value={@APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=RoleRepresentation.class, type=SchemaType.ARRAY))}), @APIResponse(responseCode="403", description="Forbidden")})
    public Stream<RoleRepresentation> getRealmRoleMappings() {
        this.viewPermission.require();
        return this.roleMapper.getRealmRoleMappingsStream().map(ModelToRepresentation::toBriefRepresentation);
    }

    @Path(value="realm/composite")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Role Mapper")
    @Operation(summary="Get effective realm-level role mappings This will recurse all composite roles to get the result.")
    @APIResponses(value={@APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=RoleRepresentation.class, type=SchemaType.ARRAY))}), @APIResponse(responseCode="403", description="Forbidden")})
    public Stream<RoleRepresentation> getCompositeRealmRoleMappings(@Parameter(description="if false, return roles with their attributes") @QueryParam(value="briefRepresentation") @DefaultValue(value="true") boolean briefRepresentation) {
        this.viewPermission.require();
        Function<RoleModel, RoleRepresentation> toBriefRepresentation = briefRepresentation ? ModelToRepresentation::toBriefRepresentation : ModelToRepresentation::toRepresentation;
        return this.realm.getRolesStream().filter(arg_0 -> ((RoleMapperModel)this.roleMapper).hasRole(arg_0)).map(toBriefRepresentation);
    }

    @Path(value="realm/available")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Role Mapper")
    @Operation(summary="Get realm-level roles that can be mapped")
    @APIResponses(value={@APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=RoleRepresentation.class, type=SchemaType.ARRAY))}), @APIResponse(responseCode="403", description="Forbidden")})
    public Stream<RoleRepresentation> getAvailableRealmRoleMappings() {
        this.viewPermission.require();
        return this.realm.getRolesStream().filter(this::canMapRole).filter(((Predicate<RoleModel>)arg_0 -> ((RoleMapperModel)this.roleMapper).hasDirectRole(arg_0)).negate()).map(ModelToRepresentation::toBriefRepresentation);
    }

    @Path(value="realm")
    @POST
    @Consumes(value={"application/json"})
    @Tag(name="Role Mapper")
    @Operation(summary="Add realm-level role mappings to the user")
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="400", description="Bad Request"), @APIResponse(responseCode="403", description="Forbidden"), @APIResponse(responseCode="404", description="Not Found"), @APIResponse(responseCode="500", description="Internal Server Error")})
    public void addRealmRoleMappings(@Parameter(description="Roles to add") List<RoleRepresentation> roles) {
        this.managePermission.require();
        logger.debugv("** addRealmRoleMappings: {0}", roles);
        try {
            for (RoleRepresentation role : roles) {
                RoleModel roleModel = this.realm.getRole(role.getName());
                if (roleModel == null || !roleModel.getId().equals(role.getId())) {
                    throw new NotFoundException("Role not found");
                }
                this.auth.roles().requireMapRole(roleModel);
                this.roleMapper.grantRole(roleModel);
            }
        }
        catch (ModelIllegalStateException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw ErrorResponse.error(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (ModelException | ReadOnlyException me) {
            logger.warn((Object)me.getMessage(), me);
            throw new ErrorResponseException("invalid_request", "Could not add user role mappings!", Response.Status.BAD_REQUEST);
        }
        if (!roles.isEmpty()) {
            this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(roles).success();
        }
    }

    @Path(value="realm")
    @DELETE
    @Consumes(value={"application/json"})
    @Tag(name="Role Mapper")
    @Operation(summary="Delete realm-level role mappings")
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="400", description="Bad Request"), @APIResponse(responseCode="403", description="Forbidden"), @APIResponse(responseCode="404", description="Not Found"), @APIResponse(responseCode="500", description="Internal Server Error")})
    public void deleteRealmRoleMappings(List<RoleRepresentation> roles) {
        this.managePermission.require();
        logger.debug((Object)"deleteRealmRoleMappings");
        if (roles == null) {
            roles = this.roleMapper.getRealmRoleMappingsStream().peek(roleModel -> {
                this.auth.roles().requireMapRole((RoleModel)roleModel);
                this.roleMapper.deleteRoleMapping(roleModel);
            }).map(ModelToRepresentation::toBriefRepresentation).collect(Collectors.toList());
        } else {
            for (RoleRepresentation role : roles) {
                RoleModel roleModel2 = this.realm.getRole(role.getName());
                if (roleModel2 == null || !roleModel2.getId().equals(role.getId())) {
                    throw new NotFoundException("Role not found");
                }
                this.auth.roles().requireMapRole(roleModel2);
                try {
                    this.roleMapper.deleteRoleMapping(roleModel2);
                }
                catch (ModelIllegalStateException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw ErrorResponse.error(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
                }
                catch (ModelException | ReadOnlyException me) {
                    logger.warn((Object)me.getMessage(), me);
                    throw new ErrorResponseException("invalid_request", "Could not remove user role mappings!", Response.Status.BAD_REQUEST);
                }
            }
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(roles).success();
    }

    private boolean canMapRole(RoleModel roleModel) {
        return this.auth.roles().canMapRole(roleModel);
    }

    @Path(value="clients/{client-id}")
    public ClientRoleMappingsResource getUserClientRoleMappingsResource(@PathParam(value="client-id") @Parameter(description="client id (not clientId!)") String client) {
        ClientModel clientModel = this.realm.getClientById(client);
        if (clientModel == null) {
            throw new NotFoundException("Client not found");
        }
        ClientRoleMappingsResource resource = new ClientRoleMappingsResource((UriInfo)this.session.getContext().getUri(), this.session, this.realm, this.auth, this.roleMapper, clientModel, this.adminEvent, this.managePermission, this.viewPermission);
        return resource;
    }
}

