/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action;

import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.UnicodeUtil;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.VersionType;

@PublicApi(since="1.0.0")
public interface DocWriteRequest<T>
extends IndicesRequest,
Accountable {
    public static final String REQUIRE_ALIAS = "require_alias";

    public T index(String var1);

    public String index();

    public String id();

    @Override
    public IndicesOptions indicesOptions();

    public T routing(String var1);

    public String routing();

    public long version();

    public T version(long var1);

    public VersionType versionType();

    public T versionType(VersionType var1);

    public T setIfSeqNo(long var1);

    public T setIfPrimaryTerm(long var1);

    public long ifSeqNo();

    public long ifPrimaryTerm();

    public OpType opType();

    public boolean isRequireAlias();

    public static DocWriteRequest<?> readDocumentRequest(@Nullable ShardId shardId, StreamInput in) throws IOException {
        ActionRequest docWriteRequest;
        byte type = in.readByte();
        if (type == 0) {
            docWriteRequest = new IndexRequest(shardId, in);
        } else if (type == 1) {
            docWriteRequest = new DeleteRequest(shardId, in);
        } else if (type == 2) {
            docWriteRequest = new UpdateRequest(shardId, in);
        } else {
            throw new IllegalStateException("invalid request type [" + type + " ]");
        }
        return docWriteRequest;
    }

    public static ActionRequestValidationException validateDocIdLength(String id, ActionRequestValidationException validationException) {
        int docIdLength;
        if (id != null && (docIdLength = UnicodeUtil.calcUTF16toUTF8Length((CharSequence)id, (int)0, (int)id.length())) > 512) {
            return ValidateActions.addValidationError("id [" + id + "] is too long, must be no longer than 512 bytes but was: " + docIdLength, validationException);
        }
        return validationException;
    }

    public static void writeDocumentRequest(StreamOutput out, DocWriteRequest<?> request) throws IOException {
        if (request instanceof IndexRequest) {
            out.writeByte((byte)0);
            ((IndexRequest)request).writeTo(out);
        } else if (request instanceof DeleteRequest) {
            out.writeByte((byte)1);
            ((DeleteRequest)request).writeTo(out);
        } else if (request instanceof UpdateRequest) {
            out.writeByte((byte)2);
            ((UpdateRequest)request).writeTo(out);
        } else {
            throw new IllegalStateException("invalid request [" + request.getClass().getSimpleName() + " ]");
        }
    }

    public static void writeDocumentRequestThin(StreamOutput out, DocWriteRequest<?> request) throws IOException {
        if (request instanceof IndexRequest) {
            out.writeByte((byte)0);
            ((IndexRequest)request).writeThin(out);
        } else if (request instanceof DeleteRequest) {
            out.writeByte((byte)1);
            ((DeleteRequest)request).writeThin(out);
        } else if (request instanceof UpdateRequest) {
            out.writeByte((byte)2);
            ((UpdateRequest)request).writeThin(out);
        } else {
            throw new IllegalStateException("invalid request [" + request.getClass().getSimpleName() + " ]");
        }
    }

    public static ActionRequestValidationException validateSeqNoBasedCASParams(DocWriteRequest request, ActionRequestValidationException validationException) {
        long version = request.version();
        VersionType versionType = request.versionType();
        if (!versionType.validateVersionForWrites(version)) {
            validationException = ValidateActions.addValidationError("illegal version value [" + version + "] for version type [" + versionType.name() + "]", validationException);
        }
        if (versionType == VersionType.INTERNAL && version != -3L && version != -4L) {
            validationException = ValidateActions.addValidationError("internal versioning can not be used for optimistic concurrency control. Please use `if_seq_no` and `if_primary_term` instead", validationException);
        }
        if (request.ifSeqNo() != -2L && (versionType != VersionType.INTERNAL || version != -3L)) {
            validationException = ValidateActions.addValidationError("compare and write operations can not use versioning", validationException);
        }
        if (request.ifPrimaryTerm() == 0L && request.ifSeqNo() != -2L) {
            validationException = ValidateActions.addValidationError("ifSeqNo is set, but primary term is [0]", validationException);
        }
        if (request.ifPrimaryTerm() != 0L && request.ifSeqNo() == -2L) {
            validationException = ValidateActions.addValidationError("ifSeqNo is unassigned, but primary term is [" + request.ifPrimaryTerm() + "]", validationException);
        }
        return validationException;
    }

    @PublicApi(since="1.0.0")
    public static enum OpType {
        INDEX(0),
        CREATE(1),
        UPDATE(2),
        DELETE(3);

        private final byte op;
        private final String lowercase;

        private OpType(int op) {
            this.op = (byte)op;
            this.lowercase = this.toString().toLowerCase(Locale.ROOT);
        }

        public byte getId() {
            return this.op;
        }

        public String getLowercase() {
            return this.lowercase;
        }

        public static OpType fromId(byte id) {
            switch (id) {
                case 0: {
                    return INDEX;
                }
                case 1: {
                    return CREATE;
                }
                case 2: {
                    return UPDATE;
                }
                case 3: {
                    return DELETE;
                }
            }
            throw new IllegalArgumentException("Unknown opType: [" + id + "]");
        }

        public static OpType fromString(String sOpType) {
            String lowerCase = sOpType.toLowerCase(Locale.ROOT);
            for (OpType opType : OpType.values()) {
                if (!opType.getLowercase().equals(lowerCase)) continue;
                return opType;
            }
            throw new IllegalArgumentException("Unknown opType: [" + sOpType + "]");
        }
    }
}

