"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiRelativeTab", {
  enumerable: true,
  get: function get() {
    return _relative_tab.EuiRelativeTab;
  }
});
exports.OuiRelativeTab = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _datemath = _interopRequireDefault(require("@opensearch/datemath"));

var _to_case = require("../../../../services/string/to_case");

var _services = require("../../../../services");

var _flex = require("../../../flex");

var _form = require("../../../form");

var _spacer = require("../../../spacer");

var _time_units = require("../time_units");

var _relative_options = require("../relative_options");

var _relative_utils = require("../relative_utils");

var _accessibility = require("../../../accessibility");

var _i18n = require("../../../i18n");

var _relative_tab = require("../../../../eui_components/date_picker/super_date_picker/date_popover/relative_tab");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } } /*
                                                                                                                                                                                                                                                                                                                                      * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                                      *
                                                                                                                                                                                                                                                                                                                                      * The OpenSearch Contributors require contributions made to
                                                                                                                                                                                                                                                                                                                                      * this file be licensed under the Apache-2.0 license or a
                                                                                                                                                                                                                                                                                                                                      * compatible open source license.
                                                                                                                                                                                                                                                                                                                                      *
                                                                                                                                                                                                                                                                                                                                      * Modifications Copyright OpenSearch Contributors. See
                                                                                                                                                                                                                                                                                                                                      * GitHub history for details.
                                                                                                                                                                                                                                                                                                                                      */ /*
                                                                                                                                                                                                                                                                                                                                          * Licensed to Elasticsearch B.V. under one or more contributor
                                                                                                                                                                                                                                                                                                                                          * license agreements. See the NOTICE file distributed with
                                                                                                                                                                                                                                                                                                                                          * this work for additional information regarding copyright
                                                                                                                                                                                                                                                                                                                                          * ownership. Elasticsearch B.V. licenses this file to you under
                                                                                                                                                                                                                                                                                                                                          * the Apache License, Version 2.0 (the "License"); you may
                                                                                                                                                                                                                                                                                                                                          * not use this file except in compliance with the License.
                                                                                                                                                                                                                                                                                                                                          * You may obtain a copy of the License at
                                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                                          *    http://www.apache.org/licenses/LICENSE-2.0
                                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                                          * Unless required by applicable law or agreed to in writing,
                                                                                                                                                                                                                                                                                                                                          * software distributed under the License is distributed on an
                                                                                                                                                                                                                                                                                                                                          * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
                                                                                                                                                                                                                                                                                                                                          * KIND, either express or implied.  See the License for the
                                                                                                                                                                                                                                                                                                                                          * specific language governing permissions and limitations
                                                                                                                                                                                                                                                                                                                                          * under the License.
                                                                                                                                                                                                                                                                                                                                          */

// eslint-disable-line import/named
var OuiRelativeTab = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(OuiRelativeTab, _Component);

  var _super = _createSuper(OuiRelativeTab);

  function OuiRelativeTab() {
    var _this;

    (0, _classCallCheck2.default)(this, OuiRelativeTab);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", _objectSpread(_objectSpread({}, (0, _relative_utils.parseRelativeParts)(_this.props.value)), {}, {
      sentenceCasedPosition: (0, _to_case.toSentenceCase)(_this.props.position)
    }));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "generateId", (0, _services.htmlIdGenerator)());
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onCountChange", function (event) {
      var sanitizedValue = parseInt(event.target.value, 10);

      _this.setState({
        count: isNaN(sanitizedValue) ? undefined : sanitizedValue
      }, _this.handleChange);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onUnitChange", function (event) {
      _this.setState({
        unit: event.target.value
      }, _this.handleChange);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onRoundChange", function (event) {
      _this.setState({
        round: event.target.checked
      }, _this.handleChange);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleChange", function () {
      var _this$state = _this.state,
          count = _this$state.count,
          round = _this$state.round,
          roundUnit = _this$state.roundUnit,
          unit = _this$state.unit;
      var onChange = _this.props.onChange;

      if (count === undefined || count < 0) {
        return;
      }

      var date = (0, _relative_utils.toRelativeStringFromParts)({
        count: count,
        round: round,
        roundUnit: roundUnit,
        unit: unit
      });
      onChange(date);
    });
    return _this;
  }

  (0, _createClass2.default)(OuiRelativeTab, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$state2 = this.state,
          count = _this$state2.count,
          unit = _this$state2.unit;
      var relativeDateInputNumberDescriptionId = this.generateId();
      var isInvalid = count === undefined || count < 0;

      var parsedValue = _datemath.default.parse(this.props.value, {
        roundUp: this.props.roundUp
      });

      var formatedValue = isInvalid || !parsedValue || !parsedValue.isValid() ? '' : parsedValue.locale(this.props.locale || 'en').format(this.props.dateFormat);
      return /*#__PURE__*/_react.default.createElement(_form.OuiForm, {
        className: "ouiDatePopoverContent__padded"
      }, /*#__PURE__*/_react.default.createElement(_flex.OuiFlexGroup, {
        gutterSize: "s",
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_flex.OuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
        tokens: ['ouiRelativeTab.numberInputError', 'ouiRelativeTab.numberInputLabel'],
        defaults: ['Must be >= 0', 'Time span amount']
      }, function (_ref) {
        var _ref2 = (0, _slicedToArray2.default)(_ref, 2),
            numberInputError = _ref2[0],
            numberInputLabel = _ref2[1];

        return /*#__PURE__*/_react.default.createElement(_form.OuiFormRow, {
          isInvalid: isInvalid,
          error: isInvalid ? numberInputError : null
        }, /*#__PURE__*/_react.default.createElement(_form.OuiFieldNumber, {
          compressed: true,
          "aria-label": numberInputLabel,
          "aria-describedby": relativeDateInputNumberDescriptionId,
          "data-test-subj": 'superDatePickerRelativeDateInputNumber',
          value: count,
          onChange: _this2.onCountChange,
          isInvalid: isInvalid
        }));
      })), /*#__PURE__*/_react.default.createElement(_flex.OuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
        token: "ouiRelativeTab.unitInputLabel",
        default: "Relative time span"
      }, function (unitInputLabel) {
        return /*#__PURE__*/_react.default.createElement(_form.OuiSelect, {
          compressed: true,
          "aria-label": unitInputLabel,
          "data-test-subj": 'superDatePickerRelativeDateInputUnitSelector',
          value: unit,
          options: _relative_options.relativeOptions,
          onChange: _this2.onUnitChange
        });
      }))), /*#__PURE__*/_react.default.createElement(_spacer.OuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
        token: "ouiRelativeTab.roundingLabel",
        default: "Round to the {unit}",
        values: {
          unit: _time_units.timeUnits[unit.substring(0, 1)]
        }
      }, function (roundingLabel) {
        return /*#__PURE__*/_react.default.createElement(_form.OuiSwitch, {
          "data-test-subj": 'superDatePickerRelativeDateRoundSwitch',
          label: roundingLabel,
          checked: _this2.state.round,
          onChange: _this2.onRoundChange
        });
      }), /*#__PURE__*/_react.default.createElement(_spacer.OuiSpacer, {
        size: "m"
      }), /*#__PURE__*/_react.default.createElement(_form.OuiFieldText, {
        compressed: true,
        value: formatedValue,
        readOnly: true,
        prepend: /*#__PURE__*/_react.default.createElement(_form.OuiFormLabel, null, /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
          token: "ouiRelativeTab.relativeDate",
          default: "{position} date",
          values: {
            position: this.state.sentenceCasedPosition
          }
        }))
      }), /*#__PURE__*/_react.default.createElement(_accessibility.OuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("p", {
        id: relativeDateInputNumberDescriptionId
      }, /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
        token: "ouiRelativeTab.fullDescription",
        default: "The unit is changeable. Currently set to {unit}.",
        values: {
          unit: unit
        }
      }))));
    }
  }]);
  return OuiRelativeTab;
}(_react.Component);
/* OUI -> EUI Aliases: Build-Time */


exports.OuiRelativeTab = OuiRelativeTab;
OuiRelativeTab.propTypes = {
  dateFormat: _propTypes.default.string.isRequired,
  locale: _propTypes.default.any,
  value: _propTypes.default.string.isRequired,
  onChange: _propTypes.default.func.isRequired,
  roundUp: _propTypes.default.bool,
  position: _propTypes.default.oneOf(["start", "end"]).isRequired
};
/* OUI -> EUI Aliases: Build-Time */