/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.nio;

import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.opensearch.nio.NioChannel;
import org.opensearch.nio.ServerChannelContext;

public class NioServerSocketChannel
extends NioChannel {
    private final ServerSocketChannel serverSocketChannel;
    private final AtomicBoolean contextSet = new AtomicBoolean(false);
    private volatile InetSocketAddress localAddress;
    private ServerChannelContext context;

    public NioServerSocketChannel(ServerSocketChannel serverSocketChannel) {
        this.serverSocketChannel = serverSocketChannel;
    }

    public void setContext(ServerChannelContext context) {
        if (!this.contextSet.compareAndSet(false, true)) {
            throw new IllegalStateException("Context on this channel were already set. It should only be once.");
        }
        this.context = context;
    }

    public void addBindListener(BiConsumer<Void, Exception> listener) {
        this.context.addBindListener(listener);
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        this.attemptToSetLocalAddress();
        return this.localAddress;
    }

    @Override
    public ServerSocketChannel getRawChannel() {
        return this.serverSocketChannel;
    }

    public ServerChannelContext getContext() {
        return this.context;
    }

    public String toString() {
        return "NioServerSocketChannel{localAddress=" + String.valueOf(this.getLocalAddress()) + "}";
    }

    private void attemptToSetLocalAddress() {
        if (this.localAddress == null) {
            this.localAddress = (InetSocketAddress)this.serverSocketChannel.socket().getLocalSocketAddress();
        }
    }
}

