module completions {

  def "nu-complete satty initial_tool" [] {
    [ "pointer" "crop" "line" "arrow" "rectangle" "ellipse" "text" "marker" "blur" "highlight" "brush" ]
  }

  def "nu-complete satty action_on_enter" [] {
    [ "save-to-clipboard" "save-to-file" ]
  }

  def "nu-complete satty primary_highlighter" [] {
    [ "block" "freehand" ]
  }

  # Modern Screenshot Annotation. A Screenshot Annotation Tool inspired by Swappy and Flameshot.
  export extern satty [
    --config(-c): string      # Path to the config file. Otherwise will be read from XDG_CONFIG_DIR/satty/config.toml
    --filename(-f): string    # Path to input image or '-' to read from stdin
    --fullscreen              # Start Satty in fullscreen mode
    --output-filename(-o): string # Filename to use for saving action. Omit to disable saving to file. Might contain format specifiers: <https://docs.rs/chrono/latest/chrono/format/strftime/index.html>
    --early-exit              # Exit directly after copy/save action
    --corner-roundness: string # Draw corners of rectangles round if the value is greater than 0 (Defaults to 12) (0 disables rounded corners)
    --initial-tool: string@"nu-complete satty initial_tool" # Select the tool on startup
    --init-tool: string@"nu-complete satty initial_tool" # Select the tool on startup
    --copy-command: string    # Configure the command to be called on copy, for example `wl-copy`
    --annotation-size-factor: string # Increase or decrease the size of the annotations
    --action-on-enter: string@"nu-complete satty action_on_enter" # Action to perform when pressing Enter
    --save-after-copy         # After copying the screenshot, save it to a file as well
    --right-click-copy        # Right click to copy
    --default-hide-toolbars(-d) # Hide toolbars by default
    --font-family: string     # Font family to use for text annotations
    --font-style: string      # Font style to use for text annotations
    --primary-highlighter: string@"nu-complete satty primary_highlighter" # The primary highlighter to use, secondary is accessible with CTRL
    --disable-notifications   # Disable notifications
    --profile-startup         # print profiling
    --help(-h)                # Print help
    --version(-V)             # Print version
  ]

}

export use completions *
