/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.chatgpt;

import com.theokanning.openai.completion.chat.ChatCompletionChoice;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatCompletionResult;
import com.theokanning.openai.completion.chat.ChatFunctionCall;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.completion.chat.ChatMessageRole;
import com.theokanning.openai.service.FunctionExecutor;
import com.theokanning.openai.service.OpenAiService;
import java.sql.Connection;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.Catalog;
import schemacrawler.tools.command.chatgpt.FunctionReturn;
import schemacrawler.tools.command.chatgpt.embeddings.QueryService;
import schemacrawler.tools.command.chatgpt.options.ChatGPTCommandOptions;
import schemacrawler.tools.command.chatgpt.utility.ChatGPTUtility;
import schemacrawler.tools.command.chatgpt.utility.ChatHistory;
import us.fatehi.utility.string.StringFormat;

public final class ChatGPTConsole
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(ChatGPTConsole.class.getCanonicalName());
    private static final String PROMPT = String.format("%nPrompt: ", new Object[0]);
    private final ChatGPTCommandOptions commandOptions;
    private final FunctionExecutor functionExecutor;
    private final OpenAiService service;
    private final QueryService queryService;
    private final ChatHistory chatHistory;
    private final boolean useMetadata;

    public ChatGPTConsole(ChatGPTCommandOptions commandOptions, Catalog catalog, Connection connection) {
        this.commandOptions = Objects.requireNonNull(commandOptions, "ChatGPT options not provided");
        Objects.requireNonNull(catalog, "No catalog provided");
        Objects.requireNonNull(connection, "No connection provided");
        this.functionExecutor = ChatGPTUtility.newFunctionExecutor(catalog, connection);
        Duration timeout = Duration.ofSeconds(commandOptions.getTimeout());
        this.service = new OpenAiService(commandOptions.getApiKey(), timeout);
        this.queryService = new QueryService(this.service);
        this.queryService.addTables(catalog.getTables());
        this.useMetadata = commandOptions.isUseMetadata();
        this.chatHistory = new ChatHistory(commandOptions.getContext(), new ArrayList<ChatMessage>());
    }

    @Override
    public void close() {
        this.service.shutdownExecutor();
    }

    public void console() {
        try (Scanner scanner = new Scanner(System.in);){
            while (true) {
                System.out.print(PROMPT);
                String prompt = scanner.nextLine();
                List<ChatMessage> completions = this.complete(prompt);
                ChatGPTUtility.printResponse(completions, System.out);
                if (!ChatGPTUtility.isExitCondition(completions)) continue;
                return;
            }
        }
    }

    private List<ChatMessage> complete(String prompt) {
        ArrayList<ChatMessage> completions = new ArrayList<ChatMessage>();
        try {
            ChatMessage userMessage = new ChatMessage(ChatMessageRole.USER.value(), prompt);
            this.chatHistory.add(userMessage);
            List<ChatMessage> messages = this.chatHistory.toList();
            if (this.useMetadata) {
                Collection<ChatMessage> chatMessages = this.queryService.query(prompt);
                messages.addAll(chatMessages);
            }
            ChatCompletionRequest completionRequest = ChatCompletionRequest.builder().messages(messages).functions(this.functionExecutor.getFunctions()).functionCall(new ChatCompletionRequest.ChatCompletionRequestFunctionCall("auto")).model(this.commandOptions.getModel()).n(Integer.valueOf(1)).build();
            this.logChatRequest(completionRequest.getMessages(), completionRequest.getFunctions());
            ChatCompletionResult chatCompletion = this.service.createChatCompletion(completionRequest);
            LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Token usage: %s", new Object[]{chatCompletion.getUsage()}));
            ChatMessage responseMessage = ((ChatCompletionChoice)chatCompletion.getChoices().get(0)).getMessage();
            this.chatHistory.add(responseMessage);
            ChatFunctionCall functionCall = responseMessage.getFunctionCall();
            if (functionCall != null) {
                FunctionReturn functionReturn = (FunctionReturn)this.functionExecutor.execute(functionCall);
                ChatMessage functionResponseMessage = new ChatMessage(ChatMessageRole.FUNCTION.value(), (String)functionReturn.get(), functionCall.getName(), functionCall);
                completions.add(functionResponseMessage);
            } else {
                completions.add(responseMessage);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, e.getMessage(), e);
            ChatMessage exceptionMessage = this.functionExecutor.convertExceptionToMessage(e);
            completions.add(exceptionMessage);
        }
        return completions;
    }

    private void logChatRequest(List<ChatMessage> messages, List<?> functions) {
        Level level = Level.CONFIG;
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("ChatGPT request:").append(System.lineSeparator());
        if (messages != null) {
            for (ChatMessage message : messages) {
                buffer.append(message).append(System.lineSeparator());
            }
        }
        if (functions != null) {
            for (Object function : functions) {
                buffer.append(function).append(System.lineSeparator());
            }
        }
        LOGGER.log(level, buffer.toString());
    }
}

