/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.serialize.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import schemacrawler.tools.command.serialize.model.TableDocument;

@JsonNaming(value=PropertyNamingStrategies.KebabCaseStrategy.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"databaseProductName", "tables"})
public final class CatalogDocument
implements Serializable {
    private static final long serialVersionUID = -1937966351313941597L;
    private final List<TableDocument> tables = new ArrayList<TableDocument>();
    private final String databaseProductName;

    public CatalogDocument(String databaseProductName) {
        this.databaseProductName = databaseProductName;
    }

    public void addTable(TableDocument table) {
        if (table != null) {
            this.tables.add(table);
        }
    }

    @JsonProperty(value="db")
    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    @JsonProperty(value="tables")
    public List<TableDocument> getTables() {
        return this.tables;
    }

    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return super.toString();
        }
    }
}

