/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.template;

import java.util.HashMap;
import java.util.Objects;
import schemacrawler.schemacrawler.exceptions.InternalRuntimeException;
import schemacrawler.tools.command.template.TemplateRenderer;
import schemacrawler.tools.command.template.options.TemplateLanguageType;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.options.LanguageOptions;

public final class TemplateCommand
extends BaseSchemaCrawlerCommand<LanguageOptions> {
    static final String COMMAND = "template";

    public TemplateCommand() {
        super(COMMAND);
    }

    public void checkAvailability() {
    }

    public void execute() {
        Objects.requireNonNull((LanguageOptions)this.commandOptions, "No template language provided");
        this.checkCatalog();
        TemplateLanguageType languageType = TemplateLanguageType.valueOf(((LanguageOptions)this.commandOptions).getLanguage());
        TemplateRenderer templateRenderer = this.newTemplateRenderer(languageType);
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("title", this.outputOptions.getTitle());
        context.put("catalog", this.catalog);
        context.put("identifiers", this.identifiers);
        templateRenderer.setResourceFilename(((LanguageOptions)this.commandOptions).getScript());
        templateRenderer.setContext(context);
        templateRenderer.setOutputOptions(this.outputOptions);
        templateRenderer.execute();
    }

    public boolean usesConnection() {
        return true;
    }

    private TemplateRenderer newTemplateRenderer(TemplateLanguageType languageType) {
        try {
            String templateRendererClassName = languageType.getTemplateRendererClassName();
            Class<?> templateRendererClass = Class.forName(templateRendererClassName);
            TemplateRenderer templateRenderer = (TemplateRenderer)templateRendererClass.newInstance();
            return templateRenderer;
        }
        catch (Exception e) {
            throw new InternalRuntimeException(String.format("Could not instantiate template renderer for <%s>", new Object[]{languageType}), (Throwable)e);
        }
    }
}

