/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.registry;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.tools.registry.PluginRegistry;
import us.fatehi.utility.property.PropertyName;

public abstract class BasePluginRegistry
implements PluginRegistry {
    private static final Logger LOGGER = Logger.getLogger(BasePluginRegistry.class.getName());

    @Override
    public void log() {
        boolean log = LOGGER.isLoggable(Level.CONFIG);
        if (!log) {
            return;
        }
        int index = 0;
        StringBuilder buffer = new StringBuilder(1024);
        try {
            int maxNameLength = 0;
            Collection<PropertyName> registeredPlugins = this.getRegisteredPlugins();
            for (PropertyName registeredPlugin : registeredPlugins) {
                int length = registeredPlugin.getName().length();
                if (length <= maxNameLength) continue;
                maxNameLength = length;
            }
            String format = String.format("%%2d %%%ds %%s", maxNameLength);
            buffer.append("Registered ").append(this.getName()).append(":").append(System.lineSeparator());
            for (PropertyName registeredPlugin : registeredPlugins) {
                buffer.append(String.format(format, ++index, registeredPlugin.getName(), registeredPlugin.getDescription())).append(System.lineSeparator());
            }
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARNING, "Could not list " + this.getName(), e);
        }
        LOGGER.log(Level.CONFIG, buffer.toString());
    }
}

