/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.db.db2;

import com.ibm.db2.cmx.runtime.HeterogeneousBatchKind;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.Configuration;
import com.ibm.db2.cmx.runtime.internal.db.JdbcData;
import com.ibm.db2.cmx.runtime.internal.db.db2.HeterogeneousBatchControl;
import com.ibm.db2.cmx.runtime.internal.db.db2.PDQConnectionCallbackImpl;
import com.ibm.db2.cmx.runtime.internal.metadata.StatementDescriptorImpl;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.statement.Hook;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.cmx.runtime.statement.StatementDescriptor;
import com.ibm.db2.jcc.DB2CallableStatement;
import com.ibm.db2.jcc.DB2PreparedStatement;
import com.ibm.db2.jcc.DB2Statement;
import com.ibm.db2.jcc.DB2Wrapper;
import com.ibm.db2.jcc.DBHeterogeneousBatchUpdateException;
import com.ibm.db2.jcc.PDQCallbackRegistry;
import com.ibm.db2.jcc.PDQConnection;
import java.lang.reflect.Method;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;

public class DB2JdbcData
extends JdbcData {
    protected PDQConnection pdqConnection_;
    protected DB2Statement jccStmt_;
    protected DB2PreparedStatement jccPstmt_;
    protected DB2CallableStatement jccCallStmt_;
    protected boolean getJccStmtViaCallback_;
    protected boolean callbackTriggered_;
    public boolean isStaticExecution_ = false;
    protected ConnectionType connectionType_;
    protected HeterogeneousBatchControl heteroBatchControl_;
    protected StatementDescriptorImpl currStatementDescriptor_;
    protected boolean isLUW_;

    public DB2JdbcData(Connection connection, Hook hook, Map<Object, Object> map, Integer n2, Integer n3, DatabaseMetaData databaseMetaData) {
        super(connection, hook, map, n2, n3, databaseMetaData);
        this.checkAndSetConnectionType(connection);
        try {
            this.isLUW_ = databaseMetaData.getDatabaseProductVersion().charAt(0) == 'S';
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.connectionType_ == ConnectionType.UNKNOWNCONNECTION) {
            PDQCallbackRegistry.registerConnectionCallback(PDQConnectionCallbackImpl.pdqConnectionCallbackInstance_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerCallback() {
        boolean bl2 = false;
        switch (this.connectionType_) {
            case DB2WRAPPER: {
                Connection connection = this.connection_;
                synchronized (connection) {
                    this.pdqConnection_ = this.unwrapDB2WrapperForPDQConnection((DB2Wrapper)((Object)this.connection_));
                    if (this.pdqConnection_ == null) {
                        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_UNWRAP_CONN", new Object[0]), null, 10360);
                    }
                    try {
                        this.pdqConnection_.registerConnectionCallback(PDQConnectionCallbackImpl.pdqConnectionCallbackInstance_);
                        PDQConnectionCallbackImpl.threadLocalContext_.set(this);
                        bl2 = true;
                        DataLogger.logInfo(this.logger_, this, "registerCallback", "DB2Wrapper");
                    }
                    catch (SQLException sQLException) {
                        bl2 = false;
                    }
                    break;
                }
            }
            case PDQCONNECTION: {
                this.pdqConnection_ = (PDQConnection)((Object)this.connection_);
                if (this.pdqConnection_ != null) break;
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_UNWRAP_CONN", new Object[0]), null, 10361);
            }
            default: {
                PDQConnectionCallbackImpl.threadLocalContext_.set(this);
                this.pdqConnection_ = null;
            }
        }
        return bl2;
    }

    protected PDQConnection unwrapDB2WrapperForPDQConnection(DB2Wrapper dB2Wrapper) {
        if (dB2Wrapper instanceof PDQConnection) {
            return (PDQConnection)((Object)dB2Wrapper);
        }
        try {
            Object object = dB2Wrapper.getDB2Object();
            while (!(object instanceof PDQConnection) && object instanceof DB2Wrapper) {
                object = ((DB2Wrapper)object).getDB2Object();
            }
            return (PDQConnection)object;
        }
        catch (ClassCastException classCastException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_DB2_PDQ_CONN", new Object[0]), classCastException, 10231);
        }
    }

    private void checkAndSetConnectionType(Connection connection) {
        this.connectionType_ = connection instanceof DB2Wrapper ? ConnectionType.DB2WRAPPER : (connection instanceof PDQConnection ? ConnectionType.PDQCONNECTION : ConnectionType.UNKNOWNCONNECTION);
        DataLogger.logInfo(this.logger_, this, "checkAndSetConnectionType", "connectionType_", new Object[]{this.connectionType_});
    }

    @Override
    protected void addToHeteroBatch(PreparedStatement preparedStatement) {
        this.heteroBatchControl_.wrappedPstmtList_.add(preparedStatement);
        this.heteroBatchControl_.jccPstmtList_.add(this.jccPstmt_);
        DataLogger.logInfo(this.logger_, this, "addToHeteroBatch", "add pstmt, jccPstmt_ to List", preparedStatement, this.jccPstmt_);
    }

    @Override
    protected boolean registerCallbackIfHeteroBatch() {
        boolean bl2 = false;
        if (this.isHeteroBatch_) {
            bl2 = this.registerCallback();
            this.getJccStmtViaCallback_ = true;
        } else {
            this.getJccStmtViaCallback_ = false;
        }
        this.callbackTriggered_ = false;
        return bl2;
    }

    @Override
    protected void deregisterCallbackIfHeteroBatch() {
        try {
            this.getJccStmtViaCallback_ = false;
            PDQConnectionCallbackImpl.threadLocalContext_.remove();
            this.pdqConnection_.deregisterConnectionCallback();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    protected void chkCallbackTriggered(PreparedStatement preparedStatement) throws SQLException {
        if (!this.callbackTriggered_) {
            switch (this.connectionType_) {
                case PDQCONNECTION: {
                    this.jccPstmt_ = (DB2PreparedStatement)preparedStatement;
                    break;
                }
                case DB2WRAPPER: 
                case UNKNOWNCONNECTION: {
                    preparedStatement.clearBatch();
                }
            }
            DataLogger.logInfo(this.logger_, this, "chkCallbackTriggered", "no callback, jccPstmt_ now", this.jccPstmt_);
        }
    }

    @Override
    public void setConnection(Connection connection) {
        super.setConnection(connection);
        this.checkAndSetConnectionType(connection);
    }

    public ArrayList<DB2PreparedStatement> getListOfHeteroBatchStmts() {
        return this.heteroBatchControl_.jccPstmtList_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[][] endBatch() {
        int[][] nArray = null;
        if (this.logger_.isLoggable(Level.FINER)) {
            DataLogger.enter(this.logger_, this, "endBatch");
        }
        try {
            if (!this.isHeteroBatch_ || this.heteroBatchControl_ == null) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_BATCH_NO_STARTBATCH", new Object[0]), null, 10362);
            }
            if (this.heteroBatchControl_.jccPstmtList_.size() == 0) {
                int[][] nArray2 = new int[0][0];
                return nArray2;
            }
            try {
                this.heteroBatchControl_.heteroBatchJccStmt_.addDBBatch(this.heteroBatchControl_.jccPstmtList_);
                PDQConnectionCallbackImpl.threadLocalContext_.set(this);
            }
            catch (SQLException sQLException) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_BATCH_INVALID_STMTS", new Object[0]), sQLException, 10369);
            }
            try {
                this.heteroBatchControl_.heteroBatchStmt_.executeBatch();
            }
            catch (BatchUpdateException batchUpdateException) {
                nArray = ((DBHeterogeneousBatchUpdateException)((Object)batchUpdateException)).getHeterogeneousBatchUpdateCounts();
                throw ExceptionFactory.createUpdateManyExceptionForRuntimeOnly(this, Messages.getText("ERR_BATCH_ERROR_EXECUTING", new Object[0]), batchUpdateException, 10363, null, nArray);
            }
            catch (SQLException sQLException) {
                try {
                    nArray = this.heteroBatchControl_.heteroBatchJccStmt_.getHeterogeneousBatchUpdateCounts();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                throw ExceptionFactory.createUpdateManyExceptionForRuntimeOnly(this, Messages.getText("ERR_BATCH_ERROR_EXECUTING", new Object[0]), sQLException, 10364, null, nArray);
            }
            finally {
                PDQConnectionCallbackImpl.threadLocalContext_.remove();
            }
            try {
                nArray = this.heteroBatchControl_.heteroBatchJccStmt_.getHeterogeneousBatchUpdateCounts();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            int[][] nArray3 = nArray;
            return nArray3;
        }
        finally {
            this.defaultCleanUpForHeteroBatch();
            if (this.logger_.isLoggable(Level.FINER)) {
                DataLogger.exit(this.logger_, this, "endBatch", nArray);
            }
        }
    }

    private void defaultCleanUpForHeteroBatch() {
        PDQConnectionCallbackImpl.threadLocalContext_.remove();
        if (this.isHeteroBatch_ && this.heteroBatchControl_ != null) {
            this.cleanHeteroBatch();
            if (this.heteroBatchControl_.heteroBatchStmt_ != null) {
                try {
                    this.heteroBatchControl_.heteroBatchStmt_.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.heteroBatchControl_.heteroBatchStmt_ = null;
            this.heteroBatchControl_.heteroBatchJccStmt_ = null;
            this.heteroBatchControl_.currHeteroBatchKind_ = HeterogeneousBatchKind.heterogeneousNone__;
        }
        this.pdqConnection_ = null;
        this.getJccStmtViaCallback_ = false;
        this.isHeteroBatch_ = false;
    }

    @Override
    public void cancelBatch() {
        if (this.logger_.isLoggable(Level.FINER)) {
            DataLogger.enter(this.logger_, this, "cancelBatch");
        }
        this.defaultCleanUpForHeteroBatch();
        if (this.logger_.isLoggable(Level.FINER)) {
            DataLogger.exit(this.logger_, this, "cancelBatch", null);
        }
    }

    @Override
    public HeterogeneousBatchKind getBatchKind() {
        HeterogeneousBatchKind heterogeneousBatchKind = HeterogeneousBatchKind.heterogeneousNone__;
        if (this.isHeteroBatch_ && this.heteroBatchControl_ != null) {
            heterogeneousBatchKind = this.heteroBatchControl_.currHeteroBatchKind_;
        }
        if (this.logger_.isLoggable(Level.FINER)) {
            DataLogger.exit(this.logger_, this, "getBatchKind", (Object)heterogeneousBatchKind);
        }
        return heterogeneousBatchKind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startBatch(HeterogeneousBatchKind heterogeneousBatchKind) {
        boolean bl2;
        block33: {
            if (!Configuration.isLicensed__) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_BATCH_LICENSE", new Object[0]), null, 10359);
            }
            bl2 = false;
            if (this.logger_.isLoggable(Level.FINER)) {
                DataLogger.enter(this.logger_, this, "startBatch(" + (Object)((Object)heterogeneousBatchKind) + ")");
            }
            boolean bl3 = this.registerCallback();
            try {
                if (this.heteroBatchControl_ == null) {
                    this.heteroBatchControl_ = new HeterogeneousBatchControl();
                    this.heteroBatchControl_.jccPstmtList_ = new ArrayList();
                    this.heteroBatchControl_.wrappedPstmtList_ = new ArrayList();
                    DataLogger.logInfo(this.logger_, this, "startBatch", "heteroBatchControl_ created");
                }
                if (this.isHeteroBatch_) {
                    this.cleanHeteroBatch();
                    throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_BATCH_ALREADY_IN_BATCH", new Object[0]), null, 10365);
                }
                if (heterogeneousBatchKind != HeterogeneousBatchKind.heterogeneousModify__) {
                    throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_BATCH_UNSUPPORTED_MODE", new Object[]{heterogeneousBatchKind}), null, 10366);
                }
                this.heteroBatchControl_.currHeteroBatchKind_ = heterogeneousBatchKind;
                try {
                    this.getJccStmtViaCallback_ = true;
                    this.callbackTriggered_ = false;
                    this.heteroBatchControl_.heteroBatchStmt_ = null;
                    this.heteroBatchControl_.heteroBatchStmt_ = this.connection_.createStatement();
                    if (this.logger_.isLoggable(Level.FINEST)) {
                        DataLogger.logInfo(this.logger_, this, "startBatch", "create heteroBatchStmt_, jccStmt_, getJccStmtViaCallback_", this.heteroBatchControl_.heteroBatchStmt_, this.jccStmt_, this.getJccStmtViaCallback_);
                    }
                    if (!this.callbackTriggered_) {
                        switch (this.connectionType_) {
                            case PDQCONNECTION: {
                                this.jccStmt_ = (DB2Statement)this.heteroBatchControl_.heteroBatchStmt_;
                                break;
                            }
                            case DB2WRAPPER: 
                            case UNKNOWNCONNECTION: {
                                this.heteroBatchControl_.heteroBatchStmt_.clearBatch();
                            }
                        }
                    }
                }
                catch (SQLException sQLException) {
                    throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_BATCH_NO_STMT", new Object[0]), sQLException, 10367);
                }
                this.heteroBatchControl_.heteroBatchJccStmt_ = this.jccStmt_;
                DataLogger.logInfo(this.logger_, this, "startBatch", "heteroBatchJccStmt_ is", this.heteroBatchControl_.heteroBatchJccStmt_);
                if (this.pdqConnection_ == null) {
                    throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(this, Messages.getText("ERR_UNWRAP_CONN", new Object[0]), null, 10368);
                }
                bl2 = true;
                if (!bl3 || this.pdqConnection_ == null) break block33;
            }
            catch (Throwable throwable) {
                if (bl3 && this.pdqConnection_ != null) {
                    try {
                        DataLogger.logInfo(this.logger_, this, "startBatch", "deregisterConnectionCallback");
                        this.pdqConnection_.deregisterConnectionCallback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (!bl2) {
                    DataLogger.logInfo(this.logger_, this, "startBatch", "startBatch failed, cleaning up");
                    this.pdqConnection_ = null;
                    if (this.heteroBatchControl_.heteroBatchStmt_ != null) {
                        try {
                            this.heteroBatchControl_.heteroBatchStmt_.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    this.heteroBatchControl_.heteroBatchStmt_ = null;
                }
                this.isHeteroBatch_ = bl2;
                PDQConnectionCallbackImpl.threadLocalContext_.remove();
                this.getJccStmtViaCallback_ = false;
                if (this.logger_.isLoggable(Level.FINER)) {
                    if (bl2) {
                        DataLogger.logInfo(this.logger_, this, "startBatch", " Success, connectionType_", new Object[]{this.connectionType_});
                    }
                    DataLogger.exit(this.logger_, this, "startBatch", null);
                }
                throw throwable;
            }
            try {
                DataLogger.logInfo(this.logger_, this, "startBatch", "deregisterConnectionCallback");
                this.pdqConnection_.deregisterConnectionCallback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (!bl2) {
            DataLogger.logInfo(this.logger_, this, "startBatch", "startBatch failed, cleaning up");
            this.pdqConnection_ = null;
            if (this.heteroBatchControl_.heteroBatchStmt_ != null) {
                try {
                    this.heteroBatchControl_.heteroBatchStmt_.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.heteroBatchControl_.heteroBatchStmt_ = null;
        }
        this.isHeteroBatch_ = bl2;
        PDQConnectionCallbackImpl.threadLocalContext_.remove();
        this.getJccStmtViaCallback_ = false;
        if (this.logger_.isLoggable(Level.FINER)) {
            if (bl2) {
                DataLogger.logInfo(this.logger_, this, "startBatch", " Success, connectionType_", new Object[]{this.connectionType_});
            }
            DataLogger.exit(this.logger_, this, "startBatch", null);
        }
    }

    private void cleanHeteroBatch() {
        this.isHeteroBatch_ = false;
        try {
            this.heteroBatchControl_.heteroBatchStmt_.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        for (PreparedStatement preparedStatement : this.heteroBatchControl_.wrappedPstmtList_) {
            if (this.logger_.isLoggable(Level.FINEST)) {
                DataLogger.logInfo(this.logger_, this, "cleanHeteroBatch", "closing pstmt", preparedStatement);
            }
            try {
                preparedStatement.close();
            }
            catch (SQLException sQLException) {}
        }
        this.heteroBatchControl_.wrappedPstmtList_.clear();
        this.heteroBatchControl_.jccPstmtList_.clear();
        DataLogger.logInfo(this.logger_, this, "cleanHeteroBatch", "Pstmt Lists cleared");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PreparedStatement getPreparedStatement(String string, String[] stringArray, StatementDescriptor statementDescriptor, boolean bl2) throws SQLException {
        boolean bl3 = false;
        PreparedStatement preparedStatement = null;
        this.ignoreAGK_ = stringArray == null;
        try {
            StatementDescriptorImpl statementDescriptorImpl = (StatementDescriptorImpl)statementDescriptor;
            String string2 = statementDescriptorImpl.getCursorName();
            bl3 = this.registerCallbackIfHeteroBatch();
            if (stringArray != null && !bl2) {
                this.storeMetadataCorrelatorForTransportToMonitorLayer(statementDescriptorImpl);
                SqlStatementType sqlStatementType = statementDescriptor.getSqlStatementType();
                if (sqlStatementType == SqlStatementType.UPDATE || sqlStatementType == SqlStatementType.DELETE || sqlStatementType == SqlStatementType.MERGE) {
                    DatabaseMetaData databaseMetaData;
                    String string3;
                    if (this.connection_.getAutoCommit() || statementDescriptorImpl.getCursorName() != null) {
                        this.ignoreAGK_ = true;
                    } else if (!this.isLUW_ && 8 > (string3 = (databaseMetaData = this.dbMetaData_).getDatabaseProductVersion()).length() && string3.charAt(0) == 'D') {
                        char c10 = string3.charAt(7);
                        int n2 = databaseMetaData.getDatabaseMajorVersion();
                        if (n2 == 8 || n2 == 9 && c10 < '\u0005' || n2 == 10 && c10 < '\u0002') {
                            this.ignoreAGK_ = true;
                        }
                    }
                }
                preparedStatement = this.ignoreAGK_ ? this.connection_.prepareStatement(string) : this.connection_.prepareStatement(string, stringArray);
            } else if (!bl2) {
                this.storeMetadataCorrelatorForTransportToMonitorLayer(statementDescriptorImpl);
                preparedStatement = this.connection_.prepareStatement(string);
            } else {
                this.storeMetadataCorrelatorForTransportToMonitorLayer(statementDescriptorImpl);
                preparedStatement = this.connection_.prepareStatement(string, statementDescriptorImpl.getType(), statementDescriptorImpl.getConcurrency(), statementDescriptorImpl.getHoldability());
                if (string2 != null && bl2) {
                    preparedStatement.setCursorName(string2);
                }
            }
            if (this.isHeteroBatch_) {
                this.chkCallbackTriggered(preparedStatement);
            }
        }
        finally {
            if (bl3) {
                this.deregisterCallbackIfHeteroBatch();
            }
        }
        this.applySQLSettingsToStatement(preparedStatement);
        if (this.logger_.isLoggable(Level.FINEST)) {
            DataLogger.logInfo(dynamicLogger__, this, "DB2JdbcData getPreparedStatement(String, String[], StatementDescriptor, boolean)", "input(4), pstmt", string, stringArray, statementDescriptor, bl2, preparedStatement);
        }
        return preparedStatement;
    }

    protected <T> T unwrap(Statement statement, Class<T> clazz) {
        Class<?> clazz2 = statement.getClass();
        try {
            Method method = DB2JdbcData.getMethodForClass(clazz2, "unwrap", Class.class);
            return (T)method.invoke((Object)statement, clazz);
        }
        catch (Exception exception) {
            this.logger_.log(Level.FINE, "Unable to unwrap " + clazz2.getCanonicalName() + " for " + clazz.getCanonicalName() + ". Error:" + exception.getMessage());
            return (T)statement;
        }
    }

    private static Method getMethodForClass(Class clazz, String string, Class ... classArray) throws NoSuchMethodException {
        return clazz.getMethod(string, classArray);
    }

    static enum ConnectionType {
        PDQCONNECTION,
        DB2WRAPPER,
        UNKNOWNCONNECTION;

    }
}

