/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.http;

import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.semconv.http.HttpSpanNameExtractorBuilder;
import java.util.Set;

public final class HttpSpanNameExtractor {
    public static <REQUEST> SpanNameExtractor<REQUEST> create(HttpClientAttributesGetter<REQUEST, ?> getter) {
        return HttpSpanNameExtractor.builder(getter).build();
    }

    public static <REQUEST> SpanNameExtractor<REQUEST> create(HttpServerAttributesGetter<REQUEST, ?> getter) {
        return HttpSpanNameExtractor.builder(getter).build();
    }

    public static <REQUEST> HttpSpanNameExtractorBuilder<REQUEST> builder(HttpClientAttributesGetter<REQUEST, ?> getter) {
        return new HttpSpanNameExtractorBuilder<REQUEST>(getter, null);
    }

    public static <REQUEST> HttpSpanNameExtractorBuilder<REQUEST> builder(HttpServerAttributesGetter<REQUEST, ?> getter) {
        return new HttpSpanNameExtractorBuilder<REQUEST>(null, getter);
    }

    private HttpSpanNameExtractor() {
    }

    static final class Server<REQUEST>
    implements SpanNameExtractor<REQUEST> {
        private final HttpServerAttributesGetter<REQUEST, ?> getter;
        private final Set<String> knownMethods;

        Server(HttpServerAttributesGetter<REQUEST, ?> getter, Set<String> knownMethods) {
            this.getter = getter;
            this.knownMethods = knownMethods;
        }

        @Override
        public String extract(REQUEST request) {
            String method = this.getter.getHttpRequestMethod(request);
            String route = this.getter.getHttpRoute(request);
            if (method == null) {
                return "HTTP";
            }
            if (!this.knownMethods.contains(method)) {
                method = "HTTP";
            }
            return route == null ? method : method + " " + route;
        }
    }

    static final class Client<REQUEST>
    implements SpanNameExtractor<REQUEST> {
        private final HttpClientAttributesGetter<REQUEST, ?> getter;
        private final Set<String> knownMethods;

        Client(HttpClientAttributesGetter<REQUEST, ?> getter, Set<String> knownMethods) {
            this.getter = getter;
            this.knownMethods = knownMethods;
        }

        @Override
        public String extract(REQUEST request) {
            String method = this.getter.getHttpRequestMethod(request);
            if (method == null || !this.knownMethods.contains(method)) {
                return "HTTP";
            }
            return method;
        }
    }
}

