/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.lint;

import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.tools.lint.BaseLinterProvider;
import us.fatehi.utility.IOUtility;
import us.fatehi.utility.string.StringFormat;

public final class LintUtility {
    public static final Logger LOGGER = Logger.getLogger(LintUtility.class.getName());

    public static <E> boolean listStartsWith(List<E> main, List<E> sub) {
        if (main == null || sub == null || main.size() < sub.size()) {
            return false;
        }
        if (main.isEmpty()) {
            return true;
        }
        return main.subList(0, sub.size()).equals(sub);
    }

    private LintUtility() {
    }

    public static String readDescription(String linterId) {
        String descriptionResource = String.format("/help/%s.txt", linterId);
        if (BaseLinterProvider.class.getResource(descriptionResource) == null) {
            LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Could not find description resource for linter {0}, at {1}", new Object[]{linterId}));
            return "";
        }
        String descriptionText = IOUtility.readResourceFully((String)descriptionResource);
        return descriptionText;
    }
}

