/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.internal.core.type.codec.registry.DefaultCodecRegistry;
import com.ing.data.cassandra.jdbc.AbstractConnection;
import com.ing.data.cassandra.jdbc.CassandraDatabaseMetaData;
import com.ing.data.cassandra.jdbc.CassandraPreparedStatement;
import com.ing.data.cassandra.jdbc.CassandraStatement;
import com.ing.data.cassandra.jdbc.SessionHolder;
import com.ing.data.cassandra.jdbc.codec.AbstractCodec;
import com.ing.data.cassandra.jdbc.codec.BigintToBigDecimalCodec;
import com.ing.data.cassandra.jdbc.codec.DecimalToDoubleCodec;
import com.ing.data.cassandra.jdbc.codec.FloatToDoubleCodec;
import com.ing.data.cassandra.jdbc.codec.IntToLongCodec;
import com.ing.data.cassandra.jdbc.codec.LongToIntCodec;
import com.ing.data.cassandra.jdbc.codec.SmallintToIntCodec;
import com.ing.data.cassandra.jdbc.codec.TimestampToLongCodec;
import com.ing.data.cassandra.jdbc.codec.TinyintToIntCodec;
import com.ing.data.cassandra.jdbc.codec.VarintToIntCodec;
import com.ing.data.cassandra.jdbc.optionset.Default;
import com.ing.data.cassandra.jdbc.optionset.OptionSet;
import com.ing.data.cassandra.jdbc.utils.JdbcUrlUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraConnection
extends AbstractConnection
implements Connection {
    public static volatile int dbMajorVersion = 2;
    public static volatile int dbMinorVersion = 1;
    public static volatile int dbPatchVersion = 0;
    protected static final int FALLBACK_FETCH_SIZE = 100;
    private static final Logger LOG = LoggerFactory.getLogger(CassandraConnection.class);
    private static final boolean AUTO_COMMIT_DEFAULT = true;
    protected String username;
    protected String url;
    private final SessionHolder sessionHolder;
    private final Session cSession;
    private final Properties connectionProperties;
    private final Metadata metadata;
    private final Set<Statement> statements = new ConcurrentSkipListSet<Statement>();
    private final ConcurrentMap<String, CassandraPreparedStatement> preparedStatements = new ConcurrentHashMap<String, CassandraPreparedStatement>();
    private final ConsistencyLevel defaultConsistencyLevel;
    private int defaultFetchSize = 100;
    private String currentKeyspace;
    private final boolean debugMode;
    private Properties clientInfo;
    private volatile boolean isClosed;
    private final OptionSet optionSet;

    CassandraConnection(SessionHolder sessionHolder) throws SQLException {
        this.sessionHolder = sessionHolder;
        Properties sessionProperties = sessionHolder.properties;
        DriverExecutionProfile defaultConfigProfile = sessionHolder.session.getContext().getConfig().getDefaultProfile();
        this.debugMode = Boolean.TRUE.toString().equals(sessionProperties.getProperty("debug", ""));
        this.connectionProperties = (Properties)sessionProperties.clone();
        this.clientInfo = new Properties();
        this.url = "jdbc:cassandra:".concat(JdbcUrlUtil.createSubName(sessionProperties));
        this.currentKeyspace = sessionProperties.getProperty("databaseName");
        this.optionSet = this.lookupOptionSet(sessionProperties.getProperty("complianceMode"));
        this.username = sessionProperties.getProperty("user", defaultConfigProfile.getString((DriverOption)DefaultDriverOption.AUTH_PROVIDER_USER_NAME, ""));
        this.defaultConsistencyLevel = DefaultConsistencyLevel.valueOf((String)sessionProperties.getProperty("consistencyLevel", defaultConfigProfile.getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY, ConsistencyLevel.LOCAL_ONE.name())));
        int fetchSizeFromProfile = defaultConfigProfile.getInt((DriverOption)DefaultDriverOption.REQUEST_PAGE_SIZE, 100);
        String fetchSizeParameter = sessionProperties.getProperty("fetchSize");
        try {
            this.defaultFetchSize = fetchSizeParameter == null ? fetchSizeFromProfile : Integer.parseInt(fetchSizeParameter);
        }
        catch (NumberFormatException e) {
            LOG.warn(String.format("Invalid fetch size parameter: '%s'. The default fetch size (%d) will be used instead.", fetchSizeParameter, fetchSizeFromProfile));
            this.defaultFetchSize = fetchSizeFromProfile;
        }
        this.cSession = sessionHolder.session;
        this.metadata = this.cSession.getMetadata();
        LOG.info("Connected to cluster: {}, with session: {}", (Object)Objects.toString(this.getCatalog(), "<not available>"), (Object)this.cSession.getName());
        this.metadata.getNodes().forEach((uuid, node) -> LOG.info("Datacenter: {}; Host: {}; Rack: {}", new Object[]{node.getDatacenter(), node.getEndPoint().resolve(), node.getRack()}));
        this.metadata.getNodes().entrySet().stream().findFirst().ifPresent(entry -> {
            Version cassandraVersion = ((Node)entry.getValue()).getCassandraVersion();
            if (cassandraVersion != null) {
                dbMajorVersion = cassandraVersion.getMajor();
                dbMinorVersion = cassandraVersion.getMinor();
                dbPatchVersion = cassandraVersion.getPatch();
                LOG.info("Node: {} runs Cassandra v.{}", (Object)((Node)entry.getValue()).getEndPoint().resolve(), (Object)cassandraVersion);
            }
        });
    }

    public CassandraConnection(Session cSession, String currentKeyspace, ConsistencyLevel defaultConsistencyLevel, boolean debugMode, OptionSet optionSet) {
        this.sessionHolder = null;
        this.connectionProperties = new Properties();
        this.optionSet = optionSet == null ? this.lookupOptionSet(null) : optionSet;
        this.currentKeyspace = currentKeyspace;
        this.cSession = cSession;
        this.metadata = cSession.getMetadata();
        this.defaultConsistencyLevel = defaultConsistencyLevel;
        this.debugMode = debugMode;
        ArrayList<AbstractCodec> codecs = new ArrayList<AbstractCodec>();
        codecs.add(new TimestampToLongCodec());
        codecs.add(new LongToIntCodec());
        codecs.add(new IntToLongCodec());
        codecs.add(new BigintToBigDecimalCodec());
        codecs.add(new DecimalToDoubleCodec());
        codecs.add(new FloatToDoubleCodec());
        codecs.add(new VarintToIntCodec());
        codecs.add(new SmallintToIntCodec());
        codecs.add(new TinyintToIntCodec());
        codecs.forEach(codec -> ((DefaultCodecRegistry)cSession.getContext().getCodecRegistry()).register(codec));
    }

    private void checkNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLNonTransientConnectionException("Method was called on a closed Connection.");
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void close() throws SQLException {
        if (this.sessionHolder != null) {
            this.sessionHolder.release();
        }
        this.isClosed = true;
    }

    @Override
    public void commit() throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkNotClosed();
        CassandraStatement statement = new CassandraStatement(this);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkNotClosed();
        CassandraStatement statement = new CassandraStatement(this, null, resultSetType, resultSetConcurrency);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkNotClosed();
        CassandraStatement statement = new CassandraStatement(this, null, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkNotClosed();
        return true;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkNotClosed();
        return this.optionSet.getCatalog();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkNotClosed();
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkNotClosed();
        return this.clientInfo;
    }

    @Override
    public String getClientInfo(String label) throws SQLException {
        this.checkNotClosed();
        return this.clientInfo.getProperty(label);
    }

    @Override
    public void setClientInfo(Properties properties) {
        if (properties != null) {
            this.clientInfo = properties;
        }
    }

    @Override
    public void setClientInfo(String key, String value) {
        this.clientInfo.setProperty(key, value);
    }

    public Metadata getClusterMetadata() {
        return this.metadata;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public ConsistencyLevel getDefaultConsistencyLevel() {
        return this.defaultConsistencyLevel;
    }

    public int getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkNotClosed();
        return 1;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkNotClosed();
        return new CassandraDatabaseMetaData(this);
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkNotClosed();
        return this.currentKeyspace;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkNotClosed();
        this.currentKeyspace = schema;
    }

    public Session getSession() {
        return this.cSession;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkNotClosed();
        return 0;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkNotClosed();
        if (level != 0) {
            throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support transactions.");
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        HashMap typeMap = new HashMap();
        LOG.info("Current keyspace: {}", (Object)this.currentKeyspace);
        this.metadata.getKeyspace(this.currentKeyspace).ifPresent(keyspaceMetadata -> keyspaceMetadata.getUserDefinedTypes().forEach((cqlIdentifier, userDefinedType) -> typeMap.put(cqlIdentifier.asInternal(), userDefinedType.getClass())));
        return typeMap;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkNotClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isValid(int timeout) throws SQLTimeoutException {
        if (timeout < 0) {
            throw new SQLTimeoutException("The timeout value was less than zero.");
        }
        if (this.getSession().isClosed()) {
            return false;
        }
        try (CassandraStatement stmt = (CassandraStatement)this.createStatement();){
            ExecutorService stmtExecutor = Executors.newCachedThreadPool();
            Callable<Object> callableStmt = () -> stmt.execute("SELECT uuid() FROM system.local");
            if (timeout != 0) {
                Future<Object> futureStmtExecution = stmtExecutor.submit(callableStmt);
                try {
                    futureStmtExecution.get(timeout, TimeUnit.SECONDS);
                    return true;
                }
                catch (Exception e) {
                    boolean bl = false;
                    if (stmt == null) return bl;
                    if (var3_4 == null) {
                        stmt.close();
                        return bl;
                    }
                    try {
                        stmt.close();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        var3_4.addSuppressed(throwable);
                        return bl;
                    }
                }
                finally {
                    futureStmtExecution.cancel(true);
                }
            }
            callableStmt.call();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkNotClosed();
        return sql;
    }

    @Override
    public CassandraPreparedStatement prepareStatement(String cql) throws SQLException {
        CassandraPreparedStatement preparedStatement = (CassandraPreparedStatement)this.preparedStatements.get(cql);
        if (preparedStatement == null && (preparedStatement = this.preparedStatements.putIfAbsent(cql, this.prepareStatement(cql, 1003, 1007, 1))) == null) {
            return (CassandraPreparedStatement)this.preparedStatements.get(cql);
        }
        return preparedStatement;
    }

    @Override
    public CassandraPreparedStatement prepareStatement(String cql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(cql, resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public CassandraPreparedStatement prepareStatement(String cql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkNotClosed();
        CassandraPreparedStatement statement = new CassandraPreparedStatement(this, cql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.statements.add(statement);
        return statement;
    }

    @Override
    public void rollback() throws SQLException {
        this.checkNotClosed();
        if (this.optionSet.shouldThrowExceptionOnRollback()) {
            throw new SQLFeatureNotSupportedException("The Cassandra implementation is always in auto-commit mode.");
        }
    }

    protected boolean removeStatement(Statement statement) {
        return this.statements.remove(statement);
    }

    public String toString() {
        return "CassandraConnection [connectionProperties=" + this.connectionProperties + "]";
    }

    public OptionSet getOptionSet() {
        return this.optionSet;
    }

    private OptionSet lookupOptionSet(String property) {
        ServiceLoader<OptionSet> loader = ServiceLoader.load(OptionSet.class);
        for (OptionSet optionSet : loader) {
            if (!optionSet.getClass().getSimpleName().equalsIgnoreCase(property)) continue;
            optionSet.setConnection(this);
            return optionSet;
        }
        Default optionSet = new Default();
        optionSet.setConnection(this);
        return optionSet;
    }
}

