/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.internal.core.cql.MultiPageResultSet;
import com.datastax.oss.driver.internal.core.cql.SinglePageResultSet;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.ing.data.cassandra.jdbc.AbstractStatement;
import com.ing.data.cassandra.jdbc.CassandraConnection;
import com.ing.data.cassandra.jdbc.CassandraResultSet;
import com.ing.data.cassandra.jdbc.CassandraStatementExtras;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTransientException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraStatement
extends AbstractStatement
implements CassandraStatementExtras,
Comparable<Object>,
Statement {
    public static final int MAX_ASYNC_QUERIES = 1000;
    public static final String STATEMENTS_SEPARATOR_REGEX = ";";
    protected static final int DEFAULT_FETCH_SIZE = 100;
    private static final Logger LOG = LoggerFactory.getLogger(CassandraStatement.class);
    protected CassandraConnection connection;
    protected String cql;
    protected ArrayList<String> batchQueries;
    protected int fetchDirection = 1000;
    protected int fetchSize;
    protected int maxFieldSize = 0;
    protected int maxRows = 0;
    protected int resultSetType;
    protected int resultSetConcurrency;
    protected int resultSetHoldability;
    protected java.sql.ResultSet currentResultSet = null;
    protected int updateCount = -1;
    protected boolean escapeProcessing = true;
    protected com.datastax.oss.driver.api.core.cql.Statement<?> statement;
    protected ConsistencyLevel consistencyLevel;
    private boolean isClosed;
    private DriverExecutionProfile customTimeoutProfile;

    CassandraStatement(CassandraConnection connection) throws SQLException {
        this(connection, null, 1003, 1007, 1);
    }

    CassandraStatement(CassandraConnection connection, String cql) throws SQLException {
        this(connection, cql, 1003, 1007, 1);
    }

    CassandraStatement(CassandraConnection connection, String cql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this(connection, cql, resultSetType, resultSetConcurrency, 1);
    }

    CassandraStatement(CassandraConnection connection, String cql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.connection = connection;
        this.cql = cql;
        this.batchQueries = new ArrayList();
        this.consistencyLevel = connection.getDefaultConsistencyLevel();
        this.fetchSize = connection.getDefaultFetchSize();
        this.isClosed = false;
        if (resultSetType != 1003 && resultSetType != 1004 && resultSetType != 1005) {
            throw new SQLSyntaxErrorException(String.format("The argument for result set type: %d is not a valid value.", resultSetType));
        }
        this.resultSetType = resultSetType;
        if (resultSetConcurrency != 1007 && resultSetConcurrency != 1008) {
            throw new SQLSyntaxErrorException(String.format("The argument for result set concurrency: %d is not a valid value.", resultSetConcurrency));
        }
        this.resultSetConcurrency = resultSetConcurrency;
        if (resultSetHoldability != 1 && resultSetHoldability != 2) {
            throw new SQLSyntaxErrorException(String.format("The argument for result set holdability: %d is not a valid value.", resultSetHoldability));
        }
        this.resultSetHoldability = resultSetHoldability;
    }

    @Override
    public void addBatch(String query) throws SQLException {
        this.checkNotClosed();
        this.batchQueries.add(query);
    }

    protected final void checkNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLRecoverableException("Method was called on a closed Statement.");
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkNotClosed();
        this.batchQueries = new ArrayList();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.cql = null;
    }

    @Override
    public int compareTo(@Nonnull Object target) {
        if (this.equals(target)) {
            return 0;
        }
        if (this.hashCode() < target.hashCode()) {
            return -1;
        }
        return 1;
    }

    private List<String> splitStatements(String cql) {
        String[] cqlQueries = cql.split(STATEMENTS_SEPARATOR_REGEX);
        ArrayList<String> cqlQueriesToExecute = new ArrayList<String>(cqlQueries.length);
        String singleQuote = "'";
        StringBuilder prevCqlQuery = new StringBuilder();
        for (String cqlQuery : cqlQueries) {
            boolean isNotFirstQueryPartWithoutStringValue;
            boolean hasStringValues = cqlQuery.contains("'");
            boolean isFirstQueryPartWithIncompleteStringValue = StringUtils.countMatches((CharSequence)cqlQuery, (CharSequence)"'") % 2 == 1 && prevCqlQuery.length() == 0;
            boolean isNotFirstQueryPartWithCompleteStringValue = StringUtils.countMatches((CharSequence)cqlQuery, (CharSequence)"'") % 2 == 0 && prevCqlQuery.length() > 0;
            boolean bl = isNotFirstQueryPartWithoutStringValue = !prevCqlQuery.toString().isEmpty() && !cqlQuery.contains("'");
            if (hasStringValues && (isFirstQueryPartWithIncompleteStringValue || isNotFirstQueryPartWithCompleteStringValue) || isNotFirstQueryPartWithoutStringValue) {
                prevCqlQuery.append(cqlQuery).append(STATEMENTS_SEPARATOR_REGEX);
                continue;
            }
            prevCqlQuery.append(cqlQuery);
            cqlQueriesToExecute.add(prevCqlQuery.toString());
            prevCqlQuery = new StringBuilder();
        }
        return cqlQueriesToExecute;
    }

    private void doExecute(String cql) throws SQLException {
        block12: {
            ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
            try {
                List<String> cqlQueries = this.splitStatements(cql);
                int nbQueriesToExecute = cqlQueries.size();
                if (!(nbQueriesToExecute <= 1 || cql.trim().toLowerCase().startsWith("begin") && cql.toLowerCase().contains("batch") && cql.toLowerCase().contains("apply"))) {
                    ArrayList<ResultSet> results = new ArrayList<ResultSet>();
                    if ((double)nbQueriesToExecute > 1100.0) {
                        throw new SQLNonTransientException(String.format("Too many queries at once (%d). You must split your queries into more batches!", nbQueriesToExecute));
                    }
                    if (!this.connection.getOptionSet().executeMultipleQueriesByStatementAsync()) {
                        for (String cqlQuery : cqlQueries) {
                            ResultSet rs = this.executeSingleStatement(cqlQuery);
                            results.add(rs);
                        }
                    } else {
                        for (String cqlQuery : cqlQueries) {
                            if (LOG.isDebugEnabled() || this.connection.isDebugMode()) {
                                LOG.debug("CQL: {}", (Object)cqlQuery);
                            }
                            SimpleStatement stmt = (SimpleStatement)((SimpleStatement)SimpleStatement.newInstance((String)cqlQuery).setConsistencyLevel(this.connection.getDefaultConsistencyLevel())).setPageSize(this.fetchSize);
                            if (this.customTimeoutProfile != null) {
                                stmt = (SimpleStatement)stmt.setExecutionProfile(this.customTimeoutProfile);
                            }
                            CompletionStage resultSetFuture = ((CqlSession)this.connection.getSession()).executeAsync((com.datastax.oss.driver.api.core.cql.Statement)stmt);
                            futures.add(resultSetFuture);
                        }
                        for (CompletionStage future : futures) {
                            AsyncResultSet asyncResultSet = (AsyncResultSet)CompletableFutures.getUninterruptibly((CompletionStage)future);
                            Object rows = asyncResultSet.hasMorePages() ? new MultiPageResultSet(asyncResultSet) : new SinglePageResultSet(asyncResultSet);
                            results.add((ResultSet)rows);
                        }
                    }
                    this.currentResultSet = new CassandraResultSet(this, results);
                    break block12;
                }
                this.currentResultSet = new CassandraResultSet(this, this.executeSingleStatement(cql));
            }
            catch (Exception e) {
                for (CompletionStage future : futures) {
                    future.toCompletableFuture().cancel(true);
                }
                throw new SQLTransientException(e);
            }
        }
    }

    private ResultSet executeSingleStatement(String cql) {
        if (LOG.isTraceEnabled() || this.connection.isDebugMode()) {
            LOG.debug("CQL: {}", (Object)cql);
        }
        SimpleStatement stmt = (SimpleStatement)((SimpleStatement)SimpleStatement.newInstance((String)cql).setConsistencyLevel(this.connection.getDefaultConsistencyLevel())).setPageSize(this.fetchSize);
        if (this.customTimeoutProfile != null) {
            stmt = (SimpleStatement)stmt.setExecutionProfile(this.customTimeoutProfile);
        }
        return ((CqlSession)this.connection.getSession()).execute((com.datastax.oss.driver.api.core.cql.Statement)stmt);
    }

    @Override
    public boolean execute(String query) throws SQLException {
        this.checkNotClosed();
        this.doExecute(query);
        return this.currentResultSet != null && ((CassandraResultSet)this.currentResultSet).hasMoreRows();
    }

    @Override
    public boolean execute(String cql, int autoGeneratedKeys) throws SQLException {
        this.checkNotClosed();
        if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
            throw new SQLSyntaxErrorException(String.format("Auto key generation value of: %d is illegal.", autoGeneratedKeys));
        }
        if (autoGeneratedKeys == 1) {
            throw new SQLFeatureNotSupportedException("The Cassandra implementation does not currently support returning generated keys.");
        }
        return this.execute(cql);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] returnCounts = new int[this.batchQueries.size()];
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        if (LOG.isTraceEnabled() || this.connection.isDebugMode()) {
            LOG.debug("CQL statements: {}", (Object)this.batchQueries.size());
        }
        for (String query : this.batchQueries) {
            if (LOG.isTraceEnabled() || this.connection.isDebugMode()) {
                LOG.debug("CQL: {}", (Object)query);
            }
            SimpleStatement stmt = (SimpleStatement)SimpleStatement.newInstance((String)query).setConsistencyLevel(this.connection.getDefaultConsistencyLevel());
            if (this.customTimeoutProfile != null) {
                stmt = (SimpleStatement)stmt.setExecutionProfile(this.customTimeoutProfile);
            }
            CompletionStage resultSetFuture = ((CqlSession)this.connection.getSession()).executeAsync((com.datastax.oss.driver.api.core.cql.Statement)stmt);
            futures.add(resultSetFuture);
        }
        int i = 0;
        for (CompletionStage future : futures) {
            CompletableFutures.getUninterruptibly((CompletionStage)future);
            returnCounts[i] = 1;
            ++i;
        }
        return returnCounts;
    }

    @Override
    public java.sql.ResultSet executeQuery(String cql) throws SQLException {
        this.checkNotClosed();
        this.doExecute(cql);
        if (this.currentResultSet == null) {
            throw new SQLNonTransientException("No ResultSet returned from the CQL statement passed in an 'executeQuery()' method.");
        }
        return this.currentResultSet;
    }

    @Override
    public int executeUpdate(String cql) throws SQLException {
        this.checkNotClosed();
        this.doExecute(cql);
        return this.connection.getOptionSet().getSQLUpdateResponse();
    }

    @Override
    public int executeUpdate(String cql, int autoGeneratedKeys) throws SQLException {
        this.checkNotClosed();
        if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
            throw new SQLFeatureNotSupportedException(String.format("Auto key generation value of: %d is illegal.", autoGeneratedKeys));
        }
        return this.executeUpdate(cql);
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkNotClosed();
        return this.connection;
    }

    public CassandraConnection getCassandraConnection() throws SQLException {
        return (CassandraConnection)this.getConnection();
    }

    @Override
    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    @Override
    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        this.statement = this.statement.setConsistencyLevel(consistencyLevel);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkNotClosed();
        return this.fetchDirection;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkNotClosed();
        if (direction == 1000 || direction == 1001 || direction == 1002) {
            if (this.getResultSetType() == 1003 && direction != 1000) {
                throw new SQLSyntaxErrorException(String.format("Fetch direction value of: %d is illegal.", direction));
            }
        } else {
            throw new SQLSyntaxErrorException(String.format("Fetch direction value of: %d is illegal.", direction));
        }
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkNotClosed();
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkNotClosed();
        if (rows < 0) {
            throw new SQLSyntaxErrorException(String.format("Fetch size of: %d rows may not be negative.", rows));
        }
        this.fetchSize = rows;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkNotClosed();
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkNotClosed();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkNotClosed();
        this.resetResults();
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkNotClosed();
        switch (current) {
            case 1: {
                this.resetResults();
                break;
            }
            case 2: 
            case 3: {
                throw new SQLFeatureNotSupportedException("The Cassandra implementation does not currently support multiple open result sets.");
            }
            default: {
                throw new SQLSyntaxErrorException(String.format("The argument for keeping the current result set: %d is not a valid value.", current));
            }
        }
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkNotClosed();
        DriverExecutionProfile activeProfile = this.connection.getSession().getContext().getConfig().getDefaultProfile();
        if (this.customTimeoutProfile != null) {
            activeProfile = this.customTimeoutProfile;
        }
        return Long.valueOf(Objects.requireNonNull(activeProfile.getDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT, Duration.ZERO)).get(ChronoUnit.SECONDS)).intValue();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkNotClosed();
        DriverExecutionProfile defaultProfile = this.connection.getSession().getContext().getConfig().getDefaultProfile();
        this.customTimeoutProfile = defaultProfile.withDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT, Duration.ofSeconds(seconds));
    }

    @Override
    public java.sql.ResultSet getResultSet() throws SQLException {
        this.checkNotClosed();
        return this.currentResultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkNotClosed();
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkNotClosed();
        return 1;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkNotClosed();
        return 1003;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkNotClosed();
        return this.updateCount;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        return null;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkNotClosed();
    }

    protected final void resetResults() {
        this.currentResultSet = null;
        this.updateCount = -1;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkNotClosed();
        this.escapeProcessing = enable;
    }
}

