/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.types;

import com.ing.data.cassandra.jdbc.types.AbstractJdbcType;
import com.ing.data.cassandra.jdbc.types.MarshalException;
import java.nio.ByteBuffer;

public class JdbcLong
extends AbstractJdbcType<Long> {
    public static final JdbcLong INSTANCE = new JdbcLong();
    private static final int DEFAULT_LONG_PRECISION = 20;

    JdbcLong() {
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public int getScale(Long obj) {
        return 0;
    }

    @Override
    public int getPrecision(Long obj) {
        if (obj != null) {
            return obj.toString().length();
        }
        return 20;
    }

    @Override
    public boolean isCurrency() {
        return false;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public String toString(Long obj) {
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    @Override
    public boolean needsQuotes() {
        return false;
    }

    public String getString(ByteBuffer bytes) {
        if (bytes.remaining() == 0) {
            return "";
        }
        if (bytes.remaining() != 8) {
            throw new MarshalException("A long is exactly 8 bytes, but found: " + bytes.remaining());
        }
        return String.valueOf(bytes.getLong(bytes.position()));
    }

    @Override
    public Class<Long> getType() {
        return Long.class;
    }

    @Override
    public int getJdbcType() {
        return -5;
    }

    @Override
    public Long compose(Object obj) {
        return (Long)obj;
    }

    @Override
    public Object decompose(Long value) {
        return value;
    }
}

