/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Map;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.impl.DbAttachInfo;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSServerVersion;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.FbConnectionProperties;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbDatabaseFactory;
import org.firebirdsql.gds.ng.FbService;
import org.firebirdsql.gds.ng.FbServiceProperties;
import org.firebirdsql.gds.ng.IServiceProperties;
import org.firebirdsql.gds.ng.WireCrypt;
import org.firebirdsql.jaybird.props.def.ConnectionProperty;
import org.firebirdsql.management.ServiceManager;

public class FBServiceManager
implements ServiceManager {
    private final IServiceProperties serviceProperties = new FbServiceProperties();
    private final FbDatabaseFactory dbFactory;
    private String database;
    private OutputStream logger;
    public static final int BUFFER_SIZE = 1024;

    public FBServiceManager() {
        this(GDSFactory.getDefaultGDSType());
    }

    public FBServiceManager(String gdsType) {
        this(GDSType.getType(gdsType));
    }

    public FBServiceManager(GDSType gdsType) {
        this.serviceProperties.setType(gdsType.toString());
        this.dbFactory = GDSFactory.getDatabaseFactoryForType(gdsType);
    }

    @Override
    public final void setType(String type) {
        throw new IllegalStateException("Type must be specified on construction");
    }

    @Override
    public void setCharSet(String charSet) {
        ServiceManager.super.setCharSet(charSet);
    }

    @Override
    public String getCharSet() {
        return ServiceManager.super.getCharSet();
    }

    @Override
    public void setUser(String user) {
        ServiceManager.super.setUser(user);
    }

    @Override
    public String getUser() {
        return ServiceManager.super.getUser();
    }

    @Override
    public void setPassword(String password) {
        ServiceManager.super.setPassword(password);
    }

    @Override
    public String getPassword() {
        return ServiceManager.super.getPassword();
    }

    @Override
    public String getServerName() {
        return ServiceManager.super.getServerName();
    }

    @Override
    public void setServerName(String serverName) {
        ServiceManager.super.setServerName(serverName);
    }

    @Override
    public int getPortNumber() {
        return ServiceManager.super.getPortNumber();
    }

    @Override
    public void setPortNumber(int portNumber) {
        ServiceManager.super.setPortNumber(portNumber);
    }

    @Override
    public String getServiceName() {
        return ServiceManager.super.getServiceName();
    }

    @Override
    public void setServiceName(String serviceName) {
        ServiceManager.super.setServiceName(serviceName);
    }

    @Override
    public void setExpectedDb(String expectedDb) {
        ServiceManager.super.setExpectedDb(expectedDb);
    }

    @Override
    public String getExpectedDb() {
        return ServiceManager.super.getExpectedDb();
    }

    @Override
    public void setDatabase(String database) {
        this.database = database;
        this.setExpectedDb(database);
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    @Deprecated
    public String getHost() {
        return this.getServerName();
    }

    @Override
    @Deprecated
    public void setHost(String host) {
        this.setServerName(host);
    }

    @Override
    @Deprecated
    public int getPort() {
        return this.getPortNumber();
    }

    @Override
    @Deprecated
    public void setPort(int port) {
        this.setPortNumber(port);
    }

    @Override
    public String getWireCrypt() {
        return ServiceManager.super.getWireCrypt();
    }

    @Override
    public WireCrypt getWireCryptAsEnum() {
        return this.serviceProperties.getWireCryptAsEnum();
    }

    @Override
    public void setWireCryptAsEnum(WireCrypt wireCrypt) {
        this.serviceProperties.setWireCryptAsEnum(wireCrypt);
    }

    @Override
    public String getDbCryptConfig() {
        return ServiceManager.super.getDbCryptConfig();
    }

    @Override
    public void setDbCryptConfig(String dbCryptConfig) {
        ServiceManager.super.setDbCryptConfig(dbCryptConfig);
    }

    @Override
    public String getAuthPlugins() {
        return ServiceManager.super.getDbCryptConfig();
    }

    @Override
    public void setAuthPlugins(String authPlugins) {
        ServiceManager.super.setAuthPlugins(authPlugins);
    }

    @Override
    public boolean isWireCompression() {
        return ServiceManager.super.isWireCompression();
    }

    @Override
    public void setWireCompression(boolean wireCompression) {
        ServiceManager.super.setWireCompression(wireCompression);
    }

    @Override
    public String getProperty(String name) {
        return this.serviceProperties.getProperty(name);
    }

    @Override
    public void setProperty(String name, String value) {
        if ("type".equals(name)) {
            this.setType(value);
        }
        this.serviceProperties.setProperty(name, value);
    }

    @Override
    public Integer getIntProperty(String name) {
        return this.serviceProperties.getIntProperty(name);
    }

    @Override
    public void setIntProperty(String name, Integer value) {
        this.serviceProperties.setIntProperty(name, value);
    }

    @Override
    public Boolean getBooleanProperty(String name) {
        return this.serviceProperties.getBooleanProperty(name);
    }

    @Override
    public void setBooleanProperty(String name, Boolean value) {
        this.serviceProperties.setBooleanProperty(name, value);
    }

    @Override
    public Map<ConnectionProperty, Object> connectionPropertyValues() {
        return this.serviceProperties.connectionPropertyValues();
    }

    @Override
    public synchronized OutputStream getLogger() {
        return this.logger;
    }

    @Override
    public synchronized void setLogger(OutputStream logger) {
        this.logger = logger;
    }

    public FbService attachServiceManager() throws SQLException {
        FbService fbService = this.dbFactory.serviceConnect(this.serviceProperties);
        fbService.attach();
        return fbService;
    }

    protected FbDatabase attachDatabase() throws SQLException {
        if (this.database == null) {
            throw new SQLException("Property database needs to be set.");
        }
        FbConnectionProperties connectionProperties = new FbConnectionProperties();
        this.createDatabaseAttachInfo().copyTo(connectionProperties);
        connectionProperties.setUser(this.serviceProperties.getUser());
        connectionProperties.setPassword(this.serviceProperties.getPassword());
        FbDatabase fbDatabase = this.dbFactory.connect(connectionProperties);
        fbDatabase.attach();
        return fbDatabase;
    }

    private DbAttachInfo createDatabaseAttachInfo() {
        String serverName = this.serviceProperties.getServerName();
        String serviceAttachObjectName = this.serviceProperties.getAttachObjectName();
        if (serverName != null || serviceAttachObjectName == null || serviceAttachObjectName.isEmpty()) {
            return new DbAttachInfo(serverName, this.serviceProperties.getPortNumber(), this.database);
        }
        String databaseAttachObjectName = serviceAttachObjectName.equals("service_mgr") ? this.database : (serviceAttachObjectName.endsWith("service_mgr") ? serviceAttachObjectName.substring(0, serviceAttachObjectName.length() - 11) + this.database : (serviceAttachObjectName.endsWith("/") || serviceAttachObjectName.endsWith(":") ? serviceAttachObjectName + this.database : serviceAttachObjectName + '/' + this.database));
        return new DbAttachInfo(null, this.serviceProperties.getPortNumber(), databaseAttachObjectName);
    }

    public void queueService(FbService service) throws SQLException, IOException {
        OutputStream currentLogger = this.getLogger();
        ServiceRequestBuffer infoSRB = service.createServiceRequestBuffer();
        infoSRB.addArgument(63);
        int bufferSize = 1024;
        boolean processing = true;
        while (processing) {
            byte[] buffer = service.getServiceInfo(null, infoSRB, bufferSize);
            switch (buffer[0]) {
                case 63: {
                    int dataLength = VaxEncoding.iscVaxInteger2(buffer, 1);
                    if (dataLength == 0) {
                        if (buffer[3] != 1) {
                            throw new SQLException("Unexpected end of stream reached.");
                        }
                        processing = false;
                        break;
                    }
                    if (currentLogger == null) break;
                    currentLogger.write(buffer, 3, dataLength);
                    break;
                }
                case 2: {
                    bufferSize *= 2;
                    break;
                }
                case 1: {
                    processing = false;
                }
            }
        }
    }

    @Deprecated
    protected void executeServicesOperation(ServiceRequestBuffer srb) throws SQLException {
        try (FbService service = this.attachServiceManager();){
            service.startServiceAction(srb);
            this.queueService(service);
        }
        catch (IOException ioe) {
            throw new SQLException(ioe);
        }
    }

    protected final void executeServicesOperation(FbService service, ServiceRequestBuffer srb) throws SQLException {
        try {
            service.startServiceAction(srb);
            this.queueService(service);
        }
        catch (IOException ioe) {
            throw new SQLException(ioe);
        }
    }

    protected ServiceRequestBuffer createRequestBuffer(FbService service, int operation, int options) {
        ServiceRequestBuffer srb = service.createServiceRequestBuffer();
        srb.addArgument(operation);
        if (this.getDatabase() != null) {
            srb.addArgument(106, this.getDatabase());
        }
        srb.addArgument(108, options);
        return srb;
    }

    @Override
    public GDSServerVersion getServerVersion() throws SQLException {
        try (FbService service = this.attachServiceManager();){
            GDSServerVersion gDSServerVersion = service.getServerVersion();
            return gDSServerVersion;
        }
    }
}

