/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.api.incubator.logs;

import io.trino.jdbc.$internal.opentelemetry.api.incubator.logs.AnyValue;
import io.trino.jdbc.$internal.opentelemetry.api.incubator.logs.AnyValueType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

final class AnyValueArray
implements AnyValue<List<AnyValue<?>>> {
    private final List<AnyValue<?>> value;

    private AnyValueArray(List<AnyValue<?>> value) {
        this.value = value;
    }

    static AnyValue<List<AnyValue<?>>> create(AnyValue<?> ... value) {
        Objects.requireNonNull(value, "value must not be null");
        ArrayList list = new ArrayList(value.length);
        list.addAll(Arrays.asList(value));
        return new AnyValueArray(Collections.unmodifiableList(list));
    }

    static AnyValue<List<AnyValue<?>>> create(List<AnyValue<?>> value) {
        return new AnyValueArray(Collections.unmodifiableList(value));
    }

    @Override
    public AnyValueType getType() {
        return AnyValueType.ARRAY;
    }

    @Override
    public List<AnyValue<?>> getValue() {
        return this.value;
    }

    @Override
    public String asString() {
        return this.value.stream().map(AnyValue::asString).collect(Collectors.joining(", ", "[", "]"));
    }

    public String toString() {
        return "AnyValueArray{" + this.asString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof AnyValue && Objects.equals(this.value, ((AnyValue)o).getValue());
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

