/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Objects;
import java.util.UUID;
import schemacrawler.JvmSystemInfo;
import schemacrawler.OperatingSystemInfo;
import schemacrawler.Version;
import schemacrawler.crawl.MutableDatabaseInfo;
import schemacrawler.crawl.MutableJdbcDriverInfo;
import schemacrawler.schema.CrawlInfo;
import us.fatehi.utility.property.BaseProductVersion;
import us.fatehi.utility.property.ProductVersion;

final class MutableCrawlInfo
implements CrawlInfo {
    private static final long serialVersionUID = 5982990326485881993L;
    public static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    private final Instant crawlTimestamp;
    private final ProductVersion jvmVersion;
    private final ProductVersion operatingSystemVersion;
    private final UUID runId;
    private final ProductVersion schemaCrawlerVersion;
    private final ProductVersion databaseVersion;
    private final ProductVersion jdbcDriverVersion;

    MutableCrawlInfo(MutableDatabaseInfo databaseInfo, MutableJdbcDriverInfo jdbcDriverInfo) {
        Objects.requireNonNull(databaseInfo, "No database information provided");
        Objects.requireNonNull(jdbcDriverInfo, "No JDBC driver information provided");
        this.schemaCrawlerVersion = Version.version();
        this.operatingSystemVersion = OperatingSystemInfo.operatingSystemInfo();
        this.jvmVersion = JvmSystemInfo.jvmSystemInfo();
        this.databaseVersion = new BaseProductVersion(databaseInfo);
        this.jdbcDriverVersion = new BaseProductVersion(jdbcDriverInfo);
        this.crawlTimestamp = Instant.now();
        this.runId = UUID.randomUUID();
    }

    @Override
    public String getCrawlTimestamp() {
        ZonedDateTime dateTime = this.getCrawlTimestampUTC();
        return DATE_TIME_FORMATTER.format(dateTime);
    }

    @Override
    public Instant getCrawlTimestampInstant() {
        return this.crawlTimestamp;
    }

    @Override
    public ProductVersion getDatabaseVersion() {
        return this.databaseVersion;
    }

    @Override
    public ProductVersion getJdbcDriverVersion() {
        return this.jdbcDriverVersion;
    }

    @Override
    public ProductVersion getJvmVersion() {
        return this.jvmVersion;
    }

    @Override
    public ProductVersion getOperatingSystemVersion() {
        return this.operatingSystemVersion;
    }

    @Override
    public String getRunId() {
        return this.runId.toString();
    }

    @Override
    public ProductVersion getSchemaCrawlerVersion() {
        return this.schemaCrawlerVersion;
    }

    public String toString() {
        String crawlTimestampString = DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(this.getCrawlTimestampUTC());
        StringBuilder info = new StringBuilder(1024);
        info.append("-- generated by: ").append(this.schemaCrawlerVersion).append(System.lineSeparator());
        info.append("-- generated on: ").append(crawlTimestampString).append(System.lineSeparator());
        info.append("-- database: ").append(this.databaseVersion).append(System.lineSeparator());
        info.append("-- driver: ").append(this.jdbcDriverVersion).append(System.lineSeparator());
        info.append("-- operating system: ").append(this.operatingSystemVersion).append(System.lineSeparator());
        info.append("-- JVM system: ").append(this.jvmVersion).append(System.lineSeparator());
        return info.toString();
    }

    private ZonedDateTime getCrawlTimestampUTC() {
        return ZonedDateTime.ofInstant(this.crawlTimestamp, ZoneOffset.UTC);
    }
}

