/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrCores;
import org.apache.solr.logging.MDCLoggingContext;

class CloserThread
extends Thread {
    CoreContainer container;
    SolrCores solrCores;
    NodeConfig cfg;

    CloserThread(CoreContainer container, SolrCores solrCores, NodeConfig cfg) {
        super("CloserThread");
        this.container = container;
        this.solrCores = solrCores;
        this.cfg = cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.container.isShutDown()) {
            SolrCore core;
            Object object = this.solrCores.getModifyLock();
            synchronized (object) {
                try {
                    this.solrCores.getModifyLock().wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            while (!this.container.isShutDown() && (core = this.solrCores.getCoreToClose()) != null) {
                assert (core.getOpenCount() == 1);
                try {
                    MDCLoggingContext.setCore(core);
                    core.close();
                }
                finally {
                    this.solrCores.removeFromPendingOps(core.getName());
                }
            }
        }
    }
}

