"use strict";
/// <reference types="@volar/typescript" />
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFullLanguageServicePlugins = getFullLanguageServicePlugins;
exports.getHybridModeLanguageServicePlugins = getHybridModeLanguageServicePlugins;
__exportStar(require("@volar/language-service"), exports);
__exportStar(require("@vue/language-core"), exports);
__exportStar(require("./lib/ideFeatures/nameCasing"), exports);
__exportStar(require("./lib/types"), exports);
const types_1 = require("./lib/types");
const volar_service_emmet_1 = require("volar-service-emmet");
const volar_service_json_1 = require("volar-service-json");
const volar_service_pug_beautify_1 = require("volar-service-pug-beautify");
const volar_service_typescript_1 = require("volar-service-typescript");
const volar_service_typescript_twoslash_queries_1 = require("volar-service-typescript-twoslash-queries");
const docCommentTemplate_1 = require("volar-service-typescript/lib/plugins/docCommentTemplate");
const syntactic_1 = require("volar-service-typescript/lib/plugins/syntactic");
const css_1 = require("./lib/plugins/css");
const vue_autoinsert_dotvalue_1 = require("./lib/plugins/vue-autoinsert-dotvalue");
const vue_autoinsert_space_1 = require("./lib/plugins/vue-autoinsert-space");
const vue_complete_define_assignment_1 = require("./lib/plugins/vue-complete-define-assignment");
const vue_directive_comments_1 = require("./lib/plugins/vue-directive-comments");
const vue_document_drop_1 = require("./lib/plugins/vue-document-drop");
const vue_document_links_1 = require("./lib/plugins/vue-document-links");
const vue_extract_file_1 = require("./lib/plugins/vue-extract-file");
const vue_inlayhints_1 = require("./lib/plugins/vue-inlayhints");
const vue_sfc_1 = require("./lib/plugins/vue-sfc");
const vue_template_1 = require("./lib/plugins/vue-template");
const vue_twoslash_queries_1 = require("./lib/plugins/vue-twoslash-queries");
const language_core_1 = require("@vue/language-core");
const common_1 = require("@vue/typescript-plugin/lib/common");
const collectExtractProps_1 = require("@vue/typescript-plugin/lib/requests/collectExtractProps");
const getComponentDirectives_1 = require("@vue/typescript-plugin/lib/requests/getComponentDirectives");
const getComponentEvents_1 = require("@vue/typescript-plugin/lib/requests/getComponentEvents");
const getComponentNames_1 = require("@vue/typescript-plugin/lib/requests/getComponentNames");
const getComponentProps_1 = require("@vue/typescript-plugin/lib/requests/getComponentProps");
const getElementAttrs_1 = require("@vue/typescript-plugin/lib/requests/getElementAttrs");
const getImportPathForFile_1 = require("@vue/typescript-plugin/lib/requests/getImportPathForFile");
const getPropertiesAtLocation_1 = require("@vue/typescript-plugin/lib/requests/getPropertiesAtLocation");
const vscode_uri_1 = require("vscode-uri");
const nameCasing_1 = require("./lib/ideFeatures/nameCasing");
function getFullLanguageServicePlugins(ts, { disableAutoImportCache } = {}) {
    const plugins = [
        ...(0, volar_service_typescript_1.create)(ts, { disableAutoImportCache }),
        ...getCommonLanguageServicePlugins(ts, getTsPluginClientForLSP)
    ];
    for (let i = 0; i < plugins.length; i++) {
        const plugin = plugins[i];
        if (plugin.name === 'typescript-semantic') {
            plugins[i] = {
                ...plugin,
                create(context) {
                    const created = plugin.create(context);
                    if (!context.project.typescript) {
                        return created;
                    }
                    const languageService = created.provide['typescript/languageService']();
                    if (context.project.vue) {
                        const proxy = (0, common_1.proxyLanguageServiceForVue)(ts, context.language, languageService, context.project.vue.compilerOptions, s => context.project.typescript?.uriConverter.asUri(s));
                        languageService.getCompletionsAtPosition = proxy.getCompletionsAtPosition;
                        languageService.getCompletionEntryDetails = proxy.getCompletionEntryDetails;
                        languageService.getCodeFixesAtPosition = proxy.getCodeFixesAtPosition;
                        languageService.getDefinitionAndBoundSpan = proxy.getDefinitionAndBoundSpan;
                        languageService.getQuickInfoAtPosition = proxy.getQuickInfoAtPosition;
                    }
                    return created;
                },
            };
            break;
        }
    }
    return plugins;
    function getTsPluginClientForLSP(context) {
        if (!context.project.typescript) {
            return;
        }
        const languageService = context.inject('typescript/languageService');
        if (!languageService) {
            return;
        }
        const requestContext = {
            typescript: ts,
            language: context.language,
            languageService,
            languageServiceHost: context.project.typescript.languageServiceHost,
            isTsPlugin: false,
            getFileId: s => context.project.typescript.uriConverter.asUri(s),
        };
        return {
            async collectExtractProps(...args) {
                return await collectExtractProps_1.collectExtractProps.apply(requestContext, args);
            },
            async getPropertiesAtLocation(...args) {
                return await getPropertiesAtLocation_1.getPropertiesAtLocation.apply(requestContext, args);
            },
            async getImportPathForFile(...args) {
                return await getImportPathForFile_1.getImportPathForFile.apply(requestContext, args);
            },
            async getComponentEvents(...args) {
                return await getComponentEvents_1.getComponentEvents.apply(requestContext, args);
            },
            async getComponentDirectives(...args) {
                return await getComponentDirectives_1.getComponentDirectives.apply(requestContext, args);
            },
            async getComponentNames(...args) {
                return await getComponentNames_1.getComponentNames.apply(requestContext, args);
            },
            async getComponentProps(...args) {
                return await getComponentProps_1.getComponentProps.apply(requestContext, args);
            },
            async getElementAttrs(...args) {
                return await getElementAttrs_1.getElementAttrs.apply(requestContext, args);
            },
            async getQuickInfoAtPosition(fileName, position) {
                const languageService = context.getLanguageService();
                const uri = context.project.typescript.uriConverter.asUri(fileName);
                const sourceScript = context.language.scripts.get(uri);
                if (!sourceScript) {
                    return;
                }
                const document = context.documents.get(uri, sourceScript.languageId, sourceScript.snapshot);
                const hover = await languageService.getHover(uri, document.positionAt(position));
                let text = '';
                if (typeof hover?.contents === 'string') {
                    text = hover.contents;
                }
                else if (Array.isArray(hover?.contents)) {
                    text = hover.contents.map(c => typeof c === 'string' ? c : c.value).join('\n');
                }
                else if (hover) {
                    text = hover.contents.value;
                }
                text = text.replace(/```typescript/g, '');
                text = text.replace(/```/g, '');
                text = text.replace(/---/g, '');
                text = text.trim();
                while (true) {
                    const newText = text.replace(/\n\n/g, '\n');
                    if (newText === text) {
                        break;
                    }
                    text = newText;
                }
                text = text.replace(/\n/g, ' | ');
                return text;
            },
        };
    }
}
function getHybridModeLanguageServicePlugins(ts, getTsPluginClient) {
    const plugins = [
        (0, syntactic_1.create)(ts),
        (0, docCommentTemplate_1.create)(ts),
        ...getCommonLanguageServicePlugins(ts, () => getTsPluginClient)
    ];
    for (const plugin of plugins) {
        // avoid affecting TS plugin
        delete plugin.capabilities.semanticTokensProvider;
    }
    return plugins;
}
function getCommonLanguageServicePlugins(ts, getTsPluginClient) {
    return [
        (0, volar_service_typescript_twoslash_queries_1.create)(ts),
        (0, css_1.create)(),
        (0, volar_service_pug_beautify_1.create)(),
        (0, volar_service_json_1.create)(),
        (0, vue_template_1.create)('html', ts, getTsPluginClient),
        (0, vue_template_1.create)('pug', ts, getTsPluginClient),
        (0, vue_sfc_1.create)(),
        (0, vue_twoslash_queries_1.create)(getTsPluginClient),
        (0, vue_document_links_1.create)(),
        (0, vue_document_drop_1.create)(ts, getTsPluginClient),
        (0, vue_complete_define_assignment_1.create)(),
        (0, vue_autoinsert_dotvalue_1.create)(ts, getTsPluginClient),
        (0, vue_autoinsert_space_1.create)(),
        (0, vue_inlayhints_1.create)(ts),
        (0, vue_directive_comments_1.create)(),
        (0, vue_extract_file_1.create)(ts, getTsPluginClient),
        (0, volar_service_emmet_1.create)({
            mappedLanguages: {
                'vue-root-tags': 'html',
                'postcss': 'scss',
            },
        }),
        {
            name: 'vue-parse-sfc',
            capabilities: {
                executeCommandProvider: {
                    commands: [types_1.commands.parseSfc],
                },
            },
            create() {
                return {
                    executeCommand(_command, [source]) {
                        return (0, language_core_1.parse)(source);
                    },
                };
            },
        },
        {
            name: 'vue-name-casing',
            capabilities: {
                executeCommandProvider: {
                    commands: [
                        types_1.commands.detectNameCasing,
                        types_1.commands.convertTagsToKebabCase,
                        types_1.commands.convertTagsToPascalCase,
                        types_1.commands.convertPropsToKebabCase,
                        types_1.commands.convertPropsToCamelCase,
                    ],
                }
            },
            create(context) {
                return {
                    executeCommand(command, [uri]) {
                        if (command === types_1.commands.detectNameCasing) {
                            return (0, nameCasing_1.detect)(context, vscode_uri_1.URI.parse(uri));
                        }
                        else if (command === types_1.commands.convertTagsToKebabCase) {
                            return (0, nameCasing_1.convertTagName)(context, vscode_uri_1.URI.parse(uri), types_1.TagNameCasing.Kebab, getTsPluginClient(context));
                        }
                        else if (command === types_1.commands.convertTagsToPascalCase) {
                            return (0, nameCasing_1.convertTagName)(context, vscode_uri_1.URI.parse(uri), types_1.TagNameCasing.Pascal, getTsPluginClient(context));
                        }
                        else if (command === types_1.commands.convertPropsToKebabCase) {
                            return (0, nameCasing_1.convertAttrName)(context, vscode_uri_1.URI.parse(uri), types_1.AttrNameCasing.Kebab, getTsPluginClient(context));
                        }
                        else if (command === types_1.commands.convertPropsToCamelCase) {
                            return (0, nameCasing_1.convertAttrName)(context, vscode_uri_1.URI.parse(uri), types_1.AttrNameCasing.Camel, getTsPluginClient(context));
                        }
                    },
                };
            },
        }
    ];
}
//# sourceMappingURL=index.js.map